<?php
/**
 * ブログ記事情報変更確認画面クラス
 *
 * ブログ記事情報変更確認画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );

  class blogmod_confirm extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'simpleblog.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが自分と同じでない or 前画面のActが「blogmod_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage_last    = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage'    ) );
      $tmp_cage_current = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact' );

      if ( ( $tmp_cage_last != $tmp_cage_current and $tmp_cage_last != 'admin.site' ) or ( $tmp_act != 'blogmod_entry' and $tmp_act != 'uploadviewer' ) )
      {
        $this->obj_util->redirectTo( 'bloglist', $tmp_cage_current );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'errMsg' ][ 'message'            ] = null;
      $tmp_entered[ 'errMsg' ][ 'blogid'             ] = null;
      $tmp_entered[ 'errMsg' ][ 'title'              ] = null;
      $tmp_entered[ 'errMsg' ][ 'body'               ] = null;
      $tmp_entered[ 'errMsg' ][ 'postdate'           ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_postyear'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_postmonth'  ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_postday'    ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_posthour'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_postminite' ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_postsecond' ] = null;
      $tmp_entered[ 'errMsg' ][ 'opendate'           ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_openyear'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_openmonth'  ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_openday'    ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_openhour'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_openminite' ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_opensecond' ] = null;
      $tmp_entered[ 'errMsg' ][ 'enddate'            ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endyear'    ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endmonth'   ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endday'     ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endhour'    ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endminite'  ] = null;
      $tmp_entered[ 'errMsg' ][ 'entered_endsecond'  ] = null;

      // ページID
      if ( isset( $_POST[ 'blogid' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'blogid' ] = strip_tags( trim( $_POST[ 'blogid' ] ) );
      } // end of if
      // タイトル
      if ( isset( $_POST[ 'title' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'title' ] = strip_tags( trim( $_POST[ 'title' ] ) );
      } // end of if

      // 本文
      if ( isset( $_POST[ 'body' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'body'  ] = strip_tags( trim( $_POST[ 'body'  ] ), $this->obj_conf->get( 'ALLOWTAGS', 'body' ) );
        $tmp_entered[ 'errMsg' ][ 'body'  ] = str_replace( array( "\r\n", "\n", "\r" ), "", $tmp_entered[ 'errMsg' ][ 'body' ] );
      } // end of if

      // 投稿日
      if (     isset( $_POST[ 'posted_year' ] ) and isset( $_POST[ 'posted_month'  ] ) and isset( $_POST[ 'posted_day'    ] )
           and isset( $_POST[ 'posted_hour' ] ) and isset( $_POST[ 'posted_minite' ] ) and isset( $_POST[ 'posted_second' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'postdate'           ] = $_POST[ 'posted_year' ] . '-' . $_POST[ 'posted_month'  ] . '-' . $_POST[ 'posted_day'    ] . ' '
                                                         . $_POST[ 'posted_hour' ] . ':' . $_POST[ 'posted_minite' ] . ':' . $_POST[ 'posted_second' ];
        $tmp_entered[ 'errMsg' ][ 'entered_postyear'   ] = strip_tags( trim( $_POST[ 'posted_year'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_postmonth'  ] = strip_tags( trim( $_POST[ 'posted_month'  ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_postday'    ] = strip_tags( trim( $_POST[ 'posted_day'    ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_posthour'   ] = strip_tags( trim( $_POST[ 'posted_hour'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_postminite' ] = strip_tags( trim( $_POST[ 'posted_minite' ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_postsecond' ] = strip_tags( trim( $_POST[ 'posted_second' ] ) );
      } // end of if

      // 公開開始日
      if (     isset( $_POST[ 'open_year' ] ) and isset( $_POST[ 'open_month'  ] ) and isset( $_POST[ 'open_day'    ] )
           and isset( $_POST[ 'open_hour' ] ) and isset( $_POST[ 'open_minite' ] ) and isset( $_POST[ 'open_second' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'opendate'           ] = $_POST[ 'open_year' ] . '-' . $_POST[ 'open_month'  ] . '-' . $_POST[ 'open_day'    ] . ' '
                                                         . $_POST[ 'open_hour' ] . ':' . $_POST[ 'open_minite' ] . ':' . $_POST[ 'open_second' ];
        $tmp_entered[ 'errMsg' ][ 'entered_openyear'   ] = strip_tags( trim( $_POST[ 'open_year'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_openmonth'  ] = strip_tags( trim( $_POST[ 'open_month'  ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_openday'    ] = strip_tags( trim( $_POST[ 'open_day'    ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_openhour'   ] = strip_tags( trim( $_POST[ 'open_hour'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_openminite' ] = strip_tags( trim( $_POST[ 'open_minite' ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_opensecond' ] = strip_tags( trim( $_POST[ 'open_second' ] ) );
      } // end of if

      // 公開終了日
      if (     isset( $_POST[ 'end_year' ] ) and isset( $_POST[ 'end_month'  ] ) and isset( $_POST[ 'end_day'    ] )
           and isset( $_POST[ 'end_hour' ] ) and isset( $_POST[ 'end_minite' ] ) and isset( $_POST[ 'end_second' ] ) )
      {
        $tmp_entered[ 'errMsg' ][ 'enddate'           ] = $_POST[ 'end_year' ] . '-' . $_POST[ 'end_month'  ] . '-' . $_POST[ 'end_day'    ] . ' '
                                                        . $_POST[ 'end_hour' ] . ':' . $_POST[ 'end_minite' ] . ':' . $_POST[ 'end_second' ];
        $tmp_entered[ 'errMsg' ][ 'entered_endyear'   ] = strip_tags( trim( $_POST[ 'end_year'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_endmonth'  ] = strip_tags( trim( $_POST[ 'end_month'  ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_endday'    ] = strip_tags( trim( $_POST[ 'end_day'    ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_endhour'   ] = strip_tags( trim( $_POST[ 'end_hour'   ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_endminite' ] = strip_tags( trim( $_POST[ 'end_minite' ] ) );
        $tmp_entered[ 'errMsg' ][ 'entered_endsecond' ] = strip_tags( trim( $_POST[ 'end_second' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ブログID
      if ( ! is_numeric( $tmp_entered[ 'errMsg' ][ 'blogid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_blogid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'blogmod_entry', $tmp_cage_current );
        return false;
      } // end of if
      // タイトル（入力値が空）
      if ( empty( $tmp_entered[ 'errMsg' ][ 'title' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'empty_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // タイトル（入力値が半角255文字以上）
      if ( strlen( $tmp_entered[ 'errMsg' ][ 'title' ] ) > 255 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'toolong_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 本文（入力値が空）
      if ( empty( $tmp_entered[ 'errMsg' ][ 'body' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'empty_body';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 投稿日（未指定項目がある）
      if (    $tmp_entered[ 'errMsg' ][ 'entered_postday'  ] == '----' or $tmp_entered[ 'errMsg' ][ 'entered_postmonth'  ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_postyear'   ] == '--'
           or $tmp_entered[ 'errMsg' ][ 'entered_posthour' ] == '--'   or $tmp_entered[ 'errMsg' ][ 'entered_postminite' ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_postsecond' ] == '--' )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_postdate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // 投稿日（日付が不正）
      if ( ! checkdate( $tmp_entered[ 'errMsg' ][ 'entered_postmonth' ], $tmp_entered[ 'errMsg' ][ 'entered_postday' ], $tmp_entered[ 'errMsg' ][ 'entered_postyear' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_postdate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 公開開始日（未指定項目がある）
      if (    $tmp_entered[ 'errMsg' ][ 'entered_openyear' ] == '----' or $tmp_entered[ 'errMsg' ][ 'entered_openmonth'  ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_openday'    ] == '--'
           or $tmp_entered[ 'errMsg' ][ 'entered_openhour' ] == '--'   or $tmp_entered[ 'errMsg' ][ 'entered_openminite' ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_opensecond' ] == '--' )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_opendate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if
      // 公開開始日（日付が不正）
      if ( ! checkdate( $tmp_entered[ 'errMsg' ][ 'entered_openmonth' ], $tmp_entered[ 'errMsg' ][ 'entered_openday' ], $tmp_entered[ 'errMsg' ][ 'entered_openyear' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_opendate';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
        $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
        return false;
      } // end of if

      // 公開終了日はすべて未指定ならチェックしない
      if (     $tmp_entered[ 'errMsg' ][ 'entered_endyear' ] == '----' and $tmp_entered[ 'errMsg' ][ 'entered_endmonth'  ] == '--' and $tmp_entered[ 'errMsg' ][ 'entered_endhour'   ] == '--'
           and $tmp_entered[ 'errMsg' ][ 'entered_endhour' ] == '--'   and $tmp_entered[ 'errMsg' ][ 'entered_endminite' ] == '--' and $tmp_entered[ 'errMsg' ][ 'entered_endsecond' ] == '--' )
      {
        $tmp_entered[ 'errMsg' ][ 'enddate'           ] = '---------- --:--:--';
        $tmp_entered[ 'errMsg' ][ 'entered_endyear'   ] = '----';
        $tmp_entered[ 'errMsg' ][ 'entered_endmonth'  ] = '--';
        $tmp_entered[ 'errMsg' ][ 'entered_endday'    ] = '--';
        $tmp_entered[ 'errMsg' ][ 'entered_endhour'   ] = '--';
        $tmp_entered[ 'errMsg' ][ 'entered_endminite' ] = '--';
        $tmp_entered[ 'errMsg' ][ 'entered_endsecond' ] = '--';
      } // end of if
      else
      {
        // 公開終了日（未指定項目がある）
        if (    $tmp_entered[ 'errMsg' ][ 'entered_endyear' ] == '----' or $tmp_entered[ 'errMsg' ][ 'entered_endmonth'  ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_endhour'   ] == '--'
             or $tmp_entered[ 'errMsg' ][ 'entered_endhour' ] == '--'   or $tmp_entered[ 'errMsg' ][ 'entered_endminite' ] == '--' or $tmp_entered[ 'errMsg' ][ 'entered_endsecond' ] == '--' )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
        // 公開終了日（日付が不正）
        if ( ! checkdate( $tmp_entered[ 'errMsg' ][ 'entered_endmonth' ], $tmp_entered[ 'errMsg' ][ 'entered_endday' ], $tmp_entered[ 'errMsg' ][ 'entered_endyear' ] ) )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
        // 公開終了日（公開開始日と同じかそれ以前になっている）
        if ( mktime( $tmp_entered[ 'errMsg' ][ 'entered_openhour'  ], $tmp_entered[ 'errMsg' ][ 'entered_openminite' ], $tmp_entered[ 'errMsg' ][ 'entered_opensecond' ]
                   , $tmp_entered[ 'errMsg' ][ 'entered_openmonth' ], $tmp_entered[ 'errMsg' ][ 'entered_openday'    ], $tmp_entered[ 'errMsg' ][ 'entered_openyear'   ] )
             >=
             mktime( $tmp_entered[ 'errMsg' ][ 'entered_endhour'  ], $tmp_entered[ 'errMsg' ][ 'entered_endminite' ], $tmp_entered[ 'errMsg' ][ 'entered_endsecond' ]
                   , $tmp_entered[ 'errMsg' ][ 'entered_endmonth' ], $tmp_entered[ 'errMsg' ][ 'entered_endday'    ], $tmp_entered[ 'errMsg' ][ 'entered_endyear'   ] ) )
        {
          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'errMsg' ][ 'message' ] = 'invalid_enddate';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered[ 'errMsg' ] );
          $this->obj_util->redirectTo( 'blogadd_entry', $tmp_cage_current );
          return false;
        } // end of if
      } // end of else



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',            $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered_title',     $this->gotDat[ 'errMsg' ][ 'title'  ] );
      $this->smarty->assign ( 'entered_body',      stripslashes( $this->gotDat[ 'errMsg' ][ 'body' ] ) );
      $this->smarty->assign ( 'entered_postdate',  $this->gotDat[ 'errMsg' ][ 'postdate' ] );
      $this->smarty->assign ( 'entered_opendate',  $this->gotDat[ 'errMsg' ][ 'opendate' ] );
      $this->smarty->assign ( 'entered_enddate',   $this->gotDat[ 'errMsg' ][ 'enddate'  ] );

      $this->smarty->assign ( 'mycage',            str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'blogmod_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogmod_confirm

?>
