<?php
/**
 * 新規ヘッダ追加確認画面クラス
 *
 * 新規ヘッダ追加確認画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headeradd_confirm extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.site」でない or 前画面のActが「headeradd_entry」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'headeradd_entry' ) )
      {
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'act'           ] = null;
      $tmp_entered[ 'cage'          ] = null;
      $tmp_entered[ 'robots_index'  ] = null;
      $tmp_entered[ 'robots_follow' ] = null;
      $tmp_entered[ 'title'         ] = null;
      $tmp_entered[ 'description'   ] = null;
      $tmp_entered[ 'keywords'      ] = null;
      $tmp_entered[ 'author'        ] = null;
      $tmp_entered[ 'javascript'    ] = null;
      $tmp_entered[ 'css'           ] = null;
      $tmp_entered[ 'favicon'       ] = null;

      // act
      if ( isset( $_POST[ 'act'           ] ) )
      {
        $tmp_entered[ 'act'           ] = strip_tags( trim( $_POST[ 'act'           ] ) );
      } // end of if

      // cage
      if ( isset( $_POST[ 'cage'          ] ) )
      {
        $tmp_entered[ 'cage'          ] = strip_tags( trim( $_POST[ 'cage'          ] ) );
      } // end of if

      // robots_index
      if ( isset( $_POST[ 'robots_index'  ] ) )
      {
        $tmp_entered[ 'robots_index'  ] = strip_tags( trim( $_POST[ 'robots_index'  ] ) );
      } // end of if

      // robots_follow
      if ( isset( $_POST[ 'robots_follow' ] ) )
      {
        $tmp_entered[ 'robots_follow' ] = strip_tags( trim( $_POST[ 'robots_follow' ] ) );
      } // end of if

      // title
      if ( isset( $_POST[ 'title'         ] ) )
      {
        $tmp_entered[ 'title'         ] = strip_tags( trim( $_POST[ 'title'         ] ) );
      } // end of if

      // description
      if ( isset( $_POST[ 'description'   ] ) )
      {
        $tmp_entered[ 'description'   ] = strip_tags( trim( $_POST[ 'description'   ] ) );
      } // end of if

      // keywords
      if ( isset( $_POST[ 'keywords'      ] ) )
      {
        $tmp_entered[ 'keywords'      ] = strip_tags( trim( $_POST[ 'keywords'      ] ) );
      } // end of if

      // author
      if ( isset( $_POST[ 'author'        ] ) )
      {
        $tmp_entered[ 'author'        ] = strip_tags( trim( $_POST[ 'author'        ] ) );
      } // end of if

      // javascript
      if ( isset( $_POST[ 'javascript'    ] ) )
      {
        $tmp_entered[ 'javascript'    ] = strip_tags( trim( $_POST[ 'javascript'    ] ) );
      } // end of if

      // css
      if ( isset( $_POST[ 'css'           ] ) )
      {
        $tmp_entered[ 'css'           ] = strip_tags( trim( $_POST[ 'css'           ] ) );
      } // end of if

      // favicon
      if ( isset( $_POST[ 'favicon'       ] ) )
      {
        $tmp_entered[ 'favicon'       ] = strip_tags( trim( $_POST[ 'favicon'       ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // Act
      if ( ! preg_match( "/^[[:alnum:].\-_]{1,255}$/", $tmp_entered[ 'act' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_act';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // Cage
      if ( ! preg_match( "/^[[:alnum:].\-_]{0,255}$/", $tmp_entered[ 'cage' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_cage';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // robots(index)
      if ( $tmp_entered[ 'robots_index' ] != 0 and $tmp_entered[ 'robots_index' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_index';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // robots(follow)
      if ( $tmp_entered[ 'robots_follow' ] != 0 and $tmp_entered[ 'robots_follow' ] != 1 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_robot_follow';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // title
      if ( strlen( $tmp_entered[ 'title' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_title';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // description
      if ( strlen( $tmp_entered[ 'description' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_description';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // keywords
      if ( strlen( $tmp_entered[ 'keywords' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_keywords';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // author
      if ( strlen( $tmp_entered[ 'author' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_author';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // javascript
      if ( strlen( $tmp_entered[ 'javascript' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_javascript';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // css
      if ( strlen( $tmp_entered[ 'css' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_css';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if

      // favicon
      if ( strlen( $tmp_entered[ 'favicon' ] ) > 10000 )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_favicon';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
        return false;
      } // end of if



      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();



      //------------------------------------------------------------------------
      // 既存レコードのチェック
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT count( `headers`.`header_id` ) as cnt  -- カウント
                FROM `risoluto_t_headerinfo` headers
               WHERE `headers`.`act`  = ?
                 AND `headers`.`cage` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'act'  ]
                      , $tmp_entered[ 'cage' ]
                      );

        // SQLの実行に失敗した場合は、入力画面に戻る
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( $tmp_result[ 'cnt' ] != 0 )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();

          // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
          $tmp_entered[ 'message' ] = 'already_exist';
          $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'lastact' ), $tmp_entered );
          $this->obj_util->redirectTo( 'headeradd_entry', 'admin.site' );
          return false;
        } // end of if

        // 接続に成功している場合は接続をクローズする
        $this->obj_db->dbDisConnect();
      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      //------------------------------------------------------------------------
      // 特に問題がなければ、画面表示用にクラス変数とセッションに値をセットする
      //------------------------------------------------------------------------
      $this->gotDat = $tmp_entered;
      $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentact' ), $tmp_entered );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',  $this->obj_util->getHeader() );

      $this->smarty->assign ( 'entered', $this->gotDat );

      // 表示
      $this->smarty->display( 'headeradd_confirm.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headeradd_confirm

?>
