/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BeanProperty;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.XMLBeanInfoDigester;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.EmptyExpression;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.StringExpression;
import org.apache.commons.betwixt.expression.Updater;
import org.apache.commons.betwixt.registry.DefaultXMLBeanInfoRegistry;
import org.apache.commons.betwixt.registry.XMLBeanInfoRegistry;
import org.apache.commons.betwixt.strategy.ClassNormalizer;
import org.apache.commons.betwixt.strategy.DefaultNameMapper;
import org.apache.commons.betwixt.strategy.DefaultPluralStemmer;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.betwixt.strategy.PluralStemmer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLIntrospector {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$XMLIntrospector == null ? (class$org$apache$commons$betwixt$XMLIntrospector = XMLIntrospector.class$("org.apache.commons.betwixt.XMLIntrospector")) : class$org$apache$commons$betwixt$XMLIntrospector));
    private boolean attributesForPrimitives = false;
    private boolean wrapCollectionsInElement = true;
    private XMLBeanInfoRegistry registry = new DefaultXMLBeanInfoRegistry();
    private XMLBeanInfoDigester digester;
    private PluralStemmer pluralStemmer;
    private NameMapper elementNameMapper;
    private ClassNormalizer classNormalizer = new ClassNormalizer();
    private NameMapper attributeNameMapper;
    private boolean useBeanInfoSearchPath = false;
    static /* synthetic */ Class class$org$apache$commons$betwixt$XMLIntrospector;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$org$apache$commons$beanutils$DynaClass;

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public XMLBeanInfoRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(XMLBeanInfoRegistry registry) {
        this.registry = registry;
    }

    public ClassNormalizer getClassNormalizer() {
        return this.classNormalizer;
    }

    public void setClassNormalizer(ClassNormalizer classNormalizer) {
        this.classNormalizer = classNormalizer;
    }

    public boolean isCachingEnabled() {
        return true;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
    }

    public void flushCache() {
    }

    public XMLBeanInfo introspect(Object bean) throws IntrospectionException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Introspecting...");
            this.log.debug(bean);
        }
        if (bean instanceof DynaBean) {
            XMLBeanInfo xmlBeanInfo = this.findByXMLDescriptor(bean.getClass());
            if (xmlBeanInfo != null) {
                return xmlBeanInfo;
            }
            return this.introspect(((DynaBean)bean).getDynaClass());
        }
        Class normalClass = this.getClassNormalizer().getNormalizedClass(bean);
        return this.introspect(normalClass);
    }

    public XMLBeanInfo introspect(DynaClass dynaClass) {
        XMLBeanInfo xmlInfo = this.createXMLBeanInfo(dynaClass);
        DynaClassBeanType beanClass = new DynaClassBeanType(dynaClass);
        this.populate(xmlInfo, beanClass);
        return xmlInfo;
    }

    public XMLBeanInfo introspect(Class aClass) throws IntrospectionException {
        XMLBeanInfo xmlInfo;
        String[] searchPath = null;
        if (!this.useBeanInfoSearchPath) {
            searchPath = Introspector.getBeanInfoSearchPath();
            Introspector.setBeanInfoSearchPath(new String[0]);
        }
        if ((xmlInfo = this.registry.get(aClass)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to lookup an XML descriptor for class: " + aClass));
            }
            if ((xmlInfo = this.findByXMLDescriptor(aClass)) == null) {
                BeanInfo info = Introspector.getBeanInfo(aClass);
                xmlInfo = this.introspect(info);
            }
            if (xmlInfo != null) {
                this.registry.put(aClass, xmlInfo);
            }
        } else {
            this.log.trace((Object)"Used cached XMLBeanInfo.");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)xmlInfo);
        }
        if (!this.useBeanInfoSearchPath) {
            Introspector.setBeanInfoSearchPath(searchPath);
        }
        return xmlInfo;
    }

    public XMLBeanInfo introspect(BeanInfo beanInfo) throws IntrospectionException {
        XMLBeanInfo xmlBeanInfo = this.createXMLBeanInfo(beanInfo);
        this.populate(xmlBeanInfo, new JavaBeanType(beanInfo));
        return xmlBeanInfo;
    }

    private void populate(XMLBeanInfo xmlBeanInfo, BeanType bean) {
        String name = bean.getBeanName();
        ElementDescriptor elementDescriptor = new ElementDescriptor();
        elementDescriptor.setLocalName(this.getElementNameMapper().mapTypeToElementName(name));
        elementDescriptor.setPropertyType(bean.getElementType());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Populating:" + bean));
        }
        if (bean.isPrimitiveType()) {
            this.log.trace((Object)"Bean is primitive");
            elementDescriptor.setTextExpression(StringExpression.getInstance());
            elementDescriptor.setPrimitiveType(true);
        } else if (bean.isLoopType()) {
            this.log.trace((Object)"Bean is loop");
            ElementDescriptor loopDescriptor = new ElementDescriptor();
            loopDescriptor.setContextExpression(new IteratorExpression(EmptyExpression.getInstance()));
            if (bean.isMapType()) {
                loopDescriptor.setQualifiedName("entry");
            }
            elementDescriptor.setElementDescriptors(new ElementDescriptor[]{loopDescriptor});
        } else {
            Descriptor[] descriptors;
            this.log.trace((Object)"Bean is standard type");
            ArrayList elements = new ArrayList();
            ArrayList attributes = new ArrayList();
            ArrayList contents = new ArrayList();
            this.addProperties(bean.getProperties(), elements, attributes, contents);
            int size = elements.size();
            if (size > 0) {
                descriptors = new ElementDescriptor[size];
                elements.toArray(descriptors);
                elementDescriptor.setElementDescriptors((ElementDescriptor[])descriptors);
            }
            if ((size = attributes.size()) > 0) {
                descriptors = new AttributeDescriptor[size];
                attributes.toArray(descriptors);
                elementDescriptor.setAttributeDescriptors((AttributeDescriptor[])descriptors);
            }
            if ((size = contents.size()) > 0 && size > 0) {
                descriptors = new Descriptor[size];
                contents.toArray(descriptors);
                elementDescriptor.setContentDescriptors(descriptors);
            }
        }
        xmlBeanInfo.setElementDescriptor(elementDescriptor);
        XMLIntrospectorHelper.defaultAddMethods(this, elementDescriptor, bean.getElementType());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Populated descriptor:");
            this.log.trace((Object)elementDescriptor);
        }
    }

    protected XMLBeanInfo createXMLBeanInfo(DynaClass dynaClass) {
        XMLBeanInfo beanInfo = new XMLBeanInfo(dynaClass.getClass());
        return beanInfo;
    }

    public boolean isAttributesForPrimitives() {
        return this.attributesForPrimitives;
    }

    public void setAttributesForPrimitives(boolean attributesForPrimitives) {
        this.attributesForPrimitives = attributesForPrimitives;
    }

    public boolean isWrapCollectionsInElement() {
        return this.wrapCollectionsInElement;
    }

    public void setWrapCollectionsInElement(boolean wrapCollectionsInElement) {
        this.wrapCollectionsInElement = wrapCollectionsInElement;
    }

    public PluralStemmer getPluralStemmer() {
        if (this.pluralStemmer == null) {
            this.pluralStemmer = this.createPluralStemmer();
        }
        return this.pluralStemmer;
    }

    public void setPluralStemmer(PluralStemmer pluralStemmer) {
        this.pluralStemmer = pluralStemmer;
    }

    public NameMapper getNameMapper() {
        return this.getElementNameMapper();
    }

    public void setNameMapper(NameMapper nameMapper) {
        this.setElementNameMapper(nameMapper);
    }

    public NameMapper getElementNameMapper() {
        if (this.elementNameMapper == null) {
            this.elementNameMapper = this.createNameMapper();
        }
        return this.elementNameMapper;
    }

    public void setElementNameMapper(NameMapper nameMapper) {
        this.elementNameMapper = nameMapper;
    }

    public NameMapper getAttributeNameMapper() {
        if (this.attributeNameMapper == null) {
            this.attributeNameMapper = this.createNameMapper();
        }
        return this.attributeNameMapper;
    }

    public void setAttributeNameMapper(NameMapper nameMapper) {
        this.attributeNameMapper = nameMapper;
    }

    public Descriptor createDescriptor(PropertyDescriptor propertyDescriptor, boolean useAttributesForPrimitives) throws IntrospectionException {
        return this.createXMLDescriptor(new BeanProperty(propertyDescriptor));
    }

    public Descriptor createXMLDescriptor(BeanProperty beanProperty) {
        String name = beanProperty.getPropertyName();
        Class type = beanProperty.getPropertyType();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating descriptor for property: name=" + name + " type=" + type));
        }
        NodeDescriptor descriptor = null;
        Expression propertyExpression = beanProperty.getPropertyExpression();
        Updater propertyUpdater = beanProperty.getPropertyUpdater();
        if (propertyExpression == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("No read method for property: name=" + name + " type=" + type));
            }
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Property expression=" + propertyExpression));
        }
        if ((class$java$lang$Class == null ? (class$java$lang$Class = XMLIntrospector.class$("java.lang.Class")) : class$java$lang$Class).equals(type) && "class".equals(name)) {
            this.log.trace((Object)"Ignoring class property");
            return null;
        }
        if (this.isPrimitiveType(type)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Primitive type: " + name));
            }
            if (this.isAttributesForPrimitives()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Adding property as attribute: " + name));
                }
                descriptor = new AttributeDescriptor();
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Adding property as element: " + name));
                }
                descriptor = new ElementDescriptor(true);
            }
            descriptor.setTextExpression(propertyExpression);
            if (propertyUpdater != null) {
                descriptor.setUpdater(propertyUpdater);
            }
        } else if (this.isLoopType(type)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Loop type: " + name));
                this.log.trace((Object)("Wrap in collections? " + this.isWrapCollectionsInElement()));
            }
            ElementDescriptor loopDescriptor = new ElementDescriptor();
            loopDescriptor.setContextExpression(new IteratorExpression(propertyExpression));
            loopDescriptor.setWrapCollectionsInElement(this.isWrapCollectionsInElement());
            if ((class$java$util$Map == null ? (class$java$util$Map = XMLIntrospector.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(type)) {
                loopDescriptor.setQualifiedName("entry");
                loopDescriptor.addElementDescriptor(new ElementDescriptor("key"));
                loopDescriptor.addElementDescriptor(new ElementDescriptor("value"));
            }
            ElementDescriptor elementDescriptor = new ElementDescriptor();
            elementDescriptor.setWrapCollectionsInElement(this.isWrapCollectionsInElement());
            elementDescriptor.setElementDescriptors(new ElementDescriptor[]{loopDescriptor});
            descriptor = elementDescriptor;
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Standard property: " + name));
            }
            ElementDescriptor elementDescriptor = new ElementDescriptor();
            elementDescriptor.setContextExpression(propertyExpression);
            if (propertyUpdater != null) {
                elementDescriptor.setUpdater(propertyUpdater);
            }
            descriptor = elementDescriptor;
        }
        if (descriptor instanceof NodeDescriptor) {
            NodeDescriptor nodeDescriptor = descriptor;
            if (descriptor instanceof AttributeDescriptor) {
                nodeDescriptor.setLocalName(this.getAttributeNameMapper().mapTypeToElementName(name));
            } else {
                nodeDescriptor.setLocalName(this.getElementNameMapper().mapTypeToElementName(name));
            }
        }
        descriptor.setPropertyName(name);
        descriptor.setPropertyType(type);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Created descriptor:");
            this.log.trace((Object)descriptor);
        }
        return descriptor;
    }

    protected PluralStemmer createPluralStemmer() {
        return new DefaultPluralStemmer();
    }

    protected NameMapper createNameMapper() {
        return new DefaultNameMapper();
    }

    protected synchronized XMLBeanInfo findByXMLDescriptor(Class aClass) {
        URL url;
        String name = aClass.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        if ((url = aClass.getResource(name = name + ".betwixt")) != null) {
            try {
                String urlText = url.toString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Parsing Betwixt XML descriptor: " + urlText));
                }
                if (this.digester == null) {
                    this.digester = new XMLBeanInfoDigester();
                    this.digester.setXMLIntrospector(this);
                }
                this.digester.setBeanClass(aClass);
                return (XMLBeanInfo)this.digester.parse(urlText);
            }
            catch (Exception e) {
                this.log.warn((Object)("Caught exception trying to parse: " + name), (Throwable)e);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Could not find betwixt file " + name));
        }
        return null;
    }

    protected void addProperties(BeanInfo beanInfo, List elements, List attributes, List contents) throws IntrospectionException {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            int i = 0;
            int size = descriptors.length;
            while (i < size) {
                this.addProperty(beanInfo, descriptors[i], elements, attributes, contents);
                ++i;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)elements);
            this.log.trace((Object)attributes);
            this.log.trace((Object)contents);
        }
    }

    protected void addProperties(BeanProperty[] beanProperties, List elements, List attributes, List contents) {
        if (beanProperties != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(beanProperties.length + " properties to be added"));
            }
            int i = 0;
            int size = beanProperties.length;
            while (i < size) {
                this.addProperty(beanProperties[i], elements, attributes, contents);
                ++i;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"After properties have been added (elements, attributes, contents):");
            this.log.trace((Object)elements);
            this.log.trace((Object)attributes);
            this.log.trace((Object)contents);
        }
    }

    protected void addProperty(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor, List elements, List attributes, List contents) throws IntrospectionException {
        this.addProperty(propertyDescriptor, elements, attributes, contents);
    }

    protected void addProperty(PropertyDescriptor propertyDescriptor, List elements, List attributes, List contents) throws IntrospectionException {
        this.addProperty(new BeanProperty(propertyDescriptor), elements, attributes, contents);
    }

    protected void addProperty(BeanProperty beanProperty, List elements, List attributes, List contents) {
        Descriptor nodeDescriptor = this.createXMLDescriptor(beanProperty);
        if (nodeDescriptor == null) {
            return;
        }
        if (nodeDescriptor instanceof ElementDescriptor) {
            elements.add(nodeDescriptor);
        } else if (nodeDescriptor instanceof AttributeDescriptor) {
            attributes.add(nodeDescriptor);
        } else {
            contents.add(nodeDescriptor);
        }
    }

    protected void addProperties(BeanInfo beanInfo, List elements, List attributes) throws IntrospectionException {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            int i = 0;
            int size = descriptors.length;
            while (i < size) {
                this.addProperty(beanInfo, descriptors[i], elements, attributes);
                ++i;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)elements);
            this.log.trace((Object)attributes);
        }
    }

    protected void addProperty(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor, List elements, List attributes) throws IntrospectionException {
        NodeDescriptor nodeDescriptor = XMLIntrospectorHelper.createDescriptor(propertyDescriptor, this.isAttributesForPrimitives(), this);
        if (nodeDescriptor == null) {
            return;
        }
        if (nodeDescriptor instanceof ElementDescriptor) {
            elements.add(nodeDescriptor);
        } else {
            attributes.add(nodeDescriptor);
        }
    }

    protected XMLBeanInfo createXMLBeanInfo(BeanInfo beanInfo) {
        XMLBeanInfo xmlBeanInfo = new XMLBeanInfo(beanInfo.getBeanDescriptor().getBeanClass());
        return xmlBeanInfo;
    }

    public boolean isLoopType(Class type) {
        return XMLIntrospectorHelper.isLoopType(type);
    }

    public boolean isPrimitiveType(Class type) {
        return XMLIntrospectorHelper.isPrimitiveType(type);
    }

    public boolean useBeanInfoSearchPath() {
        return this.useBeanInfoSearchPath;
    }

    public void setUseBeanInfoSearchPath(boolean useBeanInfoSearchPath) {
        this.useBeanInfoSearchPath = useBeanInfoSearchPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DynaClassBeanType
    extends BeanType {
        private DynaClass dynaClass;
        private BeanProperty[] properties;

        public DynaClassBeanType(DynaClass dynaClass) {
            this.dynaClass = dynaClass;
            DynaProperty[] dynaProperties = dynaClass.getDynaProperties();
            this.properties = new BeanProperty[dynaProperties.length];
            int i = 0;
            int size = dynaProperties.length;
            while (i < size) {
                this.properties[i] = new BeanProperty(dynaProperties[i]);
                ++i;
            }
        }

        public String getBeanName() {
            return this.dynaClass.getName();
        }

        public Class getElementType() {
            return class$org$apache$commons$beanutils$DynaClass == null ? (class$org$apache$commons$beanutils$DynaClass = XMLIntrospector.class$("org.apache.commons.beanutils.DynaClass")) : class$org$apache$commons$beanutils$DynaClass;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMapType() {
            return false;
        }

        public boolean isLoopType() {
            return false;
        }

        public BeanProperty[] getProperties() {
            return this.properties;
        }
    }

    private class JavaBeanType
    extends BeanType {
        private BeanInfo beanInfo;
        private Class beanClass;
        private String name;
        private BeanProperty[] properties;

        public JavaBeanType(BeanInfo beanInfo) {
            this.beanInfo = beanInfo;
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            this.beanClass = beanDescriptor.getBeanClass();
            this.name = beanDescriptor.getName();
            if (this.beanClass.isArray()) {
                this.name = "Array";
            }
        }

        public Class getElementType() {
            return this.beanClass;
        }

        public String getBeanName() {
            return this.name;
        }

        public boolean isPrimitiveType() {
            return XMLIntrospectorHelper.isPrimitiveType(this.beanClass);
        }

        public boolean isLoopType() {
            return XMLIntrospectorHelper.isLoopType(this.beanClass);
        }

        public boolean isMapType() {
            return (class$java$util$Map == null ? (class$java$util$Map = XMLIntrospector.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.beanClass);
        }

        public BeanProperty[] getProperties() {
            if (this.properties == null) {
                BeanInfo[] additionals;
                ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
                PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    int i = 0;
                    int size = descriptors.length;
                    while (i < size) {
                        propertyDescriptors.add(descriptors[i]);
                        ++i;
                    }
                }
                if ((additionals = this.beanInfo.getAdditionalBeanInfo()) != null) {
                    int i = 0;
                    int outerSize = additionals.length;
                    while (i < outerSize) {
                        BeanInfo additionalInfo = additionals[i];
                        descriptors = this.beanInfo.getPropertyDescriptors();
                        if (descriptors != null) {
                            int j = 0;
                            int innerSize = descriptors.length;
                            while (j < innerSize) {
                                propertyDescriptors.add(descriptors[j]);
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                this.properties = new BeanProperty[propertyDescriptors.size()];
                int count = 0;
                Iterator it = ((AbstractList)propertyDescriptors).iterator();
                while (it.hasNext()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)it.next();
                    this.properties[count] = new BeanProperty(propertyDescriptor);
                    ++count;
                }
            }
            return this.properties;
        }
    }

    private abstract class BeanType {
        private BeanType() {
        }

        public abstract String getBeanName();

        public abstract Class getElementType();

        public abstract boolean isPrimitiveType();

        public abstract boolean isMapType();

        public abstract boolean isLoopType();

        public abstract BeanProperty[] getProperties();

        public String toString() {
            return "Bean[name=" + this.getBeanName() + ", type=" + this.getElementType();
        }
    }
}

