/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagerResultSetWrapper;
import org.seasar.extension.jdbc.ResultSetFactory;

public class PagerResultSetFactoryWrapper
implements ResultSetFactory {
    private ResultSetFactory resultSetFactory;
    private boolean useScrollCursor = true;

    public PagerResultSetFactoryWrapper(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public void setUseScrollCursor(boolean useScrollCursor) {
        this.useScrollCursor = useScrollCursor;
    }

    public ResultSet createResultSet(PreparedStatement ps) {
        ResultSet resultSet = this.resultSetFactory.createResultSet(ps);
        Object[] args = PagerContext.getContext().peekArgs();
        if (PagerContext.isPagerCondition(args)) {
            PagerCondition condition = PagerContext.getPagerCondition(args);
            return new PagerResultSetWrapper(resultSet, condition, this.useScrollCursor);
        }
        return resultSet;
    }
}

