/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.dao.AnnotationReaderFactory;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoNotFoundRuntimeException;
import org.seasar.dao.Dbms;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.ValueTypeFactory;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.handler.ProcedureHandlerImpl;
import org.seasar.dao.impl.AbstractAutoStaticCommand;
import org.seasar.dao.impl.AbstractSqlCommand;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.FieldAnnotationReaderFactory;
import org.seasar.dao.impl.InsertAutoDynamicCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.StaticStoredProcedureCommand;
import org.seasar.dao.impl.UpdateAutoDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.dao.impl.ValueTypeFactoryImpl;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public class DaoMetaDataImpl
implements DaoMetaData {
    private static final Pattern startWithOrderByPattern = Pattern.compile("(/\\*[^*]+\\*/)*order by", 2);
    private static final Pattern startWithSelectPattern = Pattern.compile("^\\s*select\\s", 2);
    private static final Pattern startWithBeginCommentPattern = Pattern.compile("/\\*BEGIN\\*/\\s*WHERE .+", 2);
    private static final Pattern startWithIfCommentPattern = Pattern.compile("/\\*IF .+", 2);
    private static final String NOT_SINGLE_ROW_UPDATED = "NotSingleRowUpdated";
    protected Class daoClass;
    protected Class daoInterface;
    protected BeanDesc daoBeanDesc;
    protected DataSource dataSource;
    protected DaoAnnotationReader annotationReader;
    protected StatementFactory statementFactory;
    protected ResultSetFactory resultSetFactory;
    protected AnnotationReaderFactory annotationReaderFactory;
    protected String sqlFileEncoding = "JISAutoDetect";
    protected Dbms dbms;
    protected Class beanClass;
    protected BeanMetaData beanMetaData;
    protected Map sqlCommands = new HashMap();
    protected ValueTypeFactory valueTypeFactory;
    protected String[] daoSuffixes = new String[]{"Dao"};
    protected String[] insertPrefixes = new String[]{"insert", "create", "add"};
    protected String[] updatePrefixes = new String[]{"update", "modify", "store"};
    protected String[] deletePrefixes = new String[]{"delete", "remove"};
    protected String[] unlessNullSuffixes = new String[]{"UnlessNull"};
    protected ResultSetHandlerFactory resultSetHandlerFactory;
    static /* synthetic */ Class class$org$seasar$dao$impl$AbstractDao;

    public DaoMetaDataImpl() {
    }

    public DaoMetaDataImpl(Class daoClass, DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory) {
        this(daoClass, dataSource, statementFactory, resultSetFactory, new FieldAnnotationReaderFactory(), null, null, null, null, null);
    }

    public DaoMetaDataImpl(Class daoClass, DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory, AnnotationReaderFactory annotationReaderFactory) {
        this(daoClass, dataSource, statementFactory, resultSetFactory, annotationReaderFactory, null, null, null, null, null);
    }

    public DaoMetaDataImpl(Class daoClass, DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory, AnnotationReaderFactory annotationReaderFactory, String encoding, String[] daoSuffixes, String[] insertPrefixes, String[] updatePrefixes, String[] deletePrefixes) {
        this.setDaoClass(daoClass);
        this.setDataSource(dataSource);
        this.setStatementFactory(statementFactory);
        this.setResultSetFactory(resultSetFactory);
        this.setAnnotationReaderFactory(annotationReaderFactory);
        this.setValueTypeFactory(new ValueTypeFactoryImpl());
        if (encoding != null) {
            this.setSqlFileEncoding(encoding);
        }
        if (daoSuffixes != null) {
            this.setDaoSuffixes(daoSuffixes);
        }
        if (insertPrefixes != null) {
            this.setInsertPrefixes(insertPrefixes);
        }
        if (updatePrefixes != null) {
            this.setUpdatePrefixes(updatePrefixes);
        }
        if (deletePrefixes != null) {
            this.setDeletePrefixes(deletePrefixes);
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Class daoClass = this.getDaoClass();
        this.daoInterface = this.getDaoInterface(daoClass);
        this.daoBeanDesc = BeanDescFactory.getBeanDesc((Class)daoClass);
        this.annotationReader = this.getAnnotationReaderFactory().createDaoAnnotationReader(this.daoBeanDesc);
        this.setBeanClass(this.annotationReader.getBeanClass());
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData((Connection)con);
            this.dbms = DbmsManager.getDbms(dbMetaData);
            BeanMetaDataImpl beanMetaDataImpl = new BeanMetaDataImpl();
            beanMetaDataImpl.setBeanClass(this.getBeanClass());
            beanMetaDataImpl.setDatabaseMetaData(dbMetaData);
            beanMetaDataImpl.setDbms(this.dbms);
            beanMetaDataImpl.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
            beanMetaDataImpl.setValueTypeFactory(this.getValueTypeFactory());
            beanMetaDataImpl.initialize();
            this.beanMetaData = beanMetaDataImpl;
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        this.resultSetHandlerFactory = new ResultSetHandlerFactoryImpl(this.beanMetaData);
        this.setupSqlCommand();
    }

    protected void setupSqlCommand() {
        BeanDesc idbd = BeanDescFactory.getBeanDesc((Class)this.daoInterface);
        String[] names = idbd.getMethodNames();
        for (int i = 0; i < names.length; ++i) {
            Method[] methods = this.daoBeanDesc.getMethods(names[i]);
            if (methods.length != 1 || !MethodUtil.isAbstract((Method)methods[0])) continue;
            this.setupMethod(methods[0]);
        }
    }

    protected void setupMethod(Method method) {
        this.setupMethod(this.daoInterface, method);
    }

    protected void setupMethod(Class daoInterface, Method method) {
        this.setupMethodByAnnotation(daoInterface, method);
        if (!this.completedSetupMethod(method)) {
            this.setupMethodBySqlFile(daoInterface, method);
        }
        if (!this.completedSetupMethod(method)) {
            this.setupMethodByInterfaces(daoInterface, method);
        }
        if (!this.completedSetupMethod(method)) {
            this.setupMethodBySuperClass(daoInterface, method);
        }
        if (!this.completedSetupMethod(method)) {
            this.setupMethodByAuto(method);
        }
    }

    protected void setupMethodByAnnotation(Class daoInterface, Method method) {
        String procedureName;
        String sql = this.annotationReader.getSQL(method, this.dbms.getSuffix());
        if (sql != null) {
            this.setupMethodByManual(method, sql);
        }
        if ((procedureName = this.annotationReader.getStoredProcedureName(method)) != null) {
            this.setupProcedureMethod(method, procedureName);
        }
    }

    protected void setupProcedureMethod(Method method, String procedureName) {
        ProcedureHandlerImpl handler = new ProcedureHandlerImpl();
        handler.setDataSource(this.dataSource);
        handler.setDaoMethod(method);
        handler.setProcedureName(procedureName);
        handler.setResultSetHandlerFactory(this.resultSetHandlerFactory);
        handler.setStatementFactory(this.statementFactory);
        handler.initialize();
        StaticStoredProcedureCommand command = new StaticStoredProcedureCommand(handler);
        this.sqlCommands.put(method.getName(), command);
    }

    protected String readText(String path) {
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is, (String)this.getSqlFileEncoding());
        return ReaderUtil.readText((Reader)reader);
    }

    protected void setupMethodBySqlFile(Class daoInterface, Method method) {
        String base = daoInterface.getName().replace('.', '/') + "_" + method.getName();
        String dbmsPath = base + this.dbms.getSuffix() + ".sql";
        String standardPath = base + ".sql";
        if (ResourceUtil.isExist((String)dbmsPath)) {
            String sql = this.readText(dbmsPath);
            this.setupMethodByManual(method, sql);
        } else if (ResourceUtil.isExist((String)standardPath)) {
            String sql = this.readText(standardPath);
            this.setupMethodByManual(method, sql);
        }
    }

    protected void setupMethodByInterfaces(Class daoInterface, Method method) {
        Class<?>[] interfaces = daoInterface.getInterfaces();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            Method interfaceMethod = this.getSameSignatureMethod(interfaces[i], method);
            if (interfaceMethod == null) continue;
            this.setupMethod(interfaces[i], interfaceMethod);
        }
    }

    protected void setupMethodBySuperClass(Class daoInterface, Method method) {
        Method superClassMethod;
        Class superDaoClass = daoInterface.getSuperclass();
        if (superDaoClass != null && !Object.class.equals(superDaoClass) && (superClassMethod = this.getSameSignatureMethod(superDaoClass, method)) != null) {
            this.setupMethod(superDaoClass, method);
        }
    }

    protected boolean completedSetupMethod(Method method) {
        return this.sqlCommands.get(method.getName()) != null;
    }

    private Method getSameSignatureMethod(Class clazz, Method method) {
        try {
            String methodName = method.getName();
            Class[] parameterTypes = method.getParameterTypes();
            return ClassUtil.getMethod((Class)clazz, (String)methodName, (Class[])parameterTypes);
        }
        catch (NoSuchMethodRuntimeException e) {
            return null;
        }
    }

    protected void setupMethodByManual(Method method, String sql) {
        if (this.isSelect(method)) {
            this.setupSelectMethodByManual(method, sql);
        } else {
            this.setupUpdateMethodByManual(method, sql);
        }
    }

    protected void setupMethodByAuto(Method method) {
        if (this.isInsert(method.getName())) {
            this.setupInsertMethodByAuto(method);
        } else if (this.isUpdate(method.getName())) {
            this.setupUpdateMethodByAuto(method);
        } else if (this.isDelete(method.getName())) {
            this.setupDeleteMethodByAuto(method);
        } else {
            this.setupSelectMethodByAuto(method);
        }
    }

    protected void setupSelectMethodByManual(Method method, String sql) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(this.createResultSetHandler(method));
        cmd.setSql(sql);
        cmd.setArgNames(this.annotationReader.getArgNames(method));
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands.put(method.getName(), cmd);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler rsh) {
        return new SelectDynamicCommand(this.dataSource, this.statementFactory, rsh, this.resultSetFactory);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler resultSetHandler, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(resultSetHandler);
        StringBuffer buf = new StringBuffer(255);
        if (DaoMetaDataImpl.startsWithSelect(query)) {
            buf.append(query);
        } else {
            String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
            buf.append(sql);
            if (query != null) {
                boolean began = false;
                if (DaoMetaDataImpl.startsWithOrderBy(query)) {
                    buf.append(" ");
                } else if (this.startsWithBeginComment(query)) {
                    buf.append(" ");
                } else if (sql.lastIndexOf("WHERE") < 0) {
                    if (this.startsWithIfComment(query)) {
                        buf.append("/*BEGIN*/");
                        began = true;
                    }
                    buf.append(" WHERE ");
                } else {
                    if (this.startsWithIfComment(query)) {
                        buf.append("/*BEGIN*/");
                        began = true;
                    }
                    buf.append(" AND ");
                }
                buf.append(query);
                if (began) {
                    buf.append("/*END*/");
                }
            }
        }
        cmd.setSql(buf.toString());
        return cmd;
    }

    protected boolean startsWithIfComment(String query) {
        Matcher m = startWithIfCommentPattern.matcher(query);
        return m.lookingAt();
    }

    protected boolean startsWithBeginComment(String query) {
        Matcher m = startWithBeginCommentPattern.matcher(query);
        return m.lookingAt();
    }

    protected static boolean startsWithSelect(String query) {
        Matcher m;
        return query != null && (m = startWithSelectPattern.matcher(query)).lookingAt();
    }

    protected static boolean startsWithOrderBy(String query) {
        Matcher m;
        return query != null && (m = startWithOrderByPattern.matcher(query)).lookingAt();
    }

    protected ResultSetHandler createResultSetHandler(Method method) {
        return this.resultSetHandlerFactory.createResultSetHandler(method);
    }

    protected boolean isBeanClassAssignable(Class clazz) {
        return this.beanClass.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.beanClass);
    }

    protected void setupUpdateMethodByManual(Method method, String sql) {
        UpdateDynamicCommand cmd = new UpdateDynamicCommand(this.dataSource, this.statementFactory);
        cmd.setSql(sql);
        String[] argNames = this.annotationReader.getArgNames(method);
        if (argNames.length == 0 && this.isUpdateSignatureForBean(method)) {
            argNames = new String[]{StringUtil.decapitalize((String)ClassUtil.getShortClassName((Class)this.beanClass))};
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        cmd.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        this.sqlCommands.put(method.getName(), cmd);
    }

    protected boolean isUpdateSignatureForBean(Method method) {
        return method.getParameterTypes().length == 1 && this.isBeanClassAssignable(method.getParameterTypes()[0]);
    }

    protected Class getNotSingleRowUpdatedExceptionClass(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes != null) {
            for (int i = 0; i < exceptionTypes.length; ++i) {
                Class<?> exceptionType = exceptionTypes[i];
                if (exceptionType.getName().indexOf(NOT_SINGLE_ROW_UPDATED) < 0) continue;
                return exceptionType;
            }
        }
        return null;
    }

    protected void setupInsertMethodByAuto(Method method) {
        SqlCommand command;
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        if (this.isUpdateSignatureForBean(method)) {
            InsertAutoDynamicCommand cmd = new InsertAutoDynamicCommand();
            cmd.setBeanMetaData(this.getBeanMetaData());
            cmd.setDataSource(this.dataSource);
            cmd.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
            cmd.setPropertyNames(propertyNames);
            cmd.setStatementFactory(this.statementFactory);
            command = cmd;
        } else {
            InsertBatchAutoStaticCommand cmd;
            command = cmd = new InsertBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.getBeanMetaData(), propertyNames);
        }
        this.sqlCommands.put(method.getName(), command);
    }

    protected void setupUpdateMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        AbstractSqlCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? (this.isUnlessNull(method.getName()) ? this.createUpdateAutoDynamicCommand(method, propertyNames) : new UpdateAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames)) : new UpdateBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames);
        this.sqlCommands.put(method.getName(), cmd);
    }

    private AbstractSqlCommand createUpdateAutoDynamicCommand(Method method, String[] propertyNames) {
        UpdateAutoDynamicCommand uac = new UpdateAutoDynamicCommand(this.dataSource, this.statementFactory);
        uac.setBeanMetaData(this.beanMetaData);
        uac.setPropertyNames(propertyNames);
        uac.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        UpdateAutoDynamicCommand cmd = uac;
        return cmd;
    }

    protected void setupDeleteMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method);
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new DeleteAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames) : new DeleteBatchAutoStaticCommand(this.dataSource, this.statementFactory, this.beanMetaData, propertyNames);
        this.sqlCommands.put(method.getName(), cmd);
    }

    protected String[] getPersistentPropertyNames(Method method) {
        PropertyType pt;
        int i;
        ArrayList<String> names = new ArrayList<String>();
        String[] props = this.annotationReader.getNoPersistentProps(method);
        if (props != null) {
            for (i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
                pt = this.beanMetaData.getPropertyType(i);
                if (!pt.isPersistent() || this.isPropertyExist(props, pt.getPropertyName())) continue;
                names.add(pt.getPropertyName());
            }
        } else {
            props = this.annotationReader.getPersistentProps(method);
            if (props != null) {
                names.addAll(Arrays.asList(props));
                for (i = 0; i < this.beanMetaData.getPrimaryKeySize(); ++i) {
                    String pk = this.beanMetaData.getPrimaryKey(i);
                    PropertyType pt2 = this.beanMetaData.getPropertyTypeByColumnName(pk);
                    names.add(pt2.getPropertyName());
                }
                if (this.beanMetaData.hasVersionNoPropertyType()) {
                    names.add(this.beanMetaData.getVersionNoPropertyName());
                }
                if (this.beanMetaData.hasTimestampPropertyType()) {
                    names.add(this.beanMetaData.getTimestampPropertyName());
                }
            }
        }
        if (names.size() == 0) {
            for (i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
                pt = this.beanMetaData.getPropertyType(i);
                if (!pt.isPersistent()) continue;
                names.add(pt.getPropertyName());
            }
        }
        return names.toArray(new String[names.size()]);
    }

    protected boolean isPropertyExist(String[] props, String propertyName) {
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].equalsIgnoreCase(propertyName)) continue;
            return true;
        }
        return false;
    }

    protected void setupSelectMethodByAuto(Method method) {
        String query = this.annotationReader.getQuery(method);
        ResultSetHandler handler = this.createResultSetHandler(method);
        SelectDynamicCommand cmd = null;
        String[] argNames = this.annotationReader.getArgNames(method);
        Class[] types = method.getParameterTypes();
        if (query != null && !DaoMetaDataImpl.startsWithOrderBy(query)) {
            cmd = this.createSelectDynamicCommand(handler, query);
        } else {
            cmd = this.createSelectDynamicCommand(handler);
            String sql = null;
            if (argNames.length == 0 && method.getParameterTypes().length == 1) {
                Class clazz = method.getParameterTypes()[0];
                if (this.isUpdateSignatureForBean(method)) {
                    clazz = this.beanClass;
                }
                sql = this.createAutoSelectSqlByDto(clazz);
                types = new Class[]{clazz};
            } else {
                sql = this.createAutoSelectSql(argNames);
            }
            if (query != null) {
                sql = sql + " " + query;
            }
            cmd.setSql(sql);
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(types);
        this.sqlCommands.put(method.getName(), cmd);
    }

    protected String createAutoSelectSqlByDto(Class dtoClass) {
        String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (dtoClass.isPrimitive()) {
            return sql;
        }
        DtoMetaDataImpl dmd = this.createDtoMetaData(dtoClass);
        boolean began = false;
        if (sql.lastIndexOf("WHERE") <= 0) {
            buf.append("/*BEGIN*/ WHERE ");
            began = true;
        }
        for (int i = 0; i < dmd.getPropertyTypeSize(); ++i) {
            PropertyType pt = dmd.getPropertyType(i);
            String aliasName = pt.getColumnName();
            if (!this.beanMetaData.hasPropertyTypeByAliasName(aliasName) || !this.beanMetaData.getPropertyTypeByAliasName(aliasName).isPersistent()) continue;
            String columnName = this.beanMetaData.convertFullColumnName(aliasName);
            String propertyName = "dto." + pt.getPropertyName();
            buf.append("/*IF ");
            buf.append(propertyName);
            buf.append(" != null*/");
            buf.append(" ");
            if (!began || i != 0) {
                buf.append("AND ");
            }
            buf.append(columnName);
            buf.append(" = /*");
            buf.append(propertyName);
            buf.append("*/null");
            buf.append("/*END*/");
        }
        if (began) {
            buf.append("/*END*/");
        }
        return buf.toString();
    }

    private DtoMetaDataImpl createDtoMetaData(Class dtoClass) {
        DtoMetaDataImpl dtoMetaData = new DtoMetaDataImpl();
        dtoMetaData.setBeanClass(dtoClass);
        dtoMetaData.setBeanAnnotationReader(this.getAnnotationReaderFactory().createBeanAnnotationReader(dtoClass));
        dtoMetaData.setValueTypeFactory(this.getValueTypeFactory());
        dtoMetaData.initialize();
        for (int i = 0; i < this.beanMetaData.getPropertyTypeSize(); ++i) {
            PropertyType master = this.beanMetaData.getPropertyType(i);
            String name = master.getPropertyName();
            if (!dtoMetaData.hasPropertyType(name)) continue;
            PropertyType slave = dtoMetaData.getPropertyType(name);
            slave.setColumnName(master.getColumnName());
        }
        return dtoMetaData;
    }

    protected String createAutoSelectSql(String[] argNames) {
        String sql = this.dbms.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (argNames.length != 0) {
            boolean began = false;
            if (sql.lastIndexOf("WHERE") <= 0) {
                buf.append("/*BEGIN*/ WHERE ");
                began = true;
            }
            for (int i = 0; i < argNames.length; ++i) {
                String columnName = this.beanMetaData.convertFullColumnName(argNames[i]);
                buf.append("/*IF ");
                buf.append(argNames[i]);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(argNames[i]);
                buf.append("*/null");
                buf.append("/*END*/");
            }
            if (began) {
                buf.append("/*END*/");
            }
        }
        return buf.toString();
    }

    protected void checkAutoUpdateMethod(Method method) {
        if (method.getParameterTypes().length != 1 || !this.isBeanClassAssignable(method.getParameterTypes()[0]) && !method.getParameterTypes()[0].isAssignableFrom(List.class) && !method.getParameterTypes()[0].isArray()) {
            throw new IllegalSignatureRuntimeException("EDAO0006", method.toString());
        }
    }

    protected boolean isSelect(Method method) {
        if (this.isInsert(method.getName())) {
            return false;
        }
        if (this.isUpdate(method.getName())) {
            return false;
        }
        return !this.isDelete(method.getName());
    }

    protected boolean isInsert(String methodName) {
        for (int i = 0; i < this.insertPrefixes.length; ++i) {
            if (!methodName.startsWith(this.insertPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isUpdate(String methodName) {
        for (int i = 0; i < this.updatePrefixes.length; ++i) {
            if (!methodName.startsWith(this.updatePrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isDelete(String methodName) {
        for (int i = 0; i < this.deletePrefixes.length; ++i) {
            if (!methodName.startsWith(this.deletePrefixes[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnlessNull(String methodName) {
        for (int i = 0; i < this.unlessNullSuffixes.length; ++i) {
            if (!methodName.endsWith(this.unlessNullSuffixes[i])) continue;
            return true;
        }
        return false;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    protected void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData;
    }

    public SqlCommand getSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd = (SqlCommand)this.sqlCommands.get(methodName);
        if (cmd == null) {
            throw new MethodNotFoundRuntimeException(this.daoClass, methodName, null);
        }
        return cmd;
    }

    public boolean hasSqlCommand(String methodName) {
        return this.sqlCommands.containsKey(methodName);
    }

    public SqlCommand createFindCommand(String query) {
        return this.createSelectDynamicCommand(new BeanListMetaDataResultSetHandler(this.beanMetaData), query);
    }

    public SqlCommand createFindArrayCommand(String query) {
        return this.createSelectDynamicCommand(new BeanArrayMetaDataResultSetHandler(this.beanMetaData), query);
    }

    public SqlCommand createFindBeanCommand(String query) {
        return this.createSelectDynamicCommand(new BeanMetaDataResultSetHandler(this.beanMetaData), query);
    }

    public SqlCommand createFindObjectCommand(String query) {
        return this.createSelectDynamicCommand((ResultSetHandler)new ObjectResultSetHandler(), query);
    }

    public Class getDaoInterface(Class clazz) {
        if (clazz.isInterface()) {
            return clazz;
        }
        for (Class target = clazz; target != (class$org$seasar$dao$impl$AbstractDao == null ? DaoMetaDataImpl.class$("org.seasar.dao.impl.AbstractDao") : class$org$seasar$dao$impl$AbstractDao); target = target.getSuperclass()) {
            Class<?>[] interfaces = target.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> intf = interfaces[i];
                for (int j = 0; j < this.daoSuffixes.length; ++j) {
                    if (!intf.getName().endsWith(this.daoSuffixes[j])) continue;
                    return intf;
                }
            }
        }
        throw new DaoNotFoundRuntimeException(clazz);
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    protected AnnotationReaderFactory getAnnotationReaderFactory() {
        return this.annotationReaderFactory;
    }

    public void setAnnotationReaderFactory(AnnotationReaderFactory annotationReaderFactory) {
        this.annotationReaderFactory = annotationReaderFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory = statementFactory;
    }

    public void setDaoSuffixes(String[] daoSuffixes) {
        this.daoSuffixes = daoSuffixes;
    }

    public void setDeletePrefixes(String[] deletePrefixes) {
        this.deletePrefixes = deletePrefixes;
    }

    protected String getSqlFileEncoding() {
        return this.sqlFileEncoding;
    }

    public void setSqlFileEncoding(String sencoding) {
        this.sqlFileEncoding = sencoding;
    }

    public void setInsertPrefixes(String[] insertPrefixes) {
        this.insertPrefixes = insertPrefixes;
    }

    public void setUpdatePrefixes(String[] updatePrefixes) {
        this.updatePrefixes = updatePrefixes;
    }

    public void setUnlessNullSuffixes(String[] suffixes) {
        this.unlessNullSuffixes = suffixes;
    }

    protected ValueTypeFactory getValueTypeFactory() {
        return this.valueTypeFactory;
    }

    public void setValueTypeFactory(ValueTypeFactory valueTypeFactory) {
        this.valueTypeFactory = valueTypeFactory;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected Class getDaoClass() {
        return this.daoClass;
    }

    public void setDaoClass(Class daoClass) {
        this.daoClass = daoClass;
    }

    static class ResultSetHandlerFactoryImpl
    implements ResultSetHandlerFactory {
        final BeanMetaData beanMetaData;

        ResultSetHandlerFactoryImpl(BeanMetaData beanMetaData) {
            this.beanMetaData = beanMetaData;
        }

        public ResultSetHandler createResultSetHandler(Method method) {
            Class beanClass = this.beanMetaData.getBeanClass();
            if ((class$java$util$List == null ? (class$java$util$List = DaoMetaDataImpl.class$("java.util.List")) : class$java$util$List).isAssignableFrom(method.getReturnType())) {
                return new BeanListMetaDataResultSetHandler(this.beanMetaData);
            }
            if (this.isBeanClassAssignable(beanClass, method.getReturnType())) {
                return new BeanMetaDataResultSetHandler(this.beanMetaData);
            }
            if (method.getReturnType().isAssignableFrom(Array.newInstance(beanClass, 0).getClass())) {
                return new BeanArrayMetaDataResultSetHandler(this.beanMetaData);
            }
            return new ObjectResultSetHandler();
        }

        private boolean isBeanClassAssignable(Class beanClass, Class clazz) {
            return beanClass.isAssignableFrom(clazz) || clazz.isAssignableFrom(beanClass);
        }
    }
}

