/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/12/13
 *
 */
package com.kickmogu.rhythm.mail;

import java.util.*;
import com.kickmogu.rhythm.mail.ws.*;
import javax.mail.Message;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;

public class MessageIdSearchTerm extends SearchTerm {
	private List<String> msgIds;
	
	public MessageIdSearchTerm(String[] msgIds) {
		this.msgIds = Arrays.asList(msgIds);
	}
	
	public boolean match(Message msg) {
		String orgMsgId = "";
		try {
		    if (msg.getHeader("Message-ID") != null 
		    		 && !StringUtils.isEmpty(msg.getHeader("Message-ID")[0])) {
		    	orgMsgId = msg.getHeader("Message-ID")[0];
			} else {
				orgMsgId = MailWs.getOriginalMessageId(msg);
			}
			return msgIds.indexOf(orgMsgId) > -1;
		} catch (Exception ex) {
			return false;
		}
	}

}
