/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InstantiationRuntimeException;
import org.seasar.framework.exception.NoSuchConstructorRuntimeException;
import org.seasar.framework.exception.NoSuchFieldRuntimeException;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.util.StringUtil;

public final class ClassUtil {
    private static Map wrapperToPrimitiveMap = new HashMap();
    private static Map primitiveToWrapperMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    private ClassUtil() {
    }

    public static Class forName(String className) throws ClassNotFoundRuntimeException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassNotFoundRuntimeException(ex);
        }
    }

    public static Object newInstance(Class clazz) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new InstantiationRuntimeException(clazz, ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(clazz, ex);
        }
    }

    public static Object newInstance(String className) throws ClassNotFoundRuntimeException, InstantiationRuntimeException, IllegalAccessRuntimeException {
        return ClassUtil.newInstance(ClassUtil.forName(className));
    }

    public static boolean isAssignableFrom(Class toClass, Class fromClass) {
        if (toClass == (class$java$lang$Object == null ? (class$java$lang$Object = ClassUtil.class$("java.lang.Object")) : class$java$lang$Object) && !fromClass.isPrimitive()) {
            return true;
        }
        if (toClass.isPrimitive()) {
            fromClass = ClassUtil.getPrimitiveClassIfWrapper(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Class getPrimitiveClass(Class clazz) {
        return (Class)wrapperToPrimitiveMap.get(clazz);
    }

    public static Class getPrimitiveClassIfWrapper(Class clazz) {
        Class ret = ClassUtil.getPrimitiveClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Class getWrapperClass(Class clazz) {
        return (Class)primitiveToWrapperMap.get(clazz);
    }

    public static Class getWrapperClassIfPrimitive(Class clazz) {
        Class ret = ClassUtil.getWrapperClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Constructor getConstructor(Class clazz, Class[] argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchConstructorRuntimeException(clazz, argTypes, ex);
        }
    }

    public static Method getMethod(Class clazz, String methodName, Class[] argTypes) {
        try {
            return clazz.getMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchMethodRuntimeException(clazz, methodName, argTypes, ex);
        }
    }

    public static Field getField(Class clazz, String fieldName) {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new NoSuchFieldRuntimeException(clazz, fieldName, ex);
        }
    }

    public static String getPackageName(Class clazz) {
        String fqcn = clazz.getName();
        int pos = fqcn.lastIndexOf(46);
        if (pos > 0) {
            return fqcn.substring(0, pos);
        }
        return null;
    }

    public static String getShortClassName(Class clazz) {
        String s = clazz.getName();
        int i = s.lastIndexOf(46);
        if (i > 0) {
            return s.substring(i + 1);
        }
        return s;
    }

    public static String getSimpleClassName(Class clazz) {
        if (clazz.isArray()) {
            return ClassUtil.getSimpleClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String concatName(String s1, String s2) {
        return s1 != null ? s1 + '.' + s2 : s2;
    }

    public static String getResourcePath(Class clazz) {
        return StringUtil.replace(clazz.getName(), ".", "/") + ".class";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        wrapperToPrimitiveMap.put(class$java$lang$Character == null ? (class$java$lang$Character = ClassUtil.class$("java.lang.Character")) : class$java$lang$Character, Character.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtil.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Short == null ? (class$java$lang$Short = ClassUtil.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtil.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Long == null ? (class$java$lang$Long = ClassUtil.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Double == null ? (class$java$lang$Double = ClassUtil.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Float == null ? (class$java$lang$Float = ClassUtil.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        wrapperToPrimitiveMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        primitiveToWrapperMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ClassUtil.class$("java.lang.Character")) : class$java$lang$Character);
        primitiveToWrapperMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtil.class$("java.lang.Byte")) : class$java$lang$Byte);
        primitiveToWrapperMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ClassUtil.class$("java.lang.Short")) : class$java$lang$Short);
        primitiveToWrapperMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtil.class$("java.lang.Integer")) : class$java$lang$Integer);
        primitiveToWrapperMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ClassUtil.class$("java.lang.Long")) : class$java$lang$Long);
        primitiveToWrapperMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ClassUtil.class$("java.lang.Double")) : class$java$lang$Double);
        primitiveToWrapperMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ClassUtil.class$("java.lang.Float")) : class$java$lang$Float);
        primitiveToWrapperMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }
}

