/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/11/28
 *
 */
package com.kickmogu.rhythm.mail.test;

import com.kickmogu.rhythm.core.ws.MemberWs;
import com.kickmogu.rhythm.core.*;
import com.kickmogu.rhythm.mail.Mail;
import com.kickmogu.rhythm.mail.ws.MailWs;
import javax.mail.*;

public class ImapTest {

	public static void main(String[] args) throws Exception {
		int mailSettingId = 1;
		MemberWs memWs = new MemberWs();
		BaseResult result = memWs.authorize("mogu", args[0]);
		Member me = (Member) result.getResult();
		MailWs mailDao = new MailWs();
		String folders = (String) mailDao.listFolders(me, mailSettingId).getResult();
		System.out.println("-----------Folder List------------");
		//for (int i = 0; i < folders.length; i++) {
			System.out.println(folders);
		//}
		
		Mail[] mails = (Mail[]) mailDao.listMails(me, mailSettingId, "Cyrus.Kickmogu", false).getResult();
		System.out.println("-----------Mail List------------");
		for (int i = 0; i < mails.length; i++) {
			System.out.println(mails[i].getSubject() + ":" + mails[i].getMsgId());
		}
		Folder inbox = mailDao.getTargetFolder(me, mailSettingId, "Test");
		inbox.open(Folder.READ_ONLY);
		try {
			Message[] msgs = mailDao.msgId2MsgNo(inbox, new String[] {
					"<200610161943.i93LacTw000630@www5.sikorsky.com>",
			});
			System.out.println("-----------Searched Mail List------------");
			for (int i = 0; i < msgs.length; i++) {
				System.out.println("msg " + i + ":" + msgs[i].getSubject());
			}
		} finally {
			inbox.close(false);
		}
		
		System.out.println("delete result code: " + mailDao.deleteMail(me, mailSettingId, "Test", new String[] {mails[0].getMsgId()}).getStatusCode());
	}

}
