/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2005/11/24
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package com.kickmogu.rhythm.core;

import org.apache.log4j.Category;

public class Permission extends RhythmTree {
	static Category log = Category.getInstance(Permission.class.getName());

	public final static String ROLE_ALL = "ROLE_ALL";
	public final static String USER_MANAGE = "USER_MANAGE";
	public final static String ROLE_MANAGE = "ROLE_MANAGE";
	public final static String USER_VIEW = "USER_VIEW";

	public final static String PERMISSION_ALL	= "PERMISSION_ALL";

	String code;
	String className;
	
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}
	
	protected String getXmlOpenTag() {
		return "<" + this.getClass().getName().replace(".", "_")
		+ " id=\"" + getId() + "\""
		+ " code=\"" + getCode() + "\""
		+ " className=\"" + getClassName() + "\""
		+ " name=\"" + getName() + "\">\n";
	}
	
	/**
	 * TreeŜIDCX^XT
	 * @param condId
	 * @return
	 */
	public static Permission searchByCode(String condCode) {
		return ((Permission) RhythmTreeManager.getRoot(Permission.class)).searchByCodeImpl(condCode);
	}

	/**
	 * w肳ꂽPermissionCodeThisCX^X̎}܂߂c[ɑĂ邩`FbN
	 * @param permCode
	 * @return true EEE@w肳ꂽPermissionCode܂܂Ă
	 */
	public boolean isIncludePermission(String permCode) {
		Permission perm = searchByCode(permCode);
		if (perm == null) {
			log.error("permission code not found:" + permCode);
			return false;
		}
		return search(perm.getId()) != null;
	}

	public Permission searchByCodeImpl(String condCode) {
		if (getCode().equals(condCode)) {
			return this;
		}
		for (int i = 0; i < getChildren().size(); i++) {
			Permission result = ((Permission) getChildren().get(i)).searchByCodeImpl(condCode);
			if (result != null) {
				return result;
			}
		}
		return null;
	}

	/**
	 * @return className ߂܂B
	 */
	public String getClassName() {
		return className;
	}

	/**
	 * @param className className ݒB
	 */
	public void setClassName(String className) {
		this.className = className;
	}
	
	
	/**
	 * f[^쐬
	 */
	public static void main(String[] arg) throws Exception {
		Permission rootPerm = new Permission();
		rootPerm.setName("SĂ̌");
		rootPerm.setCode(PERMISSION_ALL);
		
		Permission rolePerm = new Permission();
		rolePerm.setName("[UO[Ǘ");
		rolePerm.setCode(ROLE_ALL);
		rootPerm.addToChild(rolePerm);
		rolePerm.setClassName(Role.class.getName());

		Permission roleChildPerm = new Permission();
		roleChildPerm.setName("[UQ");
		roleChildPerm.setCode(USER_VIEW);
		roleChildPerm.setClassName(Role.class.getName());
		rolePerm.addToChild(roleChildPerm);
		
		roleChildPerm = new Permission();
		roleChildPerm.setName("[UO[vǗ");
		roleChildPerm.setCode(ROLE_MANAGE);
		roleChildPerm.setClassName(Role.class.getName());
		rolePerm.addToChild(roleChildPerm);
		
		roleChildPerm = new Permission();
		roleChildPerm.setName("[UǗ");
		roleChildPerm.setCode(USER_MANAGE);
		roleChildPerm.setClassName(Role.class.getName());
		rolePerm.addToChild(roleChildPerm);
		
		RhythmTreeManager.setRoot(rootPerm);
		RhythmTreeManager.write(Permission.class);
	}

}
