/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2006/11/28
 *
 */
package com.kickmogu.rhythm.core;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Category;

import com.kickmogu.Config;

public class MailSetting {
	static Category log = Category.getInstance(MailSetting.class.getName());

	public final static String UNIQ_KEYNAME = "rhythm " + MailSetting.class.getName() + " id";

	private int id;
	private int memberId;
	private String name;					// ݒ薼
	private String senderName;
	private String imapLoginid;
	private String imapHost;
	private String imapPassword;
	private String smtpHost;
	private String email;
	private String mailSendedFolder = "Sent";
	private String mailFooter;
	
	/**
	 * @return id ߂܂B
	 */
	public int getId() {
		return id;
	}
	/**
	 * @param id id ݒB
	 */
	public void setId(int id) {
		this.id = id;
	}
	/**
	 * @return imapHost ߂܂B
	 */
	public String getImapHost() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.mailsetting.imap_host"))) {
			return Config.getProperty("demo.mailsetting.imap_host");
		}
		return imapHost;
	}
	/**
	 * @param imapHost imapHost ݒB
	 */
	public void setImapHost(String imapHost) {
		this.imapHost = imapHost;
	}
	/**
	 * @return imapLoginid ߂܂B
	 */
	public String getImapLoginid() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.mailsetting.imap_user"))) {
			return Config.getProperty("demo.mailsetting.imap_user");
		}
		return imapLoginid;
	}
	/**
	 * @param imapLoginid imapLoginid ݒB
	 */
	public void setImapLoginid(String imapLoginid) {
		this.imapLoginid = imapLoginid;
	}
	/**
	 * @return impaPassword ߂܂B
	 */
	public String getImapPassword() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.mailsetting.imap_password"))) {
			return Config.getProperty("demo.mailsetting.imap_password");
		}
		return imapPassword;
	}
	/**
	 * @param impaPassword impaPassword ݒB
	 */
	public void setImapPassword(String impaPassword) {
		this.imapPassword = impaPassword;
	}
	/**
	 * @return smtpHost ߂܂B
	 */
	public String getSmtpHost() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.mailsetting.smtp_host"))) {
			return Config.getProperty("demo.mailsetting.smtp_host");
		}
		return smtpHost;
	}
	/**
	 * @param smtpHost smtpHost ݒB
	 */
	public void setSmtpHost(String smtpHost) {
		this.smtpHost = smtpHost;
	}
	/**
	 * @return email ߂܂B
	 */
	public String getEmail() {
		if (!StringUtils.isEmpty(Config.getProperty("demo.mailsetting.email"))) {
			return Config.getProperty("demo.mailsetting.email");
		}
		return email;
	}
	/**
	 * @param email email ݒB
	 */
	public void setEmail(String email) {
		this.email = email;
	}
	/**
	 * @return mailSendedFolder ߂܂B
	 */
	public String getMailSendedFolder() {
		return mailSendedFolder;
	}
	/**
	 * @param mailSendedFolder mailSendedFolder ݒB
	 */
	public void setMailSendedFolder(String mailSendedFolder) {
		this.mailSendedFolder = mailSendedFolder;
	}

	/**
	 * @return mailFooter ߂܂B
	 */
	public String getMailFooter() {
		return mailFooter;
	}
	/**
	 * @param mailFooter mailFooter ݒB
	 */
	public void setMailFooter(String mailFooter) {
		this.mailFooter = mailFooter;
	}
	/**
	 * @return member_id ߂܂B
	 */
	public int getMemberId() {
		return memberId;
	}
	/**
	 * @param member_id member_id ݒB
	 */
	public void setMemberId(int member_id) {
		this.memberId = member_id;
	}
	/**
	 * @return sendname ߂܂B
	 */
	public String getSenderName() {
		return senderName;
	}
	/**
	 * @param sendname sendname ݒB
	 */
	public void setSenderName(String sendname) {
		this.senderName = sendname;
	}
	/**
	 * @return name ߂܂B
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name name ݒB
	 */
	public void setName(String name) {
		this.name = name;
	}

}
