/*
 * Copyright 2007 Kickmogu Co. Ltd. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */



/*
 * 쐬: 2005/06/23
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
package com.kickmogu.rhythm.todo.dao;

import java.util.Date;
import com.kickmogu.rhythm.todo.*;

/**
 * @author mogu
 */
public interface TodoDao {
    public Class BEAN = Todo.class;
    
    public static final String BasicSql = "select Todo.*, Member.name as registrantName "
    	+ " , (select max(todoworker.kind) from todoworker where todoid = todo.id and memberid=?) as myRole"
    	+ " from Todo, Member where deleted = 0 and ";
    public static final String JoinSql = " and Todo.registrant = Member.id";
    
    public static final String listRootTodos_SQL = BasicSql + " kind = 0 and parentid = 0 and depth = 0 and todoTreeId = ? " + JoinSql + " order by rootId, seq";
    public static final String listTodoThreads_SQL = BasicSql + " kind = 0 and parentid = 0 and rootId = ? " + JoinSql + " order by seq";
    public static final String listTodoFlat_SQL = BasicSql + " planFromDate is not null and planToDate is not null and kind = 0 and parentid = 0 and rootId = ? " + JoinSql + " order by seq";
    public static final String getTodo_SQL = BasicSql + "Todo.id = ?" + JoinSql;
    public static final String listSchedules_SQL = BasicSql + "((registrant in /*registrant*/('0', '2') and kind = 1 and open = true) or (kind = 0 and todoTreeId in /*todoTreeId*/('0','1') and open = true) "
    	+ " or (registrant = /*owner*/ and open = false))"
    	+ " and  (planfromDate between /*fr1*/ and /*fr2*/ or plantoDate between /*to1*/ and /*to2*/) " + JoinSql;
    public static final String listSchedules_ARGS = "searcherId,registrant,todoTreeId,owner,fr1,fr2,to1,to2";
    public static final String listHolidays_SQL = "select -id as id, name as subject, day as planFromDate, day as planFromDate from holiday";
    
    public int update(Todo todo);
    
    public int insert(Todo todo);

    public int delete(Todo todo);
    
    public Todo getTodo(int searcherId, int id);

    public Todo[] listRootTodos(int searcherId, int categoryId);
    
    public Todo[] listTodoThreads(int searcherId, int rootId);

    public Todo[] listTodoFlat(int searcherId, int rootId);

    public Todo[] listSchedules(int searcherId, int[] registrant, int[] todoTreeId, int owner, Date fromDate, Date fromDate2, Date toDate, Date toDate2);

    public Todo[] listHolidays();
}
