/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.node;

import org.seasar.dao.CommandContext;
import org.seasar.dao.IllegalBoolExpressionRuntimeException;
import org.seasar.dao.node.ContainerNode;
import org.seasar.dao.node.ElseNode;
import org.seasar.framework.util.OgnlUtil;

public class IfNode
extends ContainerNode {
    private String expression;
    private Object parsedExpression;
    private ElseNode elseNode;

    public IfNode(String expression) {
        this.expression = expression;
        this.parsedExpression = OgnlUtil.parseExpression((String)expression);
    }

    public String getExpression() {
        return this.expression;
    }

    public ElseNode getElseNode() {
        return this.elseNode;
    }

    public void setElseNode(ElseNode elseNode) {
        this.elseNode = elseNode;
    }

    public void accept(CommandContext ctx) {
        Object result = OgnlUtil.getValue((Object)this.parsedExpression, (Object)ctx);
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                super.accept(ctx);
                ctx.setEnabled(true);
            } else if (this.elseNode != null) {
                this.elseNode.accept(ctx);
                ctx.setEnabled(true);
            }
        } else {
            throw new IllegalBoolExpressionRuntimeException(this.expression);
        }
    }
}

