/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.handler;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.handler.AbstractBasicProcedureHandler;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class ProcedureHandlerImpl
extends AbstractBasicProcedureHandler {
    private Method daoMethod;
    private ResultSetHandlerFactory resultSetHandlerFactory;
    private int outParameterNumbers;

    public void initialize() {
        this.outParameterNumbers = this.initTypes();
    }

    protected Object execute(Connection connection, Object[] args) {
        CallableStatement cs = null;
        try {
            cs = this.prepareCallableStatement(connection);
            this.bindArgs(cs, args);
            if (cs.execute()) {
                Object object = this.handleResultSet(cs);
                return object;
            }
            Object object = this.handleNoResultSet(cs);
            return object;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        finally {
            StatementUtil.close((Statement)cs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResultSet(CallableStatement cs) throws SQLException {
        ResultSet rs = null;
        try {
            rs = cs.getResultSet();
            if (rs == null) {
                throw new IllegalStateException("JDBC Driver's BUG");
            }
            Object object = this.resultSetHandlerFactory.createResultSetHandler(this.daoMethod).handle(rs);
            return object;
        }
        finally {
            ResultSetUtil.close((ResultSet)rs);
        }
    }

    protected Object handleNoResultSet(CallableStatement cs) throws SQLException {
        Class<?> returnType;
        if (Map.class.isAssignableFrom(returnType = this.daoMethod.getReturnType())) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (int i = 0; i < this.columnInOutTypes.length; ++i) {
                if (!this.isOutputColum(this.columnInOutTypes[i])) continue;
                result.put(this.columnNames[i], cs.getObject(i + 1));
            }
            return result;
        }
        if (this.outParameterNumbers > 1) {
            throw new SRuntimeException("EDAO0010");
        }
        for (int i = 0; i < this.columnInOutTypes.length; ++i) {
            if (!this.isOutputColum(this.columnInOutTypes[i])) continue;
            return cs.getObject(i + 1);
        }
        return null;
    }

    public void setDaoMethod(Method method) {
        this.daoMethod = method;
    }

    public void setResultSetHandlerFactory(ResultSetHandlerFactory resultSetHandlerFactory) {
        this.resultSetHandlerFactory = resultSetHandlerFactory;
    }
}

