/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;

public final class DbmsManager {
    private static Map dbmses = new HashMap();

    private DbmsManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dbms getDbms(DataSource dataSource) {
        Dbms dbms = null;
        Connection con = DataSourceUtil.getConnection((DataSource)dataSource);
        try {
            DatabaseMetaData dmd = ConnectionUtil.getMetaData((Connection)con);
            dbms = DbmsManager.getDbms(dmd);
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        return dbms;
    }

    public static Dbms getDbms(DatabaseMetaData dmd) {
        return DbmsManager.getDbms(DatabaseMetaDataUtil.getDatabaseProductName((DatabaseMetaData)dmd));
    }

    public static Dbms getDbms(String productName) {
        Dbms dbms = (Dbms)dbmses.get(productName);
        if (dbms == null) {
            dbms = (Dbms)dbmses.get("");
        }
        return dbms;
    }

    static {
        Properties dbmsClassNames = ResourceUtil.getProperties((String)"dbms.properties");
        Iterator<Object> i = dbmsClassNames.keySet().iterator();
        while (i.hasNext()) {
            String productName = (String)i.next();
            Dbms dbms = (Dbms)ClassUtil.newInstance((String)dbmsClassNames.getProperty(productName));
            dbmses.put(productName, dbms);
        }
    }
}

