/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ArgDefAware;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerNotRegisteredRuntimeException;
import org.seasar.framework.container.MethodDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;

public class S2ContainerServlet
extends HttpServlet {
    private static final long serialVersionUID = 407266935204779128L;
    public static final String CONFIG_PATH_KEY = "configPath";
    public static final String DEBUG_KEY = "debug";
    public static final String COMMAND = "command";
    public static final String RESTART = "restart";
    public static final String LIST = "list";
    public static final String PATH = "path";
    private static S2ContainerServlet instance;
    private boolean debug;
    static /* synthetic */ Class class$org$seasar$framework$container$impl$ArgDefImpl;

    public S2ContainerServlet() {
        instance = this;
    }

    public static S2ContainerServlet getInstance() {
        return instance;
    }

    public void init() {
        String configPath = null;
        String debugStr = null;
        ServletConfig servletConfig = this.getServletConfig();
        if (servletConfig != null) {
            configPath = servletConfig.getInitParameter(CONFIG_PATH_KEY);
            debugStr = servletConfig.getInitParameter(DEBUG_KEY);
        }
        if (!StringUtil.isEmpty(configPath)) {
            SingletonS2ContainerFactory.setConfigPath(configPath);
        }
        if (!StringUtil.isEmpty(debugStr)) {
            this.debug = Boolean.valueOf(debugStr);
        }
        SingletonS2ContainerFactory.setServletContext(this.getServletContext());
        SingletonS2ContainerFactory.init();
    }

    public void destroy() {
        SingletonS2ContainerFactory.destroy();
    }

    public static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getParameter(COMMAND);
        if (this.debug && RESTART.equalsIgnoreCase(command)) {
            this.destroy();
            this.init();
            response.getWriter().write("S2ContainerServlet is restarted.");
        } else if (this.debug && LIST.equalsIgnoreCase(command)) {
            this.list(request, response);
        } else {
            response.getWriter().write("S2ContainerServlet is running.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void list(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String path = request.getParameter(PATH);
        S2Container container = this.getContainer(path);
        if (container == null) {
            out.write("S2Container[" + container.getPath() + "] is not found.");
            return;
        }
        out.write("<html><head><title>S2 Components</title></head><body>");
        try {
            out.write("<h1>S2Container</h1>");
            out.write("<ul>");
            try {
                out.write("<li>path : <code>" + container.getPath() + "</code></li>");
                String nameSpace = container.getNamespace();
                if (!StringUtil.isEmpty(nameSpace)) {
                    out.write("<li>namespace : <code>" + nameSpace + "</code></li>");
                }
            }
            finally {
                out.write("</ul>");
            }
            this.listInclude(container, request, out);
            this.listComponent(container, out);
        }
        finally {
            out.write("</body></html>");
        }
    }

    protected S2Container getContainer(String path) {
        S2Container root = SingletonS2ContainerFactory.getContainer();
        try {
            return StringUtil.isEmpty(path) ? root : root.getDescendant(path);
        }
        catch (ContainerNotRegisteredRuntimeException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listInclude(S2Container container, HttpServletRequest request, PrintWriter out) throws IOException {
        if (container.getChildSize() == 0) {
            return;
        }
        out.write("<h2>Includes</h2>");
        out.write("<p><ul>");
        try {
            String requestUri = request.getRequestURI();
            String queryString = "?command=list&path=";
            for (int i = 0; i < container.getChildSize(); ++i) {
                S2Container child = container.getChild(i);
                String path = child.getPath();
                out.write("<li><a href='" + requestUri + "?command=list&path=" + path + "'><code>" + path + "</code></a></li>");
            }
        }
        finally {
            out.write("</ul></p>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listComponent(S2Container container, PrintWriter out) throws IOException {
        if (container.getComponentDefSize() == 0) {
            return;
        }
        out.write("<h2>Components</h2>");
        out.write("<p><ul>");
        try {
            for (int i = 0; i < container.getComponentDefSize(); ++i) {
                ComponentDef cd = container.getComponentDef(i);
                this.printComponent(cd, out);
            }
        }
        finally {
            out.write("</ul></p>");
        }
    }

    protected void printComponent(ComponentDef cd, PrintWriter out) throws IOException {
        String name = cd.getComponentName();
        Class clazz = cd.getComponentClass();
        out.write("<li style='list-style-type: square'><code><strong>" + (name != null ? name : "-") + " [" + (clazz != null ? clazz.getName() : "-") + "]</strong></code>");
        out.write("<ul>");
        out.write("<li style='list-style-type: circle'>instance : <code>" + cd.getInstanceDef().getName() + "</code></li>");
        out.write("<li style='list-style-type: circle'>autoBinding : <code>" + cd.getAutoBindingDef().getName() + "</code></li>");
        String expr = cd.getExpression();
        if (!StringUtil.isEmpty(expr)) {
            out.write("<li style='list-style-type: circle'>ognl : <code>" + expr + "</code></li>");
        }
        this.printArg(cd, out);
        this.printAspect(cd, out);
        this.printProperty(cd, out);
        this.printInitMethod(cd, out);
        this.printDestroyMethod(cd, out);
        try {
            Object component = cd.getComponent();
            out.write("<li style='list-style-type: circle'>toString : <pre style='border-style: solid; border-width: 1'>" + component + "</pre></li>");
        }
        catch (Exception ignore) {
            // empty catch block
        }
        out.write("</ul>");
    }

    protected void printArg(ArgDefAware cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getArgDefSize(); ++i) {
            ComponentDef child;
            out.write("<li style='list-style-type: circle'>arg<ul>");
            ArgDef ad = cd.getArgDef(i);
            String expr = ad.getExpression();
            if (!StringUtil.isEmpty(expr)) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + expr + "</code></li>");
            }
            if ((child = this.getChildComponentDef(ad)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    protected void printAspect(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getAspectDefSize(); ++i) {
            ComponentDef child;
            String expr;
            String[] pointCuts;
            out.write("<li style='list-style-type: circle'>aspect<ul>");
            AspectDef ad = cd.getAspectDef(i);
            PointcutImpl pc = (PointcutImpl)ad.getPointcut();
            if (pc != null && (pointCuts = pc.getMethodNames()) != null && pointCuts.length > 0) {
                out.write("<li style='list-style-type: circle'>pointcut<ul>");
                for (int j = 0; j < pointCuts.length; ++j) {
                    out.write("<li style='list-style-type: circle'><code>" + pointCuts[j] + "</code></li>");
                }
                out.write("</ul></li>");
            }
            if (!StringUtil.isEmpty(expr = ad.getExpression())) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + expr + "</code></li>");
            }
            if ((child = this.getChildComponentDef(ad)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    protected void printProperty(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getPropertyDefSize(); ++i) {
            ComponentDef child;
            out.write("<li style='list-style-type: circle'>property<ul>");
            PropertyDef pd = cd.getPropertyDef(i);
            out.write("<li style='list-style-type: circle'>name : <code>" + pd.getPropertyName() + "</code></li>");
            String expr = pd.getExpression();
            if (!StringUtil.isEmpty(expr)) {
                out.write("<li style='list-style-type: circle'>ognl : <code>" + expr + "</code></li>");
            }
            if ((child = this.getChildComponentDef(pd)) != null) {
                this.printComponent(child, out);
            }
            out.write("</ul></li>");
        }
    }

    protected void printInitMethod(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getInitMethodDefSize(); ++i) {
            out.write("<li style='list-style-type: circle'>initMethod<ul>");
            this.printMethod(cd.getInitMethodDef(i), out);
            out.write("</ul></li>");
        }
    }

    protected void printDestroyMethod(ComponentDef cd, PrintWriter out) throws IOException {
        for (int i = 0; i < cd.getDestroyMethodDefSize(); ++i) {
            out.write("<li style='list-style-type: circle'>destroyMethod<ul>");
            this.printMethod(cd.getDestroyMethodDef(i), out);
            out.write("</ul></li>");
        }
    }

    protected void printMethod(MethodDef md, PrintWriter out) throws IOException {
        ComponentDef child;
        out.write("<li style='list-style-type: circle'>name : <code>" + md.getMethodName() + "</code></li>");
        String expr = md.getExpression();
        if (!StringUtil.isEmpty(expr)) {
            out.write("<li style='list-style-type: circle'>ognl : <code>" + expr + "</code></li>");
        }
        if ((child = this.getChildComponentDef(md)) != null) {
            this.printComponent(child, out);
        }
    }

    protected ComponentDef getChildComponentDef(Object o) {
        try {
            Field f = (class$org$seasar$framework$container$impl$ArgDefImpl == null ? (class$org$seasar$framework$container$impl$ArgDefImpl = S2ContainerServlet.class$("org.seasar.framework.container.impl.ArgDefImpl")) : class$org$seasar$framework$container$impl$ArgDefImpl).getDeclaredField("childComponentDef");
            ((AccessibleObject)f).setAccessible(true);
            return (ComponentDef)f.get(o);
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

