/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util.xa;

import javax.transaction.xa.Xid;

public class XidWrapper
implements Xid {
    private final Xid xid;
    private final String asString;
    private final int hashCode;

    public static final Xid wrap(Xid xid) {
        return XidWrapper.wrap(xid, false);
    }

    public static final Xid wrap(Xid xid, boolean includeBranch) {
        return xid instanceof XidWrapper ? xid : new XidWrapper(xid, includeBranch);
    }

    private XidWrapper(Xid xid, boolean includeBranch) {
        this.xid = xid;
        StringBuffer b = new StringBuffer(64);
        b.append(new String(xid.getGlobalTransactionId()));
        if (includeBranch) {
            b.append("-").append(new String(xid.getBranchQualifier()));
        }
        this.asString = b.toString();
        this.hashCode = this.asString.hashCode();
    }

    public Xid getXid() {
        return this.xid;
    }

    public int getFormatId() {
        return this.xid.getFormatId();
    }

    public byte[] getGlobalTransactionId() {
        return this.xid.getGlobalTransactionId();
    }

    public byte[] getBranchQualifier() {
        return this.xid.getBranchQualifier();
    }

    public boolean equals(Object o) {
        return o != null && this.asString.equals(o.toString());
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

