/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io;

import java.beans.IntrospectionException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.io.AbstractBeanWriter;
import org.apache.commons.betwixt.io.WriteContext;
import org.apache.commons.betwixt.strategy.MixedContentEncodingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BeanWriter
extends AbstractBeanWriter {
    private Writer writer;
    private static final String EOL = "\n";
    private String endOfLine = "\n";
    private String indent;
    private boolean autoFlush;
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$io$BeanWriter == null ? (class$org$apache$commons$betwixt$io$BeanWriter = BeanWriter.class$("org.apache.commons.betwixt.io.BeanWriter")) : class$org$apache$commons$betwixt$io$BeanWriter));
    private boolean currentElementIsEmpty = false;
    private boolean currentElementHasBodyText = false;
    private boolean closedStartTag = true;
    private int indentLevel;
    private MixedContentEncodingStrategy mixedContentEncodingStrategy = MixedContentEncodingStrategy.DEFAULT;
    static /* synthetic */ Class class$org$apache$commons$betwixt$io$BeanWriter;

    public BeanWriter() {
        this(System.out);
    }

    public BeanWriter(OutputStream out) {
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
        this.autoFlush = true;
    }

    public BeanWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        this.autoFlush = true;
    }

    public BeanWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeXmlDeclaration(String xmlDeclaration) throws IOException {
        this.writer.write(xmlDeclaration);
        this.printLine();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Object bean) throws IOException, SAXException, IntrospectionException {
        super.write(bean);
        if (this.autoFlush) {
            this.writer.flush();
        }
    }

    public void enablePrettyPrint() {
        this.endOfLine = EOL;
        this.indent = "  ";
    }

    public String getEndOfLine() {
        return this.endOfLine;
    }

    public void setEndOfLine(String endOfLine) {
        this.endOfLine = endOfLine;
        int i = 0;
        while (i < endOfLine.length()) {
            if (!Character.isWhitespace(endOfLine.charAt(i))) {
                this.log.warn((Object)"Invalid EndOfLine character(s)");
                break;
            }
            ++i;
        }
    }

    public String getIndent() {
        return this.indent;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public MixedContentEncodingStrategy getMixedContentEncodingStrategy() {
        return this.mixedContentEncodingStrategy;
    }

    public void setMixedContentEncodingStrategy(MixedContentEncodingStrategy strategy) {
        this.mixedContentEncodingStrategy = strategy;
    }

    protected void startElement(WriteContext context, String uri, String localName, String qualifiedName, Attributes attr) throws IOException, SAXException {
        if (!this.closedStartTag) {
            this.writer.write(62);
            this.printLine();
        }
        ++this.indentLevel;
        this.indent();
        this.writer.write(60);
        this.writer.write(qualifiedName);
        int i = 0;
        while (i < attr.getLength()) {
            this.writer.write(32);
            this.writer.write(attr.getQName(i));
            this.writer.write("=\"");
            this.writer.write(XMLUtils.escapeAttributeValue(attr.getValue(i)));
            this.writer.write(34);
            ++i;
        }
        this.closedStartTag = false;
        this.currentElementIsEmpty = true;
        this.currentElementHasBodyText = false;
    }

    protected void endElement(WriteContext context, String uri, String localName, String qualifiedName) throws IOException, SAXException {
        if (!this.closedStartTag && this.currentElementIsEmpty) {
            this.writer.write("/>");
            this.closedStartTag = true;
        } else {
            if (!this.currentElementHasBodyText) {
                this.indent();
            }
            this.writer.write("</");
            this.writer.write(qualifiedName);
            this.writer.write(62);
        }
        --this.indentLevel;
        this.printLine();
        this.currentElementHasBodyText = false;
    }

    protected void bodyText(WriteContext context, String text) throws IOException {
        if (text == null) {
            this.log.error((Object)"[expressBodyText]Body text is null");
        } else {
            if (!this.closedStartTag) {
                this.writer.write(62);
                this.closedStartTag = true;
            }
            this.writer.write(this.mixedContentEncodingStrategy.encode(text, context.getCurrentDescriptor()));
            this.currentElementIsEmpty = false;
            this.currentElementHasBodyText = true;
        }
    }

    private void printLine() throws IOException {
        if (this.endOfLine != null) {
            this.writer.write(this.endOfLine);
        }
    }

    private void indent() throws IOException {
        if (this.indent != null) {
            int i = 0;
            while (i < this.indentLevel) {
                this.writer.write(this.getIndent());
                ++i;
            }
        }
    }

    protected void writePrintln() throws IOException {
        if (this.endOfLine != null) {
            this.writer.write(this.endOfLine);
        }
    }

    protected void writeIndent() throws IOException {
        if (this.indent != null) {
            int i = 0;
            while (i < this.indentLevel) {
                this.writer.write(this.getIndent());
                ++i;
            }
        }
    }

    protected String escapeBodyValue(Object value) {
        return XMLUtils.escapeBodyValue(value);
    }

    protected String escapeAttributeValue(Object value) {
        return XMLUtils.escapeAttributeValue(value);
    }

    protected void expressElementStart(String qualifiedName) throws IOException {
        if (qualifiedName == null) {
            this.log.fatal((Object)"[expressElementStart]Qualified name is null.");
            throw new RuntimeException("Qualified name is null.");
        }
        this.writePrintln();
        this.writeIndent();
        this.writer.write(60);
        this.writer.write(qualifiedName);
    }

    protected void expressTagClose() throws IOException {
        this.writer.write(62);
    }

    protected void expressElementEnd(String qualifiedName) throws IOException {
        if (qualifiedName == null) {
            this.log.fatal((Object)"[expressElementEnd]Qualified name is null.");
            throw new RuntimeException("Qualified name is null.");
        }
        this.writer.write("</");
        this.writer.write(qualifiedName);
        this.writer.write(62);
    }

    protected void expressElementEnd() throws IOException {
        this.writer.write("/>");
    }

    protected void expressBodyText(String text) throws IOException {
        if (text == null) {
            this.log.error((Object)"[expressBodyText]Body text is null");
        } else {
            this.writer.write(XMLUtils.escapeBodyValue(text));
        }
    }

    protected void expressAttribute(String qualifiedName, String value) throws IOException {
        if (value == null) {
            this.log.error((Object)"Null attribute value.");
            return;
        }
        if (qualifiedName == null) {
            this.log.error((Object)"Null attribute value.");
            return;
        }
        this.writer.write(32);
        this.writer.write(qualifiedName);
        this.writer.write("=\"");
        this.writer.write(XMLUtils.escapeAttributeValue(value));
        this.writer.write(34);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

