/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.PropertyDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.digester.MappedPropertyRule;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ElementRule
extends MappedPropertyRule {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$ElementRule == null ? (class$org$apache$commons$betwixt$digester$ElementRule = ElementRule.class$("org.apache.commons.betwixt.digester.ElementRule")) : class$org$apache$commons$betwixt$digester$ElementRule));
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$ElementRule;

    public static final void setLog(Log newLog) {
        log = newLog;
    }

    public void begin(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (name == null || name.trim().equals("")) {
            throw new SAXException("Name attribute is required.");
        }
        if (!XMLUtils.isWellFormedXMLName(name)) {
            throw new SAXException("'" + name + "' would not be a well formed xml element name.");
        }
        ElementDescriptor descriptor = new ElementDescriptor();
        descriptor.setQualifiedName(name);
        descriptor.setLocalName(name);
        String uri = attributes.getValue("uri");
        if (uri != null) {
            descriptor.setURI(uri);
        }
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        String propertyType = attributes.getValue("type");
        if (log.isTraceEnabled()) {
            log.trace((Object)("(BEGIN) name=" + name + " uri=" + uri + " property=" + propertyName + " type=" + propertyType));
        }
        descriptor.setPropertyType(this.getPropertyType(propertyType, this.beanClass, propertyName));
        String implementationClass = attributes.getValue("class");
        if (log.isTraceEnabled()) {
            log.trace((Object)("'class' attribute=" + implementationClass));
        }
        if (implementationClass != null) {
            try {
                Class<?> clazz = Class.forName(implementationClass);
                descriptor.setImplementationClass(clazz);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot load class named: " + implementationClass), (Throwable)e);
                }
                throw new SAXException("Cannot load class named: " + implementationClass);
            }
        }
        if (propertyName != null && propertyName.length() > 0) {
            this.configureDescriptor(descriptor, attributes.getValue("updater"));
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (top instanceof XMLBeanInfo) {
            XMLBeanInfo beanInfo = (XMLBeanInfo)top;
            beanInfo.setElementDescriptor(descriptor);
            this.beanClass = beanInfo.getBeanClass();
        } else if (top instanceof ElementDescriptor) {
            ElementDescriptor parent = (ElementDescriptor)top;
            parent.addElementDescriptor(descriptor);
        } else {
            throw new SAXException("Invalid use of <element>. It should be nested inside <info> or other <element> nodes");
        }
        this.digester.push((Object)descriptor);
    }

    public void end() {
        Object object = this.digester.pop();
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor) {
        this.configureDescriptor(elementDescriptor, null);
    }

    protected void configureDescriptor(ElementDescriptor elementDescriptor, String updateMethodName) {
        String name;
        PropertyDescriptor descriptor;
        Class beanClass = this.getBeanClass();
        if (beanClass != null && (descriptor = this.getPropertyDescriptor(beanClass, name = elementDescriptor.getPropertyName())) != null) {
            XMLIntrospectorHelper.configureProperty(elementDescriptor, descriptor, updateMethodName, beanClass);
            this.getProcessedPropertyNameSet().add(name);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

