--
-- PostgreSQL database dump
--

SET client_encoding = 'EUC_JP';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: address; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE address (
    id integer NOT NULL,
    kind integer NOT NULL,
    prefecture integer NOT NULL,
    zip character varying(10),
    city character varying(300),
    address character varying(300),
    "comment" character varying(300)
);


ALTER TABLE public.address OWNER TO rhythmuser;

--
-- Name: addressbook; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE addressbook (
    id integer NOT NULL,
    email character varying(200),
    firstname character varying(50),
    lastname character varying(50),
    firstspell character varying(50),
    lastspell character varying(50),
    displayname character varying(100),
    registrant integer NOT NULL,
    categoryid integer NOT NULL
);


ALTER TABLE public.addressbook OWNER TO rhythmuser;

--
-- Name: addressbookaddress; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE addressbookaddress (
    id integer NOT NULL,
    addressbookid integer NOT NULL,
    addressid integer NOT NULL
);


ALTER TABLE public.addressbookaddress OWNER TO rhythmuser;

--
-- Name: addressbookemailaddress; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE addressbookemailaddress (
    id integer NOT NULL,
    addressbookid integer NOT NULL,
    emailaddressid integer NOT NULL
);


ALTER TABLE public.addressbookemailaddress OWNER TO rhythmuser;

--
-- Name: addressbooktelephone; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE addressbooktelephone (
    id integer NOT NULL,
    addressbookid integer NOT NULL,
    telephoneid integer NOT NULL
);


ALTER TABLE public.addressbooktelephone OWNER TO rhythmuser;

--
-- Name: addresscategory; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE addresscategory (
    id integer NOT NULL,
    registrant integer NOT NULL,
    name character varying(100)
);


ALTER TABLE public.addresscategory OWNER TO rhythmuser;

--
-- Name: basebean; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE basebean (
    id integer NOT NULL,
    deleted integer DEFAULT 0 NOT NULL,
    registdate timestamp without time zone NOT NULL,
    updatedate timestamp without time zone,
    registrant integer NOT NULL
);


ALTER TABLE public.basebean OWNER TO rhythmuser;

--
-- Name: board; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE board (
    id integer NOT NULL,
    registrant integer NOT NULL,
    registdate timestamp without time zone NOT NULL,
    seq integer NOT NULL,
    depth integer NOT NULL,
    rootid integer NOT NULL,
    rootseq integer NOT NULL,
    subject character varying(500) NOT NULL,
    body character varying(10000) NOT NULL,
    boardtreeid integer NOT NULL
);


ALTER TABLE public.board OWNER TO rhythmuser;

--
-- Name: daosequence; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE daosequence (
    keyname character varying(50) NOT NULL,
    seq integer NOT NULL
);


ALTER TABLE public.daosequence OWNER TO rhythmuser;

--
-- Name: emailaddress; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE emailaddress (
    id integer NOT NULL,
    kind integer NOT NULL,
    email character varying(200)
);


ALTER TABLE public.emailaddress OWNER TO rhythmuser;

--
-- Name: holiday; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE holiday (
    id integer NOT NULL,
    name character varying(100) NOT NULL,
    "day" date NOT NULL
);


ALTER TABLE public.holiday OWNER TO rhythmuser;

--
-- Name: mailsetting; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE mailsetting (
    id integer NOT NULL,
    memberid integer NOT NULL,
    sendername character varying(50) NOT NULL,
    name character varying(50) NOT NULL,
    email character varying(200),
    imaploginid character varying(50),
    imaphost character varying(50),
    imappassword character varying(50),
    smtphost character varying(50),
    mailsendedfolder character varying(50),
    mailfooter character varying(500)
);


ALTER TABLE public.mailsetting OWNER TO rhythmuser;

--
-- Name: member; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE member (
    id integer NOT NULL,
    loginid character varying(50) NOT NULL,
    name character varying(50) NOT NULL,
    passwd character varying(50) NOT NULL,
    payhour integer DEFAULT 0 NOT NULL,
    restminutes integer DEFAULT 0 NOT NULL,
    trafficexpenses integer DEFAULT 0 NOT NULL,
    trafficexpenseskind integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.member OWNER TO rhythmuser;

--
-- Name: rolemember; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE rolemember (
    roleid integer NOT NULL,
    memberid integer NOT NULL
);


ALTER TABLE public.rolemember OWNER TO rhythmuser;

--
-- Name: telephone; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE telephone (
    id integer NOT NULL,
    kind integer NOT NULL,
    tel character varying(20)
);


ALTER TABLE public.telephone OWNER TO rhythmuser;

--
-- Name: timecard; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE timecard (
    id integer NOT NULL,
    registrant integer NOT NULL,
    intime timestamp without time zone NOT NULL,
    outtime timestamp without time zone,
    inipaddr character varying(15),
    outipaddr character varying(15)
);


ALTER TABLE public.timecard OWNER TO rhythmuser;

--
-- Name: todo; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE todo (
    id integer NOT NULL,
    registrant integer NOT NULL,
    registdate timestamp without time zone NOT NULL,
    seq integer NOT NULL,
    depth integer NOT NULL,
    rootid integer NOT NULL,
    subject character varying(500) NOT NULL,
    body character varying(10000) NOT NULL,
    todotreeid integer NOT NULL,
    planfromdate timestamp without time zone,
    plantodate timestamp without time zone,
    deleted integer DEFAULT 0 NOT NULL,
    updatedate timestamp without time zone,
    loopunit integer,
    loopinterval integer,
    loopcount integer,
    parentid integer,
    complete boolean,
    looptarget timestamp without time zone,
    open boolean DEFAULT true NOT NULL,
    kind integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.todo OWNER TO rhythmuser;

--
-- Name: todoworker; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE todoworker (
    id integer NOT NULL,
    todoid integer NOT NULL,
    kind integer NOT NULL,
    memberid integer NOT NULL
);


ALTER TABLE public.todoworker OWNER TO rhythmuser;

--
-- Name: windowpos; Type: TABLE; Schema: public; Owner: rhythmuser; Tablespace: 
--

CREATE TABLE windowpos (
    id integer NOT NULL,
    memberid integer NOT NULL,
    x integer NOT NULL,
    y integer NOT NULL,
    height integer NOT NULL,
    width integer NOT NULL,
    windowname character varying(100),
    optionxml text
);


ALTER TABLE public.windowpos OWNER TO rhythmuser;

--
-- Data for Name: address; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY address (id, kind, prefecture, zip, city, address, "comment") FROM stdin;
\.


--
-- Data for Name: addressbook; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY addressbook (id, email, firstname, lastname, firstspell, lastspell, displayname, registrant, categoryid) FROM stdin;
\.


--
-- Data for Name: addressbookaddress; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY addressbookaddress (id, addressbookid, addressid) FROM stdin;
\.


--
-- Data for Name: addressbookemailaddress; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY addressbookemailaddress (id, addressbookid, emailaddressid) FROM stdin;
\.


--
-- Data for Name: addressbooktelephone; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY addressbooktelephone (id, addressbookid, telephoneid) FROM stdin;
\.


--
-- Data for Name: addresscategory; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY addresscategory (id, registrant, name) FROM stdin;
\.


--
-- Data for Name: basebean; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY basebean (id, deleted, registdate, updatedate, registrant) FROM stdin;
\.


--
-- Data for Name: board; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY board (id, registrant, registdate, seq, depth, rootid, rootseq, subject, body, boardtreeid) FROM stdin;
\.


--
-- Data for Name: daosequence; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY daosequence (keyname, seq) FROM stdin;
rhtym role id	1
rhtym member id	1
\.


--
-- Data for Name: emailaddress; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY emailaddress (id, kind, email) FROM stdin;
\.


--
-- Data for Name: holiday; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY holiday (id, name, "day") FROM stdin;
20050101		2005-01-01
20050110	ͤ	2005-01-10
20050211	ǰ	2005-02-11
20050320	ʬ	2005-03-20
20050321	(ص)	2005-03-21
20050429	ߤɤ	2005-04-29
20050503	ˡǰ	2005-05-03
20050504	̱ε	2005-05-04
20050505	ɤ	2005-05-05
20050718		2005-07-18
20050919	Ϸ	2005-09-19
20050923	ʬ	2005-09-23
20051010	ΰ	2005-10-10
20051103	ʸ	2005-11-03
20051123	ϫդ	2005-11-23
20051223	ŷ	2005-12-23
20060101		2006-01-01
20060102	(ص)	2006-01-02
20060109	ͤ	2006-01-09
20060211	ǰ	2006-02-11
20060321	ʬ	2006-03-21
20060429	ߤɤ	2006-04-29
20060503	ˡǰ	2006-05-03
20060504	̱ε	2006-05-04
20060505	ɤ	2006-05-05
20060717		2006-07-17
20060918	Ϸ	2006-09-18
20060923	ʬ	2006-09-23
20061009	ΰ	2006-10-09
20061103	ʸ	2006-11-03
20061123	ϫդ	2006-11-23
20061223	ŷ	2006-12-23
20070101		2007-01-01
20070108	ͤ	2007-01-08
20070211	ǰ	2007-02-11
20070212	(ص)	2007-02-12
20070321	ʬ	2007-03-21
20070429	¤	2007-04-29
20070430	(ص)	2007-04-30
20070503	ˡǰ	2007-05-03
20070504	ߤɤ	2007-05-04
20070505	ɤ	2007-05-05
20070716		2007-07-16
20070917	Ϸ	2007-09-17
20070923	ʬ	2007-09-23
20070924	(ص)	2007-09-24
20071008	ΰ	2007-10-08
20071103	ʸ	2007-11-03
20071123	ϫդ	2007-11-23
20071223	ŷ	2007-12-23
20071224	(ص)	2007-12-24
20080101		2008-01-01
20080114	ͤ	2008-01-14
20080211	ǰ	2008-02-11
20080320	ʬ	2008-03-20
20080429	¤	2008-04-29
20080503	ˡǰ	2008-05-03
20080504	ߤɤ	2008-05-04
20080505	ɤ	2008-05-05
20080506	(ص)	2008-05-06
20080721		2008-07-21
20080915	Ϸ	2008-09-15
20080923	ʬ	2008-09-23
20081013	ΰ	2008-10-13
20081103	ʸ	2008-11-03
20081123	ϫդ	2008-11-23
20081124	(ص)	2008-11-24
20081223	ŷ	2008-12-23
20090101		2009-01-01
20090112	ͤ	2009-01-12
20090211	ǰ	2009-02-11
20090320	ʬ	2009-03-20
20090429	¤	2009-04-29
20090503	ˡǰ	2009-05-03
20090504	ߤɤ	2009-05-04
20090505	ɤ	2009-05-05
20090506	(ص)	2009-05-06
20090720		2009-07-20
20090921	Ϸ	2009-09-21
20090922	̱ε	2009-09-22
20090923	ʬ	2009-09-23
20091012	ΰ	2009-10-12
20091103	ʸ	2009-11-03
20091123	ϫդ	2009-11-23
20091223	ŷ	2009-12-23
20100101		2010-01-01
20100111	ͤ	2010-01-11
20100211	ǰ	2010-02-11
20100321	ʬ	2010-03-21
20100322	(ص)	2010-03-22
20100429	¤	2010-04-29
20100503	ˡǰ	2010-05-03
20100504	ߤɤ	2010-05-04
20100505	ɤ	2010-05-05
20100719		2010-07-19
20100920	Ϸ	2010-09-20
20100923	ʬ	2010-09-23
20101011	ΰ	2010-10-11
20101103	ʸ	2010-11-03
20101123	ϫդ	2010-11-23
20101223	ŷ	2010-12-23
20110101		2011-01-01
20110110	ͤ	2011-01-10
20110211	ǰ	2011-02-11
20110321	ʬ	2011-03-21
20110429	¤	2011-04-29
20110503	ˡǰ	2011-05-03
20110504	ߤɤ	2011-05-04
20110505	ɤ	2011-05-05
20110718		2011-07-18
20110919	Ϸ	2011-09-19
20110923	ʬ	2011-09-23
20111010	ΰ	2011-10-10
20111103	ʸ	2011-11-03
20111123	ϫդ	2011-11-23
20111223	ŷ	2011-12-23
\.


--
-- Data for Name: mailsetting; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY mailsetting (id, memberid, sendername, name, email, imaploginid, imaphost, imappassword, smtphost, mailsendedfolder, mailfooter) FROM stdin;
\.


--
-- Data for Name: member; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY member (id, loginid, name, passwd, payhour, restminutes, trafficexpenses, trafficexpenseskind) FROM stdin;
0	root	root	root	0	0	0	0
\.


--
-- Data for Name: rolemember; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY rolemember (roleid, memberid) FROM stdin;
0	0
\.


--
-- Data for Name: telephone; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY telephone (id, kind, tel) FROM stdin;
\.


--
-- Data for Name: timecard; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY timecard (id, registrant, intime, outtime, inipaddr, outipaddr) FROM stdin;
\.


--
-- Data for Name: todo; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY todo (id, registrant, registdate, seq, depth, rootid, subject, body, todotreeid, planfromdate, plantodate, deleted, updatedate, loopunit, loopinterval, loopcount, parentid, complete, looptarget, open, kind) FROM stdin;
\.


--
-- Data for Name: todoworker; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY todoworker (id, todoid, kind, memberid) FROM stdin;
\.


--
-- Data for Name: windowpos; Type: TABLE DATA; Schema: public; Owner: rhythmuser
--

COPY windowpos (id, memberid, x, y, height, width, windowname, optionxml) FROM stdin;
\.


--
-- Name: address_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY address
    ADD CONSTRAINT address_pkey PRIMARY KEY (id);


--
-- Name: addressbook_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY addressbook
    ADD CONSTRAINT addressbook_pkey PRIMARY KEY (id);


--
-- Name: addressbookaddress_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY addressbookaddress
    ADD CONSTRAINT addressbookaddress_pkey PRIMARY KEY (id);


--
-- Name: addressbookemailaddress_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY addressbookemailaddress
    ADD CONSTRAINT addressbookemailaddress_pkey PRIMARY KEY (id);


--
-- Name: addressbooktelephone_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY addressbooktelephone
    ADD CONSTRAINT addressbooktelephone_pkey PRIMARY KEY (id);


--
-- Name: addresscategory_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY addresscategory
    ADD CONSTRAINT addresscategory_pkey PRIMARY KEY (id);


--
-- Name: basebean_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY basebean
    ADD CONSTRAINT basebean_pkey PRIMARY KEY (id);


--
-- Name: board_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY board
    ADD CONSTRAINT board_pkey PRIMARY KEY (id);


--
-- Name: daosequence_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY daosequence
    ADD CONSTRAINT daosequence_pkey PRIMARY KEY (keyname);


--
-- Name: emailaddress_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY emailaddress
    ADD CONSTRAINT emailaddress_pkey PRIMARY KEY (id);


--
-- Name: holiday_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY holiday
    ADD CONSTRAINT holiday_pkey PRIMARY KEY (id);


--
-- Name: mailsetting_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY mailsetting
    ADD CONSTRAINT mailsetting_pkey PRIMARY KEY (id);


--
-- Name: member_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY member
    ADD CONSTRAINT member_pkey PRIMARY KEY (id);


--
-- Name: rolemember_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY rolemember
    ADD CONSTRAINT rolemember_pkey PRIMARY KEY (roleid, memberid);


--
-- Name: telephone_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY telephone
    ADD CONSTRAINT telephone_pkey PRIMARY KEY (id);


--
-- Name: timecard_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY timecard
    ADD CONSTRAINT timecard_pkey PRIMARY KEY (id);


--
-- Name: todo_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY todo
    ADD CONSTRAINT todo_pkey PRIMARY KEY (id);


--
-- Name: todoworker_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY todoworker
    ADD CONSTRAINT todoworker_pkey PRIMARY KEY (id);


--
-- Name: windowpos_pkey; Type: CONSTRAINT; Schema: public; Owner: rhythmuser; Tablespace: 
--

ALTER TABLE ONLY windowpos
    ADD CONSTRAINT windowpos_pkey PRIMARY KEY (id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

