// -*-c++-*-

/*!
  \file view_config_dialog.h
  \brief View Config Dialog class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_VIEW_CONFIG_DIALOG_H
#define SOCCERWINDOW2_VIEW_CONFIG_DIALOG_H

#include <boost/shared_ptr.hpp>

class wxButton;
class wxCheckBox;
class wxChoice;
class wxRadioButton;
class wxSpinCtrl;
class wxSpinEvent;
class wxSizer;
class wxSlider;
class wxStaticText;
class MainFrame;
class ViewConfig;
class ViewConfigControl;

//! field canvas configuration dialog
class ViewConfigDialog
    : public wxDialog {
private:

    MainFrame * M_main_frame;

    boost::shared_ptr< ViewConfigControl > M_control;

    const ViewConfig & M_config;

    wxTextCtrl * M_ball_trace_start;
    wxTextCtrl * M_ball_trace_end;

    wxTextCtrl * M_player_trace_start;
    wxTextCtrl * M_player_trace_end;

    wxTextCtrl * M_auto_trace_start;
    wxTextCtrl * M_auto_trace_period;

    wxSpinCtrl * M_ball_future;
    wxSpinCtrl * M_player_future;

    wxCheckBox * M_enlarge_cb;

    wxSlider * M_scale_slider;
    wxStaticText * M_scale_text;

    wxTextCtrl * M_canvas_width_text;
    wxTextCtrl * M_canvas_height_text;
    //wxButton * M_load_canvas_size_btn;
    wxButton * M_set_canvas_size_btn;

    wxCheckBox * M_player_number_cb;
    wxCheckBox * M_hetero_number_cb;
    wxCheckBox * M_stamina_cb;
    wxCheckBox * M_view_cone_cb;
    wxCheckBox * M_control_area_cb;

    wxCheckBox * M_show_score_board_cb;
    wxCheckBox * M_show_ball_cb;
    wxCheckBox * M_show_player_cb;
    wxCheckBox * M_show_flags_cb;
    wxCheckBox * M_show_offside_line_cb;

    wxCheckBox * M_show_voronoi_cb;
    wxCheckBox * M_show_delaunay_cb;
    wxChoice * M_voronoi_choice;

    wxRadioButton * M_focus_ball_rb;
    wxRadioButton * M_focus_player_rb;
    wxRadioButton * M_focus_fix_rb;

    wxRadioButton * M_select_all_rb;
    wxRadioButton * M_select_left_rb;
    wxRadioButton * M_select_right_rb;
    wxRadioButton * M_select_fix_rb;
    wxRadioButton * M_unselect_rb;

    wxButton * M_left_player_btn[11];
    wxButton * M_right_player_btn[11];

    wxRadioButton * M_grass_normal_rb;
    wxRadioButton * M_grass_line_rb;
    wxRadioButton * M_grass_checker_rb;

    wxCheckBox * M_ball_trace_cb;
    wxCheckBox * M_player_trace_cb;

public:
    //! constructor
    ViewConfigDialog( wxWindow * parent,
                      MainFrame * main_frame,
                      boost::shared_ptr< ViewConfigControl > control,
                      ViewConfig & config );

    ~ViewConfigDialog();
private:

    void createControls();
    wxSizer * createZoomControls();
    wxSizer * createCanvasSizeControls(  wxWindow * parent );
    wxSizer * createPlayersDetailControls();
    wxSizer * createShowControls();
    wxSizer * createCompGeomControls();
    wxSizer * createFocusControls();
    wxSizer * createPlayerSelectionControls();
    wxSizer * createGrassTypeControls();
    wxSizer * createTraceControls();
    wxSizer * createInertiaMoveControls();

    void connectEvents();

    ///////////////////////////////////////////////////////
    void handleCloseEvent( wxCloseEvent & event );
    void handleCommandEvent( wxCommandEvent & event );

    void handleSliderScroll( wxScrollEvent & event );

    //void handleLoadSizeButton( wxCommandEvent & event );
    void handleSetSizeButton( wxCommandEvent & event );

    void handleBallTraceStart( wxCommandEvent & event );
    void handleBallTraceEnd( wxCommandEvent & event );

    void handlePlayerTraceStart( wxCommandEvent & event );
    void handlePlayerTraceEnd( wxCommandEvent & event );

    void handleAutoTraceStart( wxCommandEvent & event );
    void handleAutoTracePeriod( wxCommandEvent & event );

    void handleBallFutureCycle( wxSpinEvent & event );
    void handlePlayerFutureCycle( wxSpinEvent & event );

public:

    /*!

    */
    void setGrassType();

    /*!

    */
    void setScale();

    /*!

    */
    void setEnlarge();

    /*!

    */
    void setShowScoreBoard();

    /*!

    */
    void setShowBall();

    /*!

    */
    void setShowPlayers();

    /*!

    */
    void setShowPlayerNumber();

    /*!

    */
    void setShowStamina();

    /*!

    */
    void setShowHeteroNumber();

    /*!

    */
    void setShowViewCone();

    /*!

    */
    void setShowControlArea();

    /*!

    */
    void setShowFlags();

    /*!

    */
    void setShowOffsideLine();

    /*!

    */
    void setShowVoronoiDiagram();

    /*!

    */
    void setShowDelaunayTriangle();

    /*!

    */
    void setVoronoiTarget();
    /*!

    */

    void setFocusType();

    /*!

    */

    void setPlayerSelectType();

    /*!

    */
    void setBallAutoTrace();

    /*!

    */
    void setPlayerAutoTrace();

    /*!

     */
    void setAutoTraceStart();

    /*!

     */
    void setAutoTracePeriod();

    /*!

    */
    void setLineTrace();

    /*!

    */
    void setBallTraceStart();

    /*!

    */
    void setBallTraceEnd();

    /*!

    */
    void setPlayerTraceStart();

    /*!

    */
    void setPlayerTraceEnd();

    /*!

    */
    void setBallFutureCycle();

    /*!

    */
    void setPlayerFutureCycle();

};

#endif
