// -*-c++-*-

/*!
  \file view_config_control.h
  \brief field canvas configuration control class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_VIEW_CONFIG_CONTROL_H
#define SOCCER_WINDOW2_VIEW_CONFIG_CONTROL_H

#include <boost/any.hpp>

class MainFrame;
class MainData;
class ViewConfig;
class ViewConfigDialog;
class DebugMessageFrame;

/*!
  \class ViewConfigControl
  \brief control configuration data related things
*/
class ViewConfigControl {
private:

    MainFrame * M_main_frame;

    const MainData & M_main_data;

    ViewConfig * M_config_data;

    ViewConfigDialog * M_config_dlg;

    DebugMessageFrame * M_debug_frame;

    //! not accessible
    ViewConfigControl();

public:

    ViewConfigControl( MainFrame * main_frame,
                       const MainData & main_data );

    void setData( ViewConfig * data );

    void setDialog( ViewConfigDialog * dlg );

    void setDebugMessageFrame( DebugMessageFrame * debug_frame );

    void setScale( const double & scale );

    void recvGrassLines( const boost::any * );
    void recvGrassChecker( const boost::any * );
    void recvGrassNormal( const boost::any * );

    void recvZoomIn( const boost::any * );
    void recvZoomOut( const boost::any * );
    void recvUnzoom( const boost::any * );
    void recvEnlarge( const boost::any * );

    void recvShowScoreBoard( const boost::any * );
    void recvShowBall( const boost::any * );
    void recvShowPlayers( const boost::any * );

    void recvShowPlayerNumber( const boost::any * );
    void recvShowStamina( const boost::any * );
    void recvShowHeteroNumber( const boost::any * );
    void recvShowViewCone( const boost::any * );
    void recvShowControlArea( const boost::any * );
    void recvShowFlags( const boost::any * );
    void recvShowOffsideLine( const boost::any * );
    void recvShowVoronoiDiagram( const boost::any * );
    void recvShowDelaunayTriangle( const boost::any * );
    void recvChoiceVoronoiTarget( const boost::any * data );

    void recvSelectAutoAll( const boost::any * );
    void recvSelectAutoLeft( const boost::any * );
    void recvSelectAutoRight( const boost::any * );
    void recvSelectFix( const boost::any * );
    void recvSelectPlayer( const boost::any * data );
    void recvUnselectPlayer( const boost::any * );

    void recvFocusPoint( const boost::any * data );
    void recvFocusBall( const boost::any * );
    void recvFocusPlayer( const boost::any * );
    void recvFocusFix( const boost::any * );

    void recvToggleBallAutoTrace( const boost::any * );
    void recvTogglePlayerAutoTrace( const boost::any * );

    void recvSetAutoTraceStart( const boost::any * data );
    void recvSetAutoTracePeriod( const boost::any * data );

    void recvToggleLineTrace( const boost::any * );

    void recvSetBallTraceStart( const boost::any * data );
    void recvSetBallTraceEnd( const boost::any * data );

    void recvSetPlayerTraceStart( const boost::any * data );
    void recvSetPlayerTraceEnd( const boost::any * data );

    void recvBallTraceSelectAll( const boost::any * );
    void recvPlayerTraceSelectAll( const boost::any * );

    void recvSetBallFutureCycle( const boost::any * data );
    void recvSetPlayerFutureCycle( const boost::any * data );

    void recvShowDebugView( const boost::any * );
    void recvShowDebugViewBall( const boost::any * );
    void recvShowDebugViewSelf( const boost::any * );
    void recvShowDebugViewPlayers( const boost::any * );
    void recvShowDebugViewComment( const boost::any * );
    void recvShowDebugViewFigure( const boost::any * );
    void recvShowDebugViewTarget( const boost::any * );
    void recvShowDebugViewMessage( const boost::any * );
};

#endif
