// -*-c++-*-

/*!
  \file soccerwindow_app.cpp
  \brief soccerwindow2 main application class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/config.h>
#include <wx/fileconf.h>
#endif

#include <iostream>
#include <string>

#include "id.h"
#include "main_data.h"
#include "main_frame.h"
#include "app_config.h"

#include "soccerwindow_app.h"

/*-------------------------------------------------------------------*/
/*!
  This macro creates new application instance that is global variable.
*/
IMPLEMENT_APP( SoccerWindowApp );

/*-------------------------------------------------------------------*/

//! application name
const wxString SoccerWindowApp::APP_NAME = wxT( "soccerwindow2" );
//! config file name
const wxString SoccerWindowApp::APP_CONFIG_FILE = wxT( "soccerwindow2.ini" );

/*-------------------------------------------------------------------*/
/*!
  This method is a start point of application.
  It is used for the initialization for application.
  Because it can return the error, it can return 'false' and we can
  quit an application immediately if it failed to initialize.
  \return result of initialization.
*/
bool
SoccerWindowApp::OnInit()
{
    char **std_argv = new char*[argc];
    for ( int i = 0; i < argc; ++i )
    {
        wxString tmp( argv[i] );
        std_argv[i] = new char[tmp.length() + 1];
#ifdef UNICODE
        std::strcpy( std_argv[i], (const char*)tmp.mbc_str() );
#else
        std::strcpy( std_argv[i], (const char*)tmp.c_str() );
#endif
    }

    if ( ! AppConfig::instance().parseCmdLine( argc, std_argv ) )
    {
        return false;
    }

    for ( int i = 0; i < argc; ++i )
    {
        delete [] std_argv[i];
    }
    delete [] std_argv;

    MainFrame * main_frame = new MainFrame( APP_NAME );

    // show window
    main_frame->Show( true );
    // set application top window
    // this method can be called only from OnInit().
    this->SetTopWindow( main_frame );

    // if base class OnInit is used, CmdLineParser of base class is called...
    //bool result = wxApp::OnInit();
    bool result = true;

    // if specified by command lien, init data connection.
    if ( ! AppConfig::instance().gameLogFilePath().empty() )
    {
        main_frame->loadRCG( AppConfig::instance().gameLogFilePath() );
        return result;
    }

    if ( AppConfig::instance().connect() )
    {
        std::string host = AppConfig::instance().host();
        if ( host.empty() )
        {
            host = "localhost";
        }
        main_frame->connectMonitorClient( host.c_str() );
    }

    if ( AppConfig::instance().debugServerMode() )
    {
        main_frame->startDebugServer();
    }

    // wxApp::OnRun() is called,
    // enter in main message loop
    // and application is run.
    // if returned false, application should be shut down immediately.
    return result;
}

/*-------------------------------------------------------------------*/
/*!

*/
int
SoccerWindowApp::OnExit()
{
    //std::cerr << PACKAGE_NAME << " is end." << std::endl;

    return wxApp::OnExit();
}

/*-------------------------------------------------------------------*/
/*!
  \brief static method
  \return path to the application config file
*/
wxString
SoccerWindowApp::get_config_file_path()
{
    // config file settings
    wxString file_path;
#ifdef __WXMSW__
#  if 1
    // Win default: %USERPROFILE%\file.ini
    file_path = wxEmptyString;
#  else
    // save at application directory.
    file_path += wxGetCwd();
    file_path += "\\"; // path separator for Windows is "\". "
    file_path += "/"; // path separator for Linux is "/".
    file_path += SoccerWindowApp::APP_CONFIG_FILE;
#  endif
#else
    // Unix default: ~/.file
    file_path = wxEmptyString;
#endif

    return file_path;
}

/*-------------------------------------------------------------------*/
/*!
  \brief static method
  \return reference to the config file object
*/
wxFileConfig &
SoccerWindowApp::get_config_file()
{
    static wxFileConfig file( SoccerWindowApp::APP_NAME, // app name
                              wxEmptyString, // vendor name
                              get_config_file_path(), // local file name
                              wxEmptyString, // global file name
                              wxCONFIG_USE_LOCAL_FILE // use local user file.
                              );

    return file;
}
