// -*-c++-*-

/*!
  \file player_type_grid.cpp
  \brief Player Type List Grid class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#include <wx/grid.h>
#endif

#include <iostream>

#include <rcsc/param/player_type.h>
#include <rcsc/param/server_param.h>

#include "id.h"

#include "player_type_grid.h"

namespace {
const int ROW_SIZE = 7;
const int COL_SIZE = 14; // the number of param string
const int FONT_SIZE = 10;
const int CELL_HEIGHT = 18;
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeGrid::PlayerTypeGrid( wxWindow * parent )
    : wxGrid( parent, SWID_GRID_PLAYER_TYPE )
{
    createCells();
    createLabels();
}

/*-------------------------------------------------------------------*/
/*!

*/
PlayerTypeGrid::~PlayerTypeGrid()
{
    //std::cerr << "delete PlayerTypeGrid" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeGrid::createCells()
{
    wxFont font( FONT_SIZE, wxDEFAULT, wxNORMAL, wxNORMAL,
                 false, wxT( "" ),
                 wxFONTENCODING_ISO8859_1 );

    this->SetLabelFont( font );
    this->SetDefaultCellFont( font );

    this->CreateGrid( ROW_SIZE, COL_SIZE );

    // set all cells read only
    for ( int i = 0; i < ROW_SIZE; ++i )
    {
        for ( int j = 0; i < COL_SIZE; ++i )
        {
            this->SetReadOnly( i, j );
        }
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeGrid::createLabels()
{
    this->SetColLabelAlignment( wxALIGN_LEFT, wxALIGN_CENTER );
    this->SetRowLabelSize( 12 ); // width of left label cell
    this->SetColLabelSize( CELL_HEIGHT ); // height of top label cell

    // set label string
    for ( int i = 0; i < ROW_SIZE; ++i )
    {
        wxString label;
        label.Printf( wxT( "%d" ), i  );
        this->SetRowLabelValue( i, label );
    }
    {
        int i = -1;
        this->SetColLabelValue( ++i, wxT( "Speed Real/Max" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 1.123
        this->SetColLabelValue( ++i, wxT( "AccelStep" ) );
        this->SetColFormatNumber( i );
        this->SetColLabelValue( ++i, wxT( "AccelMax" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 0.123
        this->SetColLabelValue( ++i, wxT( "StamInc" ) );
        this->SetColFormatFloat( i, 4, 1 ); // 43.1
        this->SetColLabelValue( ++i, wxT( "Consume" ) );
        this->SetColFormatFloat( i, 4, 1 ); // 54.3
        this->SetColLabelValue( ++i, wxT( "Kickable" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 1.123
        //this->SetColLabelValue( ++i, wxT( "SpeedMax" ) );
        //this->SetColFormatFloat( i, 5, 3 ); // 1.123
        this->SetColLabelValue( ++i, wxT( "Decay" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 0.432
        this->SetColLabelValue( ++i, wxT( "Inertia" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 5.432
        this->SetColLabelValue( ++i, wxT( "DashRate" ) );
        this->SetColFormatFloat( i, 7, 5 ); // 0.00543
        this->SetColLabelValue( ++i, wxT( "Size" ) );
        this->SetColFormatFloat( i, 4, 2 ); // 0.21
        this->SetColLabelValue( ++i, wxT( "KickMargin" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 0.876
        this->SetColLabelValue( ++i, wxT( "KickRand" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 0.876
        this->SetColLabelValue( ++i, wxT( "ExtStam" ) );
        this->SetColFormatFloat( i, 4, 1 ); // 99.2
        this->SetColLabelValue( ++i, wxT( "Effort Max/Min" ) );
        this->SetColFormatFloat( i, 5, 3 ); // 0.876
        //this->SetColLabelValue( ++i, wxT( "EffortMin" ) );
        //this->SetColFormatFloat( i, 5, 3 ); // 0.876
    }
}

/*-------------------------------------------------------------------*/
/*!

*/
void
PlayerTypeGrid::
setValues( const std::vector< rcsc::PlayerType > & player_types )
{
    int col = 0;
    for ( std::vector< rcsc::PlayerType >::const_iterator
              it = player_types.begin();
          it != player_types.end();
          ++it, ++col )
    {
        int raw = -1;
        wxString val;

        val.Printf( wxT( "%5.3f / %5.3f" ), it->realSpeedMax(), it->playerSpeedMax() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%d" ), it->cyclesToReachMaxSpeed() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), // max accel
                    rcsc::ServerParam::i().maxPower() * it->dashPowerRate() * it->effortMax() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->staminaIncMax() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ),
                    it->getOneStepStaminaComsumption( rcsc::ServerParam::i() ) );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->playerSize() + it->kickableMargin() + 0.085 );
        this->SetCellValue( col, ++raw, val );
        //val.Printf( wxT( "%f" ), it->playerSpeedMax() );
        //this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->playerDecay() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->inertiaMoment() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->dashPowerRate() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->playerSize() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->kickableMargin() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->kickRand() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%f" ), it->extraStamina() );
        this->SetCellValue( col, ++raw, val );
        val.Printf( wxT( "%5.3f / %5.3f" ), it->effortMax(), it->effortMin() );
        this->SetCellValue( col, ++raw, val );
        //val.Printf( wxT( "%f" ), it->effortMin() );
        //this->SetCellValue( col, ++raw, val );
    }

    this->AutoSize();
}
