// -*-c++-*-

/*!
  \file formation_edit_frame.h
  \brief formation editor frame class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FORMATION_EDITOR_FRAME_H
#define FORMATION_EDITOR_FRAME_H

#include <boost/shared_ptr.hpp>

class FEditorCanvas;
class FEditorDialog;
class FEditorData;

class wxSpinCtrl;
class wxSpinEvent;

//! formation editor frame class
class FEditorFrame
    : public wxFrame {
private:
    //! main child screen window (View)
    FEditorCanvas * M_editor_canvas;

    //! data instance (Data)
    boost::shared_ptr< FEditorData > M_editor_data;

    //! role info manager dialog
    FEditorDialog * M_editor_dialog;

    //! training data index control
    wxSpinCtrl * M_train_data_index;

public:
    //! constructor
    FEditorFrame();

    //! destructor
    ~FEditorFrame();


private:

    /*!
      \brief realizes all child windows
     */
    void createWindows();

    /*!
      \brief associate event Id with handler method
     */
    void connectEvents();

    /*!
      \brief create menu bar window.
      this method is called from createWindows()
     */
    void createMenuBar();

    /*!
      \brief create tool bar window.
      this method is called from createWindows()
     */
    void createToolBar();

    /*!
      \brief create status bar window.
      this method is called from createWindows()
     */
    void createStatusBar();

    //--------------------------------------------------
    /*!
      \brief destruct all window object.
     */
    void quit();

    //--------------------------------------------------
    // wx event handlers

    /*!
      \brief wx event handler.
      this method is called when main frame is closed.
     */
    void handleCloseEvent( wxCloseEvent & event );

    /*!
      \brief menu event 'New'
     */
    void handleMenuNew( wxCommandEvent & event );

    /*!
      \brief menu event 'Open'
     */
    void handleMenuOpen( wxCommandEvent & event );

    /*!
      \brief menu event 'Save All'
     */
    void handleMenuSaveAll( wxCommandEvent & event );

    /*!
      \brief menu event 'Save'
     */
    void handleMenuSave( wxCommandEvent & event );

    /*!
      \brief menu event 'Save as'
     */
    void handleMenuSaveAs( wxCommandEvent & event );


    /*!
      \brief menu event 'Open Train Data'
     */
    void handleMenuOpenTrainData( wxCommandEvent & event );

    /*!
      \brief menu event 'Save Train Data'
     */
    void handleMenuSaveTrainData( wxCommandEvent & event );

    /*!
      \brief menu event 'Save Train Data as'
     */
    void handleMenuSaveTrainDataAs( wxCommandEvent & event );

    /*!
      \brief menu event 'Quit'
     */
    void handleMenuQuit( wxCommandEvent & event );

    /*!
      \brief event 'Reset Ball'
     */
    void handleResetBall( wxCommandEvent & event );

    /*!
      \brief toggle event 'Player Auto Move'
     */
    void handlePlayerAutoMove( wxCommandEvent & event );

    /*!
      \brief UI update event for 'Player Auto Move' button
     */
    void handleUpdatePlayerAutoMove( wxUpdateUIEvent & event );

    /*!
      \brief menu event 'Show Dialog'
     */
    void handleMenuShowDialog( wxCommandEvent & event );

    /*!
      \brief menu event 'Ball Draggable'
     */
    void handleBallDraggable( wxCommandEvent & event );

    /*!
      \brief UI update event for 'Ball Draggable' button
     */
    void handleUpdateBallDraggable( wxUpdateUIEvent & event );

    /*!
      \brief menu event 'Replace Training Data'
     */
    void handleReplaceTrainData( wxCommandEvent & event );

    /*!
      \brief menu event 'Delete Training Data'
     */
    void handleDeleteTrainData( wxCommandEvent & event );

    /*!
      \brief spin button event for training data index
     */
    //void handleSpinTrainData( wxCommandEvent & event );
    void handleSpinTrainData( wxSpinEvent & event );

    /*!
      \brief event for training data record
     */
    void handleRecordPosition( wxCommandEvent & event );

    /*!
      \brief event for training execution.
     */
    void handleTrain( wxCommandEvent & event );
    //--------------------------------------------------

    /*!
      \brief realize formation file open dialog.
     */
    void showOpenDialog();

    /*!
      \brief realize training data file open dialog
     */
    void showOpenTrainDataDialog();

public:

    /*!
      \brief set range of training data index.
      \param max_idx new max index value
     */
    void setTrainDataIndexMax( const int max_idx );

    /*!
      \brief update status bar text. current mouse position is printed.
      \param x printed x-value
      \param x printed y-value
     */
    void updateStatusText( const double & x,
                           const double & y );

};

#endif
