// -*-c++-*-

/*!
	\file ball_panel.cpp
	\brief ball info panel class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <iostream>
#include <cassert>

#include <rcsc/geom/vector_2d.h>

#include "id.h"
#include "main_data.h"
#include "monitor_view_data.h"
#include "view_holder.h"

#include "ball_panel.h"

namespace {
const int value_width = -1;
}

/*-------------------------------------------------------------------*/
/*!

*/
BallPanel::BallPanel( wxWindow * parent,
                      const MainData & data )
		: wxPanel( parent, SWID_PANEL_BALL )
    , M_data( data )
    , M_pos( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_vel( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_polar( new wxStaticText( this, -1, wxT( " 000.00, 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_last_move( new wxStaticText( this, -1, wxT( " 000.00, 000.00" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
    , M_last_polar( new wxStaticText( this, -1, wxT( " 000.00, 0000.0" ), wxDefaultPosition, wxSize( value_width, -1 ), wxALIGN_RIGHT | wxST_NO_AUTORESIZE ) )
{
		assert( parent );

		wxBoxSizer * panel_sizer = new wxBoxSizer( wxVERTICAL );

    const int label_width = 70;
		const int label_rate = 0; // label width rate for sizer
		const int value_rate = 0; // value width rate for sizer
    const int side_space = 8; // side space in each value box
    const int left_space = 0; // left space in top panel box

    const int label_style = 0;//wxLEFT;
    const int value_style = wxLEFT;//wxRIGHT;
    const int box_style = 0;//wxALIGN_LEFT | wxLEFT | wxEXPAND;

		// add top border space
		//panel_sizer->Add( 0, 4 );

		// make position box
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Pos" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_pos,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// make velocity box
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "Vel" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_vel,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// speed
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "PolarVel" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_polar,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
    }
		// make last velocity box
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "LastMove" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_last_move,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
		}
		// make last speed box
		{
				wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
				sizer->Add( new wxStaticText( this, -1, wxT( "LastPolar" ), wxDefaultPosition, wxSize( label_width, -1 ), wxALIGN_RIGHT ),
                    label_rate, label_style, side_space );
				sizer->Add( M_last_polar,
                    value_rate, value_style, side_space );
				panel_sizer->Add( sizer, 0, box_style, left_space );
    }

		panel_sizer->SetSizeHints( this );
		this->SetAutoLayout( true );
		this->SetSizer( panel_sizer );
}

/*-------------------------------------------------------------------*/
/*!

*/
BallPanel::~BallPanel()
{
		std::cerr << "delete BallPanel" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
BallPanel::update()
{
    if ( ! IsShown() )
    {
        return;
    }

    const MonitorViewPtr v = M_data.getCurrentViewData();
    if ( ! v )
    {
        //std::cerr << __FILE__ << ":" << __LINE__
        //          << " Null view data" << std::endl;
        return ;
    }

		wxString temp;
		temp.Printf( wxT( " %6.2f, %6.2f" ), v->ball().x(), v->ball().y() );
		M_pos->SetLabel( temp );

		if ( v->ball().hasDelta() )
		{
				rcsc::Vector2D vel( v->ball().deltaX(), v->ball().deltaY() );

				temp.Printf( wxT( " %6.2f, %6.2f" ), vel.x, vel.y );
				M_vel->SetLabel( temp );

        temp.Printf( wxT( " %6.3f, %6.1f" ), vel.r(), vel.th().degree() );
				M_polar->SetLabel( temp );
		}

    std::size_t last_index = M_data.getViewIndex();
    if ( last_index == 0 )
    {
        temp = wxT( "      0,      0" );
        M_last_move->SetLabel( temp );
        M_last_polar->SetLabel( temp );
        return;
    }

    --last_index;
    const MonitorViewPtr last_view = M_data.getViewHolder().getViewData( last_index );
    if ( ! last_view
         || ! last_view->ball().hasDelta() )
    {
        temp = wxT( "      0,      0" );
        M_last_move->SetLabel( temp );
        M_last_polar->SetLabel( temp );
        return;
    }

    rcsc::Vector2D move( v->ball().x() - last_view->ball().x(),
                         v->ball().y() - last_view->ball().y() );

    temp.Printf(  wxT( " %6.2f, %6.2f" ), move.x, move.y );
    M_last_move->SetLabel( temp );

    temp.Printf( wxT( " %6.3f, %6.1f" ), move.r(), move.th().degree() );
    M_last_polar->SetLabel( temp );
}
