// -*-c++-*-

/*!
  \file voronoi_diagram_painter.h
  \brief Voronoi Diagram & Delaunay Triangulation painter class Header File.
*/

/*
 *Copyright:

 Copyright (C) 2004 Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_VORONOI_DIAGRAM_PAINTER_H
#define SOCCER_WINDOW2_VORONOI_DIAGRAM_PAINTER_H

#include "painter_interface.h"

class MainData;

class VoronoiDiagramPainter
    : private PainterInterface {
private:

    struct VoronoiEdge {
        std::size_t player1;
        std::size_t player2;
        rcsc::Vector2D point1;
        rcsc::Vector2D point2;

        VoronoiEdge( std::size_t i1,
                     std::size_t i2,
                     const double & p1x,
                     const double & p1y,
                     const double & p2x,
                     const double & p2y )
            : player1( i1 )
            , player2( i2 )
            , point1( p1x, p1y )
            , point2( p2x, p2y )
          { }
    };



    const MainData & M_data;

    VoronoiDiagramPainter();

public:

    VoronoiDiagramPainter( const MainData & data )
        : M_data( data )
      { }

    /*!
      \brief draw soccer field and stationary objects
      \param dc reference to the device context
    */
    void draw( wxDC & dc ) const;

};

#endif
