// -*-c++-*-

/*!
  \file player_painer.h
  \brief player painter class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_PLAYER_PAINTER_H
#define SOCCER_WINDOW2_PLAYER_PAINTER_H

#include "painter_interface.h"

class MainData;

class PlayerPainter 
    : private PainterInterface {
private:

    struct Param {
        int x_; //!< screen X coordinates
        int y_; //!< screen Y coordinates
        int body_radius_; //!< pixel of body radius
        int kick_radius_; //!< pixel of kick area radius
        int draw_radius_; //!< pixel of main draw radius.
        bool have_full_effort_; //!< flag to check effort value
        const Player & player_;
        const Ball & ball_;
        const rcsc::PlayerType & player_type_;

        /*!
          \brief constructor
          \param p reference to parent class
          \param draw_param set of draw parameters
          \param sparam server parameters
          \param ptypes set of player type parameters
         */
        Param( const Player & p,
               const Ball & ball,
               const ViewConfig & view_conf,
               const rcsc::PlayerType & ptype );
    private:
        //! not used
        Param();
    };


    const MainData & M_data;

public:

    explicit
    PlayerPainter( const MainData & data )
        : M_data( data )
      { }


    void draw( wxDC & dc ) const;

private:

    /*!
      \brief draw body circle
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
    */
    void drawBody( wxDC & dc,
                   const PlayerPainter::Param & param ) const;

    /*!
      \brief draw shador arc
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
    */
    void drawShadow( wxDC & dc,
                     const PlayerPainter::Param & param ) const;

    /*!
      \brief draw player's body edge lines.
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
     */
    void drawEdge( wxDC & dc,
                   const PlayerPainter::Param & param ) const;

    /*!
      \brief draw player's future points
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
    */
    void drawFuture( wxDC & dc,
                     const PlayerPainter::Param & param ) const;

    /*!
      \brief draw view cone
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
    */
    void drawViewCone( wxDC & dc,
                       const PlayerPainter::Param & param ) const;

    /*! 
      \brief draw goalie catchable area. And if ball is in player's tackla
      area, tackle area rectangle is drawn.
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
     */
    void drawControlArea( wxDC & dc,
                          const PlayerPainter::Param & param ) const;

    /*!
      \brief draw text info
      \param dc reference to DC
      \param param parameter set that defeines this players draw settings
    */
    void drawText( wxDC & dc,
                   const PlayerPainter::Param & param ) const;

};

#endif
