// -*-c++-*-

/*!
  \file main_toolbar.h
  \brief Main Toolbar class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_MAIN_TOOLBAR_H
#define SOCCERWINDOW2_MAIN_TOOLBAR_H

class MainData;
class MainFrame;

//! toolbar that controls logplayer
class MainToolBar
    : public wxToolBar {
private:

    MainFrame * M_main_frame;

    const MainData & M_data;

    //! cycle controller
    wxSlider * M_cycle_slider;
    //! cycle controller
    wxTextCtrl * M_cycle_text_box;

    //! not used
    MainToolBar();
    //! not used
    MainToolBar( const MainToolBar & );
    //! not used
    MainToolBar & operator=( const MainToolBar & );
public:

    /*!
      \brief create new toolbar window
      \param parent pointer to the parent window
      \param style window style
      \param main_frame pointer to the CONTROL
      \param data const reference to the DATA
    */
    MainToolBar( wxWindow * parent,
                 const long & style,
                 MainFrame * main_frame,
                 const MainData & data );

    ~MainToolBar();

private:
    void createTools();

    //! slider factory
    wxSlider * createCycleSlider( wxWindow * parent );
    //! text box factory
    wxTextCtrl * createCycleTextBox( wxWindow * parent );

    void connectEvents();

    //! event handler
    void handleSliderScroll( wxScrollEvent & event );
    //! event handler
    void handleCycleTextEnter( wxCommandEvent & event );

public:
    void update();
};

#endif
