// -*-c++-*-

/*!
  \file fedit_app.h
  \brief formation editor main application class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef FORMATION_EDITOR_APP_H
#define FORMAIION_EDITOR_APP_H

/*!
  main application class
*/
class FEditApp
    : public wxApp {
public:
    static const wxString APP_NAME; //!< application name
    static const wxString APP_CONFIG_FILE; //!< config file name

    // override the virtual functions of super class(wxApp)
    // ----------------------------

    /*!
      \brief realize application window.
      \return result of initialization.

      This method is a start point of application.
      It is used for the initialization for application.
      Because it can return the error, it can return 'false' and we can
      quit an application immediately if it failed to initialize.
    */
    virtual
    bool OnInit();

    virtual
    int OnExit();

private:

    /*!
      \brief static method
      \return path to the application config file
    */
    static
    wxString get_config_file_path();

public:

    /*!
      \brief static method
      \return reference to the config file object
     */
    static
    wxFileConfig & get_config_file();

};

DECLARE_APP( FEditApp )

#endif
