// -*-c++-*-

/*!
  \file detail_dialog.cpp
  \brief Detail info Dialog class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <cassert>
#include <iostream>

#include "id.h"
#include "ball_panel.h"
#include "main_data.h"
#include "main_frame.h"
#include "monitor_view_data.h"
#include "player_panel.h"

#include "detail_dialog.h"

/*-------------------------------------------------------------------*/
/*!

*/
DetailDialog::DetailDialog( wxWindow * parent,
                            MainFrame * main_frame,
                            const MainData & data )
    : wxDialog( parent,
                SWID_DIALOG_DETAIL, wxT( "Object Detail" ),
                wxPoint( 0, 0 ), //wxDefaultPosition,
                wxDefaultSize,
                wxCAPTION | wxSYSTEM_MENU | wxCLOSE_BOX )
    , M_main_frame( main_frame )
    , M_ball_panel( new BallPanel( this, data ) )
    , M_player_panel( new PlayerPanel( this, data ) )
{
    assert( main_frame );

    wxBoxSizer * main_sizer = new wxBoxSizer( wxVERTICAL );

    // ball box
    wxStaticBoxSizer * ball_sizer
        =  new wxStaticBoxSizer( new wxStaticBox( this, -1, wxT( "Ball" ) ),
                                 wxVERTICAL );
    ball_sizer->Add( M_ball_panel );

    // player box
    wxStaticBoxSizer * player_sizer
        = new wxStaticBoxSizer( new wxStaticBox( this, -1, wxT( "Player" ) ),
                                wxVERTICAL );
    player_sizer->Add( M_player_panel );

    main_sizer->Add( ball_sizer );
    main_sizer->Add( player_sizer );

    main_sizer->SetSizeHints( this );
    this->SetAutoLayout( true );
    this->SetSizer( main_sizer );
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
DetailDialog::Show( bool show )
{
    M_ball_panel->Show( show );
    M_player_panel->Show( show );

    return wxDialog::Show( show );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DetailDialog::update()
{
    M_ball_panel->update();
    M_player_panel->update();
}
