// -*-c++-*-

/*!
  \file
  \brief View Config Dialog class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <cassert>
#include <iostream>

#include "id.h"
#include "app_config.h"

#include "debug_log_dir_dialog.h"

/*-------------------------------------------------------------------*/
/*!

*/
DebugLogDirDialog::DebugLogDirDialog( wxWindow * parent )
    : wxDialog( parent,
                SWID_DIALOG_DEBUG_LOG_DIR, wxT( "Select Log Directory" ),
                wxDefaultPosition,
                wxDefaultSize,
                wxDEFAULT_DIALOG_STYLE //wxCAPTION | wxSYSTEM_MENU | wxCLOSE_BOX
                )
    , M_side_select_rb( static_cast< wxRadioBox * >( 0 ) )
{
    assert( parent );

    createControls();
    connectEvents();
}

/*-------------------------------------------------------------------*/
/*!

*/
DebugLogDirDialog::~DebugLogDirDialog()
{
    //std::cerr << "delete DebugLogDirDialog" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
rcsc::SideID
DebugLogDirDialog::getSide() const
{
    if ( ! M_side_select_rb )
    {
        return rcsc::LEFT;
    }

    switch ( M_side_select_rb->GetSelection() ) {
    case 0:
        return rcsc::LEFT;
    case 1:
        return rcsc::RIGHT;
    default:
        return rcsc::LEFT;
    }

    return rcsc::LEFT;
}

/*-------------------------------------------------------------------*/
/*!

*/
std::string
DebugLogDirDialog::getDirPath() const
{
    if ( ! M_log_dir )
    {
        return std::string( "" );
    }

#ifdef UNICODE
    return std::string( (const char*)M_log_dir->GetValue().mbc_str() );
#else
    return std::string( (const char*)M_log_dir->GetValue().c_str() );
#endif
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugLogDirDialog::connectEvents()
{
    // command event : button
    Connect( SWID_BUTTON_SELECT_DEBUG_DIR, wxEVT_COMMAND_BUTTON_CLICKED,
             wxCommandEventHandler( DebugLogDirDialog::handleSelectDirButton ) );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugLogDirDialog::createControls()
{
    wxBoxSizer * panel_sizer = new wxBoxSizer( wxVERTICAL );

    ///////////////////////////////////////////////////////
    wxString choices[2] = { _( "Left" ), _( "Right" ) };
    M_side_select_rb = new wxRadioBox( this, -1,
                                       _( "Side Selection" ),
                                       wxDefaultPosition, wxDefaultSize,
                                       2, choices );

    panel_sizer->Add( M_side_select_rb,
                      0, wxLEFT | wxRIGHT, 4 );

    ///////////////////////////////////////////////////////

    panel_sizer->Add( createDirSelectControls( this ),
                      0, wxLEFT | wxRIGHT, 4 );

    panel_sizer->Add( createAnswerControls( this ),
                      0, wxLEFT | wxRIGHT, 4 );

    panel_sizer->SetSizeHints( this );
    this->SetAutoLayout( true );
    this->SetSizer( panel_sizer );
}

/*-------------------------------------------------------------------*/
/*!

*/
wxSizer *
DebugLogDirDialog::createDirSelectControls( wxWindow * parent )
{
    wxStaticBox * sbox = new wxStaticBox( parent, -1,
                                          wxT( "Log Directry" ) );
    wxStaticBoxSizer * sizer = new wxStaticBoxSizer( sbox, wxHORIZONTAL );

    {
        wxString dir_str( wxT( "" ) );
        if ( AppConfig::instance().debugLogDir().empty() )
        {
            dir_str = ::wxGetCwd(); // current working directory
        }
        else
        {
            dir_str = wxString( AppConfig::instance().debugLogDir().c_str(),
                                *wxConvCurrent );
        }

        M_log_dir = new wxTextCtrl( parent, -1,
                                    dir_str,
                                    wxDefaultPosition,
                                    wxSize( 320, -1 ) );
        sizer->Add( M_log_dir,
                    0, wxALIGN_CENTER_VERTICAL, 0 );

        int width, height;
        this->GetTextExtent( wxT( "..." ), &width, &height );

        M_select_dir_btn = new wxButton( parent, SWID_BUTTON_SELECT_DEBUG_DIR,
                                         wxT( "..." ),
                                         wxDefaultPosition,
                                         wxSize( width + 12, -1 ) );
        sizer->Add( M_select_dir_btn,
                    0, wxALIGN_CENTER_VERTICAL, 0 );
    }

    return sizer;
}

/*-------------------------------------------------------------------*/
/*!

*/
wxSizer *
DebugLogDirDialog::createAnswerControls( wxWindow * parent )
{
    wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );

    //sizer->AddStretchSpacer();

    sizer->Add( new wxButton( parent, wxID_OK, _( "Ok" ) ),
                1, wxALL, 6 );

    sizer->Add( new wxButton( parent, wxID_CANCEL, _( "Cancel" ) ),
                1, wxALL, 6 );

    //sizer->AddStretchSpacer();

    return sizer;
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugLogDirDialog::handleSelectDirButton( wxCommandEvent & WXUNUSED( event ) )
{
    wxDirDialog dlg( this, // parent parent
                     wxT( "Choose a log directory" ),
                     M_log_dir->GetValue(),  // default path
                     wxDEFAULT_DIALOG_STYLE );

    if ( dlg.ShowModal() != wxID_OK )
    {
        return;
    }

    M_log_dir->SetValue( dlg.GetPath() );
}

/*-------------------------------------------------------------------*/
/*!

*/
void
DebugLogDirDialog::handleOkButton( wxCommandEvent & WXUNUSED( event ) )
{
    this->Hide();
}
