// -*-c++-*-

/*!
  \file debug_message_frame.h
  \brief debug message viewer class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW_DEBUG_MESSAGE_FRAME_H
#define SOCCER_WINDOW_DEBUG_MESSAGE_FRAME_H

#include <boost/any.hpp>
#include <boost/shared_ptr.hpp>

#include <rcsc/types.h>

class MainData;
class MainFrame;
class DebugLogHolder;

class wxNotebookEvent;

//! debug manager frame class
class DebugMessageFrame
    : public wxFrame {
private:

    MainFrame * M_main_frame;

    MainData & M_data;

    //! debug log data holder
    boost::shared_ptr< DebugLogHolder > M_debug_holder;

    wxTextCtrl * M_message[11];

    //! notebook selection number == player selection
    int M_selection;

    //! log level flag
    int M_level;

    //! not used
    DebugMessageFrame();
    //! noncopyable
    DebugMessageFrame( const DebugMessageFrame & );
    //! noncopyable
    DebugMessageFrame & operator=( const DebugMessageFrame & );

public:
    /*!
      \brief construct with other modules
      \param parent wx parent window
      \param main_frame main control frame
      \param data main data reference
     */
    DebugMessageFrame( wxWindow * parent,
                       MainFrame * main_frame,
                       MainData & data );

    //! destructor
    ~DebugMessageFrame();

    /*!
      \brief delete all loaded data.
     */
    void clear();

    boost::shared_ptr< const DebugLogHolder > getDebugLogHolder() const
      {
          return M_debug_holder;
      }

private:

    /*!
      \brief load preference from the ~/.soccerwindow2
     */
    void loadConfig();

    /*!
      \brief save preference to the ~/.soccerwindow2
     */
    void saveConfig();

    /*!
      \brief create child windows
     */
    void createWindows();

    /*!
      \brief connect event Id to the event handler
     */
    void connectEvents();

    //--------------------------------------------------
    // create window objects

    /*!
      \brief realize menu bar.
    */
    void createMenuBar();

    /*!
      \brief realize tool bar.
     */
    void createToolBar();

    //--------------------------------------------------

    /*!
      \brief realize dialog window to select team side & log directory
     */
    void showDebugLogDirDialog();

    /*!
      \brief load debug log data from the specified directory
      \param side team side that log data is loaded
      \param dir_path directory path that log files are located.
     */
    void loadDebugLogDir( const rcsc::SideID side,
                          const std::string & dir_path );

    //--------------------------------------------------
    // wx event handlers

    /*!
      \brief called when main frame is closed.
    */
    void handleCloseEvent( wxCloseEvent & event );

    void handleNotebookPageChanged( wxNotebookEvent & event );

    //--------------------------------------------------
    // message handlers

    void recvShowDebugLogDirDialog( const boost::any * )
      {
          showDebugLogDirDialog();
      }

    void recvDebugLevel1( const boost::any * );
    void recvDebugLevel2( const boost::any * );
    void recvDebugLevel3( const boost::any * );
    void recvDebugLevel4( const boost::any * );
    void recvDebugLevel5( const boost::any * );
    void recvDebugLevel6( const boost::any * );
    void recvDebugLevel7( const boost::any * );
    void recvDebugLevel8( const boost::any * );
    void recvDebugLevel9( const boost::any * );
    void recvDebugLevel10( const boost::any * );
    void recvDebugLevel11( const boost::any * );
    void recvDebugLevel12( const boost::any * );
    void recvDebugLevel13( const boost::any * );
    void recvDebugLevel14( const boost::any * );
    void recvDebugLevel15( const boost::any * );
    void recvDebugLevel16( const boost::any * );

    void recvDisplayDebugMessage( const boost::any * );

    void recvDebugLogSync( const boost::any * );
    void recvDebugLogDecrement( const boost::any * data );
    void recvDebugLogIncrement( const boost::any * data );

public:

    /*!
      \brief update data in child window
    */
    void update();

    void setCycle( const long & cycle );


    /*!

    */
    void setShowDebugView();

    /*!

    */
    void setShowDebugViewSelf();

    /*!

    */
    void setShowDebugViewBall();

    /*!

    */
    void setShowDebugViewPlayers();

    /*!

    */
    void setShowDebugViewComment();

    /*!

    */
    void setShowDebugViewFigure();

    /*!

    */
    void setShowDebugViewTarget();

    /*!

    */
    void setShowDebugViewMessage();

};

#endif
