// -*-c++-*-

/*!
  \file ball_trace_painter.cpp
  \brief ball trace painter class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "main_data.h"
#include "monitor_view_data.h"

#include "ball_trace_painter.h"

/*-------------------------------------------------------------------*/
/*!
  \param dc reference to the device context
*/
void
BallTracePainter::draw( wxDC & dc ) const
{
    const ViewHolder & holder = M_data.getViewHolder();
    const ViewConfig & conf = M_data.config();

    long start_cycle = conf.getBallTraceStart();
    long end_cycle = conf.getBallTraceEnd();

    const MonitorViewCont & vc = holder.getMonitorViewCont();

    if ( vc.empty() )
    {
        return;
    }

    if ( conf.isBallAutoTrace() )
    {
        start_cycle = std::max( 0L, M_data.getCurrentViewData()->cycle() - 10 );
        //end_cycle = std::min( start_cycle + 20, vc.back()->cycle() );
    }
    else if ( start_cycle >= end_cycle )
    {
        return;
    }

    const std::size_t first = holder.getIndexOf( start_cycle );
    const std::size_t last = ( conf.isBallAutoTrace()
                               ? std::min( first + 20, vc.size() - 1 )
                               : holder.getIndexOf( end_cycle ) );
    if ( first >= last )
    {
        return;
    }

    const bool line_trace = conf.isLineTrace();

    if ( line_trace )
    {
        dc.SetBrush( *wxTRANSPARENT_BRUSH );
    }
    else
    {
        dc.SetBrush( *wxMEDIUM_GREY_BRUSH );
    }
    //const wxPen & bpen = ( line_trace
    //? M_data.gdi().getBallPen()
    //: *wxMEDIUM_GREY_PEN );
    const wxPen & bpen = M_data.gdi().getBallPen();

    std::size_t i = first;
    int prev_x = conf.getScreenX( vc[i]->ball().x() );
    int prev_y = conf.getScreenY( vc[i]->ball().y() );
    ++i;
    for ( ; i <= last; ++i )
    {
        switch ( vc[i]->playmode().mode() ) {
        case rcsc::PM_BeforeKickOff:
        case rcsc::PM_TimeOver:
        case rcsc::PM_KickOff_Left:
        case rcsc::PM_KickOff_Right:
            prev_x = conf.getScreenX( 0.0 );
            prev_y = conf.getScreenY( 0.0 );
            continue;
        case rcsc::PM_PlayOn:
        case rcsc::PM_AfterGoal_Left:
        case rcsc::PM_AfterGoal_Right:
            dc.SetPen( bpen );
            break;
        default:
            //std::cerr << "playmode = " << vc[i]->playmode().name() << std::endl;
            dc.SetPen( *wxBLACK_DASHED_PEN );
            break;
        }

        const Ball & b = vc[i]->ball();
        int ix = conf.getScreenX( b.x() );
        int iy = conf.getScreenY( b.y() );
        if ( line_trace )
        {
            dc.DrawLine( prev_x, prev_y, ix, iy );
        }
        else
        {
            dc.DrawLine( prev_x, prev_y, ix, iy );
            dc.DrawCircle( ix, iy, 2 );
        }
        prev_x = ix;
        prev_y = iy;
    }
}
