// -*-c++-*-

/*!
  \file view_holder.h
  \brief view data repository Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_VIEW_HOLDER_H
#define SOCCERWINDOW2_VIEW_HOLDER_H

#include <map>

#include <boost/any.hpp>
#include <boost/shared_ptr.hpp>

#include <rcsc/param/player_type.h>
#include <rcsc/rcg/holder.h>

#include "monitor_view_data.h"
#include "debug_view_data.h"

class MainFrame;

//! drawing data repository
class ViewHolder
    : public rcsc::rcg::Holder {
private:

    MainFrame * M_main_frame;

    //! last changed playmode
    char M_last_playmode;
    //! last changed left team info
    rcsc::rcg::team_t M_last_team_left;
    //! last changed right team info
    rcsc::rcg::team_t M_last_team_right;

    //! the record of score change
    std::vector< std::size_t > M_score_change_indexes;

    //! player_type set
    std::vector< rcsc::PlayerType > M_player_types;

    //! last received view data
    MonitorViewPtr M_latest_view_data;

    //! view data container.
    std::vector< MonitorViewPtr > M_monitor_view_cont;

    //! debug view data set for left players (key:cycle)
    std::map< long, DebugViewCont > M_left_debug_view;

    //! debug view data set for right players (key:cycle)
    std::map< long, DebugViewCont > M_right_debug_view;


    //! nocopyable
    ViewHolder( const ViewHolder & );
    //! nocopyable
    ViewHolder & operator=( const ViewHolder & );

public:
    //! constructor.
    explicit
    ViewHolder( MainFrame * main_frame );

    ~ViewHolder();
    //--------------------------------------------------
    //! clear all stored data
    void clear();

    //--------------------------------------------------
    // override methods.

    //! register showinfo_t (rcg v2, monitor v1)
    bool addShowInfo( const rcsc::rcg::showinfo_t & show );
    //! register showinfo_t (monitor v2 only)
    bool addShowInfo2( const rcsc::rcg::showinfo_t2 & show2 );
    //! register showinfo_t (rcg v3 only)
    bool addShortShowInfo2( const rcsc::rcg::short_showinfo_t2 & show2 );

    void pushBackLatestViewData();

    //! register msginfo_t
    bool addMsgInfo( const short board, const std::string & msg );

    //! register drawinfo_t
    bool addDrawInfo( const rcsc::rcg::drawinfo_t & draw );

    //! register playmode
    bool addPlayMode( const char pmode );
    //! register team_t * 2
    bool addTeamInfo( const rcsc::rcg::team_t & team_l,
                      const rcsc::rcg::team_t & team_r );

    //! register server_params_t
    bool addServerParam( const rcsc::rcg::server_params_t & sparams );
    //! register player_params_t
    bool addPlayerParam( const rcsc::rcg::player_params_t & pparams );
    //! register player_type_t
    bool addPlayerType( const rcsc::rcg::player_type_t & ptinfo );

    //--------------------------------------------------

    //! set debug view data
    void addDebugView( const long & cycle,
                       const char side,
                       const int unum,
                       DebugViewPtr debug_view );

    //--------------------------------------------------

    char getLastPlayMode() const
      {
          return M_last_playmode;
      }

    //! get const reference of data container.
    const
    std::vector< MonitorViewPtr > & getMonitorViewCont() const
      {
          return M_monitor_view_cont;
      }

    //! get debug view data container
    const
    std::map< long, DebugViewCont > & getLeftDebugView() const
      {
          return M_left_debug_view;
      }
    //! get debug view data container
    const
    std::map< long, DebugViewCont > & getRightDebugView() const
      {
          return M_right_debug_view;
      }

    //! get player_type map
    const
    std::vector< rcsc::PlayerType > & getPlayerTypes() const
      {
          return M_player_types;
      }

    const
    std::vector< std::size_t > & getScoreChangeIndexes() const
      {
          return M_score_change_indexes;
      }

    const
    MonitorViewPtr getViewData( const std::size_t idx ) const;

    const
    MonitorViewPtr getLatestViewData() const
      {
          return M_latest_view_data;
      }

    std::size_t getIndexOf( const long & cycle ) const;

private:
    void addMonitorViewData( boost::shared_ptr< MonitorViewData > ptr );
};

#endif
