// -*-c++-*-

/*!
	\file mouse_state.h
	\brief mouse state class Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.	If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCERWINDOW2_MOUSE_STATE_H
#define SOCCERWINDOW2_MOUSE_STATE_H

///////////////////////////////////////////////////////////////////////
//! formation editor canvas class
class MouseState {
private:

    bool M_down;
    wxPoint M_down_point;
    wxPoint M_drag_point;

public:
    MouseState()
        : M_down( false )
        , M_down_point( 0, 0 )
        , M_drag_point( 0, 0 )
          { }


    void down( const wxPoint & pos )
      {
          M_down = true;
          M_down_point = M_drag_point = pos;
      }
    void up()
      {
          M_down = false;
      }
    void motion( const wxPoint & pos )
      {
          if ( M_down )
          {
              M_drag_point = pos;
          }
      }

    bool isDown() const
      {
          return M_down;
      }
    const
    wxPoint & getDownPoint() const
      {
          return M_down_point;
      }
    const
    wxPoint & getDragPoint() const
      {
          return M_drag_point;
      }

    bool isDragged() const
      {
          return ( M_down
                   && ( std::abs( M_down_point.x - M_drag_point.x ) > 2
                        || std::abs( M_down_point.y - M_drag_point.y ) > 2 )
                   );
      }

};

#endif
