// -*-c++-*-

/*!
  \file id.h
  \brief ID List Header File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifndef SOCCER_WINDOW2_ID_H
#define SOCCER_WINDOW2_ID_H

enum {
    SWID_SOCCER_WINDOW_APP = 100,

    // global command event IDs
    SWID_QUIT,
    SWID_SHOW_HELP_DIALOG,
    SWID_SHOW_ABOUT_DIALOG,
    SWID_SHOW_OPEN_RCG_DIALOG, // file open
    SWID_SHOW_CONNECT_DIALOG, // text entry
    SWID_SHOW_PLAYER_TYPE_DIALOG,
    SWID_SHOW_DETAIL_DIALOG,
    SWID_SHOW_IMAGE_SAVE_DIALOG,
    SWID_SHOW_VIEW_CONFIG_DIALOG,
    SWID_SHOW_DEBUG_MESSAGE_FRAME,

    // window IDs
    SWID_STATUSBAR,

    // toolbar
    SWID_TOOLBAR_LOGPLAYER,
    SWID_SLIDER_LOGPLAYER,
    SWID_TEXTBOX_LOGPLAYER,

    SWID_TOOLBAR_MONITOR,

    // player type dialog
    SWID_DIALOG_PLAYER_TYPE,

    SWID_GRID_PLAYER_TYPE,

    // detail dialog
    SWID_DIALOG_DETAIL,

    SWID_PANEL_BALL,
    SWID_PANEL_PLAYER,

    // view config dialog
    SWID_DIALOG_FIELD_CANVAS_CONFIG,

    SWID_SLIDER_FIELD_SCALE,
    SWID_CHOICE_VORONOI_TARGET,

    // signal for config change
    SWID_CHANGED_VIEW_CONFIG,

    SWID_TEXTBOX_BALL_TRACE_START,
    SWID_TEXTBOX_BALL_TRACE_END,
    SWID_TEXTBOX_PLAYER_TRACE_START,
    SWID_TEXTBOX_PLAYER_TRACE_END,
    SWID_TEXTBOX_BALL_FUTURE_CYCLE,
    SWID_TEXTBOX_PLAYER_FUTURE_CYCLE,

    // image save dialog
    SWID_DIALOG_IMAGE_SAVE,

    SWID_IMAGE_SAVE_SELECT_ALL,
    SWID_IMAGE_SAVE_SELECT_DIR,
    SWID_IMAGE_SAVE_EXECUTE,

    // debug message frame
    SWID_FRAME_DEBUG_MESSAGE,
    SWID_TEXTBOX_LOGLEVEL_MIN,
    SWID_TEXTBOX_LOGLEVEL_MAX,
    SWID_NOTEBOOK_DEBUG_MESSAGE,
    SWID_TEXTBOX_DEBUG_MESSAGE_1,
    SWID_TEXTBOX_DEBUG_MESSAGE_2,
    SWID_TEXTBOX_DEBUG_MESSAGE_3,
    SWID_TEXTBOX_DEBUG_MESSAGE_4,
    SWID_TEXTBOX_DEBUG_MESSAGE_5,
    SWID_TEXTBOX_DEBUG_MESSAGE_6,
    SWID_TEXTBOX_DEBUG_MESSAGE_7,
    SWID_TEXTBOX_DEBUG_MESSAGE_8,
    SWID_TEXTBOX_DEBUG_MESSAGE_9,
    SWID_TEXTBOX_DEBUG_MESSAGE_10,
    SWID_TEXTBOX_DEBUG_MESSAGE_11,

    SWID_DIALOG_DEBUG_LOG_DIR,

    // popup menu ID
    SWID_MENU_MONITOR_DROPBALL,
    SWID_MENU_MONITOR_FREEKICK_LEFT,
    SWID_MENU_MONITOR_FREEKICK_RIGHT,

    // submenu ID
    SWID_SUBMENU_GRASS_TYPE,

    // timer ID
    SWID_TIMER_MONITOR,
    SWID_TIMER_DEBUG_SERVER,
    SWID_TIMER_LOGPLAYER,

    /////////////////////////////////////////////////
    SWID_MAIN_FRAME_COMMAND_BEGIN,

    // menu command event IDs
    SWID_TOGGLE_MENUBAR,
    SWID_TOGGLE_TOOLBAR,
    SWID_TOGGLE_STATUSBAR,
    SWID_TOGGLE_MAXIMIZE,
    SWID_TOGGLE_FULLSCREEN,
    SWID_SHOW_PREFERENCE_DIALOG,

    // view data event Ids
    SWID_RECEIVE_MONITOR_PACKET,
    SWID_SET_VIEW_DATA_INDEX,
    SWID_SET_VIEW_DATA_INDEX_FIRST,
    SWID_SET_VIEW_DATA_INDEX_LAST,
    SWID_SET_VIEW_DATA_CYCLE,
    SWID_STEP_VIEW_DATA_FORWARD,
    SWID_STEP_VIEW_DATA_BACK,

    SWID_SET_BALL_TRACE_START,
    SWID_SET_BALL_TRACE_END,
    SWID_SET_PLAYER_TRACE_START,
    SWID_SET_PLAYER_TRACE_END,
    SWID_SET_BALL_FUTURE_CYCLE,
    SWID_SET_PLAYER_FUTURE_CYCLE,

    // monitor command IDs
    SWID_MONITOR_CONNECT,
    SWID_MONITOR_DISCONNECT,
    SWID_MONITOR_KICKOFF,
    SWID_MONITOR_DROPBALL,
    SWID_MONITOR_FREEKICK_LEFT,
    SWID_MONITOR_FREEKICK_RIGHT,
    SWID_MONITOR_MODE_NORMAL,
    SWID_MONITOR_MODE_MOVE_PLAYER,
    SWID_MONITOR_MODE_DISCARD_PLAYER,
    SWID_MONITOR_CHANGE_PLAYMODE,

    // logplayer command IDs

    SWID_LOGPLAYER_SET_INDEX,
    SWID_LOGPLAYER_STOP,
    SWID_LOGPLAYER_PLAY_BACK,
    SWID_LOGPLAYER_PLAY_FORWARD,
    SWID_LOGPLAYER_PLAY_OR_STOP,
    SWID_LOGPLAYER_STEP_BACK,
    SWID_LOGPLAYER_STEP_FORWARD,
    SWID_LOGPLAYER_GOTO_FIRST,
    SWID_LOGPLAYER_GOTO_LAST,
    SWID_LOGPLAYER_GOTO_PREV_SCORE,
    SWID_LOGPLAYER_GOTO_NEXT_SCORE,
    SWID_LOGPLAYER_DECELERATE,
    SWID_LOGPLAYER_ACCELERATE,
    SWID_LOGPLAYER_GOTO_INDEX,
    SWID_LOGPLAYER_GOTO_CYCLE,
    SWID_LOGPLAYER_AUTO_LOOP,

    SWID_REQUEST_LIVE_MODE,

    SWID_REQUEST_KILL_SERVER,
    SWID_REQUEST_RESTART_SERVER,

    // canvas event IDs
    SWID_CANVAS_LOAD_SIZE_BUTTON,
    SWID_CANVAS_SET_SIZE_BUTTON,
    SWID_CANVAS_ZOOMIN,
    SWID_CANVAS_ZOOMOUT,
    SWID_CANVAS_UNZOOM,
    SWID_CANVAS_ENLARGE,
    SWID_CANVAS_DRAW_SCORE_BOARD,
    SWID_CANVAS_DRAW_BALL,
    SWID_CANVAS_DRAW_PLAYER,
    SWID_CANVAS_DRAW_PLAYER_NUMBER,
    SWID_CANVAS_DRAW_STAMINA,
    SWID_CANVAS_DRAW_HETERO_NUMBER,
    SWID_CANVAS_DRAW_VIEW_CONE,
    SWID_CANVAS_DRAW_CONTROL_AREA,
    SWID_CANVAS_DRAW_FLAGS,
    SWID_CANVAS_DRAW_OFFSIDE_LINE,
    SWID_CANVAS_DRAW_VORONOI_DIAGRAM,
    SWID_CANVAS_DRAW_DELAUNAY_TRIANGLE,
    SWID_CANVAS_VORONOI_ALL,
    SWID_CANVAS_VORONOI_LEFT,
    SWID_CANVAS_VORONOI_RIGHT,
    SWID_CANVAS_POPUP_NORMAL_MENU,
    SWID_CANVAS_POPUP_MONITOR_MENU,
    SWID_CANVAS_GRASS_LINES,
    SWID_CANVAS_GRASS_CHECKER,
    SWID_CANVAS_GRASS_NORMAL,
    SWID_CANVAS_FOCUS_POINT,
    SWID_CANVAS_FOCUS_BALL,
    SWID_CANVAS_FOCUS_PLAYER,
    SWID_CANVAS_FOCUS_FIX,
    SWID_CANVAS_SELECT_AUTO_ALL,
    SWID_CANVAS_SELECT_AUTO_LEFT,
    SWID_CANVAS_SELECT_AUTO_RIGHT,
    SWID_CANVAS_SELECT_FIX,
    SWID_CANVAS_SELECT_PLAYER,
    SWID_CANVAS_SELECT_PLAYER_L1,
    SWID_CANVAS_SELECT_PLAYER_L2,
    SWID_CANVAS_SELECT_PLAYER_L3,
    SWID_CANVAS_SELECT_PLAYER_L4,
    SWID_CANVAS_SELECT_PLAYER_L5,
    SWID_CANVAS_SELECT_PLAYER_L6,
    SWID_CANVAS_SELECT_PLAYER_L7,
    SWID_CANVAS_SELECT_PLAYER_L8,
    SWID_CANVAS_SELECT_PLAYER_L9,
    SWID_CANVAS_SELECT_PLAYER_L10,
    SWID_CANVAS_SELECT_PLAYER_L11,
    SWID_CANVAS_SELECT_PLAYER_R1,
    SWID_CANVAS_SELECT_PLAYER_R2,
    SWID_CANVAS_SELECT_PLAYER_R3,
    SWID_CANVAS_SELECT_PLAYER_R4,
    SWID_CANVAS_SELECT_PLAYER_R5,
    SWID_CANVAS_SELECT_PLAYER_R6,
    SWID_CANVAS_SELECT_PLAYER_R7,
    SWID_CANVAS_SELECT_PLAYER_R8,
    SWID_CANVAS_SELECT_PLAYER_R9,
    SWID_CANVAS_SELECT_PLAYER_R10,
    SWID_CANVAS_SELECT_PLAYER_R11,
    SWID_CANVAS_UNSELECT_PLAYER,
    SWID_CANVAS_TOGGLE_TRACE_MODE,
    SWID_CANVAS_TOGGLE_BALL_AUTO_TRACE,
    SWID_CANVAS_TOGGLE_PLAYER_AUTO_TRACE,

    // debug server
    SWID_DEBUG_SERVER_START,
    SWID_DEBUG_SERVER_STOP,

    SWID_MAIN_FRAME_COMMAND_END,

    // end of main frame commands
    ///////////////////////////////////////////////////////////
    // debug message frame commands

    SWID_DEBUG_FRAME_COMMAND_BEGIN,

    // visual debugger
    SWID_CANVAS_DRAW_DEBUG_VIEW,
    SWID_CANVAS_DRAW_DEBUG_VIEW_BALL,
    SWID_CANVAS_DRAW_DEBUG_VIEW_SELF,
    SWID_CANVAS_DRAW_DEBUG_VIEW_PLAYERS,
    SWID_CANVAS_DRAW_DEBUG_VIEW_COMMENT,
    SWID_CANVAS_DRAW_DEBUG_VIEW_FIGURE,
    SWID_CANVAS_DRAW_DEBUG_VIEW_TARGET,
    SWID_CANVAS_DRAW_DEBUG_VIEW_MESSAGE,

    // debug log directory
    SWID_SHOW_DEBUG_LOG_DIR_DIALOG,

    SWID_BUTTON_SELECT_DEBUG_DIR, // dir selector dialog

    SWID_DISPLAY_DEBUG_MESSAGE,

    // debug log message level
    SWID_DEBUG_LEVEL_1,
    SWID_DEBUG_LEVEL_2,
    SWID_DEBUG_LEVEL_3,
    SWID_DEBUG_LEVEL_4,
    SWID_DEBUG_LEVEL_5,
    SWID_DEBUG_LEVEL_6,
    SWID_DEBUG_LEVEL_7,
    SWID_DEBUG_LEVEL_8,
    SWID_DEBUG_LEVEL_9,
    SWID_DEBUG_LEVEL_10,
    SWID_DEBUG_LEVEL_11,
    SWID_DEBUG_LEVEL_12,
    SWID_DEBUG_LEVEL_13,
    SWID_DEBUG_LEVEL_14,
    SWID_DEBUG_LEVEL_15,
    SWID_DEBUG_LEVEL_16,

    SWID_DEBUG_SELECT_PLAYER,
    SWID_DEBUG_LOG_SYNC,
    SWID_DEBUG_LOG_DECREMENT,
    SWID_DEBUG_LOG_INCREMENT,

    SWID_DEBUG_FRAME_COMMAND_END,
    // end of debug message frame commands
    ///////////////////////////////////////////////////////////

    ///////////////////////////////////////////////////////////
    // Formation Editor IDs
    SWID_FRAME_EDITOR,
    SWID_WINDOW_EDITOR_CANVAS,
    SWID_STATUSBAR_EDITOR,
    SWID_DIALOG_EDITOR,

    SWID_EDITOR_SPIN_INDEX_X,
    SWID_EDITOR_SPIN_INDEX_Y,

    SWID_EDITOR_MIRROR_BALL,

    SWID_EDITOR_SPIN_TRAIN_DATA,
    SWID_EDITOR_REPLACE_DATA,
    SWID_EDITOR_DELETE_DATA,

    SWID_EDITOR_FORMATION_NAME,
    SWID_EDITOR_COMBO_SELECT_MODE,

    // Formation Editor Commands
    SWID_EDITOR_NEW,
    SWID_EDITOR_OPEN,
    SWID_EDITOR_SAVE_ALL,
    SWID_EDITOR_SAVE,
    SWID_EDITOR_SAVE_AS,
    SWID_EDITOR_OPEN_TRAIN_DATA,
    SWID_EDITOR_SAVE_TRAIN_DATA,
    SWID_EDITOR_SAVE_TRAIN_DATA_AS,

    SWID_EDITOR_SHOW_DIALOG,
    SWID_EDITOR_APPLY_TO_FIELD,

    SWID_EDITOR_RESET_BALL,
    SWID_EDITOR_BALL_DRAGGABLE,
    SWID_EDITOR_PLAYER_AUTO_MOVE,

    SWID_EDITOR_RECORD_POSITION,
    SWID_EDITOR_TRAINING,

};

#endif
