// -*-c++-*-

/*!
  \file event_handler.cpp
  \brief event handler class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

#include "event_handler.h"

/*-------------------------------------------------------------------*/
/*!

*/
void
EventHandler::handle( const EventMessage & ev )
{
    //std::cerr << "EventHandler::handle id = " << ev.getId() << std::endl;
    HandlerMap::iterator it = M_handlers.find( ev.getId() );
    if ( it == M_handlers.end() )
    {
        return;
    }

    //std::cerr << "EventHandler::handle handler size = " << it->second.size() << std::endl;
    for ( EventFuncCont::iterator f = it->second.begin();
          f != it->second.end();
          ++f )
    {
        (*f)( ev.getData() );
    }
}
