// -*-c++-*-

/*!
  \file debug_server.cpp
  \brief Debug Server class Source File.
*/

/*
 *Copyright:

 Copyright (C) Hidehisa AKIYAMA

 This code is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This code is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this code; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *EndCopyright:
 */

/////////////////////////////////////////////////////////////////////

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

// for compliers supporting precompling
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

// for compliers NOT supporting precompling
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <iostream>

#include <rcsc/net/udp_socket.h>

#include "id.h"
#include "app_config.h"

#include "view_holder.h"
#include "debug_client_parser.h"

#include "debug_server.h"

namespace {
const int POLL_INTERVAL_MS = 20;
}

/*-------------------------------------------------------------------*/
/*!
  \param port my socket port number
*/
DebugServer::DebugServer( const int port,
                          ViewHolder & view_holder )
    : M_socket( new rcsc::UDPSocket( port ) )
    , M_timer( this, SWID_TIMER_DEBUG_SERVER )
    , M_view_holder( view_holder )
{
    if ( M_socket->fd() == -1 )
    {
        return;
    }

    //std::cerr << "create Logplayer" << std::endl;
    // connect event handler
    Connect( SWID_TIMER_DEBUG_SERVER, wxEVT_TIMER,
             wxTimerEventHandler( DebugServer::handleTimer ) );
}

/*-------------------------------------------------------------------*/
/*!
  destructor.
*/
DebugServer::~DebugServer()
{
    M_timer.Stop();
    M_socket->close();
    std::cerr << "Close Debug Server" << std::endl;
}

/*-------------------------------------------------------------------*/
/*!

*/
bool
DebugServer::isConnected() const
{
    return ( M_socket->fd() != -1 );
}

/*-------------------------------------------------------------------*/
/*!
  start timer
*/
void
DebugServer::start()
{
    M_timer.Start( POLL_INTERVAL_MS );
}

/*-------------------------------------------------------------------*/
/*!
  timer event handler.
*/
void
DebugServer::handleTimer( wxTimerEvent & event )
{
    int n = 0;
    char buf[8192];
    while ( ( n = M_socket->receive( buf, sizeof( buf ) ) ) > 0 )
    {
        buf[n] = '\0';
        DebugClientParser parser;
        parser.parse( buf, M_view_holder );
    }
}
