/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAA;
import org.eclipse.swt.internal.win32.NOTIFYICONDATAW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    TrayItem item;
    String text = "";
    String message = "";
    int id;
    int x;
    int y;
    boolean autoHide = true;
    boolean hasLocation;
    boolean visible;
    static final int TIMER_ID = 100;

    public ToolTip(Shell shell, int n) {
        super(shell, ToolTip.checkStyle(n));
        this.parent = shell;
        this.checkOrientation(shell);
        shell.createToolTip(this);
    }

    static int checkStyle(int n) {
        int n2 = 11;
        if ((n & n2) == 0) {
            return n;
        }
        return ToolTip.checkBits(n, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void destroyWidget() {
        if (this.parent != null) {
            this.parent.destroyToolTip(this);
        }
        this.releaseHandle();
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autoHide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (this.item != null) {
            return this.visible;
        }
        long l = this.hwndToolTip();
        if (OS.SendMessage(l, OS.TTM_GETCURRENTTOOL, 0L, 0L) != 0L) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(l, OS.TTM_GETCURRENTTOOL, 0L, tOOLINFO) != 0L) {
                return (tOOLINFO.uFlags & 1) == 0 && tOOLINFO.uId == (long)this.id;
            }
        }
        return false;
    }

    long hwndToolTip() {
        return (this.style & 0x1000) != 0 ? this.parent.balloonTipHandle() : this.parent.toolTipHandle();
    }

    public boolean isVisible() {
        this.checkWidget();
        if (this.item != null) {
            return this.getVisible() && this.item.getVisible();
        }
        return this.getVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.item = null;
        this.id = -1;
    }

    void releaseWidget() {
        long l;
        super.releaseWidget();
        if (this.item == null && this.autoHide && OS.SendMessage(l = this.hwndToolTip(), OS.TTM_GETCURRENTTOOL, 0L, 0L) != 0L) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            if (OS.SendMessage(l, OS.TTM_GETCURRENTTOOL, 0L, tOOLINFO) != 0L && (tOOLINFO.uFlags & 1) == 0 && tOOLINFO.uId == (long)this.id) {
                OS.SendMessage(l, 1041, 0L, tOOLINFO);
                OS.SendMessage(l, 1052, 0L, 0L);
                OS.KillTimer(l, 100L);
            }
        }
        if (this.item != null && this.item.toolTip == this) {
            this.item.toolTip = null;
        }
        this.item = null;
        this.message = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAutoHide(boolean bl) {
        this.checkWidget();
        this.autoHide = bl;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (OS.IsWinCE) {
            return;
        }
        if (bl == this.getVisible()) {
            return;
        }
        if (this.item == null) {
            Object object;
            int n;
            long l = this.parent.handle;
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = this.id;
            tOOLINFO.hwnd = l;
            long l2 = this.hwndToolTip();
            Shell shell = this.parent.getShell();
            if (this.text.length() != 0) {
                n = 0;
                if ((this.style & 2) != 0) {
                    n = 1;
                }
                if ((this.style & 8) != 0) {
                    n = 2;
                }
                if ((this.style & 1) != 0) {
                    n = 3;
                }
                shell.setToolTipTitle(l2, this.text, n);
            } else {
                shell.setToolTipTitle(l2, null, 0);
            }
            n = 0;
            if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                n = (rECT.right - rECT.left) / 4;
            } else {
                long l3 = OS.MonitorFromWindow(l, 2);
                object = new MONITORINFO();
                ((MONITORINFO)object).cbSize = MONITORINFO.sizeof;
                OS.GetMonitorInfo(l3, (MONITORINFO)object);
                n = (((MONITORINFO)object).rcWork_right - ((MONITORINFO)object).rcWork_left) / 4;
            }
            OS.SendMessage(l2, 1048, 0L, (long)n);
            if (bl) {
                int n2 = this.x;
                int n3 = this.y;
                if (!this.hasLocation && OS.GetCursorPos((POINT)(object = new POINT()))) {
                    n2 = ((POINT)object).x;
                    n3 = ((POINT)object).y;
                }
                long l4 = OS.MAKELPARAM(n2, n3);
                OS.SendMessage(l2, 1042, 0L, l4);
                POINT pOINT = new POINT();
                OS.GetCursorPos(pOINT);
                RECT rECT = new RECT();
                OS.GetClientRect(l, rECT);
                OS.MapWindowPoints(l, 0L, rECT, 2);
                if (!OS.PtInRect(rECT, pOINT)) {
                    long l5 = OS.GetCursor();
                    OS.SetCursor(0L);
                    OS.SetCursorPos(rECT.left, rECT.top);
                    OS.SendMessage(l2, 1041, 1L, tOOLINFO);
                    OS.SetCursorPos(pOINT.x, pOINT.y);
                    OS.SetCursor(l5);
                } else {
                    OS.SendMessage(l2, 1041, 1L, tOOLINFO);
                }
                int n4 = (int)OS.SendMessage(l2, 1045, 2L, 0L);
                OS.SetTimer(l2, 100L, n4, 0L);
            } else {
                OS.SendMessage(l2, 1041, 0L, tOOLINFO);
                OS.SendMessage(l2, 1052, 0L, 0L);
                OS.KillTimer(l2, 100L);
            }
            return;
        }
        if (this.item != null && OS.SHELL32_MAJOR >= 5 && bl) {
            Object object;
            NOTIFYICONDATA nOTIFYICONDATA = OS.IsUnicode ? new NOTIFYICONDATAW() : new NOTIFYICONDATAA();
            TCHAR tCHAR = new TCHAR(0, this.text, true);
            TCHAR tCHAR2 = new TCHAR(0, this.message, true);
            if (OS.IsUnicode) {
                object = nOTIFYICONDATA.szInfoTitle;
                int n = Math.min(((char[])object).length - 1, tCHAR.length());
                System.arraycopy(tCHAR.chars, 0, object, 0, n);
                char[] cArray = nOTIFYICONDATA.szInfo;
                int n5 = Math.min(cArray.length - 1, tCHAR2.length());
                System.arraycopy(tCHAR2.chars, 0, cArray, 0, n5);
            } else {
                object = ((NOTIFYICONDATAA)nOTIFYICONDATA).szInfoTitle;
                int n = Math.min(((char[])object).length - 1, tCHAR.length());
                System.arraycopy(tCHAR.bytes, 0, object, 0, n);
                byte[] byArray = ((NOTIFYICONDATAA)nOTIFYICONDATA).szInfo;
                int n6 = Math.min(byArray.length - 1, tCHAR2.length());
                System.arraycopy(tCHAR2.bytes, 0, byArray, 0, n6);
            }
            object = this.item.getDisplay();
            nOTIFYICONDATA.cbSize = NOTIFYICONDATA.sizeof;
            nOTIFYICONDATA.uID = this.item.id;
            nOTIFYICONDATA.hWnd = object.hwndMessage;
            nOTIFYICONDATA.uFlags = 16;
            if ((this.style & 2) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 1;
            }
            if ((this.style & 8) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 2;
            }
            if ((this.style & 1) != 0) {
                nOTIFYICONDATA.dwInfoFlags = 3;
            }
            this.sendEvent(22);
            this.visible = OS.Shell_NotifyIcon(1, nOTIFYICONDATA);
        }
    }
}

