/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBundle;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.NSColorSpace;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSLocale;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNotificationCenter;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSRunLoop;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSTimer;
import org.eclipse.swt.internal.cocoa.NSTouch;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTApplicationDelegate;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    static byte[] types;
    static int size;
    static int align;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    boolean disposing;
    int sendEventCount;
    double rotation;
    double magnification;
    boolean gestureActive;
    int touchCounter;
    long primaryIdentifier;
    NSMutableArray currentTouches;
    TouchSource[] touchSources;
    Synchronizer synchronizer;
    Thread thread;
    boolean allowTimers = true;
    boolean runAsyncMessages = true;
    GCData[] contexts;
    Caret currentCaret;
    boolean ignoreFocus;
    boolean sendEvent;
    int clickCountButton;
    int clickCount;
    Control currentControl;
    Control trackingControl;
    Control tooltipControl;
    Widget tooltipTarget;
    NSMutableArray isPainting;
    NSMutableArray needsDisplay;
    NSMutableArray needsDisplayInRect;
    NSMutableArray runLoopModes;
    NSDictionary markedAttributes;
    boolean smallFonts;
    NSFont buttonFont;
    NSFont popUpButtonFont;
    NSFont textFieldFont;
    NSFont secureTextFieldFont;
    NSFont searchFieldFont;
    NSFont comboBoxFont;
    NSFont sliderFont;
    NSFont scrollerFont;
    NSFont textViewFont;
    NSFont tableViewFont;
    NSFont outlineViewFont;
    NSFont datePickerFont;
    NSFont boxFont;
    NSFont tabViewFont;
    NSFont progressIndicatorFont;
    Shell[] modalShells;
    Dialog modalDialog;
    Menu menuBar;
    Menu[] menus;
    Menu[] popups;
    NSApplication application;
    int applicationClass;
    NSImage dockImage;
    boolean isEmbedded;
    static boolean launched;
    int systemUIMode;
    int systemUIOptions;
    Control focusControl;
    Control currentFocusControl;
    int focusEvent;
    NSWindow screenWindow;
    NSWindow keyWindow;
    NSAutoreleasePool[] pools;
    int poolCount;
    int loopCount;
    int[] screenID = new int[32];
    NSPoint[] screenCascade = new NSPoint[32];
    int runLoopObserver;
    Callback observerCallback;
    boolean lockCursor = true;
    int oldCursorSetProc;
    Callback cursorSetCallback;
    boolean comboPoppedUp = false;
    boolean mozillaRunning;
    static final String MOZILLA_RUNNING = "org.eclipse.swt.internal.mozillaRunning";
    static Callback windowCallback2;
    static Callback windowCallback3;
    static Callback windowCallback4;
    static Callback windowCallback5;
    static Callback windowCallback6;
    static Callback dialogCallback3;
    static Callback dialogCallback4;
    static Callback dialogCallback5;
    static Callback applicationCallback2;
    static Callback applicationCallback3;
    static Callback applicationCallback4;
    static Callback applicationCallback6;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    Menu trayItemMenu;
    Menu appMenuBar;
    Menu appMenu;
    TaskBar taskBar;
    Image errorImage;
    Image infoImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    float[][] colors;
    float[] alternateSelectedControlTextColor;
    float[] selectedControlTextColor;
    float[] alternateSelectedControlColor;
    float[] secondarySelectedControlColor;
    static int[][] KeyTable;
    static String APP_NAME;
    static String APP_VERSION;
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final byte[] SWT_OBJECT;
    static final byte[] SWT_EMBED_FRAMES;
    static final byte[] SWT_IMAGE;
    static final byte[] SWT_ROW;
    static final byte[] SWT_COLUMN;
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.modalDialog";
    static Display Default;
    static Display[] Displays;
    static final int GROW_SIZE = 1024;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Runnable[] timerList;
    NSTimer[] nsTimers;
    SWTWindowDelegate timerDelegate;
    static SWTApplicationDelegate applicationDelegate;
    static NSObject currAppDelegate;
    boolean runSettings;
    SWTWindowDelegate settingsDelegate;
    static final int DEFAULT_BUTTON_INTERVAL = 30;
    Object data;
    String[] keys;
    Object[] values;
    static Map dynamicObjectMap;
    Runnable hoverTimer = new Runnable(){

        public void run() {
            if (Display.this.currentControl != null && !Display.this.currentControl.isDisposed()) {
                Display.this.currentControl.sendMouseEvent(null, 32, Display.this.trackingControl != null && !Display.this.trackingControl.isDisposed());
            }
        }
    };
    Runnable caretTimer = new Runnable(){

        public void run() {
            if (Display.this.currentCaret != null) {
                if (Display.this.currentCaret == null || Display.this.currentCaret.isDisposed()) {
                    return;
                }
                if (Display.this.currentCaret.blinkCaret()) {
                    int n = Display.this.currentCaret.blinkRate;
                    if (n != 0) {
                        Display.this.timerExec(n, this);
                    }
                } else {
                    Display.this.currentCaret = null;
                }
            }
        }
    };
    Runnable defaultButtonTimer = new Runnable(){

        public void run() {
            Button button;
            if (Display.this.isDisposed()) {
                return;
            }
            Shell shell = Display.this.getActiveShell();
            if (shell != null && !shell.isDisposed() && (button = shell.defaultButton) != null && !button.isDisposed()) {
                NSView nSView = button.view;
                nSView.display();
            }
            if (Display.this.isDisposed()) {
                return;
            }
            if (Display.this.hasDefaultButton()) {
                Display.this.timerExec(30, this);
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        types = byArray;
        size = C.PTR_SIZEOF;
        align = C.PTR_SIZEOF == 4 ? 2 : 3;
        launched = false;
        KeyTable = new int[][]{{58, 65536}, {56, 131072}, {59, 262144}, {55, 0x400000}, {61, 65536}, {62, 262144}, {60, 131072}, {54, 0x400000}, {126, 0x1000001}, {125, 0x1000002}, {123, 0x1000003}, {124, 0x1000004}, {116, 0x1000005}, {121, 0x1000006}, {115, 0x1000007}, {119, 0x1000008}, {51, 8}, {36, 13}, {117, 127}, {53, 27}, {76, 10}, {48, 9}, {122, 0x100000A}, {120, 0x100000B}, {99, 0x100000C}, {118, 0x100000D}, {96, 0x100000E}, {97, 0x100000F}, {98, 0x1000010}, {100, 0x1000011}, {101, 0x1000012}, {109, 0x1000013}, {103, 0x1000014}, {111, 0x1000015}, {105, 0x1000016}, {107, 0x1000017}, {113, 0x1000018}, {106, 0x1000019}, {64, 0x100001A}, {79, 0x100001B}, {80, 0x100001C}, {67, 16777258}, {69, 16777259}, {76, 0x1000050}, {78, 16777261}, {65, 16777262}, {75, 16777263}, {82, 0x1000030}, {83, 0x1000031}, {84, 16777266}, {85, 0x1000033}, {86, 16777268}, {87, 16777269}, {88, 16777270}, {89, 16777271}, {91, 16777272}, {92, 16777273}, {81, 16777277}, {57, 16777298}, {71, 16777299}, {114, 0x1000051}};
        APP_VERSION = "";
        byte[] byArray2 = new byte[11];
        byArray2[0] = 83;
        byArray2[1] = 87;
        byArray2[2] = 84;
        byArray2[3] = 95;
        byArray2[4] = 79;
        byArray2[5] = 66;
        byArray2[6] = 74;
        byArray2[7] = 69;
        byArray2[8] = 67;
        byArray2[9] = 84;
        SWT_OBJECT = byArray2;
        byte[] byArray3 = new byte[17];
        byArray3[0] = 83;
        byArray3[1] = 87;
        byArray3[2] = 84;
        byArray3[3] = 95;
        byArray3[4] = 69;
        byArray3[5] = 77;
        byArray3[6] = 66;
        byArray3[7] = 69;
        byArray3[8] = 68;
        byArray3[9] = 95;
        byArray3[10] = 70;
        byArray3[11] = 82;
        byArray3[12] = 65;
        byArray3[13] = 77;
        byArray3[14] = 69;
        byArray3[15] = 83;
        SWT_EMBED_FRAMES = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = 83;
        byArray4[1] = 87;
        byArray4[2] = 84;
        byArray4[3] = 95;
        byArray4[4] = 73;
        byArray4[5] = 77;
        byArray4[6] = 65;
        byArray4[7] = 71;
        byArray4[8] = 69;
        SWT_IMAGE = byArray4;
        byte[] byArray5 = new byte[8];
        byArray5[0] = 83;
        byArray5[1] = 87;
        byArray5[2] = 84;
        byArray5[3] = 95;
        byArray5[4] = 82;
        byArray5[5] = 79;
        byArray5[6] = 87;
        SWT_ROW = byArray5;
        byte[] byArray6 = new byte[11];
        byArray6[0] = 83;
        byArray6[1] = 87;
        byArray6[2] = 84;
        byArray6[3] = 95;
        byArray6[4] = 67;
        byArray6[5] = 79;
        byArray6[6] = 76;
        byArray6[7] = 85;
        byArray6[8] = 77;
        byArray6[9] = 78;
        SWT_COLUMN = byArray6;
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    static byte[] ascii(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return byArray;
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    void addContext(GCData gCData) {
        if (this.contexts == null) {
            this.contexts = new GCData[12];
        }
        int n = 0;
        while (n < this.contexts.length) {
            if (this.contexts[n] == null || this.contexts[n] == gCData) {
                this.contexts[n] = gCData;
                return;
            }
            ++n;
        }
        GCData[] gCDataArray = new GCData[this.contexts.length + 12];
        gCDataArray[this.contexts.length] = gCData;
        System.arraycopy(this.contexts, 0, gCDataArray, 0, this.contexts.length);
        this.contexts = gCDataArray;
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[12];
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == null) {
                this.menus[n] = menu;
                return;
            }
            ++n;
        }
        Menu[] menuArray = new Menu[this.menus.length + 12];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void addPool() {
        this.addPool((NSAutoreleasePool)new NSAutoreleasePool().alloc().init());
    }

    void addPool(NSAutoreleasePool nSAutoreleasePool) {
        Object object;
        if (this.pools == null) {
            this.pools = new NSAutoreleasePool[4];
        }
        if (this.poolCount == this.pools.length) {
            object = new NSAutoreleasePool[this.poolCount + 4];
            System.arraycopy(this.pools, 0, object, 0, this.poolCount);
            this.pools = object;
        }
        if (this.poolCount == 0) {
            object = NSThread.currentThread().threadDictionary();
            ((NSMutableDictionary)object).setObject(NSNumber.numberWithInteger(nSAutoreleasePool.id), NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        this.pools[this.poolCount++] = nSAutoreleasePool;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(NSObject nSObject, Widget widget) {
        if (nSObject == null) {
            return;
        }
        int n = OS.object_setInstanceVariable(nSObject.id, SWT_OBJECT, widget.jniRef);
        if (n == 0) {
            if (dynamicObjectMap == null) {
                dynamicObjectMap = new HashMap();
            }
            LONG lONG = new LONG(widget.jniRef);
            dynamicObjectMap.put(nSObject, lONG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.NSBeep();
    }

    void cascadeWindow(NSWindow nSWindow, NSScreen nSScreen) {
        NSDictionary nSDictionary = nSScreen.deviceDescription();
        int n = new NSNumber(nSDictionary.objectForKey((id)NSString.stringWith((String)"NSScreenNumber")).id).intValue();
        int n2 = 0;
        while (this.screenID[n2] != 0 && this.screenID[n2] != n) {
            ++n2;
        }
        this.screenID[n2] = n;
        NSPoint nSPoint = this.screenCascade[n2];
        if (nSPoint == null) {
            NSRect nSRect = nSScreen.frame();
            nSPoint = new NSPoint();
            nSPoint.x = nSRect.x;
            nSPoint.y = nSRect.y + nSRect.height;
        }
        this.screenCascade[n2] = nSWindow.cascadeTopLeftFromPoint(nSPoint);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void checkEnterExit(Control control, NSEvent nSEvent, boolean bl) {
        if (control != this.currentControl) {
            if (this.currentControl != null && !this.currentControl.isDisposed()) {
                this.currentControl.sendMouseEvent(nSEvent, 7, bl);
            }
            if (control != null && control.isDisposed()) {
                control = null;
            }
            this.currentControl = control;
            if (control != null) {
                control.sendMouseEvent(nSEvent, 6, bl);
            }
            this.setCursor(control);
        }
        this.timerExec(control != null && !control.isDisposed() ? this.getToolTipTime() : -1, this.hoverTimer);
    }

    void checkFocus() {
        if (this.ignoreFocus) {
            return;
        }
        Control control = this.currentFocusControl;
        Control control2 = this.getFocusControl();
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.sendFocusEvent(16);
            }
            this.currentFocusControl = control2;
            if (control2 != null && !control2.isDisposed()) {
                control2.sendFocusEvent(15);
            }
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] != null) {
                    if (!bl) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[n].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static NSRect convertRect(NSScreen nSScreen, NSRect nSRect) {
        float f = nSScreen.userSpaceScaleFactor();
        nSRect.x /= f;
        nSRect.y /= f;
        nSRect.width /= f;
        nSRect.height /= f;
        return nSRect;
    }

    static String convertToLf(String string) {
        char c = '\r';
        char c2 = '\n';
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(c2, 0);
        if (n2 == -1 || n2 == 0) {
            return string;
        }
        if (string.charAt(n2 - 1) != c) {
            return string;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            int n3 = string.indexOf(c, n2);
            if (n3 == -1) {
                n3 = n;
            }
            String string2 = string.substring(n2, n3);
            stringBuffer.append(string2);
            n2 = n3 + 2;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) break;
            if (this.modalShells[n] == null) {
                return;
            }
            ++n;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    void clearPool() {
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
            this.addPool();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        this.synchronizer = new Synchronizer(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        String string;
        Class<?> clazz;
        int n;
        if (OS.VERSION < 4176) {
            System.out.println("***WARNING: SWT requires MacOS X version 10.5 or greater");
            System.out.println("***WARNING: Detected: " + Integer.toHexString((OS.VERSION & 0xFF00) >> 8) + "." + Integer.toHexString((OS.VERSION & 0xF0) >> 4) + "." + Integer.toHexString(OS.VERSION & 0xF));
            this.error(20);
        }
        NSThread nSThread = NSThread.currentThread();
        if (!NSThread.isMainThread()) {
            System.out.println("***WARNING: Display must be created on main thread due to Cocoa restrictions.");
            this.error(22);
        }
        NSMutableDictionary nSMutableDictionary = nSThread.threadDictionary();
        NSString nSString = NSString.stringWith("SWT_NSAutoreleasePool");
        NSNumber nSNumber = new NSNumber(nSMutableDictionary.objectForKey(nSString));
        this.addPool(new NSAutoreleasePool(nSNumber.integerValue()));
        this.application = NSApplication.sharedApplication();
        this.isEmbedded = this.application.isRunning();
        int[] nArray = new int[2];
        if (OS.GetCurrentProcess(nArray) == 0) {
            int n2 = OS.getpid();
            n = Display.getApplicationName().UTF8String();
            if (n != 0) {
                OS.CPSSetProcessName(nArray, n);
            }
            if (!this.isBundled()) {
                OS.TransformProcessType(nArray, 1);
                OS.SetFrontProcess(nArray);
            }
            if ((n = OS.getenv(Display.ascii("APP_ICON_" + n2))) != 0) {
                clazz = NSString.stringWithUTF8String(n);
                NSImage nSImage = (NSImage)new NSImage().alloc();
                this.dockImage = nSImage = nSImage.initByReferencingFile((NSString)((Object)clazz));
                this.application.setApplicationIconImage(nSImage);
            }
        }
        if ((n = OS.objc_lookUpClass(string = "SWTApplication")) == 0) {
            int n3;
            int n4;
            int n5;
            clazz = this.getClass();
            applicationCallback2 = new Callback(clazz, "applicationProc", 2);
            int n6 = applicationCallback2.getAddress();
            if (n6 == 0) {
                this.error(3);
            }
            if ((n5 = (applicationCallback3 = new Callback(clazz, "applicationProc", 3)).getAddress()) == 0) {
                this.error(3);
            }
            if ((n4 = (applicationCallback4 = new Callback(clazz, "applicationProc", 4)).getAddress()) == 0) {
                this.error(3);
            }
            if ((n3 = (applicationCallback6 = new Callback(clazz, "applicationProc", 6)).getAddress()) == 0) {
                this.error(3);
            }
            n = OS.objc_allocateClassPair(OS.object_getClass(this.application.id), string, 0);
            OS.class_addMethod(n, OS.sel_sendEvent_, n5, "@:@");
            OS.class_addMethod(n, OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_, n3, "@:i@@B");
            OS.class_addMethod(n, OS.sel_isRunning, n6, "@:");
            OS.class_addMethod(n, OS.sel_finishLaunching, n6, "@:");
            OS.objc_registerClassPair(n);
        }
        this.applicationClass = OS.object_setClass(this.application.id, n);
        string = "SWTApplicationDelegate";
        if (OS.objc_lookUpClass(string) == 0) {
            int n7 = applicationCallback3.getAddress();
            if (n7 == 0) {
                this.error(3);
            }
            n = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
            int n8 = applicationCallback4.getAddress();
            if (n8 == 0) {
                this.error(3);
            }
            n = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
            OS.class_addMethod(n, OS.sel_applicationWillFinishLaunching_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_terminate_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_orderFrontStandardAboutPanel_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_hideOtherApplications_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_hide_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_unhideAllApplications_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_applicationDidBecomeActive_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_applicationDidResignActive_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_applicationDockMenu_, n7, "@:@");
            OS.class_addMethod(n, OS.sel_application_openFile_, n8, "@:@@");
            OS.class_addMethod(n, OS.sel_application_openFiles_, n8, "@:@@");
            OS.class_addMethod(n, OS.sel_applicationShouldHandleReopen_hasVisibleWindows_, n8, "@:@B");
            OS.class_addMethod(n, OS.sel_applicationShouldTerminate_, n7, "@:@");
            OS.objc_registerClassPair(n);
        }
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.GetSystemUIMode(nArray2, nArray3);
        this.systemUIMode = nArray2[0];
        this.systemUIOptions = nArray3[0];
    }

    void createMainMenu() {
        NSMenuItem nSMenuItem;
        NSString nSString = Display.getApplicationName();
        NSString nSString2 = NSString.string();
        NSMenu nSMenu = (NSMenu)new NSMenu().alloc();
        nSMenu.initWithTitle(nSString2);
        NSString nSString3 = NSString.stringWith("%@ %@");
        NSMenuItem nSMenuItem2 = nSMenuItem = nSMenu.addItemWithTitle(nSString2, 0, nSString2);
        NSMenu nSMenu2 = (NSMenu)new NSMenu().alloc();
        nSMenu2.initWithTitle(nSString2);
        OS.objc_msgSend(this.application.id, OS.sel_registerName("setAppleMenu:"), nSMenu2.id);
        NSString nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"About")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_orderFrontStandardAboutPanel_, nSString2);
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = NSString.stringWith(SWT.getMessage("Preferences..."));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, 0, NSString.stringWith(","));
        nSMenuItem.setTag(42);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = NSString.stringWith(SWT.getMessage("Services"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, 0, nSString2);
        NSMenu nSMenu3 = (NSMenu)new NSMenu().alloc();
        nSMenu3.initWithTitle(nSString2);
        nSMenu2.setSubmenu(nSMenu3, nSMenuItem);
        nSMenu3.release();
        this.application.setServicesMenu(nSMenu3);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"Hide")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_hide_, NSString.stringWith("h"));
        nSMenuItem.setTarget(applicationDelegate);
        nSString4 = NSString.stringWith(SWT.getMessage("Hide Others"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_hideOtherApplications_, NSString.stringWith("h"));
        nSMenuItem.setKeyEquivalentModifierMask(0x180000);
        nSMenuItem.setTarget(applicationDelegate);
        nSString4 = NSString.stringWith(SWT.getMessage("Show All"));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_unhideAllApplications_, nSString2);
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu2.addItem(NSMenuItem.separatorItem());
        nSString4 = new NSString(OS.objc_msgSend(OS.class_NSString, OS.sel_stringWithFormat_, nSString3.id, NSString.stringWith((String)SWT.getMessage((String)"Quit")).id, nSString.id));
        nSMenuItem = nSMenu2.addItemWithTitle(nSString4, OS.sel_applicationShouldTerminate_, NSString.stringWith("q"));
        nSMenuItem.setTarget(applicationDelegate);
        nSMenu.setSubmenu(nSMenu2, nSMenuItem2);
        nSMenu2.release();
        this.application.setMainMenu(nSMenu);
        nSMenu.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NSMutableArray currentTouches() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.currentTouches == null) {
                this.currentTouches = (NSMutableArray)new NSMutableArray().alloc();
                this.currentTouches = this.currentTouches.initWithCapacity(5);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentTouches;
        }
    }

    int cursorSetProc(int n, int n2) {
        Cursor cursor;
        if (this.lockCursor && this.currentControl != null && (cursor = this.currentControl.findCursor()) != null && cursor.handle.id != n) {
            return 0;
        }
        OS.call(this.oldCursorSetProc, n, n2);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (display == Displays[n]) {
                    Display.Displays[n] = null;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        this.application = null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(int n, int n2) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(Widget widget, int n) {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                Display display = Displays[n];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    TouchSource findTouchSource(NSTouch nSTouch) {
        Object object;
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int n = 0;
        int n2 = this.touchSources.length;
        id id2 = nSTouch.device();
        TouchSource touchSource = null;
        while (n < n2 && this.touchSources[n] != null) {
            if (this.touchSources[n].handle == id2.id) {
                touchSource = this.touchSources[n];
                break;
            }
            ++n;
        }
        if (touchSource != null) {
            return touchSource;
        }
        if (n == n2) {
            object = new TouchSource[n2 + 4];
            System.arraycopy(this.touchSources, 0, object, 0, n2);
            this.touchSources = object;
        }
        object = new Rectangle(0, 0, (int)Math.ceil(nSTouch.deviceSize().width), (int)Math.ceil(nSTouch.deviceSize().height));
        this.touchSources[n] = touchSource = new TouchSource(id2.id, false, (Rectangle)object);
        return touchSource;
    }

    public Shell getActiveShell() {
        NSWindow nSWindow;
        this.checkDevice();
        NSWindow nSWindow2 = nSWindow = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        if (nSWindow != null) {
            Widget widget = this.getWidget(nSWindow.contentView());
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            NSPoint nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
            NSView nSView = nSWindow.contentView().hitTest(nSPoint);
            while (nSView != null) {
                widget = this.getWidget(nSView.id);
                if (widget instanceof Shell) break;
                nSView = nSView.superview();
            }
            return (Shell)widget;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        return this.getBounds(nSArray);
    }

    Rectangle getBounds(NSArray nSArray) {
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        int n = nSArray.count();
        int n2 = 0;
        while (n2 < n) {
            nSScreen = new NSScreen(nSArray.objectAtIndex(n2));
            NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.frame());
            float f5 = nSRect2.x;
            float f6 = nSRect2.x + nSRect2.width;
            float f7 = nSRect.height - nSRect2.y;
            float f8 = nSRect.height - (nSRect2.y + nSRect2.height);
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f) {
                f = f6;
            }
            if (f5 > f2) {
                f2 = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 < f3) {
                f3 = f7;
            }
            if (f8 < f3) {
                f3 = f8;
            }
            if (f7 > f4) {
                f4 = f7;
            }
            if (f8 > f4) {
                f4 = f8;
            }
            ++n2;
        }
        return new Rectangle((int)f, (int)f3, (int)(f2 - f), (int)(f4 - f3));
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        return 560;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        if (nSArray.count() != 1) {
            return this.getBounds(nSArray);
        }
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
        float f = nSRect.height - (nSRect2.y + nSRect2.height);
        return new Rectangle((int)nSRect2.x, (int)f, (int)nSRect2.width, (int)nSRect2.height);
    }

    public Control getCursorControl() {
        this.checkDevice();
        return this.findControl(false);
    }

    public Point getCursorLocation() {
        this.checkDevice();
        NSPoint nSPoint = NSEvent.mouseLocation();
        NSRect nSRect = this.getPrimaryFrame();
        return new Point((int)nSPoint.x, (int)(nSRect.height - nSPoint.y));
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDblTime() * 1000 / 60;
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        NSWindow nSWindow = this.keyWindow != null ? this.keyWindow : this.application.keyWindow();
        return this._getFocusControl(nSWindow);
    }

    Control _getFocusControl(NSWindow nSWindow) {
        if (nSWindow != null) {
            NSResponder nSResponder = nSWindow.firstResponder();
            if (nSResponder != null && !nSResponder.respondsToSelector(OS.sel_superview)) {
                return null;
            }
            NSView nSView = new NSView(nSResponder.id);
            if (nSView != null) {
                do {
                    Widget widget;
                    if (!((widget = Display.GetWidget(nSView.id)) instanceof Control)) continue;
                    return (Control)widget;
                } while ((nSView = nSView.superview()) != null);
            }
        }
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32), new Point(64, 64), new Point(128, 128)};
    }

    int getLastEventTime() {
        NSEvent nSEvent = this.application.currentEvent();
        if (nSEvent == null) {
            return 0;
        }
        double d = nSEvent.timestamp() * 1000.0;
        while (d > 2.147483647E9) {
            d -= 2.147483647E9;
        }
        return (int)d;
    }

    Menu[] getMenus(Decorations decorations) {
        Object object;
        if (this.menus == null) {
            return new Menu[0];
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.menus.length) {
            object = this.menus[n2];
            if (object != null && object.parent == decorations) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        object = new Menu[n];
        int n3 = 0;
        while (n3 < this.menus.length) {
            Menu menu = this.menus[n3];
            if (menu != null && menu.parent == decorations) {
                object[n2++] = menu;
            }
            ++n3;
        }
        return object;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        NSArray nSArray = NSScreen.screens();
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        int n = nSArray.count();
        Monitor[] monitorArray = new Monitor[n];
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = new Monitor();
            nSScreen = new NSScreen(nSArray.objectAtIndex(n2));
            NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.frame());
            monitor.handle = nSScreen.id;
            monitor.x = (int)nSRect2.x;
            monitor.y = (int)(nSRect.height - (nSRect2.y + nSRect2.height));
            monitor.width = (int)nSRect2.width;
            monitor.height = (int)nSRect2.height;
            NSRect nSRect3 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
            monitor.clientX = (int)nSRect3.x;
            monitor.clientY = (int)(nSRect.height - (nSRect3.y + nSRect3.height));
            monitor.clientWidth = (int)nSRect3.width;
            monitor.clientHeight = (int)nSRect3.height;
            monitorArray[n2] = monitor;
            ++n2;
        }
        return monitorArray;
    }

    NSRect getPrimaryFrame() {
        NSArray nSArray = NSScreen.screens();
        return new NSScreen(nSArray.objectAtIndex(0)).frame();
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor monitor = new Monitor();
        NSArray nSArray = NSScreen.screens();
        NSScreen nSScreen = new NSScreen(nSArray.objectAtIndex(0));
        NSRect nSRect = Display.convertRect(nSScreen, nSScreen.frame());
        monitor.handle = nSScreen.id;
        monitor.x = (int)nSRect.x;
        monitor.y = (int)(nSRect.height - (nSRect.y + nSRect.height));
        monitor.width = (int)nSRect.width;
        monitor.height = (int)nSRect.height;
        NSRect nSRect2 = Display.convertRect(nSScreen, nSScreen.visibleFrame());
        monitor.clientX = (int)nSRect2.x;
        monitor.clientY = (int)(nSRect.height - (nSRect2.y + nSRect2.height));
        monitor.clientWidth = (int)nSRect2.width;
        monitor.clientHeight = (int)nSRect2.height;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        NSArray nSArray = this.application.windows();
        int n = 0;
        Shell[] shellArray = new Shell[nSArray.count()];
        int n2 = 0;
        while (n2 < shellArray.length) {
            NSWindow nSWindow = new NSWindow(nSArray.objectAtIndex(n2));
            Widget widget = this.getWidget(nSWindow.contentView());
            if (widget instanceof Shell) {
                shellArray[n++] = (Shell)widget;
            }
            ++n2;
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray2 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray2, 0, n);
        return shellArray2;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        Color color = this.getWidgetColor(n);
        if (color != null) {
            return color;
        }
        return super.getSystemColor(n);
    }

    Color getWidgetColor(int n) {
        if (n >= 0 && n < this.colors.length && this.colors[n] != null) {
            return Color.cocoa_new(this, this.colors[n]);
        }
        return null;
    }

    float[] getWidgetColorRGB(int n) {
        NSColor nSColor = null;
        switch (n) {
            case 28: {
                nSColor = NSColor.blackColor();
                break;
            }
            case 29: {
                return new float[]{0.984f, 0.988f, 0.773f, 1.0f};
            }
            case 30: {
                nSColor = NSColor.windowFrameTextColor();
                break;
            }
            case 31: {
                nSColor = NSColor.alternateSelectedControlColor();
                break;
            }
            case 32: {
                nSColor = NSColor.selectedControlColor();
                break;
            }
            case 33: {
                nSColor = NSColor.disabledControlTextColor();
                break;
            }
            case 34: {
                nSColor = NSColor.secondarySelectedControlColor();
                break;
            }
            case 35: {
                nSColor = NSColor.secondarySelectedControlColor();
                break;
            }
            case 17: {
                nSColor = NSColor.controlDarkShadowColor();
                break;
            }
            case 18: {
                nSColor = NSColor.controlShadowColor();
                break;
            }
            case 19: {
                nSColor = NSColor.controlHighlightColor();
                break;
            }
            case 20: {
                nSColor = NSColor.controlLightHighlightColor();
                break;
            }
            case 22: {
                nSColor = NSColor.controlHighlightColor();
                break;
            }
            case 21: {
                nSColor = NSColor.controlTextColor();
                break;
            }
            case 23: {
                nSColor = NSColor.blackColor();
                break;
            }
            case 24: {
                nSColor = NSColor.textColor();
                break;
            }
            case 25: {
                nSColor = NSColor.textBackgroundColor();
                break;
            }
            case 27: {
                nSColor = NSColor.selectedTextColor();
                break;
            }
            case 26: {
                nSColor = NSColor.selectedTextBackgroundColor();
            }
        }
        return this.getNSColorRGB(nSColor);
    }

    float[] getNSColorRGB(NSColor nSColor) {
        if (nSColor == null) {
            return null;
        }
        NSColorSpace nSColorSpace = nSColor.colorSpace();
        if (nSColorSpace == null || nSColorSpace.colorSpaceModel() != 1) {
            nSColor = nSColor.colorUsingColorSpaceName(OS.NSDeviceRGBColorSpace);
        }
        if (nSColor == null) {
            return null;
        }
        float[] fArray = new float[nSColor.numberOfComponents()];
        nSColor.getComponents(fArray);
        return new float[]{fArray[0], fArray[1], fArray[2], fArray[3]};
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    NSImage getSystemImageForID(int n) {
        int[] nArray = new int[1];
        OS.GetIconRefFromTypeInfo(1835098995, n, 0, 0, 0, nArray);
        NSImage nSImage = (NSImage)new NSImage().alloc();
        nSImage = nSImage.initWithIconRef(nArray[0]);
        NSSize nSSize = new NSSize();
        nSSize.height = 32.0f;
        nSSize.width = 32.0f;
        nSImage.setSize(nSSize);
        nSImage.setScalesWhenResized(true);
        return nSImage;
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                NSImage nSImage = this.getSystemImageForID(1937010544);
                this.errorImage = Image.cocoa_new(this, 1, nSImage);
                return this.errorImage;
            }
            case 2: 
            case 4: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                NSImage nSImage = this.getSystemImageForID(1852798053);
                this.infoImage = Image.cocoa_new(this, 1, nSImage);
                return this.infoImage;
            }
            case 8: {
                if (this.warningImage != null) {
                    return this.warningImage;
                }
                NSImage nSImage = this.getSystemImageForID(1667331444);
                this.warningImage = Image.cocoa_new(this, 1, nSImage);
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        if (this.appMenuBar != null) {
            return this.appMenuBar;
        }
        this.appMenuBar = new Menu(this);
        return this.appMenuBar;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        if (this.appMenu == null) {
            NSMenu nSMenu = NSApplication.sharedApplication().mainMenu();
            NSMenu nSMenu2 = nSMenu.itemAtIndex(0).submenu();
            this.appMenu = new Menu(this, nSMenu2);
            int n = nSMenu2.numberOfItems();
            int n2 = 0;
            while (n2 < n) {
                NSMenuItem nSMenuItem = nSMenu2.itemAtIndex(n2);
                new MenuItem(this.appMenu, nSMenuItem);
                ++n2;
            }
        }
        return this.appMenu;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        this.taskBar = new TaskBar(this, 0);
        return this.taskBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return OS.VERSION > 4179;
    }

    int getToolTipTime() {
        this.checkDevice();
        return 560;
    }

    Widget getWidget(int n) {
        return Display.GetWidget(n);
    }

    static Widget GetWidget(int n) {
        NSObject nSObject;
        LONG lONG;
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[1];
        int n2 = OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (n2 == 0 && dynamicObjectMap != null && (lONG = (LONG)dynamicObjectMap.get(nSObject = new NSObject(n))) != null) {
            nArray[0] = lONG.value;
        }
        if (nArray[0] == 0) {
            return null;
        }
        return (Widget)OS.JNIGetObject(nArray[0]);
    }

    Widget getWidget(NSView nSView) {
        if (nSView == null) {
            return null;
        }
        return this.getWidget(nSView.id);
    }

    boolean hasDefaultButton() {
        NSArray nSArray = this.application.windows();
        int n = nSArray.count();
        int n2 = 0;
        while (n2 < n) {
            NSWindow nSWindow = new NSWindow(nSArray.objectAtIndex(n2));
            if (nSWindow.defaultButtonCell() != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void init() {
        int n;
        int n2;
        NSMenu nSMenu;
        NSMenuItem nSMenuItem;
        super.init();
        this.initClasses();
        this.initColors();
        this.initFonts();
        if (applicationDelegate == null) {
            applicationDelegate = (SWTApplicationDelegate)new SWTApplicationDelegate().alloc().init();
            if (currAppDelegate == null) {
                int n3;
                if (OS.class_JRSAppKitAWT != 0 && (n3 = OS.objc_msgSend(OS.class_JRSAppKitAWT, OS.sel_awtAppDelegate)) != 0) {
                    currAppDelegate = new NSObject(n3);
                    currAppDelegate.retain();
                }
                this.application.setDelegate(applicationDelegate);
            }
        }
        if (!launched) {
            this.application.finishLaunching();
            launched = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    NSApplication.sharedApplication().terminate(null);
                }
            });
        }
        if ((nSMenuItem = (nSMenu = this.application.mainMenu().itemAtIndex(0).submenu()).itemWithTag(-2)) != null) {
            nSMenuItem.setTag(42);
        }
        if (currAppDelegate != null) {
            currAppDelegate.init();
        }
        if (nSMenuItem != null) {
            nSMenuItem.setTag(-2);
        }
        this.observerCallback = new Callback(this, "observerProc", 3);
        int n4 = this.observerCallback.getAddress();
        if (n4 == 0) {
            this.error(3);
        }
        int n5 = 32;
        this.runLoopObserver = OS.CFRunLoopObserverCreate(0, n5, true, 0, n4, 0);
        if (this.runLoopObserver == 0) {
            this.error(2);
        }
        OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, OS.kCFRunLoopCommonModes());
        int n6 = OS.objc_lookUpClass("JNFRunLoop");
        if (n6 != 0 && (n2 = OS.objc_msgSend(n6, OS.sel_javaRunLoopMode)) != 0) {
            OS.CFRunLoopAddObserver(OS.CFRunLoopGetCurrent(), this.runLoopObserver, n2);
        }
        this.cursorSetCallback = new Callback(this, "cursorSetProc", 2);
        n2 = this.cursorSetCallback.getAddress();
        if (n2 == 0) {
            this.error(3);
        }
        if ((n = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set)) != 0) {
            this.oldCursorSetProc = OS.method_setImplementation(n, n2);
        }
        this.timerDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.settingsDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        NSNotificationCenter nSNotificationCenter = NSNotificationCenter.defaultCenter();
        nSNotificationCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSSystemColorsDidChangeNotification, null);
        nSNotificationCenter.addObserver(this.settingsDelegate, OS.sel_systemSettingsChanged_, OS.NSApplicationDidChangeScreenParametersNotification, null);
        NSTextView nSTextView = (NSTextView)new NSTextView().alloc();
        nSTextView.init();
        this.markedAttributes = nSTextView.markedTextAttributes();
        this.markedAttributes.retain();
        nSTextView.release();
        this.isPainting = (NSMutableArray)new NSMutableArray().alloc();
        this.isPainting = this.isPainting.initWithCapacity(12);
    }

    void addEventMethods(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 != 0) {
            OS.class_addMethod(n, OS.sel_mouseDown_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_mouseUp_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_scrollWheel_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_rightMouseDown_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_rightMouseUp_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_rightMouseDragged_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_otherMouseDown_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_otherMouseUp_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_otherMouseDragged_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_mouseDragged_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_mouseMoved_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_mouseEntered_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_mouseExited_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_menuForEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_keyDown_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_keyUp_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_flagsChanged_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_cursorUpdate_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_setNeedsDisplay_, n3, "@:B");
            OS.class_addMethod(n, OS.sel_shouldDelayWindowOrderingForEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_acceptsFirstMouse_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_changeColor_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_cancelOperation_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_touchesBeganWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_touchesMovedWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_touchesEndedWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_touchesCancelledWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_beginGestureWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_endGestureWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_swipeWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_rotateWithEvent_, n3, "@:@");
            OS.class_addMethod(n, OS.sel_magnifyWithEvent_, n3, "@:@");
        }
        if (n2 != 0) {
            OS.class_addMethod(n, OS.sel_resignFirstResponder, n2, "@:");
            OS.class_addMethod(n, OS.sel_becomeFirstResponder, n2, "@:");
            OS.class_addMethod(n, OS.sel_resetCursorRects, n2, "@:");
            OS.class_addMethod(n, OS.sel_updateTrackingAreas, n2, "@:");
            OS.class_addMethod(n, OS.sel_getImageView, n2, "@:");
            OS.class_addMethod(n, OS.sel_mouseDownCanMoveWindow, n2, "@:");
        }
        if (n6 != 0) {
            OS.class_addMethod(n, OS.sel_setNeedsDisplayInRect_, n6, "@:{NSRect}");
        }
        if (n4 != 0) {
            OS.class_addMethod(n, OS.sel_drawRect_, n4, "@:{NSRect}");
        }
        if (n5 != 0) {
            OS.class_addMethod(n, OS.sel_hitTest_, n5, "@:{NSPoint}");
        }
    }

    void addFrameMethods(int n, int n2, int n3) {
        OS.class_addMethod(n, OS.sel_setFrameOrigin_, n2, "@:{NSPoint}");
        OS.class_addMethod(n, OS.sel_setFrameSize_, n3, "@:{NSSize}");
    }

    void addAccessibilityMethods(int n, int n2, int n3, int n4, int n5) {
        OS.class_addMethod(n, OS.sel_accessibilityActionNames, n2, "@:");
        OS.class_addMethod(n, OS.sel_accessibilityAttributeNames, n2, "@:");
        OS.class_addMethod(n, OS.sel_accessibilityParameterizedAttributeNames, n2, "@:");
        OS.class_addMethod(n, OS.sel_accessibilityFocusedUIElement, n2, "@:");
        OS.class_addMethod(n, OS.sel_accessibilityIsIgnored, n2, "@:");
        OS.class_addMethod(n, OS.sel_accessibilityAttributeValue_, n3, "@:@");
        OS.class_addMethod(n, OS.sel_accessibilityHitTest_, n5, "@:{NSPoint}");
        OS.class_addMethod(n, OS.sel_accessibilityAttributeValue_forParameter_, n4, "@:@@");
        OS.class_addMethod(n, OS.sel_accessibilityPerformAction_, n3, "@:@");
        OS.class_addMethod(n, OS.sel_accessibilityActionDescription_, n3, "@:@");
        OS.class_addMethod(n, OS.sel_accessibilityIsAttributeSettable_, n3, "@:@");
        OS.class_addMethod(n, OS.sel_accessibilitySetValue_forAttribute_, n4, "@:@@");
        OS.class_addMethod(n, OS.sel_accessibleHandle, n2, "@:");
    }

    int registerCellSubclass(int n, int n2, int n3, byte[] byArray) {
        String string = OS.class_getName(n);
        int n4 = OS.objc_allocateClassPair(n, "SWTAccessible" + string, 0);
        OS.class_addIvar(n4, SWT_OBJECT, n2, (byte)n3, byArray);
        OS.objc_registerClassPair(n4);
        return n4;
    }

    int createWindowSubclass(int n, String string, boolean bl) {
        int n2 = OS.objc_lookUpClass(string);
        if (n2 != 0) {
            return n2;
        }
        n2 = OS.objc_allocateClassPair(n, string, 0);
        int n3 = windowCallback3.getAddress();
        int n4 = windowCallback2.getAddress();
        int n5 = windowCallback4.getAddress();
        int n6 = windowCallback6.getAddress();
        int n7 = OS.CALLBACK_view_stringForToolTip_point_userData_(n6);
        int n8 = OS.CALLBACK_accessibilityHitTest_(n3);
        if (!bl) {
            OS.class_addIvar(n2, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(n2, OS.sel_sendEvent_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_helpRequested_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_canBecomeKeyWindow, n4, "@:");
        OS.class_addMethod(n2, OS.sel_becomeKeyWindow, n4, "@:");
        OS.class_addMethod(n2, OS.sel_makeFirstResponder_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_noResponderFor_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_view_stringForToolTip_point_userData_, n7, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(n2, n4, n3, n5, n8);
        OS.objc_registerClassPair(n2);
        return n2;
    }

    int createMenuSubclass(int n, String string, boolean bl) {
        int n2 = OS.objc_lookUpClass(string);
        if (n2 != 0) {
            return n2;
        }
        n2 = OS.objc_allocateClassPair(n, string, 0);
        int n3 = windowCallback3.getAddress();
        int n4 = windowCallback4.getAddress();
        OS.class_addIvar(n2, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n2, OS.sel_menuWillOpen_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_menuDidClose_, n3, "@:@");
        OS.class_addMethod(n2, OS.sel_menu_willHighlightItem_, n4, "@:@@");
        OS.class_addMethod(n2, OS.sel_menuNeedsUpdate_, n3, "@:@");
        OS.objc_registerClassPair(n2);
        return n2;
    }

    int createMenuItemSubclass(int n, String string, boolean bl) {
        int n2 = OS.objc_lookUpClass(string);
        if (n2 != 0) {
            return n2;
        }
        n2 = OS.objc_allocateClassPair(n, string, 0);
        int n3 = windowCallback2.getAddress();
        if (!bl) {
            OS.class_addIvar(n2, SWT_OBJECT, size, (byte)align, types);
        }
        OS.class_addMethod(n2, OS.sel_sendSelection, n3, "@:");
        OS.objc_registerClassPair(n2);
        return n2;
    }

    void initClasses() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (OS.objc_lookUpClass("SWTView") != 0) {
            return;
        }
        Class<?> clazz = this.getClass();
        dialogCallback3 = new Callback(clazz, "dialogProc", 3);
        int n9 = dialogCallback3.getAddress();
        if (n9 == 0) {
            this.error(3);
        }
        if ((n8 = (dialogCallback4 = new Callback(clazz, "dialogProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n7 = (dialogCallback5 = new Callback(clazz, "dialogProc", 5)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n6 = (windowCallback3 = new Callback(clazz, "windowProc", 3)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n5 = (windowCallback2 = new Callback(clazz, "windowProc", 2)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n4 = (windowCallback4 = new Callback(clazz, "windowProc", 4)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n3 = (windowCallback5 = new Callback(clazz, "windowProc", 5)).getAddress()) == 0) {
            this.error(3);
        }
        if ((n2 = (windowCallback6 = new Callback(clazz, "windowProc", 6)).getAddress()) == 0) {
            this.error(3);
        }
        int n10 = OS.isFlipped_CALLBACK();
        int n11 = OS.CALLBACK_drawRect_(n6);
        int n12 = OS.CALLBACK_drawInteriorWithFrame_inView_(n4);
        int n13 = OS.CALLBACK_drawWithExpansionFrame_inView_(n4);
        int n14 = OS.CALLBACK_imageRectForBounds_(n6);
        int n15 = OS.CALLBACK_titleRectForBounds_(n6);
        int n16 = OS.CALLBACK_cellSizeForBounds_(n6);
        int n17 = OS.CALLBACK_hitTestForEvent_inRect_ofView_(n3);
        int n18 = OS.CALLBACK_cellSize(n5);
        int n19 = OS.CALLBACK_drawImage_withFrame_inView_(n3);
        int n20 = OS.CALLBACK_drawTitle_withFrame_inView_(n3);
        int n21 = OS.CALLBACK_setFrameOrigin_(n6);
        int n22 = OS.CALLBACK_setFrameSize_(n6);
        int n23 = OS.CALLBACK_hitTest_(n6);
        int n24 = OS.CALLBACK_markedRange(n5);
        int n25 = OS.CALLBACK_selectedRange(n5);
        int n26 = OS.CALLBACK_highlightSelectionInClipRect_(n6);
        int n27 = OS.CALLBACK_setMarkedText_selectedRange_(n4);
        int n28 = OS.CALLBACK_attributedSubstringFromRange_(n6);
        int n29 = OS.CALLBACK_characterIndexForPoint_(n6);
        int n30 = OS.CALLBACK_firstRectForCharacterRange_(n6);
        int n31 = OS.CALLBACK_textView_willChangeSelectionFromCharacterRange_toCharacterRange_(n3);
        int n32 = OS.CALLBACK_accessibilityHitTest_(n6);
        int n33 = OS.CALLBACK_shouldChangeTextInRange_replacementString_(n4);
        int n34 = OS.CALLBACK_view_stringForToolTip_point_userData_(n2);
        int n35 = OS.CALLBACK_canDragRowsWithIndexes_atPoint_(n4);
        int n36 = OS.CALLBACK_setNeedsDisplayInRect_(n6);
        int n37 = OS.CALLBACK_expansionFrameWithFrame_inView_(n4);
        int n38 = OS.CALLBACK_sizeOfLabel_(n6);
        int n39 = OS.CALLBACK_drawLabel_inRect_(n4);
        int n40 = OS.CALLBACK_drawViewBackgroundInRect_(n6);
        int n41 = OS.CALLBACK_drawBackgroundInClipRect_(n6);
        int n42 = OS.CALLBACK_scrollClipView_toPoint_(n4);
        int n43 = OS.CALLBACK_headerRectOfColumn_(n6);
        int n44 = OS.CALLBACK_columnAtPoint_(n6);
        String string = "SWTBox";
        int n45 = OS.objc_allocateClassPair(OS.class_NSBox, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTButton";
        n45 = OS.objc_allocateClassPair(OS.class_NSButton, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_validateMenuItem_, n6, "@:@");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_nextState, n5, "@:");
        string = "SWTButtonCell";
        n45 = OS.objc_allocateClassPair(OS.class_NSButtonCell, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_drawImage_withFrame_inView_, n19, "@:@{NSRect}@");
        OS.class_addMethod(n45, OS.sel_drawTitle_withFrame_inView_, n20, "@:@{NSRect}@");
        OS.class_addMethod(n45, OS.sel_drawInteriorWithFrame_inView_, n12, "@:{NSRect}@");
        OS.class_addMethod(n45, OS.sel_titleRectForBounds_, n15, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_cellSizeForBounds_, n16, "@:{NSRect}");
        OS.objc_registerClassPair(n45);
        string = "SWTCanvasView";
        n45 = OS.objc_allocateClassPair(OS.class_NSView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(n45, OS.protocol_NSTextInput);
        OS.class_addMethod(n45, OS.sel_hasMarkedText, n5, "@:");
        OS.class_addMethod(n45, OS.sel_markedRange, n24, "@:");
        OS.class_addMethod(n45, OS.sel_selectedRange, n25, "@:");
        OS.class_addMethod(n45, OS.sel_setMarkedText_selectedRange_, n27, "@:@{NSRange}");
        OS.class_addMethod(n45, OS.sel_unmarkText, n5, "@:");
        OS.class_addMethod(n45, OS.sel_validAttributesForMarkedText, n5, "@:");
        OS.class_addMethod(n45, OS.sel_attributedSubstringFromRange_, n28, "@:{NSRange}");
        OS.class_addMethod(n45, OS.sel_insertText_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_characterIndexForPoint_, n29, "@:{NSPoint}");
        OS.class_addMethod(n45, OS.sel_firstRectForCharacterRange_, n30, "@:{NSRange}");
        OS.class_addMethod(n45, OS.sel_doCommandBySelector_, n6, "@::");
        OS.class_addMethod(n45, OS.sel_canBecomeKeyView, n5, "@:");
        OS.class_addMethod(n45, OS.sel_isFlipped, n10, "@:");
        OS.class_addMethod(n45, OS.sel_acceptsFirstResponder, n5, "@:");
        OS.class_addMethod(n45, OS.sel_isOpaque, n5, "@:");
        OS.class_addMethod(n45, OS.sel_updateOpenGLContext_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_clearDeferFlushing, n5, "@:");
        OS.class_addMethod(n45, OS.sel_validRequestorForSendType_returnType_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_readSelectionFromPasteboard_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_writeSelectionToPasteboard_types_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_viewWillMoveToWindow_, n6, "@:@");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTComboBox";
        n45 = OS.objc_allocateClassPair(OS.class_NSComboBox, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_textDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textViewDidChangeSelection_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_comboBoxSelectionDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_comboBoxWillDismiss_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_comboBoxWillPopUp_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, n31, "@:@{NSRange}{NSRange}");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSComboBox.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_setObjectValue_, n6, "@:@");
        string = "SWTDatePicker";
        n45 = OS.objc_allocateClassPair(OS.class_NSDatePicker, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_isFlipped, n5, "@:");
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_sendVerticalSelection, n5, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTEditorView";
        n45 = OS.objc_allocateClassPair(OS.class_NSTextView, string, 0);
        this.addEventMethods(n45, 0, n6, n11, 0, 0);
        OS.class_addMethod(n45, OS.sel_insertText_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_doCommandBySelector_, n6, "@::");
        OS.class_addMethod(n45, OS.sel_shouldChangeTextInRange_replacementString_, n33, "@:{NSRange}@");
        OS.objc_registerClassPair(n45);
        string = "SWTImageView";
        n45 = OS.objc_allocateClassPair(OS.class_NSImageView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_isFlipped, n10, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSImageView.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTImageTextCell";
        n45 = OS.objc_allocateClassPair(OS.class_NSTextFieldCell, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addIvar(n45, SWT_IMAGE, size, (byte)align, types);
        OS.class_addIvar(n45, SWT_ROW, size, (byte)align, types);
        OS.class_addIvar(n45, SWT_COLUMN, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_drawInteriorWithFrame_inView_, n12, "@:{NSRect}@");
        OS.class_addMethod(n45, OS.sel_drawWithExpansionFrame_inView_, n13, "@:{NSRect}@");
        OS.class_addMethod(n45, OS.sel_imageRectForBounds_, n14, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_titleRectForBounds_, n15, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_hitTestForEvent_inRect_ofView_, n17, "@:@{NSRect}@");
        OS.class_addMethod(n45, OS.sel_cellSize, n18, "@:");
        OS.class_addMethod(n45, OS.sel_image, n5, "@:");
        OS.class_addMethod(n45, OS.sel_setImage_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_expansionFrameWithFrame_inView_, n37, "@:{NSRect}@");
        OS.objc_registerClassPair(n45);
        this.createMenuSubclass(OS.class_NSMenu, "SWTMenu", false);
        this.createMenuItemSubclass(OS.class_NSMenuItem, "SWTMenuItem", false);
        string = "SWTOutlineView";
        n45 = OS.objc_allocateClassPair(OS.class_NSOutlineView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_highlightSelectionInClipRect_, n26, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_sendDoubleSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_outlineViewSelectionDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineViewSelectionIsChanging_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineView_child_ofItem_, n3, "@:@i@");
        OS.class_addMethod(n45, OS.sel_outlineView_isItemExpandable_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_outlineView_numberOfChildrenOfItem_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_selectRowIndexes_byExtendingSelection_, n4, "@:@Z");
        OS.class_addMethod(n45, OS.sel_deselectRow_, n6, "@:i");
        OS.class_addMethod(n45, OS.sel_deselectAll_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineView_objectValueForTableColumn_byItem_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_outlineView_willDisplayCell_forTableColumn_item_, n2, "@:@@@@");
        OS.class_addMethod(n45, OS.sel_outlineView_shouldReorderColumn_toColumn_, n3, "@:@ii");
        OS.class_addMethod(n45, OS.sel_outlineView_setObjectValue_forTableColumn_byItem_, n2, "@:@@@@");
        OS.class_addMethod(n45, OS.sel_outlineView_shouldEditTableColumn_item_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_outlineView_shouldTrackCell_forTableColumn_item_, n2, "@:@@@@@@");
        OS.class_addMethod(n45, OS.sel_outlineView_shouldExpandItem_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_setShouldExpandItem_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_setShouldScrollClipView_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineViewColumnDidMove_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineViewColumnDidResize_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_outlineView_didClickTableColumn_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_canDragRowsWithIndexes_atPoint_, n35, "@:@{NSPoint=ff}");
        OS.class_addMethod(n45, OS.sel_outlineView_writeItems_toPasteboard_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_expandItem_expandChildren_, n4, "@:@Z");
        OS.class_addMethod(n45, OS.sel_collapseItem_collapseChildren_, n4, "@:@Z");
        OS.class_addMethod(n45, OS.sel_drawBackgroundInClipRect_, n41, "@:{NSRect}");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTPanelDelegate";
        n45 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_windowWillClose_, n9, "@:@");
        OS.class_addMethod(n45, OS.sel_changeColor_, n9, "@:@");
        OS.class_addMethod(n45, OS.sel_setColor_forAttribute_, n8, "@:@@");
        OS.class_addMethod(n45, OS.sel_changeFont_, n9, "@:@");
        OS.class_addMethod(n45, OS.sel_validModesForFontPanel_, n9, "@:@");
        OS.class_addMethod(n45, OS.sel_sendSelection_, n9, "@:@");
        OS.class_addMethod(n45, OS.sel_panel_shouldShowFilename_, n8, "@:@@");
        OS.class_addMethod(n45, OS.sel_panelDidEnd_returnCode_contextInfo_, n7, "@:@i@");
        OS.objc_registerClassPair(n45);
        string = "SWTPopUpButton";
        n45 = OS.objc_allocateClassPair(OS.class_NSPopUpButton, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_menuWillOpen_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_menuDidClose_, n6, "@:@");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSPopUpButton.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTProgressIndicator";
        n45 = OS.objc_allocateClassPair(OS.class_NSProgressIndicator, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_viewDidMoveToWindow, n5, "@:");
        OS.class_addMethod(n45, OS.sel__drawThemeProgressArea_, n6, "@:c");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTScroller";
        n45 = OS.objc_allocateClassPair(OS.class_NSScroller, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        if (OS.VERSION >= 4208) {
            n = OS.objc_getMetaClass(string);
            OS.class_addMethod(n, OS.sel_isCompatibleWithOverlayScrollers, n10, "@:");
        }
        string = "SWTScrollView";
        n45 = OS.objc_allocateClassPair(OS.class_NSScrollView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendVerticalSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_sendHorizontalSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_pageDown_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_pageUp_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_reflectScrolledClipView_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_scrollClipView_toPoint_, n42, "@:@{NSPoint}");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTSearchField";
        n45 = OS.objc_allocateClassPair(OS.class_NSSearchField, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_textDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textViewDidChangeSelection_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, n31, "@:@{NSRange}{NSRange}");
        OS.class_addMethod(n45, OS.sel_sendSearchSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_sendCancelSelection, n5, "@:");
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSSearchField.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTSecureTextField";
        n45 = OS.objc_allocateClassPair(OS.class_NSSecureTextField, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_textDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textViewDidChangeSelection_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, n31, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(n45);
        n = OS.objc_lookUpClass("NSSecureTextView");
        if (n != 0) {
            string = "SWTSecureEditorView";
            n45 = OS.objc_allocateClassPair(n, string, 0);
            this.addEventMethods(n45, 0, n6, n11, 0, 0);
            OS.class_addMethod(n45, OS.sel_insertText_, n6, "@:@");
            OS.class_addMethod(n45, OS.sel_doCommandBySelector_, n6, "@::");
            OS.class_addMethod(n45, OS.sel_shouldChangeTextInRange_replacementString_, n33, "@:{NSRange}@");
            OS.objc_registerClassPair(n45);
        }
        string = "SWTSlider";
        n45 = OS.objc_allocateClassPair(OS.class_NSSlider, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSSlider.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTStepper";
        n45 = OS.objc_allocateClassPair(OS.class_NSStepper, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendSelection, n5, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSStepper.cellClass(), size, align, types);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTTableHeaderCell";
        n45 = OS.objc_allocateClassPair(OS.class_NSTableHeaderCell, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_drawInteriorWithFrame_inView_, n12, "@:{NSRect}@");
        OS.objc_registerClassPair(n45);
        string = "SWTTableHeaderView";
        n45 = OS.objc_allocateClassPair(OS.class_NSTableHeaderView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_mouseDown_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_resetCursorRects, n5, "@:");
        OS.class_addMethod(n45, OS.sel_updateTrackingAreas, n5, "@:");
        OS.class_addMethod(n45, OS.sel_menuForEvent_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_headerRectOfColumn_, n43, "@:i");
        OS.class_addMethod(n45, OS.sel_columnAtPoint_, n44, "@:{NSPoint}");
        OS.objc_registerClassPair(n45);
        string = "SWTTableView";
        n45 = OS.objc_allocateClassPair(OS.class_NSTableView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_highlightSelectionInClipRect_, n26, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_sendDoubleSelection, n5, "@:");
        OS.class_addMethod(n45, OS.sel_numberOfRowsInTableView_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableView_objectValueForTableColumn_row_, n3, "@:@@i");
        OS.class_addMethod(n45, OS.sel_tableView_shouldEditTableColumn_row_, n3, "@:@@i");
        OS.class_addMethod(n45, OS.sel_tableView_shouldReorderColumn_toColumn_, n3, "@:@ii");
        OS.class_addMethod(n45, OS.sel_tableView_shouldTrackCell_forTableColumn_row_, n2, "@:@@@i");
        OS.class_addMethod(n45, OS.sel_tableViewSelectionIsChanging_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableViewSelectionDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableView_willDisplayCell_forTableColumn_row_, n2, "@:@@@i");
        OS.class_addMethod(n45, OS.sel_tableView_setObjectValue_forTableColumn_row_, n2, "@:@@@i");
        OS.class_addMethod(n45, OS.sel_tableViewColumnDidMove_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableViewColumnDidResize_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_setShouldScrollClipView_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableView_didClickTableColumn_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_canDragRowsWithIndexes_atPoint_, n35, "@:@{NSPoint=ff}");
        OS.class_addMethod(n45, OS.sel_selectRowIndexes_byExtendingSelection_, n4, "@:@Z");
        OS.class_addMethod(n45, OS.sel_deselectRow_, n6, "@:i");
        OS.class_addMethod(n45, OS.sel_deselectAll_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_tableView_writeRowsWithIndexes_toPasteboard_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_drawBackgroundInClipRect_, n41, "@:{NSRect}");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTTabView";
        n45 = OS.objc_allocateClassPair(OS.class_NSTabView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_tabView_willSelectTabViewItem_, n4, "@:@@");
        OS.class_addMethod(n45, OS.sel_tabView_didSelectTabViewItem_, n4, "@:@@");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTTabViewItem";
        n45 = OS.objc_allocateClassPair(OS.class_NSTabViewItem, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sizeOfLabel_, n38, "@::");
        OS.class_addMethod(n45, OS.sel_drawLabel_inRect_, n39, "@::{NSRect}");
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTTextView";
        n45 = OS.objc_allocateClassPair(OS.class_NSTextView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_insertText_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_doCommandBySelector_, n6, "@::");
        OS.class_addMethod(n45, OS.sel_textDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textView_clickedOnLink_atIndex_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_dragSelectionWithEvent_offset_slideBack_, n3, "@:@@@");
        OS.class_addMethod(n45, OS.sel_shouldChangeTextInRange_replacementString_, n33, "@:{NSRange}@");
        OS.class_addMethod(n45, OS.sel_drawViewBackgroundInRect_, n40, "@:{NSRect}");
        OS.class_addMethod(n45, OS.sel_shouldDrawInsertionPoint, n5, "@:");
        OS.objc_registerClassPair(n45);
        string = "SWTTextField";
        n45 = OS.objc_allocateClassPair(OS.class_NSTextField, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.class_addMethod(n45, OS.sel_acceptsFirstResponder, n5, "@:");
        OS.class_addMethod(n45, OS.sel_textDidChange_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textDidEndEditing_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textViewDidChangeSelection_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_, n31, "@:@{NSRange}{NSRange}");
        OS.objc_registerClassPair(n45);
        OS.class_addMethod(OS.object_getClass(n45), OS.sel_cellClass, n5, "@:");
        n45 = this.registerCellSubclass(NSTextField.cellClass(), size, align, types);
        OS.class_addMethod(n45, OS.sel_drawInteriorWithFrame_inView_, n12, "@:{NSRect}@");
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        string = "SWTTreeItem";
        n45 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.objc_registerClassPair(n45);
        string = "SWTView";
        n45 = OS.objc_allocateClassPair(OS.class_NSView, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_canBecomeKeyView, n5, "@:");
        OS.class_addMethod(n45, OS.sel_isFlipped, n10, "@:");
        OS.class_addMethod(n45, OS.sel_acceptsFirstResponder, n5, "@:");
        OS.class_addMethod(n45, OS.sel_isOpaque, n5, "@:");
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTWindow";
        this.createWindowSubclass(OS.class_NSWindow, string, false);
        string = "SWTPanel";
        n45 = OS.objc_allocateClassPair(OS.class_NSPanel, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_sendEvent_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_helpRequested_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_canBecomeKeyWindow, n5, "@:");
        OS.class_addMethod(n45, OS.sel_becomeKeyWindow, n5, "@:");
        OS.class_addMethod(n45, OS.sel_makeFirstResponder_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_noResponderFor_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_view_stringForToolTip_point_userData_, n34, "@:@i{NSPoint}@");
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTToolbar";
        n45 = OS.objc_allocateClassPair(OS.class_NSToolbar, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_, n3, "@:@@Z");
        OS.class_addMethod(n45, OS.sel_toolbarAllowedItemIdentifiers_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_toolbarDefaultItemIdentifiers_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_toolbarSelectableItemIdentifiers_, n6, "@:@");
        this.addAccessibilityMethods(n45, n5, n6, n4, n32);
        OS.objc_registerClassPair(n45);
        string = "SWTToolbarView";
        n45 = OS.objc_allocateClassPair(OS.class_NSToolbarView, string, 0);
        this.addEventMethods(n45, n5, n6, n11, n23, n36);
        this.addFrameMethods(n45, n21, n22);
        OS.objc_registerClassPair(n45);
        string = "SWTWindowDelegate";
        n45 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
        OS.class_addIvar(n45, SWT_OBJECT, size, (byte)align, types);
        OS.class_addMethod(n45, OS.sel_windowDidResize_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowDidMove_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowShouldClose_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowWillClose_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowDidResignKey_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowDidBecomeKey_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_timerProc_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_systemSettingsChanged_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowDidMiniaturize_, n6, "@:@");
        OS.class_addMethod(n45, OS.sel_windowDidDeminiaturize_, n6, "@:@");
        if (OS.VERSION >= 4208) {
            OS.class_addMethod(n45, OS.sel_windowDidEnterFullScreen_, n6, "@:@");
            OS.class_addMethod(n45, OS.sel_windowDidExitFullScreen_, n6, "@:@");
        }
        OS.objc_registerClassPair(n45);
    }

    NSFont getFont(int n, int n2) {
        int n3 = OS.objc_msgSend(OS.objc_msgSend(n, OS.sel_alloc), OS.sel_initWithFrame_, new NSRect());
        int n4 = 0;
        if (OS.objc_msgSend_bool(n3, OS.sel_respondsToSelector_, n2)) {
            n4 = OS.objc_msgSend(n3, n2);
        }
        NSFont nSFont = null;
        nSFont = n4 != 0 ? new NSFont(n4) : NSFont.systemFontOfSize(NSFont.systemFontSizeForControlSize(0));
        nSFont.retain();
        OS.objc_msgSend(n3, OS.sel_release);
        return nSFont;
    }

    void initColors() {
        this.colors = new float[36][];
        this.colors[28] = this.getWidgetColorRGB(28);
        this.colors[29] = this.getWidgetColorRGB(29);
        this.colors[30] = this.getWidgetColorRGB(30);
        this.colors[31] = this.getWidgetColorRGB(31);
        this.colors[32] = this.getWidgetColorRGB(32);
        this.colors[33] = this.getWidgetColorRGB(33);
        this.colors[34] = this.getWidgetColorRGB(34);
        this.colors[35] = this.getWidgetColorRGB(35);
        this.colors[17] = this.getWidgetColorRGB(17);
        this.colors[18] = this.getWidgetColorRGB(18);
        this.colors[19] = this.getWidgetColorRGB(19);
        this.colors[20] = this.getWidgetColorRGB(20);
        this.colors[22] = this.getWidgetColorRGB(22);
        this.colors[21] = this.getWidgetColorRGB(21);
        this.colors[23] = this.getWidgetColorRGB(23);
        this.colors[24] = this.getWidgetColorRGB(24);
        this.colors[25] = this.getWidgetColorRGB(25);
        this.colors[27] = this.getWidgetColorRGB(27);
        this.colors[26] = this.getWidgetColorRGB(26);
        this.alternateSelectedControlColor = this.getNSColorRGB(NSColor.alternateSelectedControlColor());
        this.alternateSelectedControlTextColor = this.getNSColorRGB(NSColor.alternateSelectedControlTextColor());
        this.secondarySelectedControlColor = this.getNSColorRGB(NSColor.secondarySelectedControlColor());
        this.selectedControlTextColor = this.getNSColorRGB(NSColor.selectedControlTextColor());
    }

    void initFonts() {
        this.smallFonts = System.getProperty("org.eclipse.swt.internal.carbon.smallFonts") != null;
        this.buttonFont = this.getFont(OS.class_NSButton, OS.sel_font);
        this.popUpButtonFont = this.getFont(OS.class_NSPopUpButton, OS.sel_font);
        this.textFieldFont = this.getFont(OS.class_NSTextField, OS.sel_font);
        this.secureTextFieldFont = this.getFont(OS.class_NSSecureTextField, OS.sel_font);
        this.searchFieldFont = this.getFont(OS.class_NSSearchField, OS.sel_font);
        this.comboBoxFont = this.getFont(OS.class_NSComboBox, OS.sel_font);
        this.sliderFont = this.getFont(OS.class_NSSlider, OS.sel_font);
        this.scrollerFont = this.getFont(OS.class_NSScroller, OS.sel_font);
        this.textViewFont = this.getFont(OS.class_NSTextView, OS.sel_font);
        this.tableViewFont = this.getFont(OS.class_NSTableView, OS.sel_font);
        this.outlineViewFont = this.getFont(OS.class_NSOutlineView, OS.sel_font);
        this.datePickerFont = this.getFont(OS.class_NSDatePicker, OS.sel_font);
        this.boxFont = this.getFont(OS.class_NSBox, OS.sel_titleFont);
        this.tabViewFont = this.getFont(OS.class_NSTabView, OS.sel_font);
        this.progressIndicatorFont = this.getFont(OS.class_NSProgressIndicator, OS.sel_font);
    }

    public int internal_new_GC(GCData gCData) {
        NSObject nSObject;
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.screenWindow == null) {
            nSObject = (NSWindow)new NSWindow().alloc();
            NSRect nSRect = new NSRect();
            nSObject = ((NSWindow)nSObject).initWithContentRect(nSRect, 0, 2, false);
            ((NSWindow)nSObject).setReleasedWhenClosed(false);
            this.screenWindow = nSObject;
        }
        nSObject = this.screenWindow.graphicsContext();
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return ((NSGraphicsContext)nSObject).id;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    boolean isBundled() {
        NSDictionary nSDictionary;
        NSBundle nSBundle = NSBundle.mainBundle();
        if (nSBundle != null && (nSDictionary = nSBundle.infoDictionary()) != null) {
            return NSString.stringWith("APPL").isEqual(nSDictionary.objectForKey(NSString.stringWith("CFBundlePackageType")));
        }
        return false;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event event) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        Class<?> clazz3 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            int n = 0;
            int n2 = OS.CGEventSourceCreate(1);
            if (n2 == 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean bl = false;
            int[] nArray = new int[1];
            int n3 = event.type;
            switch (n3) {
                case 1: 
                case 2: {
                    int n4 = Display.untranslateKey(event.keyCode);
                    if (n4 == 0) {
                        int n5 = 0;
                        int n6 = OS.TISCopyCurrentKeyboardInputSource();
                        int n7 = OS.TISGetInputSourceProperty(n6, OS.kTISPropertyUnicodeKeyLayoutData());
                        if (n7 == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        n5 = OS.CFDataGetBytePtr(n7);
                        if (n5 == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        if (OS.CFDataGetLength(n7) == 0) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                        int n8 = 256;
                        n4 = -1;
                        char[] cArray = new char[n8];
                        int[] nArray2 = new int[1];
                        int n9 = 0;
                        while (n9 <= 127) {
                            nArray[0] = 0;
                            OS.UCKeyTranslate(n5, (short)n9, (short)(n3 != 1 ? 1 : 0), 0, OS.LMGetKbdType(), 0, nArray, n8, nArray2, cArray);
                            if (cArray[0] == event.character) {
                                n4 = n9;
                                break;
                            }
                            n9 = (short)(n9 + 1);
                        }
                        if (n4 == -1) {
                            n9 = 0;
                            while (n9 <= 127) {
                                nArray[0] = 0;
                                OS.UCKeyTranslate(n5, (short)n9, (short)(n3 != 1 ? 1 : 0), 2, OS.LMGetKbdType(), 0, nArray, n8, nArray2, cArray);
                                if (cArray[0] == event.character) {
                                    n4 = n9;
                                    break;
                                }
                                n9 = (short)(n9 + 1);
                            }
                        }
                    }
                    if (n4 == -1 && event.character == '\u0000') {
                        n4 = 127;
                    }
                    if (n4 == -1) break;
                    if (OS.VERSION < 4192) {
                        bl = OS.CGPostKeyboardEvent((short)0, (short)n4, n3 == 1) == 0;
                        break;
                    }
                    n = OS.CGEventCreateKeyboardEvent(n2, (short)n4, n3 == 1);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    int n10;
                    CGPoint cGPoint = new CGPoint();
                    if (n3 == 5) {
                        cGPoint.x = event.x;
                        cGPoint.y = event.y;
                        n = OS.CGEventCreateMouseEvent(n2, 5, cGPoint, 0);
                        break;
                    }
                    NSPoint nSPoint = NSEvent.mouseLocation();
                    NSRect nSRect = this.getPrimaryFrame();
                    cGPoint.x = nSPoint.x;
                    cGPoint.y = (int)(nSRect.height - nSPoint.y);
                    int n11 = 0;
                    switch (event.button) {
                        case 1: {
                            n11 = event.type == 3 ? 1 : 2;
                            n10 = 0;
                            break;
                        }
                        case 2: {
                            n11 = event.type == 3 ? 25 : 26;
                            n10 = 2;
                            break;
                        }
                        case 3: {
                            n11 = event.type == 3 ? 3 : 4;
                            n10 = 1;
                            break;
                        }
                        default: {
                            n11 = event.type == 3 ? 25 : 26;
                            n10 = event.button - 1;
                        }
                    }
                    if (n10 < 0) break;
                    n = OS.CGEventCreateMouseEvent(n2, n11, cGPoint, n10);
                    break;
                }
                case 37: {
                    n = OS.CGEventCreateScrollWheelEvent(n2, 1, 1, event.count);
                    break;
                }
            }
            if (!bl && n != 0) {
                OS.CGEventPost(0, n);
                OS.CFRelease(n);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
                bl = true;
            }
            if (n2 != 0) {
                OS.CFRelease(n2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        NSWindow nSWindow;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(n, n2);
        if (control == control2) {
            return point;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n;
        nSPoint.y = n2;
        NSWindow nSWindow2 = control != null ? control.view.window() : null;
        NSWindow nSWindow3 = nSWindow = control2 != null ? control2.view.window() : null;
        if (nSWindow != null && nSWindow2 != null && nSWindow.id == nSWindow2.id) {
            if (!control.view.isFlipped()) {
                nSPoint.y = control.view.bounds().height - nSPoint.y;
            }
            nSPoint = control.view.convertPoint_toView_(nSPoint, control2.view);
            if (!control2.view.isFlipped()) {
                nSPoint.y = control2.view.bounds().height - nSPoint.y;
            }
        } else {
            float f;
            NSView nSView;
            NSRect nSRect = this.getPrimaryFrame();
            if (control != null) {
                nSView = control.eventView();
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
                nSPoint = nSView.convertPoint_toView_(nSPoint, null);
                nSPoint = nSWindow2.convertBaseToScreen(nSPoint);
                nSPoint.y = nSRect.height - nSPoint.y;
                f = nSWindow2.userSpaceScaleFactor();
                nSPoint.x /= f;
                nSPoint.y /= f;
            }
            if (control2 != null) {
                nSView = control2.eventView();
                f = nSWindow.userSpaceScaleFactor();
                nSPoint.x *= f;
                nSPoint.y = nSRect.height - nSPoint.y * f;
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
                nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
            }
        }
        point.x = (int)nSPoint.x;
        point.y = (int)nSPoint.y;
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        NSWindow nSWindow;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = n;
        nSPoint.y = n2;
        NSWindow nSWindow2 = control != null ? control.view.window() : null;
        NSWindow nSWindow3 = nSWindow = control2 != null ? control2.view.window() : null;
        if (nSWindow != null && nSWindow2 != null && nSWindow.id == nSWindow2.id) {
            if (!control.view.isFlipped()) {
                nSPoint.y = control.view.bounds().height - nSPoint.y;
            }
            nSPoint = control.view.convertPoint_toView_(nSPoint, control2.view);
            if (!control2.view.isFlipped()) {
                nSPoint.y = control2.view.bounds().height - nSPoint.y;
            }
        } else {
            float f;
            NSView nSView;
            NSRect nSRect = this.getPrimaryFrame();
            if (control != null) {
                nSView = control.eventView();
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
                nSPoint = nSView.convertPoint_toView_(nSPoint, null);
                nSPoint = nSWindow2.convertBaseToScreen(nSPoint);
                nSPoint.y = nSRect.height - nSPoint.y;
                f = nSWindow2.userSpaceScaleFactor();
                nSPoint.x /= f;
                nSPoint.y /= f;
            }
            if (control2 != null) {
                nSView = control2.eventView();
                f = nSWindow.userSpaceScaleFactor();
                nSPoint.x *= f;
                nSPoint.y = nSRect.height - nSPoint.y * f;
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
                nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
                if (!nSView.isFlipped()) {
                    nSPoint.y = nSView.bounds().height - nSPoint.y;
                }
            }
        }
        rectangle.x = (int)nSPoint.x;
        rectangle.y = (int)nSPoint.y;
        return rectangle;
    }

    int observerProc(int n, int n2, int n3) {
        switch (n2) {
            case 32: {
                if (!this.runAsyncMessages || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return 0;
    }

    boolean performKeyEquivalent(NSWindow nSWindow, NSEvent nSEvent) {
        if (this.modalDialog == null) {
            return false;
        }
        if (nSEvent.type() != 10) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = nSEvent.modifierFlags();
        if ((n3 & 0x80000) != 0) {
            n |= 0x10000;
        }
        if ((n3 & 0x20000) != 0) {
            n |= 0x20000;
        }
        if ((n3 & 0x40000) != 0) {
            n |= 0x40000;
        }
        if ((n3 & 0x100000) != 0) {
            n |= 0x400000;
        }
        if (n == 0x400000) {
            short s = nSEvent.keyCode();
            switch (s) {
                case 7: {
                    n2 = OS.sel_cut_;
                    break;
                }
                case 8: {
                    n2 = OS.sel_copy_;
                    break;
                }
                case 9: {
                    n2 = OS.sel_paste_;
                    break;
                }
                case 0: {
                    n2 = OS.sel_selectAll_;
                }
            }
            if (n2 != 0) {
                NSApplication.sharedApplication().sendAction(n2, null, NSApplication.sharedApplication());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean readAndDispatch() {
        this.checkDevice();
        if (this.sendEventCount == 0 && this.loopCount == this.poolCount - 1 && Callback.getEntryCount() == 0) {
            this.removePool();
        }
        this.addPool();
        this.runSkin();
        this.runDeferredLayouts();
        ++this.loopCount;
        boolean bl = false;
        try {
            bl |= this.runSettings();
            bl |= this.runTimers();
            bl |= this.runContexts();
            bl |= this.runPopups();
            NSEvent nSEvent = this.application.nextEventMatchingMask(0, null, OS.NSDefaultRunLoopMode, true);
            if (nSEvent != null) {
                bl = true;
                this.application.sendEvent(nSEvent);
            }
            bl |= this.runPaint();
            if (!(bl |= this.runDeferredEvents())) {
                bl = this.isDisposed() || this.runAsyncMessages(false);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.removePool();
            --this.loopCount;
            if (this.sendEventCount != 0) throw throwable;
            if (this.loopCount != this.poolCount) throw throwable;
            if (Callback.getEntryCount() != 0) throw throwable;
            this.addPool();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.removePool();
            --this.loopCount;
            if (this.sendEventCount != 0) return bl;
            if (this.loopCount != this.poolCount) return bl;
        }
        if (Callback.getEntryCount() != 0) return bl;
        this.addPool();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] == null) {
                    Display.Displays[n] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.disposing = true;
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        if (this.taskBar != null) {
            this.taskBar.dispose();
        }
        this.taskBar = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        if (this.appMenu != null) {
            this.appMenu.dispose();
        }
        this.appMenu = null;
        if (this.appMenuBar != null) {
            this.appMenuBar.dispose();
        }
        this.appMenuBar = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.infoImage = null;
        this.errorImage = null;
        this.currentCaret = null;
        if (this.hoverTimer != null) {
            this.timerExec(-1, this.hoverTimer);
        }
        this.hoverTimer = null;
        if (this.caretTimer != null) {
            this.timerExec(-1, this.caretTimer);
        }
        this.caretTimer = null;
        if (this.nsTimers != null) {
            n = 0;
            while (n < this.nsTimers.length) {
                if (this.nsTimers[n] != null) {
                    this.nsTimers[n].invalidate();
                    this.nsTimers[n].release();
                }
                ++n;
            }
        }
        this.nsTimers = null;
        if (this.timerDelegate != null) {
            this.timerDelegate.release();
        }
        this.timerDelegate = null;
        n = 0;
        while (n < this.cursors.length) {
            if (this.cursors[n] != null) {
                this.cursors[n].dispose();
            }
            ++n;
        }
        this.cursors = null;
        if (this.buttonFont != null) {
            this.buttonFont.release();
        }
        if (this.popUpButtonFont != null) {
            this.popUpButtonFont.release();
        }
        if (this.textFieldFont != null) {
            this.textFieldFont.release();
        }
        if (this.secureTextFieldFont != null) {
            this.secureTextFieldFont.release();
        }
        if (this.searchFieldFont != null) {
            this.searchFieldFont.release();
        }
        if (this.comboBoxFont != null) {
            this.comboBoxFont.release();
        }
        if (this.sliderFont != null) {
            this.sliderFont.release();
        }
        if (this.scrollerFont != null) {
            this.scrollerFont.release();
        }
        if (this.textViewFont != null) {
            this.textViewFont.release();
        }
        if (this.tableViewFont != null) {
            this.tableViewFont.release();
        }
        if (this.outlineViewFont != null) {
            this.outlineViewFont.release();
        }
        if (this.datePickerFont != null) {
            this.datePickerFont.release();
        }
        if (this.boxFont != null) {
            this.boxFont.release();
        }
        if (this.tabViewFont != null) {
            this.tabViewFont.release();
        }
        if (this.progressIndicatorFont != null) {
            this.progressIndicatorFont.release();
        }
        this.secureTextFieldFont = null;
        this.textFieldFont = null;
        this.popUpButtonFont = null;
        this.buttonFont = null;
        this.comboBoxFont = this.sliderFont = this.scrollerFont;
        this.searchFieldFont = this.sliderFont;
        this.datePickerFont = null;
        this.outlineViewFont = null;
        this.tableViewFont = null;
        this.textViewFont = null;
        this.progressIndicatorFont = null;
        this.tabViewFont = null;
        this.boxFont = null;
        if (this.dockImage != null) {
            this.dockImage.release();
        }
        this.dockImage = null;
        if (this.screenWindow != null) {
            this.screenWindow.release();
        }
        this.screenWindow = null;
        if (this.needsDisplay != null) {
            this.needsDisplay.release();
        }
        if (this.needsDisplayInRect != null) {
            this.needsDisplayInRect.release();
        }
        if (this.isPainting != null) {
            this.isPainting.release();
        }
        if (this.runLoopModes != null) {
            this.runLoopModes.release();
        }
        this.runLoopModes = null;
        this.isPainting = null;
        this.needsDisplayInRect = null;
        this.needsDisplay = null;
        this.modalShells = null;
        this.modalDialog = null;
        this.menuBar = null;
        this.menus = null;
        if (this.markedAttributes != null) {
            this.markedAttributes.release();
        }
        this.markedAttributes = null;
        if (this.oldCursorSetProc != 0) {
            n = OS.class_getInstanceMethod(OS.class_NSCursor, OS.sel_set);
            OS.method_setImplementation(n, this.oldCursorSetProc);
        }
        if (this.cursorSetCallback != null) {
            this.cursorSetCallback.dispose();
        }
        this.cursorSetCallback = null;
        if (this.settingsDelegate != null) {
            NSNotificationCenter.defaultCenter().removeObserver(this.settingsDelegate);
            this.settingsDelegate.release();
        }
        this.settingsDelegate = null;
        if (!this.isEmbedded) {
            NSMenu nSMenu = this.application.mainMenu();
            int n2 = nSMenu.numberOfItems();
            while (n2 > 1) {
                nSMenu.removeItemAtIndex(n2 - 1);
                --n2;
            }
        }
        if (dynamicObjectMap != null) {
            dynamicObjectMap.clear();
            dynamicObjectMap = null;
        }
        if (this.application != null && this.applicationClass != 0) {
            OS.object_setClass(this.application.id, this.applicationClass);
        }
        this.application = null;
        this.applicationClass = 0;
        if (this.runLoopObserver != 0) {
            OS.CFRunLoopObserverInvalidate(this.runLoopObserver);
            OS.CFRelease(this.runLoopObserver);
        }
        this.runLoopObserver = 0;
        if (this.observerCallback != null) {
            this.observerCallback.dispose();
        }
        this.observerCallback = null;
    }

    void removeContext(GCData gCData) {
        if (this.contexts == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.contexts.length) {
            if (this.contexts[n2] != null) {
                if (this.contexts[n2] == gCData) {
                    this.contexts[n2] = null;
                } else {
                    ++n;
                }
            }
            ++n2;
        }
        if (n == 0) {
            this.contexts = null;
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    Widget removeWidget(NSObject nSObject) {
        Object object;
        if (nSObject == null) {
            return null;
        }
        int[] nArray = new int[1];
        int n = OS.object_getInstanceVariable(nSObject.id, SWT_OBJECT, nArray);
        if (n == 0 && dynamicObjectMap != null) {
            object = (LONG)dynamicObjectMap.get(nSObject);
            if (object != null) {
                nArray[0] = ((LONG)object).value;
            }
            dynamicObjectMap.remove(nSObject);
        }
        if (nArray[0] == 0) {
            return null;
        }
        object = (Widget)OS.JNIGetObject(nArray[0]);
        OS.object_setInstanceVariable(nSObject.id, SWT_OBJECT, 0);
        return object;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == menu) {
                this.menus[n] = null;
                break;
            }
            ++n;
        }
    }

    void removePool() {
        NSAutoreleasePool nSAutoreleasePool = this.pools[this.poolCount - 1];
        this.pools[--this.poolCount] = null;
        if (this.poolCount == 0) {
            NSMutableDictionary nSMutableDictionary = NSThread.currentThread().threadDictionary();
            nSMutableDictionary.removeObjectForKey(NSString.stringWith("SWT_NSAutoreleasePool"));
        }
        nSAutoreleasePool.release();
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runContexts() {
        if (this.contexts != null) {
            int n = 0;
            while (n < this.contexts.length) {
                if (this.contexts[n] != null && this.contexts[n].flippedContext != null) {
                    this.contexts[n].flippedContext.flushGraphics();
                }
                ++n;
            }
        }
        return false;
    }

    boolean runDeferredEvents() {
        boolean bl = false;
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.notifyListeners(event.type, event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int n2 = 0;
            while (n2 < n) {
                Composite composite = compositeArray[n2];
                if (!composite.isDisposed()) {
                    composite.setLayoutDeferred(false);
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    NSArray runLoopModes() {
        if (this.runLoopModes == null) {
            this.runLoopModes = NSMutableArray.arrayWithCapacity(3);
            this.runLoopModes.addObject(OS.NSEventTrackingRunLoopMode);
            this.runLoopModes.addObject(OS.NSDefaultRunLoopMode);
            this.runLoopModes.addObject(OS.NSModalPanelRunLoopMode);
            this.runLoopModes.retain();
        }
        this.runLoopModes.retain();
        this.runLoopModes.autorelease();
        return this.runLoopModes;
    }

    boolean runPaint() {
        int n;
        int n2;
        if (this.needsDisplay == null && this.needsDisplayInRect == null) {
            return false;
        }
        if (this.needsDisplay != null) {
            n2 = this.needsDisplay.count();
            n = 0;
            while (n < n2) {
                OS.objc_msgSend(this.needsDisplay.objectAtIndex((int)n).id, OS.sel_setNeedsDisplay_, true);
                ++n;
            }
            this.needsDisplay.release();
            this.needsDisplay = null;
        }
        if (this.needsDisplayInRect != null) {
            n2 = this.needsDisplayInRect.count();
            n = 0;
            while (n < n2) {
                NSValue nSValue = new NSValue(this.needsDisplayInRect.objectAtIndex(n + 1));
                OS.objc_msgSend(this.needsDisplayInRect.objectAtIndex((int)n).id, OS.sel_setNeedsDisplayInRect_, nSValue.rectValue());
                n += 2;
            }
            this.needsDisplayInRect.release();
            this.needsDisplayInRect = null;
        }
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.initColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++n;
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int n2 = 0;
                while (n2 < n) {
                    Widget widget = widgetArray[n2];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFFDFFFFF;
                        widgetArray[n2] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimers() {
        if (this.timerList == null) {
            return false;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.timerList.length) {
            if (this.nsTimers[n] == null && this.timerList[n] != null) {
                Runnable runnable = this.timerList[n];
                this.timerList[n] = null;
                if (runnable != null) {
                    bl = true;
                    runnable.run();
                }
            }
            ++n;
        }
        return bl;
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        this.sendEvent(this.eventTable, event);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendEvent(EventTable eventTable, Event event) {
        try {
            ++this.sendEventCount;
            if (!this.filterEvent(event) && eventTable != null) {
                eventTable.sendEvent(event);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            --this.sendEventCount;
            throw throwable;
        }
        {
            Object var3_5 = null;
            --this.sendEventCount;
            return;
        }
    }

    static NSString getApplicationName() {
        Object object;
        NSString nSString = null;
        int n = OS.getpid();
        int n2 = OS.getenv(Display.ascii("APP_NAME_" + n));
        if (n2 != 0) {
            nSString = NSString.stringWithUTF8String(n2);
        }
        if (nSString == null && APP_NAME != null) {
            nSString = NSString.stringWith(APP_NAME);
        }
        if (nSString == null && (object = NSBundle.mainBundle().objectForInfoDictionaryKey(NSString.stringWith("CFBundleName"))) != null) {
            nSString = new NSString((id)object);
        }
        if (nSString == null && (object = System.getProperty("com.apple.mrj.application.apple.menu.about.name")) != null) {
            nSString = NSString.stringWith((String)object);
        }
        if (nSString == null) {
            nSString = NSString.stringWith("SWT");
        }
        return nSString;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    void setCurrentCaret(Caret caret) {
        this.currentCaret = caret;
        int n = this.currentCaret != null ? this.currentCaret.blinkRate : -1;
        this.timerExec(n, this.caretTimer);
    }

    void setCursor(Control control) {
        Cursor cursor = null;
        if (control != null && !control.isDisposed()) {
            cursor = control.findCursor();
        }
        if (cursor == null) {
            NSWindow nSWindow = this.application.keyWindow();
            if (nSWindow != null) {
                if (nSWindow.areCursorRectsEnabled()) {
                    nSWindow.disableCursorRects();
                    nSWindow.enableCursorRects();
                }
                return;
            }
            cursor = this.getSystemCursor(0);
        }
        this.lockCursor = false;
        cursor.handle.set();
        this.lockCursor = true;
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        Event event = new Event();
        event.type = 5;
        event.x = n;
        event.y = n2;
        this.post(event);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        Object[] objectArray;
        Object[] objectArray2;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            Object[] objectArray3 = (Object[])object;
            objectArray2 = (Object[])objectArray3[0];
            objectArray = (Object[])objectArray3[1];
            if (objectArray == null) {
                this.removeWidget((NSObject)objectArray2);
            } else {
                this.addWidget((NSObject)objectArray2, (Widget)objectArray);
            }
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.modalDialog = object == null ? null : (Dialog)object;
        }
        if (string.equals(MOZILLA_RUNNING)) {
            this.mozillaRunning = (Boolean)object;
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                objectArray2 = new String[this.keys.length - 1];
                objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, objectArray2, 0, n);
                System.arraycopy(this.keys, n + 1, objectArray2, n, objectArray2.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = objectArray2;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        objectArray2 = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray2, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray2[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray2;
    }

    void setMenuBar(Menu menu) {
        if (menu == null) {
            menu = this.appMenuBar;
        }
        if (menu == this.menuBar) {
            return;
        }
        this.menuBar = menu;
        NSMenu nSMenu = this.application.mainMenu();
        OS.CancelMenuTracking(OS.AcquireRootMenu(), true, 0);
        int n = nSMenu.numberOfItems();
        while (n > 1) {
            nSMenu.removeItemAtIndex(n - 1);
            --n;
        }
        if (menu != null) {
            MenuItem[] menuItemArray = menu.getItems();
            int n2 = 0;
            while (n2 < menuItemArray.length) {
                MenuItem menuItem = menuItemArray[n2];
                NSMenuItem nSMenuItem = menuItem.nsItem;
                nSMenuItem.setMenu(null);
                nSMenu.addItem(nSMenuItem);
                boolean bl = menu.getEnabled() && menuItem.getEnabled();
                nSMenuItem.setEnabled(!bl);
                nSMenuItem.setEnabled(bl);
                ++n2;
            }
        }
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n = 0;
        int n2 = this.modalShells.length;
        while (n < n2) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
            ++n;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        int n3 = 0;
        while (n3 < shellArray.length) {
            shellArray[n3].updateModal();
            ++n3;
        }
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.runAsyncMessages(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        try {
            this.addPool();
            this.runAsyncMessages = false;
            this.allowTimers = false;
            NSRunLoop.currentRunLoop().runMode(OS.NSDefaultRunLoopMode, NSDate.distantFuture());
            this.runAsyncMessages = true;
            this.allowTimers = true;
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.removePool();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.removePool();
            return true;
        }
    }

    int sourceProc(int n) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public void timerExec(int n, Runnable runnable) {
        NSTimer[] nSTimerArray;
        Object object;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.nsTimers == null) {
            this.nsTimers = new NSTimer[4];
        }
        int n2 = 0;
        while (n2 < this.timerList.length) {
            if (this.timerList[n2] == runnable) break;
            ++n2;
        }
        if (n2 != this.timerList.length) {
            object = this.nsTimers[n2];
            if (object == null) {
                this.timerList[n2] = null;
            } else {
                if (n < 0) {
                    object.invalidate();
                    object.release();
                    this.timerList[n2] = null;
                    this.nsTimers[n2] = null;
                } else {
                    object.setFireDate(NSDate.dateWithTimeIntervalSinceNow((double)n / 1000.0));
                }
                return;
            }
        }
        if (n < 0) {
            return;
        }
        n2 = 0;
        while (n2 < this.timerList.length) {
            if (this.timerList[n2] == null) break;
            ++n2;
        }
        if (n2 == this.timerList.length) {
            object = new Runnable[this.timerList.length + 4];
            System.arraycopy(this.timerList, 0, object, 0, this.timerList.length);
            this.timerList = object;
            nSTimerArray = new NSTimer[this.nsTimers.length + 4];
            System.arraycopy(this.nsTimers, 0, nSTimerArray, 0, this.nsTimers.length);
            this.nsTimers = nSTimerArray;
        }
        object = NSNumber.numberWithInt(n2);
        nSTimerArray = NSTimer.scheduledTimerWithTimeInterval((double)n / 1000.0, this.timerDelegate, OS.sel_timerProc_, (id)object, false);
        NSRunLoop nSRunLoop = NSRunLoop.currentRunLoop();
        nSRunLoop.addTimer((NSTimer)nSTimerArray, OS.NSModalPanelRunLoopMode);
        nSRunLoop.addTimer((NSTimer)nSTimerArray, OS.NSEventTrackingRunLoopMode);
        nSTimerArray.retain();
        if (nSTimerArray != null) {
            this.nsTimers[n2] = nSTimerArray;
            this.timerList[n2] = runnable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int timerProc(int n, int n2, int n3) {
        NSTimer nSTimer;
        block7: {
            block6: {
                nSTimer = new NSTimer(n3);
                try {
                    NSNumber nSNumber = new NSNumber(nSTimer.userInfo());
                    int n4 = nSNumber.intValue();
                    if (this.timerList == null) {
                        Object var8_7 = null;
                        nSTimer.invalidate();
                        break block6;
                    }
                    if (n4 < 0 || n4 >= this.timerList.length) break block7;
                    if (this.allowTimers) {
                        Runnable runnable = this.timerList[n4];
                        this.timerList[n4] = null;
                        this.nsTimers[n4] = null;
                        if (runnable != null) {
                            runnable.run();
                        }
                        break block7;
                    }
                    this.nsTimers[n4] = null;
                    this.wakeThread();
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    nSTimer.invalidate();
                    nSTimer.release();
                    throw throwable;
                }
            }
            nSTimer.release();
            return 0;
        }
        Object var8_9 = null;
        nSTimer.invalidate();
        nSTimer.release();
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n;
        }
    }

    void updateDefaultButton() {
        this.timerExec(this.hasDefaultButton() ? 30 : -1, this.defaultButtonTimer);
    }

    void updateQuitMenu() {
        NSMenu nSMenu;
        int n;
        Object object;
        if (this.isEmbedded) {
            return;
        }
        boolean bl = true;
        Shell[] shellArray = this.getShells();
        int n2 = 229376;
        int n3 = 0;
        while (n3 < shellArray.length) {
            object = shellArray[n3];
            if ((((Shell)object).style & n2) != 0 && ((Shell)object).isVisible()) {
                bl = false;
                break;
            }
            ++n3;
        }
        NSMenu nSMenu2 = this.application.mainMenu();
        object = nSMenu2.itemAtIndex(0);
        if (object != null && (n = (nSMenu = ((NSMenuItem)object).submenu()).indexOfItemWithTarget(applicationDelegate, OS.sel_applicationShouldTerminate_)) != -1) {
            NSMenuItem nSMenuItem = nSMenu.itemAtIndex(n);
            nSMenuItem.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        NSObject nSObject = new NSObject().alloc().init();
        nSObject.performSelectorOnMainThread(OS.sel_release, null, false);
    }

    Control findControl(boolean bl) {
        return this.findControl(bl, null);
    }

    Control findControl(boolean bl, NSView[] nSViewArray) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = null;
        NSPoint nSPoint = NSEvent.mouseLocation();
        int n = 0;
        if (OS.VERSION >= 4192) {
            n = NSWindow.windowNumberAtPoint(nSPoint, 0);
        } else {
            object3 = new int[1];
            OS.FindWindow((int)nSPoint.x, (int)(this.getPrimaryFrame().height - nSPoint.y), (int[])object3);
            if (object3[0] != false) {
                n = OS.HIWindowGetCGWindowID((int)object3[0]);
            }
        }
        object3 = this.application.windowWithWindowNumber(n);
        if (object3 != null) {
            object2 = ((NSWindow)object3).contentView();
            if (object2 != null) {
                object2 = ((NSView)object2).superview();
            }
            if (object2 != null && (object4 = ((NSView)object2).hitTest((NSPoint)(object = ((NSWindow)object3).convertScreenToBase(nSPoint)))) == null && !bl) {
                object4 = object2;
            }
        }
        object2 = null;
        if (object4 != null) {
            do {
                if (!((object = this.getWidget((NSView)object4)) instanceof Control)) continue;
                object2 = (Control)object;
                break;
            } while ((object4 = ((NSView)object4).superview()) != null);
        }
        if (bl && object2 != null && ((Control)object2).isTrim((NSView)object4)) {
            object2 = null;
        }
        if (object2 != null && nSViewArray != null) {
            nSViewArray[0] = object4;
        }
        return object2;
    }

    void finishLaunching(int n, int n2) {
        if (launched) {
            return;
        }
        launched = true;
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2);
    }

    void applicationDidBecomeActive(int n, int n2, int n3) {
        NSWindow nSWindow = this.application.keyWindow();
        if (nSWindow != null) {
            nSWindow.orderFrontRegardless();
        } else {
            this.setMenuBar(this.menuBar);
        }
        this.checkFocus();
        this.checkEnterExit(this.findControl(true), null, false);
    }

    void applicationDidResignActive(int n, int n2, int n3) {
        this.checkFocus();
        this.checkEnterExit(null, null, false);
    }

    int applicationNextEventMatchingMask(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n6 != 0 && this.trackingControl != null && !this.trackingControl.isDisposed()) {
            this.runDeferredEvents();
        }
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        int n7 = OS.objc_msgSendSuper(objc_super2, n2, n3, n4, n5, n6 != 0);
        if (n7 != 0) {
            NSEvent nSEvent;
            if (this.comboPoppedUp && this.mozillaRunning && n6 != 0 && (nSEvent = new NSEvent(n7)).type() == 15) {
                return 0;
            }
            if (n6 != 0 && this.trackingControl != null && !this.trackingControl.isDisposed()) {
                this.applicationSendTrackingEvent(new NSEvent(n7), this.trackingControl);
            }
        }
        return n7;
    }

    void applicationSendTrackingEvent(NSEvent nSEvent, Control control) {
        int n = nSEvent.type();
        boolean bl = false;
        Control control2 = null;
        switch (n) {
            case 1: 
            case 3: 
            case 25: {
                this.clickCount = this.clickCountButton == nSEvent.buttonNumber() ? nSEvent.clickCount() : 1;
                this.clickCountButton = nSEvent.buttonNumber();
                control.sendMouseEvent(nSEvent, 3, true);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                bl = true;
                control2 = this.findControl(true);
                Control control3 = control;
                this.trackingControl = null;
                if (this.clickCount == 2) {
                    control3.sendMouseEvent(nSEvent, 8, false);
                }
                if (control3.isDisposed()) break;
                control3.sendMouseEvent(nSEvent, 4, false);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                bl = true;
                control2 = control;
            }
            case 5: {
                control.sendMouseEvent(nSEvent, 5, true);
            }
        }
        if (bl && (control2 == null || !control2.isDisposed())) {
            this.checkEnterExit(control2, nSEvent, false);
        }
    }

    void applicationSendEvent(int n, int n2, int n3) {
        Object object;
        NSEvent nSEvent = new NSEvent(n3);
        NSWindow nSWindow = nSEvent.window();
        if (this.performKeyEquivalent(nSWindow, nSEvent)) {
            return;
        }
        int n4 = nSEvent.type();
        boolean bl = false;
        switch (n4) {
            case 1: 
            case 3: 
            case 25: {
                bl = true;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 22: 
            case 26: 
            case 27: {
                Shell shell;
                if (nSWindow == null || (object = (Shell)this.getWidget(nSWindow.id)) == null || (shell = ((Shell)object).getModalShell()) == null) break;
                if (bl) {
                    if (!this.application.isActive()) {
                        this.application.activateIgnoringOtherApps(true);
                    }
                    NSRect nSRect = nSWindow.contentView().frame();
                    NSPoint nSPoint = nSWindow.convertBaseToScreen(nSEvent.locationInWindow());
                    if (OS.NSPointInRect(nSPoint, nSRect)) {
                        this.beep();
                    }
                }
                return;
            }
        }
        this.sendEvent = true;
        if (nSWindow != null && nSWindow.isKeyWindow() && nSEvent.type() == 10 && (nSEvent.modifierFlags() & 0x400000) != 0) {
            nSWindow.sendEvent(nSEvent);
        }
        if (nSWindow != null && nSWindow.isKeyWindow() && nSEvent.type() == 11 && (nSEvent.modifierFlags() & 0x100000) != 0) {
            nSWindow.sendEvent(nSEvent);
        } else {
            object = new objc_super();
            ((objc_super)object).receiver = n;
            ((objc_super)object).super_class = OS.objc_msgSend(n, OS.sel_superclass);
            OS.objc_msgSendSuper((objc_super)object, n2, n3);
        }
        this.sendEvent = false;
    }

    void applicationWillFinishLaunching(int n, int n2, int n3) {
        NSMenuItem nSMenuItem;
        NSObject nSObject;
        Object object;
        Object object2;
        boolean bl = false;
        if (this.isEmbedded) {
            object2 = new int[1];
            object = new short[1];
            int n4 = OS.GetIndMenuItemWithCommandID(0, 1751737445, 1, (int[])object2, (short[])object);
            if (n4 == 0) {
                OS.DeleteMenuItem((int)object2[0], (short)object[0]);
            }
            if ((n4 = OS.GetIndMenuItemWithCommandID(0, 1751737455, 1, (int[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((int)object2[0], (short)object[0]);
            }
            if ((n4 = OS.GetIndMenuItemWithCommandID(0, 1936220524, 1, (int[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((int)object2[0], (short)object[0]);
            }
            if ((n4 = OS.GetIndMenuItemWithCommandID(0, 1903520116, 1, (int[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((int)object2[0], (short)object[0]);
            }
            if ((n4 = OS.GetIndMenuItemWithCommandID(0, 1936028278, 1, (int[])object2, (short[])object)) == 0) {
                OS.DeleteMenuItem((int)object2[0], (short)object[0]);
            }
        }
        object2 = Locale.getDefault();
        object = ((Locale)object2).getLanguage();
        NSLocale nSLocale = (NSLocale)new NSLocale().alloc();
        nSLocale = new NSLocale(nSLocale.initWithLocaleIdentifier(NSString.stringWith("en_US")));
        NSString nSString = nSLocale.displayNameForKey(OS.NSLocaleLanguageCode, NSString.stringWith((String)object));
        if (nSLocale != null) {
            nSLocale.release();
        }
        NSBundle nSBundle = NSBundle.bundleWithIdentifier(NSString.stringWith("com.apple.JavaVM"));
        NSDictionary nSDictionary = NSDictionary.dictionaryWithObject(applicationDelegate, NSString.stringWith("NSOwner"));
        NSString nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, nSString);
        if (nSString2 == null) {
            nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"), null, NSString.stringWith((String)object));
        }
        if (nSString2 == null) {
            nSString2 = nSBundle.pathForResource(NSString.stringWith("DefaultApp"), NSString.stringWith("nib"));
        }
        if (!bl) {
            boolean bl2 = bl = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0);
        }
        if (!bl) {
            nSObject = nSBundle.resourcePath();
            nSString2 = nSObject != null ? ((NSString)nSObject).stringByAppendingString(NSString.stringWith("/English.lproj/DefaultApp.nib")) : null;
            boolean bl3 = bl = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0);
        }
        if (!bl) {
            nSString2 = NSString.stringWith(String.valueOf(System.getProperty("java.home")) + "/../Resources/English.lproj/DefaultApp.nib");
            boolean bl4 = bl = nSString2 != null && NSBundle.loadNibFile(nSString2, nSDictionary, 0);
        }
        if (!bl) {
            this.createMainMenu();
        }
        if ((nSMenuItem = ((NSMenu)(nSObject = this.application.mainMenu())).itemAtIndex(0)) != null) {
            NSMenuItem nSMenuItem2;
            NSString nSString3 = Display.getApplicationName();
            NSString nSString4 = NSString.stringWith("%@");
            nSMenuItem.setTitle(nSString3);
            NSMenu nSMenu = nSMenuItem.submenu();
            NSArray nSArray = nSMenu.itemArray();
            int n5 = 0;
            while (n5 < nSArray.count()) {
                nSMenuItem2 = new NSMenuItem(nSArray.objectAtIndex(n5));
                NSString nSString5 = nSMenuItem2.title().stringByReplacingOccurrencesOfString(nSString4, nSString3);
                nSMenuItem2.setTitle(nSString5);
                int n6 = 0;
                switch (n5) {
                    case 0: {
                        n6 = -1;
                        break;
                    }
                    case 2: {
                        n6 = -2;
                        break;
                    }
                    case 6: {
                        n6 = -3;
                        break;
                    }
                    case 7: {
                        n6 = -4;
                        break;
                    }
                    case 8: {
                        n6 = -5;
                        break;
                    }
                    case 10: {
                        n6 = -6;
                    }
                }
                if (n6 != 0) {
                    nSMenuItem2.setTag(n6);
                }
                ++n5;
            }
            n5 = nSMenu.indexOfItemWithTarget(applicationDelegate, OS.sel_terminate_);
            if (n5 != -1) {
                nSMenuItem2 = nSMenu.itemAtIndex(n5);
                nSMenuItem2.setAction(OS.sel_applicationShouldTerminate_);
            }
        }
    }

    static int applicationProc(int n, int n2) {
        Display display = Display.getCurrent();
        if (display == null) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = n;
            objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, n2);
        }
        if (n2 == OS.sel_isRunning) {
            return display.isDisposed() ? 0 : 1;
        }
        if (n2 == OS.sel_finishLaunching) {
            display.finishLaunching(n, n2);
        }
        return 0;
    }

    static int applicationProc(int n, int n2, int n3) {
        Display display = Display.getCurrent();
        if (display == null && n != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = n;
            objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, n2, n3);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(n2)) {
            OS.objc_msgSend(Display.currAppDelegate.id, n2, n3);
        }
        NSApplication nSApplication = display.application;
        if (n2 == OS.sel_sendEvent_) {
            display.applicationSendEvent(n, n2, n3);
        } else if (n2 == OS.sel_applicationWillFinishLaunching_) {
            display.applicationWillFinishLaunching(n, n2, n3);
        } else {
            if (n2 == OS.sel_applicationShouldTerminate_) {
                int n4 = 0;
                if (!display.disposing) {
                    Event event = new Event();
                    display.sendEvent(21, event);
                    if (event.doit) {
                        display.dispose();
                        n4 = 1;
                    }
                }
                return n4;
            }
            if (n2 != OS.sel_orderFrontStandardAboutPanel_) {
                Menu menu;
                TaskItem taskItem;
                TaskBar taskBar;
                if (n2 == OS.sel_hideOtherApplications_) {
                    nSApplication.hideOtherApplications(nSApplication);
                } else if (n2 == OS.sel_hide_) {
                    nSApplication.hide(nSApplication);
                } else if (n2 == OS.sel_unhideAllApplications_) {
                    nSApplication.unhideAllApplications(nSApplication);
                } else if (n2 == OS.sel_applicationDidBecomeActive_) {
                    display.applicationDidBecomeActive(n, n2, n3);
                } else if (n2 == OS.sel_applicationDidResignActive_) {
                    display.applicationDidResignActive(n, n2, n3);
                } else if (n2 == OS.sel_applicationDockMenu_ && (taskBar = display.taskBar) != null && taskBar.itemCount != 0 && (taskItem = taskBar.getItem(null)) != null && (menu = taskItem.getMenu()) != null && !menu.isDisposed()) {
                    return menu.nsMenu.id;
                }
            }
        }
        return 0;
    }

    static int applicationProc(int n, int n2, int n3, int n4) {
        Display display = Display.getCurrent();
        if (display == null && n != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = n;
            objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, n2, n3, n4);
        }
        if (currAppDelegate != null && currAppDelegate.respondsToSelector(n2)) {
            OS.objc_msgSend(Display.currAppDelegate.id, n2, n3, n4);
        }
        if (n2 == OS.sel_application_openFile_) {
            String string = new NSString(n4).getString();
            Event event = new Event();
            event.text = string;
            display.sendEvent(46, event);
            return 1;
        }
        if (n2 == OS.sel_application_openFiles_) {
            NSArray nSArray = new NSArray(n4);
            int n5 = nSArray.count();
            int n6 = 0;
            while (n6 < n5) {
                String string = new NSString(nSArray.objectAtIndex(n6)).getString();
                Event event = new Event();
                event.text = string;
                display.sendEvent(46, event);
                ++n6;
            }
            new NSApplication(n3).replyToOpenOrPrint(0);
        } else if (n2 == OS.sel_applicationShouldHandleReopen_hasVisibleWindows_) {
            return 1;
        }
        return 0;
    }

    static int applicationProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Display display = Display.getCurrent();
        if (display == null && n != Display.applicationDelegate.id) {
            objc_super objc_super2 = new objc_super();
            objc_super2.receiver = n;
            objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
            return OS.objc_msgSendSuper(objc_super2, n2, n3, n4, n5, n6 != 0);
        }
        if (n2 == OS.sel_nextEventMatchingMask_untilDate_inMode_dequeue_) {
            return display.applicationNextEventMatchingMask(n, n2, n3, n4, n5, n6);
        }
        return 0;
    }

    static int dialogProc(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (nArray[0] == 0) {
            return 0;
        }
        if (n2 == OS.sel_changeColor_) {
            ColorDialog colorDialog = (ColorDialog)OS.JNIGetObject(nArray[0]);
            if (colorDialog == null) {
                return 0;
            }
            colorDialog.changeColor(n, n2, n3);
        } else if (n2 == OS.sel_changeFont_) {
            FontDialog fontDialog = (FontDialog)OS.JNIGetObject(nArray[0]);
            if (fontDialog == null) {
                return 0;
            }
            fontDialog.changeFont(n, n2, n3);
        } else {
            if (n2 == OS.sel_validModesForFontPanel_) {
                FontDialog fontDialog = (FontDialog)OS.JNIGetObject(nArray[0]);
                if (fontDialog == null) {
                    return 0;
                }
                return fontDialog.validModesForFontPanel(n, n2, n3);
            }
            if (n2 == OS.sel_sendSelection_) {
                FileDialog fileDialog = (FileDialog)OS.JNIGetObject(nArray[0]);
                if (fileDialog == null) {
                    return 0;
                }
                fileDialog.sendSelection(n, n2, n3);
            } else if (n2 == OS.sel_windowWillClose_) {
                Object object = OS.JNIGetObject(nArray[0]);
                if (object instanceof FontDialog) {
                    ((FontDialog)object).windowWillClose(n, n2, n3);
                } else if (object instanceof ColorDialog) {
                    ((ColorDialog)object).windowWillClose(n, n2, n3);
                }
            }
        }
        return 0;
    }

    static int dialogProc(int n, int n2, int n3, int n4) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (nArray[0] == 0) {
            return 0;
        }
        if (n2 == OS.sel_panel_shouldShowFilename_) {
            FileDialog fileDialog = (FileDialog)OS.JNIGetObject(nArray[0]);
            if (fileDialog == null) {
                return 0;
            }
            return fileDialog.panel_shouldShowFilename(n, n2, n3, n4);
        }
        if (n2 == OS.sel_setColor_forAttribute_) {
            FontDialog fontDialog = (FontDialog)OS.JNIGetObject(nArray[0]);
            if (fontDialog == null) {
                return 0;
            }
            fontDialog.setColor_forAttribute(n, n2, n3, n4);
            return 0;
        }
        return 0;
    }

    static int dialogProc(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (nArray[0] == 0) {
            return 0;
        }
        if (n2 == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            MessageBox messageBox = (MessageBox)OS.JNIGetObject(nArray[0]);
            if (messageBox == null) {
                return 0;
            }
            messageBox.panelDidEnd_returnCode_contextInfo(n, n2, n3, n4, n5);
        }
        return 0;
    }

    static Widget LookupWidget(int n, int n2) {
        NSView nSView;
        Widget widget = Display.GetWidget(n);
        if (widget == null && (nSView = new NSView(n)).isKindOfClass(OS.class_NSView)) {
            while (widget == null && (nSView = nSView.superview()) != null) {
                widget = Display.GetWidget(nSView.id);
            }
        }
        return widget;
    }

    static int windowProc(int n, int n2) {
        if (n2 == OS.sel_cellClass) {
            int n3 = OS.objc_msgSend(OS.class_getSuperclass(n), n2);
            int n4 = OS.objc_lookUpClass("SWTAccessible" + OS.class_getName(n3));
            return n4 != 0 ? n4 : n3;
        }
        if (!NSThread.isMainThread() && n2 == OS.sel_isOpaque) {
            return 1;
        }
        Widget widget = Display.LookupWidget(n, n2);
        if (widget == null) {
            return 0;
        }
        if (n2 == OS.sel_sendSelection) {
            widget.sendSelection();
        } else if (n2 == OS.sel_sendDoubleSelection) {
            widget.sendDoubleSelection();
        } else if (n2 == OS.sel_sendVerticalSelection) {
            widget.sendVerticalSelection();
        } else if (n2 == OS.sel_sendHorizontalSelection) {
            widget.sendHorizontalSelection();
        } else if (n2 == OS.sel_sendSearchSelection) {
            widget.sendSearchSelection();
        } else if (n2 == OS.sel_sendCancelSelection) {
            widget.sendCancelSelection();
        } else {
            if (n2 == OS.sel_acceptsFirstResponder) {
                return widget.acceptsFirstResponder(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_becomeFirstResponder) {
                return widget.becomeFirstResponder(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_resignFirstResponder) {
                return widget.resignFirstResponder(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_isOpaque) {
                return widget.isOpaque(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_isFlipped) {
                return widget.isFlipped(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_canBecomeKeyView) {
                return widget.canBecomeKeyView(n, n2) ? 1 : 0;
            }
            if (n2 == OS.sel_becomeKeyWindow) {
                widget.becomeKeyWindow(n, n2);
            } else if (n2 != OS.sel_unmarkText) {
                if (n2 == OS.sel_validAttributesForMarkedText) {
                    return widget.validAttributesForMarkedText(n, n2);
                }
                if (n2 == OS.sel_markedRange) {
                    NSRange nSRange = widget.markedRange(n, n2);
                    int n5 = OS.malloc(NSRange.sizeof);
                    OS.memmove(n5, nSRange, NSRange.sizeof);
                    return n5;
                }
                if (n2 == OS.sel_selectedRange) {
                    NSRange nSRange = widget.selectedRange(n, n2);
                    int n6 = OS.malloc(NSRange.sizeof);
                    OS.memmove(n6, nSRange, NSRange.sizeof);
                    return n6;
                }
                if (n2 == OS.sel_cellSize) {
                    NSSize nSSize = widget.cellSize(n, n2);
                    int n7 = OS.malloc(NSSize.sizeof);
                    OS.memmove(n7, nSSize, NSSize.sizeof);
                    return n7;
                }
                if (n2 == OS.sel_hasMarkedText) {
                    return widget.hasMarkedText(n, n2) ? 1 : 0;
                }
                if (n2 == OS.sel_canBecomeKeyWindow) {
                    return widget.canBecomeKeyWindow(n, n2) ? 1 : 0;
                }
                if (n2 == OS.sel_accessibilityActionNames) {
                    return widget.accessibilityActionNames(n, n2);
                }
                if (n2 == OS.sel_accessibilityAttributeNames) {
                    return widget.accessibilityAttributeNames(n, n2);
                }
                if (n2 == OS.sel_accessibilityParameterizedAttributeNames) {
                    return widget.accessibilityParameterizedAttributeNames(n, n2);
                }
                if (n2 == OS.sel_getImageView) {
                    return widget.imageView();
                }
                if (n2 == OS.sel_mouseDownCanMoveWindow) {
                    return widget.mouseDownCanMoveWindow(n, n2) ? 1 : 0;
                }
                if (n2 == OS.sel_accessibilityFocusedUIElement) {
                    return widget.accessibilityFocusedUIElement(n, n2);
                }
                if (n2 == OS.sel_accessibilityIsIgnored) {
                    return widget.accessibilityIsIgnored(n, n2) ? 1 : 0;
                }
                if (n2 == OS.sel_nextState) {
                    return widget.nextState(n, n2);
                }
                if (n2 == OS.sel_resetCursorRects) {
                    widget.resetCursorRects(n, n2);
                } else if (n2 == OS.sel_updateTrackingAreas) {
                    widget.updateTrackingAreas(n, n2);
                } else if (n2 == OS.sel_viewDidMoveToWindow) {
                    widget.viewDidMoveToWindow(n, n2);
                } else {
                    if (n2 == OS.sel_image) {
                        return widget.image(n, n2);
                    }
                    if (n2 == OS.sel_shouldDrawInsertionPoint) {
                        return widget.shouldDrawInsertionPoint(n, n2) ? 1 : 0;
                    }
                    if (n2 == OS.sel_accessibleHandle) {
                        return widget.accessibleHandle();
                    }
                    if (n2 == OS.sel_clearDeferFlushing) {
                        widget.clearDeferFlushing(n, n2);
                    }
                }
            }
        }
        return 0;
    }

    static int windowProc(int n, int n2, int n3) {
        if (!NSThread.isMainThread() && n2 == OS.sel_drawRect_) {
            return 0;
        }
        if (n2 == OS.sel_changeColor_) {
            NSColorPanel nSColorPanel = NSColorPanel.sharedColorPanel();
            id id2 = nSColorPanel.delegate();
            if (id2 != null && OS.objc_msgSend_bool(id2.id, OS.sel_isKindOfClass_, OS.objc_getClass("SWTPanelDelegate"))) {
                OS.objc_msgSend(id2.id, OS.sel_changeColor_, n3);
            }
            return 0;
        }
        if (n2 == OS.sel_timerProc_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0;
            }
            return display.timerProc(n, n2, n3);
        }
        if (n2 == OS.sel_systemSettingsChanged_) {
            Display display = Display.getCurrent();
            if (display == null) {
                return 0;
            }
            display.runSettings = true;
            return 0;
        }
        Widget widget = Display.LookupWidget(n, n2);
        if (widget == null) {
            return 0;
        }
        if (n2 == OS.sel_windowWillClose_) {
            widget.windowWillClose(n, n2, n3);
        } else if (n2 == OS.sel_drawRect_) {
            NSRect nSRect = new NSRect();
            OS.memmove(nSRect, n3, NSRect.sizeof);
            widget.drawRect(n, n2, nSRect);
        } else {
            if (n2 == OS.sel_columnAtPoint_) {
                NSPoint nSPoint = new NSPoint();
                OS.memmove(nSPoint, n3, NSPoint.sizeof);
                return widget.columnAtPoint(n, n2, nSPoint);
            }
            if (n2 == OS.sel__drawThemeProgressArea_) {
                widget._drawThemeProgressArea(n, n2, n3);
            } else if (n2 == OS.sel_setFrameOrigin_) {
                NSPoint nSPoint = new NSPoint();
                OS.memmove(nSPoint, n3, NSPoint.sizeof);
                widget.setFrameOrigin(n, n2, nSPoint);
            } else if (n2 == OS.sel_setFrameSize_) {
                NSSize nSSize = new NSSize();
                OS.memmove(nSSize, n3, NSSize.sizeof);
                widget.setFrameSize(n, n2, nSSize);
            } else {
                if (n2 == OS.sel_hitTest_) {
                    NSPoint nSPoint = new NSPoint();
                    OS.memmove(nSPoint, n3, NSPoint.sizeof);
                    return widget.hitTest(n, n2, nSPoint);
                }
                if (n2 == OS.sel_windowShouldClose_) {
                    return widget.windowShouldClose(n, n2, n3) ? 1 : 0;
                }
                if (n2 == OS.sel_mouseDown_) {
                    widget.mouseDown(n, n2, n3);
                } else if (n2 == OS.sel_keyDown_) {
                    widget.keyDown(n, n2, n3);
                } else if (n2 == OS.sel_keyUp_) {
                    widget.keyUp(n, n2, n3);
                } else if (n2 == OS.sel_flagsChanged_) {
                    widget.flagsChanged(n, n2, n3);
                } else if (n2 == OS.sel_mouseUp_) {
                    widget.mouseUp(n, n2, n3);
                } else if (n2 == OS.sel_rightMouseDown_) {
                    widget.rightMouseDown(n, n2, n3);
                } else if (n2 == OS.sel_rightMouseDragged_) {
                    widget.rightMouseDragged(n, n2, n3);
                } else if (n2 == OS.sel_rightMouseUp_) {
                    widget.rightMouseUp(n, n2, n3);
                } else if (n2 == OS.sel_otherMouseDown_) {
                    widget.otherMouseDown(n, n2, n3);
                } else if (n2 == OS.sel_otherMouseUp_) {
                    widget.otherMouseUp(n, n2, n3);
                } else if (n2 == OS.sel_otherMouseDragged_) {
                    widget.otherMouseDragged(n, n2, n3);
                } else if (n2 == OS.sel_mouseMoved_) {
                    widget.mouseMoved(n, n2, n3);
                } else if (n2 == OS.sel_mouseDragged_) {
                    widget.mouseDragged(n, n2, n3);
                } else if (n2 == OS.sel_mouseEntered_) {
                    widget.mouseEntered(n, n2, n3);
                } else if (n2 == OS.sel_mouseExited_) {
                    widget.mouseExited(n, n2, n3);
                } else if (n2 == OS.sel_cursorUpdate_) {
                    widget.cursorUpdate(n, n2, n3);
                } else {
                    if (n2 == OS.sel_menuForEvent_) {
                        return widget.menuForEvent(n, n2, n3);
                    }
                    if (n2 == OS.sel_noResponderFor_) {
                        widget.noResponderFor(n, n2, n3);
                    } else {
                        if (n2 == OS.sel_shouldDelayWindowOrderingForEvent_) {
                            return widget.shouldDelayWindowOrderingForEvent(n, n2, n3) ? 1 : 0;
                        }
                        if (n2 == OS.sel_acceptsFirstMouse_) {
                            return widget.acceptsFirstMouse(n, n2, n3) ? 1 : 0;
                        }
                        if (n2 == OS.sel_numberOfRowsInTableView_) {
                            return widget.numberOfRowsInTableView(n, n2, n3);
                        }
                        if (n2 == OS.sel_tableViewSelectionDidChange_) {
                            widget.tableViewSelectionDidChange(n, n2, n3);
                        } else if (n2 == OS.sel_tableViewSelectionIsChanging_) {
                            widget.tableViewSelectionIsChanging(n, n2, n3);
                        } else if (n2 == OS.sel_windowDidResignKey_) {
                            widget.windowDidResignKey(n, n2, n3);
                        } else if (n2 == OS.sel_windowDidBecomeKey_) {
                            widget.windowDidBecomeKey(n, n2, n3);
                        } else if (n2 == OS.sel_windowDidResize_) {
                            widget.windowDidResize(n, n2, n3);
                        } else if (n2 == OS.sel_windowDidMove_) {
                            widget.windowDidMove(n, n2, n3);
                        } else if (n2 == OS.sel_menuWillOpen_) {
                            widget.menuWillOpen(n, n2, n3);
                        } else if (n2 == OS.sel_menuDidClose_) {
                            widget.menuDidClose(n, n2, n3);
                        } else if (n2 == OS.sel_menuNeedsUpdate_) {
                            widget.menuNeedsUpdate(n, n2, n3);
                        } else if (n2 == OS.sel_outlineViewSelectionDidChange_) {
                            widget.outlineViewSelectionDidChange(n, n2, n3);
                        } else if (n2 == OS.sel_outlineViewSelectionIsChanging_) {
                            widget.outlineViewSelectionIsChanging(n, n2, n3);
                        } else if (n2 == OS.sel_sendEvent_) {
                            widget.windowSendEvent(n, n2, n3);
                        } else if (n2 == OS.sel_helpRequested_) {
                            widget.helpRequested(n, n2, n3);
                        } else if (n2 == OS.sel_scrollWheel_) {
                            widget.scrollWheel(n, n2, n3);
                        } else if (n2 == OS.sel_pageDown_) {
                            widget.pageDown(n, n2, n3);
                        } else if (n2 == OS.sel_pageUp_) {
                            widget.pageUp(n, n2, n3);
                        } else if (n2 == OS.sel_textViewDidChangeSelection_) {
                            widget.textViewDidChangeSelection(n, n2, n3);
                        } else if (n2 == OS.sel_textDidChange_) {
                            widget.textDidChange(n, n2, n3);
                        } else if (n2 == OS.sel_textDidEndEditing_) {
                            widget.textDidEndEditing(n, n2, n3);
                        } else {
                            if (n2 == OS.sel_attributedSubstringFromRange_) {
                                return widget.attributedSubstringFromRange(n, n2, n3);
                            }
                            if (n2 == OS.sel_characterIndexForPoint_) {
                                return widget.characterIndexForPoint(n, n2, n3);
                            }
                            if (n2 == OS.sel_firstRectForCharacterRange_) {
                                NSRect nSRect = widget.firstRectForCharacterRange(n, n2, n3);
                                int n4 = OS.malloc(NSRect.sizeof);
                                OS.memmove(n4, nSRect, NSRect.sizeof);
                                return n4;
                            }
                            if (n2 == OS.sel_insertText_) {
                                return widget.insertText(n, n2, n3) ? 1 : 0;
                            }
                            if (n2 == OS.sel_doCommandBySelector_) {
                                widget.doCommandBySelector(n, n2, n3);
                            } else if (n2 == OS.sel_highlightSelectionInClipRect_) {
                                widget.highlightSelectionInClipRect(n, n2, n3);
                            } else if (n2 == OS.sel_reflectScrolledClipView_) {
                                widget.reflectScrolledClipView(n, n2, n3);
                            } else {
                                if (n2 == OS.sel_accessibilityHitTest_) {
                                    NSPoint nSPoint = new NSPoint();
                                    OS.memmove(nSPoint, n3, NSPoint.sizeof);
                                    return widget.accessibilityHitTest(n, n2, nSPoint);
                                }
                                if (n2 == OS.sel_accessibilityAttributeValue_) {
                                    return widget.accessibilityAttributeValue(n, n2, n3);
                                }
                                if (n2 == OS.sel_accessibilityPerformAction_) {
                                    widget.accessibilityPerformAction(n, n2, n3);
                                } else {
                                    if (n2 == OS.sel_accessibilityActionDescription_) {
                                        return widget.accessibilityActionDescription(n, n2, n3);
                                    }
                                    if (n2 == OS.sel_accessibilityIsAttributeSettable_) {
                                        return widget.accessibilityIsAttributeSettable(n, n2, n3) ? 1 : 0;
                                    }
                                    if (n2 == OS.sel_makeFirstResponder_) {
                                        return widget.makeFirstResponder(n, n2, n3) ? 1 : 0;
                                    }
                                    if (n2 == OS.sel_tableViewColumnDidMove_) {
                                        widget.tableViewColumnDidMove(n, n2, n3);
                                    } else if (n2 == OS.sel_tableViewColumnDidResize_) {
                                        widget.tableViewColumnDidResize(n, n2, n3);
                                    } else if (n2 == OS.sel_outlineViewColumnDidMove_) {
                                        widget.outlineViewColumnDidMove(n, n2, n3);
                                    } else if (n2 == OS.sel_outlineViewColumnDidResize_) {
                                        widget.outlineViewColumnDidResize(n, n2, n3);
                                    } else if (n2 == OS.sel_setNeedsDisplay_) {
                                        widget.setNeedsDisplay(n, n2, n3 != 0);
                                    } else if (n2 == OS.sel_setNeedsDisplayInRect_) {
                                        widget.setNeedsDisplayInRect(n, n2, n3);
                                    } else if (n2 == OS.sel_setImage_) {
                                        widget.setImage(n, n2, n3);
                                    } else {
                                        if (n2 == OS.sel_headerRectOfColumn_) {
                                            NSRect nSRect = widget.headerRectOfColumn(n, n2, n3);
                                            int n5 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(n5, nSRect, NSRect.sizeof);
                                            return n5;
                                        }
                                        if (n2 == OS.sel_imageRectForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, n3, NSRect.sizeof);
                                            nSRect = widget.imageRectForBounds(n, n2, nSRect);
                                            int n6 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(n6, nSRect, NSRect.sizeof);
                                            return n6;
                                        }
                                        if (n2 == OS.sel_titleRectForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, n3, NSRect.sizeof);
                                            nSRect = widget.titleRectForBounds(n, n2, nSRect);
                                            int n7 = OS.malloc(NSRect.sizeof);
                                            OS.memmove(n7, nSRect, NSRect.sizeof);
                                            return n7;
                                        }
                                        if (n2 == OS.sel_cellSizeForBounds_) {
                                            NSRect nSRect = new NSRect();
                                            OS.memmove(nSRect, n3, NSRect.sizeof);
                                            NSSize nSSize = widget.cellSizeForBounds(n, n2, nSRect);
                                            int n8 = OS.malloc(NSSize.sizeof);
                                            OS.memmove(n8, nSSize, NSSize.sizeof);
                                            return n8;
                                        }
                                        if (n2 == OS.sel_setObjectValue_) {
                                            widget.setObjectValue(n, n2, n3);
                                        } else if (n2 == OS.sel_updateOpenGLContext_) {
                                            widget.updateOpenGLContext(n, n2, n3);
                                        } else {
                                            if (n2 == OS.sel_sizeOfLabel_) {
                                                NSSize nSSize = widget.sizeOfLabel(n, n2, n3 != 0);
                                                int n9 = OS.malloc(NSSize.sizeof);
                                                OS.memmove(n9, nSSize, NSSize.sizeof);
                                                return n9;
                                            }
                                            if (n2 == OS.sel_comboBoxSelectionDidChange_) {
                                                widget.comboBoxSelectionDidChange(n, n2, n3);
                                            } else if (n2 == OS.sel_comboBoxWillDismiss_) {
                                                widget.comboBoxWillDismiss(n, n2, n3);
                                            } else if (n2 == OS.sel_comboBoxWillPopUp_) {
                                                widget.comboBoxWillPopUp(n, n2, n3);
                                            } else if (n2 == OS.sel_drawViewBackgroundInRect_) {
                                                NSRect nSRect = new NSRect();
                                                OS.memmove(nSRect, n3, NSRect.sizeof);
                                                widget.drawViewBackgroundInRect(n, n2, nSRect);
                                            } else if (n2 == OS.sel_drawBackgroundInClipRect_) {
                                                NSRect nSRect = new NSRect();
                                                OS.memmove(nSRect, n3, NSRect.sizeof);
                                                widget.drawBackgroundInClipRect(n, n2, nSRect);
                                            } else if (n2 == OS.sel_windowDidMiniaturize_) {
                                                widget.windowDidMiniturize(n, n2, n3);
                                            } else if (n2 == OS.sel_windowDidDeminiaturize_) {
                                                widget.windowDidDeminiturize(n, n2, n3);
                                            } else if (n2 == OS.sel_windowDidEnterFullScreen_) {
                                                widget.windowDidEnterFullScreen(n, n2, n3);
                                            } else if (n2 == OS.sel_windowDidExitFullScreen_) {
                                                widget.windowDidExitFullScreen(n, n2, n3);
                                            } else if (n2 == OS.sel_touchesBeganWithEvent_) {
                                                widget.touchesBeganWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_touchesMovedWithEvent_) {
                                                widget.touchesMovedWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_touchesEndedWithEvent_) {
                                                widget.touchesEndedWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_touchesCancelledWithEvent_) {
                                                widget.touchesCancelledWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_beginGestureWithEvent_) {
                                                widget.beginGestureWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_endGestureWithEvent_) {
                                                widget.endGestureWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_swipeWithEvent_) {
                                                widget.swipeWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_magnifyWithEvent_) {
                                                widget.magnifyWithEvent(n, n2, n3);
                                            } else if (n2 == OS.sel_rotateWithEvent_) {
                                                widget.rotateWithEvent(n, n2, n3);
                                            } else {
                                                if (n2 == OS.sel_toolbarAllowedItemIdentifiers_) {
                                                    return widget.toolbarAllowedItemIdentifiers(n, n2, n3);
                                                }
                                                if (n2 == OS.sel_toolbarDefaultItemIdentifiers_) {
                                                    return widget.toolbarDefaultItemIdentifiers(n, n2, n3);
                                                }
                                                if (n2 == OS.sel_toolbarSelectableItemIdentifiers_) {
                                                    return widget.toolbarSelectableItemIdentifiers(n, n2, n3);
                                                }
                                                if (n2 == OS.sel_validateMenuItem_) {
                                                    return widget.validateMenuItem(n, n2, n3) ? 1 : 0;
                                                }
                                                if (n2 == OS.sel_readSelectionFromPasteboard_) {
                                                    return widget.readSelectionFromPasteboard(n, n2, n3) ? 1 : 0;
                                                }
                                                if (n2 == OS.sel_viewWillMoveToWindow_) {
                                                    widget.viewWillMoveToWindow(n, n2, n3);
                                                } else if (n2 == OS.sel_cancelOperation_) {
                                                    widget.cancelOperation(n, n2, n3);
                                                } else if (n2 == OS.sel_setShouldExpandItem_) {
                                                    widget.setShouldExpandItem(n, n2, n3 != 0);
                                                } else if (n2 == OS.sel_setShouldScrollClipView_) {
                                                    widget.setShouldScrollClipView(n, n2, n3 != 0);
                                                } else if (n2 == OS.sel_deselectRow_) {
                                                    widget.deselectRow(n, n2, n3);
                                                } else if (n2 == OS.sel_deselectAll_) {
                                                    widget.deselectAll(n, n2, n3);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    static int windowProc(int n, int n2, int n3, int n4) {
        Widget widget = Display.LookupWidget(n, n2);
        if (widget == null) {
            return 0;
        }
        if (n2 == OS.sel_tabView_willSelectTabViewItem_) {
            widget.tabView_willSelectTabViewItem(n, n2, n3, n4);
        } else if (n2 == OS.sel_tabView_didSelectTabViewItem_) {
            widget.tabView_didSelectTabViewItem(n, n2, n3, n4);
        } else {
            if (n2 == OS.sel_outlineView_isItemExpandable_) {
                return widget.outlineView_isItemExpandable(n, n2, n3, n4) ? 1 : 0;
            }
            if (n2 == OS.sel_outlineView_numberOfChildrenOfItem_) {
                return widget.outlineView_numberOfChildrenOfItem(n, n2, n3, n4);
            }
            if (n2 == OS.sel_menu_willHighlightItem_) {
                widget.menu_willHighlightItem(n, n2, n3, n4);
            } else if (n2 == OS.sel_setMarkedText_selectedRange_) {
                widget.setMarkedText_selectedRange(n, n2, n3, n4);
            } else if (n2 == OS.sel_drawInteriorWithFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, n3, NSRect.sizeof);
                widget.drawInteriorWithFrame_inView(n, n2, nSRect, n4);
            } else if (n2 == OS.sel_drawWithExpansionFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, n3, NSRect.sizeof);
                widget.drawWithExpansionFrame_inView(n, n2, nSRect, n4);
            } else {
                if (n2 == OS.sel_accessibilityAttributeValue_forParameter_) {
                    return widget.accessibilityAttributeValue_forParameter(n, n2, n3, n4);
                }
                if (n2 == OS.sel_tableView_didClickTableColumn_) {
                    widget.tableView_didClickTableColumn(n, n2, n3, n4);
                } else if (n2 == OS.sel_outlineView_didClickTableColumn_) {
                    widget.outlineView_didClickTableColumn(n, n2, n3, n4);
                } else {
                    if (n2 == OS.sel_shouldChangeTextInRange_replacementString_) {
                        return widget.shouldChangeTextInRange_replacementString(n, n2, n3, n4) ? 1 : 0;
                    }
                    if (n2 == OS.sel_canDragRowsWithIndexes_atPoint_) {
                        NSPoint nSPoint = new NSPoint();
                        OS.memmove(nSPoint, n4, NSPoint.sizeof);
                        return widget.canDragRowsWithIndexes_atPoint(n, n2, n3, nSPoint) ? 1 : 0;
                    }
                    if (n2 == OS.sel_expandItem_expandChildren_) {
                        widget.expandItem_expandChildren(n, n2, n3, n4 != 0);
                    } else if (n2 == OS.sel_collapseItem_collapseChildren_) {
                        widget.collapseItem_collapseChildren(n, n2, n3, n4 != 0);
                    } else {
                        if (n2 == OS.sel_expansionFrameWithFrame_inView_) {
                            NSRect nSRect = new NSRect();
                            OS.memmove(nSRect, n3, NSRect.sizeof);
                            nSRect = widget.expansionFrameWithFrame_inView(n, n2, nSRect, n4);
                            int n5 = OS.malloc(NSRect.sizeof);
                            OS.memmove(n5, nSRect, NSRect.sizeof);
                            return n5;
                        }
                        if (n2 == OS.sel_drawLabel_inRect_) {
                            NSRect nSRect = new NSRect();
                            OS.memmove(nSRect, n4, NSRect.sizeof);
                            widget.drawLabelInRect(n, n2, n3 == 1, nSRect);
                        } else if (n2 == OS.sel_scrollClipView_toPoint_) {
                            NSPoint nSPoint = new NSPoint();
                            OS.memmove(nSPoint, n4, NSPoint.sizeof);
                            widget.scrollClipViewToPoint(n, n2, n3, nSPoint);
                        } else if (n2 == OS.sel_accessibilitySetValue_forAttribute_) {
                            widget.accessibilitySetValue_forAttribute(n, n2, n3, n4);
                        } else {
                            if (n2 == OS.sel_validRequestorForSendType_returnType_) {
                                return widget.validRequestorForSendType(n, n2, n3, n4);
                            }
                            if (n2 == OS.sel_writeSelectionToPasteboard_types_) {
                                return widget.writeSelectionToPasteboard(n, n2, n3, n4) ? 1 : 0;
                            }
                            if (n2 == OS.sel_outlineView_shouldExpandItem_) {
                                return widget.outlineView_shouldExpandItem_item(n, n2, n3, n4) ? 1 : 0;
                            }
                            if (n2 == OS.sel_selectRowIndexes_byExtendingSelection_) {
                                widget.selectRowIndexes_byExtendingSelection(n, n2, n3, n4 != 0);
                            }
                        }
                    }
                }
            }
        }
        return 0;
    }

    static int windowProc(int n, int n2, int n3, int n4, int n5) {
        Widget widget = Display.LookupWidget(n, n2);
        if (widget == null) {
            return 0;
        }
        if (n2 == OS.sel_tableView_objectValueForTableColumn_row_) {
            return widget.tableView_objectValueForTableColumn_row(n, n2, n3, n4, n5);
        }
        if (n2 == OS.sel_tableView_shouldReorderColumn_toColumn_) {
            return widget.tableView_shouldReorderColumn_toColumn(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_tableView_shouldEditTableColumn_row_) {
            return widget.tableView_shouldEditTableColumn_row(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_outlineView_shouldReorderColumn_toColumn_) {
            return widget.outlineView_shouldReorderColumn_toColumn(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_outlineView_shouldEditTableColumn_item_) {
            return widget.outlineView_shouldEditTableColumn_row(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_textView_clickedOnLink_atIndex_) {
            return widget.textView_clickOnLink_atIndex(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_outlineView_child_ofItem_) {
            return widget.outlineView_child_ofItem(n, n2, n3, n4, n5);
        }
        if (n2 == OS.sel_outlineView_objectValueForTableColumn_byItem_) {
            return widget.outlineView_objectValueForTableColumn_byItem(n, n2, n3, n4, n5);
        }
        if (n2 == OS.sel_textView_willChangeSelectionFromCharacterRange_toCharacterRange_) {
            NSRange nSRange = widget.textView_willChangeSelectionFromCharacterRange_toCharacterRange(n, n2, n3, n4, n5);
            int n6 = OS.malloc(NSRange.sizeof);
            OS.memmove(n6, nSRange, NSRange.sizeof);
            return n6;
        }
        if (n2 == OS.sel_dragSelectionWithEvent_offset_slideBack_) {
            NSSize nSSize = new NSSize();
            OS.memmove(nSSize, n3, NSSize.sizeof);
            return widget.dragSelectionWithEvent(n, n2, n3, n4, n5) ? 1 : 0;
        }
        if (n2 == OS.sel_drawImage_withFrame_inView_) {
            NSRect nSRect = new NSRect();
            OS.memmove(nSRect, n4, NSRect.sizeof);
            widget.drawImageWithFrameInView(n, n2, n3, nSRect, n5);
        } else {
            if (n2 == OS.sel_drawTitle_withFrame_inView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, n4, NSRect.sizeof);
                nSRect = widget.drawTitleWithFrameInView(n, n2, n3, nSRect, n5);
                int n7 = OS.malloc(NSRect.sizeof);
                OS.memmove(n7, nSRect, NSRect.sizeof);
                return n7;
            }
            if (n2 == OS.sel_hitTestForEvent_inRect_ofView_) {
                NSRect nSRect = new NSRect();
                OS.memmove(nSRect, n4, NSRect.sizeof);
                return widget.hitTestForEvent(n, n2, n3, nSRect, n5);
            }
            if (n2 == OS.sel_tableView_writeRowsWithIndexes_toPasteboard_) {
                return widget.tableView_writeRowsWithIndexes_toPasteboard(n, n2, n3, n4, n5) ? 1 : 0;
            }
            if (n2 == OS.sel_outlineView_writeItems_toPasteboard_) {
                return widget.outlineView_writeItems_toPasteboard(n, n2, n3, n4, n5) ? 1 : 0;
            }
            if (n2 == OS.sel_toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar_) {
                return widget.toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(n, n2, n3, n4, n5 != 0);
            }
        }
        return 0;
    }

    static int windowProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Widget widget = Display.LookupWidget(n, n2);
        if (widget == null) {
            return 0;
        }
        if (n2 == OS.sel_tableView_willDisplayCell_forTableColumn_row_) {
            widget.tableView_willDisplayCell_forTableColumn_row(n, n2, n3, n4, n5, n6);
        } else if (n2 == OS.sel_outlineView_willDisplayCell_forTableColumn_item_) {
            widget.outlineView_willDisplayCell_forTableColumn_item(n, n2, n3, n4, n5, n6);
        } else if (n2 == OS.sel_outlineView_setObjectValue_forTableColumn_byItem_) {
            widget.outlineView_setObjectValue_forTableColumn_byItem(n, n2, n3, n4, n5, n6);
        } else if (n2 == OS.sel_tableView_setObjectValue_forTableColumn_row_) {
            widget.tableView_setObjectValue_forTableColumn_row(n, n2, n3, n4, n5, n6);
        } else {
            if (n2 == OS.sel_view_stringForToolTip_point_userData_) {
                return widget.view_stringForToolTip_point_userData(n, n2, n3, n4, n5, n6);
            }
            if (n2 == OS.sel_tableView_shouldTrackCell_forTableColumn_row_) {
                return widget.tableView_shouldTrackCell_forTableColumn_row(n, n2, n3, n4, n5, n6) ? 1 : 0;
            }
            if (n2 == OS.sel_outlineView_shouldTrackCell_forTableColumn_item_) {
                return widget.outlineView_shouldTrackCell_forTableColumn_item(n, n2, n3, n4, n5, n6) ? 1 : 0;
            }
        }
        return 0;
    }
}

