/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gC) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
    }

    void drawImage(Theme theme, Image image, GC gC, Rectangle rectangle) {
        long l = gC.getGCData().drawable;
        Rectangle rectangle2 = image.getBounds();
        int n = this.getStateType(0);
        if (n == 0) {
            gC.drawImage(image, 0, 0, rectangle2.width, rectangle2.height, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            long l2 = ImageList.createPixbuf(image);
            long l3 = OS.gtk_icon_source_new();
            if (l3 != 0L) {
                OS.gtk_icon_source_set_pixbuf(l3, l2);
                long l4 = theme.buttonHandle;
                long l5 = OS.gtk_widget_get_style(l4);
                theme.transferClipping(gC, l5);
                long l6 = OS.gtk_style_render_icon(l5, l3, 0, n, -1, l4, null);
                OS.g_object_unref(l2);
                if (l6 != 0L) {
                    OS.gdk_draw_pixbuf(l, gC.handle, l6, 0, 0, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 1, 0, 0);
                    OS.g_object_unref(l6);
                }
                OS.gtk_icon_source_free(l3);
            }
        }
    }

    void drawText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        long l = this.getTextHandle(theme);
        long l2 = OS.gtk_widget_get_style(l);
        long l3 = gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l4 = OS.gtk_widget_create_pango_layout(l, byArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(l4, nArray, nArray2);
        OS.pango_layout_set_width(l4, rectangle.width * 1024);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        if ((n & 0x10) != 0) {
            OS.pango_layout_set_alignment(l4, 0);
        }
        if ((n & 0x100) != 0) {
            OS.pango_layout_set_alignment(l4, 1);
        }
        if ((n & 0x40) != 0) {
            OS.pango_layout_set_alignment(l4, 2);
        }
        if ((n & 0x200) != 0) {
            n3 += (rectangle.height - OS.PANGO_PIXELS(nArray2[0])) / 2;
        }
        if ((n & 0x80) != 0) {
            n3 += rectangle.height - OS.PANGO_PIXELS(nArray2[0]);
        }
        int n4 = this.getStateType(0);
        byte[] byArray2 = Converter.wcsToMbcs(null, "label", true);
        OS.gtk_paint_layout(l2, l3, n4, false, null, l, byArray2, n2, n3, l4);
        OS.g_object_unref(l4);
    }

    Rectangle getBounds(int n, Rectangle rectangle) {
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    int getStateType(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            n3 = 4;
        } else {
            if ((n2 & 2) != 0) {
                n3 = 1;
            }
            if ((n2 & 0x40) != 0) {
                n3 = (n2 & 8) != 0 ? 1 : 2;
            }
        }
        return n3;
    }

    long getTextHandle(Theme theme) {
        return theme.labelHandle;
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return -1;
    }

    Rectangle measureText(Theme theme, String string, int n, GC gC, Rectangle rectangle) {
        long l = this.getTextHandle(theme);
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        long l2 = OS.gtk_widget_create_pango_layout(l, byArray);
        if (rectangle != null) {
            OS.pango_layout_set_width(l2, rectangle.width);
        }
        if ((n & 0x10) != 0) {
            OS.pango_layout_set_alignment(l2, 0);
        }
        if ((n & 0x100) != 0) {
            OS.pango_layout_set_alignment(l2, 1);
        }
        if ((n & 0x40) != 0) {
            OS.pango_layout_set_alignment(l2, 2);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.pango_layout_get_size(l2, nArray, nArray2);
        OS.g_object_unref(l2);
        return new Rectangle(0, 0, OS.PANGO_PIXELS(nArray[0]), OS.PANGO_PIXELS(nArray2[0]));
    }
}

