/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.vu;

import bl.radio.util.TargetLineFactory;
import bl.radio.vu.VUMeterEvent;
import bl.radio.vu.VUMeterListener;
import ch.qos.logback.classic.Logger;
import java.util.LinkedList;
import javax.sound.sampled.TargetDataLine;
import org.slf4j.LoggerFactory;

public class VUMeterTask
implements Runnable {
    private static Logger logger = (Logger)LoggerFactory.getLogger(VUMeterTask.class);
    private static final int MIN_LEVEL = 10;
    private static final int SAMPLE_POINTS = 300;
    private static final int SOUNDLESS_SAMPLE_POINTS = 270;
    private boolean isSampling;
    private VUMeterListener listener;
    private LinkedList<Integer> vuBuffer;

    public VUMeterTask(VUMeterListener vUMeterListener) {
        this.listener = vUMeterListener;
        this.vuBuffer = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.debug("Start Sampling for Level Meter...");
        this.isSampling = true;
        double d = 20.0 / Math.log(10.0) / 2.0;
        TargetDataLine targetDataLine = null;
        TargetLineFactory targetLineFactory = TargetLineFactory.getInstance();
        try {
            int n;
            byte[] byArray = new byte[256];
            targetDataLine = targetLineFactory.getOpenTargetDataLine();
            targetDataLine.start();
            while ((n = targetDataLine.read(byArray, 0, byArray.length)) > 0) {
                if (!this.isSampling) {
                } else {
                    int n2;
                    int n3 = 0;
                    for (n2 = 0; n2 < n; n2 += 2) {
                        int n4 = (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
                        n4 = n4 < 32728 ? n4 : n4 - 65536;
                        n3 = n4 > n3 ? n4 : n3;
                    }
                    int n5 = (int)Math.round(d * Math.log(n3));
                    this.vuBuffer.add(n5);
                    if (!this.isSampling) {
                    } else {
                        if (this.vuBuffer.size() >= 300) {
                            n2 = this.getLowLevelRate();
                            if (n2 >= 270) {
                                int n6 = this.getZeroLevelRate();
                                if (n6 >= 300) {
                                    if (this.listener != null) {
                                        this.listener.OnSoundless(new VUMeterEvent(n6, 2));
                                        this.isSampling = false;
                                    }
                                } else if (this.listener != null) {
                                    this.listener.OnSoundless(new VUMeterEvent(n2, 1));
                                }
                            }
                            this.vuBuffer.clear();
                        }
                        if (this.isSampling) continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            logger.error("Sampling for Level Meter Error!", (Throwable)exception);
        }
        finally {
            logger.debug("Stop Sampling for Level Meter!");
            if (targetLineFactory != null) {
                targetLineFactory.release();
            }
            System.gc();
        }
    }

    public void stop() {
        this.isSampling = false;
    }

    private int getLowLevelRate() {
        int n = 0;
        for (Integer n2 : this.vuBuffer) {
            if (n2 >= 10) continue;
            ++n;
        }
        return n;
    }

    private int getZeroLevelRate() {
        int n = 0;
        for (Integer n2 : this.vuBuffer) {
            if (n2 != 0) continue;
            ++n;
        }
        return n;
    }

    private void debug(int n) {
        String string = "----+----+====+====+>>>>+>>>>+<<<<+<<<<+";
        logger.debug(string.substring(0, n));
    }
}

