/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.util;

import bl.radio.ConfigBox;
import bl.radio.util.UrlHelper;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public final class WebClientUtil {
    private WebClientUtil() {
    }

    public static HttpResponse getResponse(HttpUriRequest httpUriRequest) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)defaultHttpClient.getParams(), (int)5000);
        HttpResponse httpResponse = null;
        try {
            httpResponse = defaultHttpClient.execute(httpUriRequest);
            StatusLine statusLine = httpResponse.getStatusLine();
            int n = statusLine.getStatusCode();
            if (n == 200 | n == 201) {
                return httpResponse;
            }
            throw new HttpResponseException(n, "");
        }
        catch (Exception exception) {
            defaultHttpClient.getConnectionManager().shutdown();
            httpUriRequest.abort();
            throw new Exception(exception);
        }
    }

    public static void writeRequest(BufferedWriter bufferedWriter, UrlHelper urlHelper) throws Exception {
        bufferedWriter.write("GET " + urlHelper.getPath() + " HTTP/1.0\r\n");
        bufferedWriter.write("Host: " + urlHelper.getHost() + ":" + urlHelper.getPort() + "\r\n");
        bufferedWriter.write("Icy-MetaData:1\r\n");
        bufferedWriter.write("User-Agent:RadioKaras\r\n");
        bufferedWriter.write("Accept:*/*\r\n");
        bufferedWriter.write("\r\n");
        bufferedWriter.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean chkStream(UrlHelper urlHelper) throws Exception {
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(urlHelper.getHost(), urlHelper.getPort());
            try (Socket socket = new Socket();){
                socket.connect(inetSocketAddress, 3000);
                socket.setSoTimeout(3000);
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                     BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));){
                    WebClientUtil.writeRequest(bufferedWriter, urlHelper);
                    String string = bufferedReader.readLine();
                    if (string == null) return true;
                    if (string.equals("")) {
                        return true;
                    }
                    if (string.equals("ICY 200 OK")) return true;
                    if (string.equals("HTTP/1.0 200 OK")) return true;
                    if (string.equals("HTTP/1.1 200 OK")) return true;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<String> sortUrl(List<String> list) throws Exception {
        Object object;
        if (list.size() < 2) {
            return list;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        block29: for (String object22 : list) {
            object = new UrlHelper(object22);
            try {
                long exception = System.currentTimeMillis();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(((UrlHelper)object).getHost(), ((UrlHelper)object).getPort());
                Socket socket = new Socket();
                Throwable throwable = null;
                try {
                    socket.connect(inetSocketAddress, 3000);
                    socket.setSoTimeout(3000);
                    BufferedReader throwable9 = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    Throwable throwable2 = null;
                    try {
                        BufferedWriter throwable7 = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                        Throwable throwable3 = null;
                        try {
                            String throwable5;
                            WebClientUtil.writeRequest(throwable7, (UrlHelper)object);
                            while ((throwable5 = throwable9.readLine()) != null && !throwable5.equals("")) {
                                if (!throwable5.equals("ICY 200 OK") && !throwable5.equals("HTTP/1.0 200 OK") && !throwable5.equals("HTTP/1.1 200 OK")) continue;
                                long l = System.currentTimeMillis();
                                hashMap.put(((UrlHelper)object).toString(), new Long(l - exception));
                                continue block29;
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (throwable7 == null) continue;
                            if (throwable3 != null) {
                                try {
                                    throwable7.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            throwable7.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (throwable9 == null) continue;
                        if (throwable2 != null) {
                            try {
                                throwable9.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        throwable9.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (Exception entry) {}
        }
        ArrayList arrayList = new ArrayList(hashMap.entrySet());
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                return ((Long)entry.getValue()).compareTo((Long)entry2.getValue());
            }
        });
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = arrayList.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            arrayList2.add((String)entry.getKey());
        }
        return arrayList2;
    }

    public static boolean isIpUrl(String string) {
        return WebClientUtil.matchUrl(string, "^(\\d|[01]?\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[01]?\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[01]?\\d\\d|2[0-4]\\d|25[0-5])\\.(\\d|[01]?\\d\\d|2[0-4]\\d|25[0-5])$");
    }

    public static boolean isPublishUrl(String string) {
        return WebClientUtil.matchUrl(string, "^pub.+$");
    }

    private static boolean matchUrl(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length < 2) {
            return false;
        }
        String string3 = stringArray[1].replaceAll("/", "");
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string3);
        return matcher.find();
    }

    public static void queryYouTube(String string) throws Exception {
        String string2 = URLEncoder.encode(string, "UTF-8");
        ConfigBox configBox = ConfigBox.getInstance();
        String string3 = configBox.getStringVal("radioKaras", "youTubeSearchUrl");
        String string4 = MessageFormat.format(string3, string2, string2);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(new URI(string4));
    }
}

