/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.channel;

import bl.radio.channel.ChannelFactory;
import bl.radio.channel.ChannelModel;
import bl.radio.channel.Top5Factory;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class SelfishFactory {
    private SelfishFactory() {
    }

    public static String getConditions(File file) throws Exception {
        Map<String, ChannelModel> map = ChannelFactory.getLoglist(file);
        if (map.size() == 0) {
            return "*";
        }
        ArrayList<Map.Entry<String, ChannelModel>> arrayList = new ArrayList<Map.Entry<String, ChannelModel>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = (Map.Entry)object2;
                ChannelModel channelModel = (ChannelModel)entry.getValue();
                ChannelModel channelModel2 = (ChannelModel)entry2.getValue();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                try {
                    Date date = new Date();
                    Date date2 = simpleDateFormat.parse(channelModel.getListenHour());
                    Date date3 = simpleDateFormat.parse(channelModel2.getListenHour());
                    if (Math.abs(date.getTime() - date2.getTime()) > Math.abs(date.getTime() - date3.getTime())) {
                        return 1;
                    }
                    if (Math.abs(date.getTime() - date2.getTime()) < Math.abs(date.getTime() - date3.getTime())) {
                        return -1;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                return 0;
            }
        });
        Map.Entry<String, ChannelModel> entry = arrayList.get(0);
        ChannelModel channelModel = entry.getValue();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String string = simpleDateFormat.format(date);
        Date date2 = simpleDateFormat2.parse(string + " " + channelModel.getListenHour());
        if (Math.abs(date.getTime() - date2.getTime()) > 0x6DDD00L) {
            List<ChannelModel> list = Top5Factory.getChannels(file);
            if (list.size() == 0) {
                return "*";
            }
            return SelfishFactory.parseConds(list.get(0));
        }
        return SelfishFactory.parseConds(channelModel);
    }

    private static String parseConds(ChannelModel channelModel) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = channelModel.getStation().split(" ");
        for (String string : stringArray) {
            if (string.trim().isEmpty() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        stringArray = channelModel.getDescription().split(" ");
        for (String string : stringArray) {
            if (string.trim().isEmpty() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        stringArray = channelModel.getCategory().split("[ ,|]");
        for (String string : stringArray) {
            if (string.trim().isEmpty() || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            if (string.trim().isEmpty()) continue;
            stringBuilder.append(string);
            stringBuilder.append(",");
        }
        return StringUtils.left((String)stringBuilder.toString(), (int)(stringBuilder.length() - 1));
    }
}

