/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragging;
    int minimum;
    int maximum;
    int thumb;
    int increment = 1;
    int pageIncrement = 10;

    public Slider(Composite composite, int n) {
        super(composite, Slider.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Slider.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            n4 = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            n3 = n4 * 10;
        } else {
            n3 = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            n4 = n3 * 10;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        NSScroller nSScroller = (NSScroller)new SWTScroller().alloc();
        NSRect nSRect = new NSRect();
        if ((this.style & 0x100) != 0) {
            nSRect.width = 1.0;
        } else {
            nSRect.height = 1.0;
        }
        nSScroller.initWithFrame(nSRect);
        nSScroller.setEnabled(true);
        nSScroller.setTarget(nSScroller);
        nSScroller.setAction(OS.sel_sendSelection);
        this.view = nSScroller;
        this.updateBar(0, this.minimum, this.maximum, this.thumb);
    }

    void createWidget() {
        this.maximum = 100;
        this.thumb = 10;
        super.createWidget();
    }

    NSFont defaultNSFont() {
        return this.display.scrollerFont;
    }

    void enableWidget(boolean bl) {
        int n;
        super.enableWidget(bl);
        if (bl && (n = this.maximum - this.thumb - this.minimum) <= 0) {
            ((NSScroller)this.view).setEnabled(false);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller nSScroller = (NSScroller)this.view;
        double d = nSScroller.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * d + (double)this.minimum));
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendSelection() {
        Event event = new Event();
        int n = (int)((NSScroller)this.view).hitPart();
        int n2 = this.getSelection();
        switch (n) {
            case 4: {
                event.detail = 0x1000001;
                n2 -= this.increment;
                break;
            }
            case 1: {
                n2 -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                n2 += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                n2 += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (event.detail != 1) {
            this.setSelection(n2);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n <= this.minimum) {
            return;
        }
        if (n - this.minimum < this.thumb) {
            this.thumb = n - this.minimum;
        }
        int n2 = Math.max(this.minimum, Math.min(this.getSelection(), n - this.thumb));
        this.maximum = n;
        this.updateBar(n2, this.minimum, n, this.thumb);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n >= this.maximum) {
            return;
        }
        if (this.maximum - n < this.thumb) {
            this.thumb = this.maximum - n;
        }
        int n2 = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), n));
        this.minimum = n;
        this.updateBar(n2, n, this.maximum, this.thumb);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.updateBar(n, this.minimum, this.maximum, this.thumb);
    }

    void setSmallSize() {
    }

    void updateBar(int n, int n2, int n3, int n4) {
        NSScroller nSScroller = (NSScroller)this.view;
        n = Math.max(n2, Math.min(n3 - n4, n));
        int n5 = n3 - n4 - n2;
        float f = n5 <= 0 ? 1.0f : (float)(n - n2) / (float)n5;
        float f2 = n5 <= 0 ? 1.0f : (float)n4 / (float)(n3 - n2);
        nSScroller.setDoubleValue(f);
        nSScroller.setKnobProportion(f2);
        nSScroller.setEnabled(n5 > 0);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        n = Math.min(n, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, n);
        this.thumb = n;
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        this.thumb = n4 = Math.min(n4, n3 - n2);
        this.maximum = n3;
        this.minimum = n2;
        this.increment = n5;
        this.pageIncrement = n6;
        this.updateBar(n, n2, n3, n4);
    }
}

