/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.engine.meta;

import bl.radio.StatusBox;
import bl.radio.channel.ChannelModel;
import bl.radio.config.MessageFactory;
import bl.radio.engine.meta.MetaEvent;
import bl.radio.engine.meta.MetaListener;
import bl.radio.util.SystemUtil;
import bl.radio.util.UrlHelper;
import bl.radio.util.WebClientUtil;
import ch.qos.logback.classic.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import org.slf4j.LoggerFactory;

public class MetaStreamer
implements Runnable {
    private static Logger logger = (Logger)LoggerFactory.getLogger(MetaStreamer.class);
    private String url;
    private boolean isPlay;
    private MetaListener listener;
    private ChannelModel channelModel;

    public MetaStreamer(ChannelModel channelModel, String string, MetaListener metaListener) {
        this.url = string;
        this.listener = metaListener;
        this.channelModel = channelModel;
    }

    @Override
    public void run() {
        block2: {
            try {
                this.isPlay = true;
                this.play();
            }
            catch (Exception exception) {
                logger.error(MessageFactory.getMessage("Error.MetaThread"), (Throwable)exception);
                MetaEvent metaEvent = new MetaEvent(null, null, this.channelModel);
                metaEvent.setHasError(true);
                if (this.listener == null) break block2;
                this.listener.notifyMetadata(metaEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void play() throws Exception {
        logger.debug("[Meta]Start Streaming Metadata...");
        StatusBox statusBox = StatusBox.getInstance();
        String string = "";
        UrlHelper urlHelper = null;
        try {
            urlHelper = new UrlHelper(this.url);
            statusBox.setUrl(urlHelper.toString());
        }
        catch (Exception exception) {
            logger.debug("[Meta]Bad URL Streaming Metadata!!");
            return;
        }
        try {
            Throwable throwable;
            Socket socket;
            while (this.isPlay) {
                block116: {
                    Object[] objectArray;
                    Throwable throwable2;
                    BufferedWriter bufferedWriter;
                    Throwable throwable3;
                    Closeable closeable;
                    int n = 0;
                    String string2 = statusBox.getStation();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(urlHelper.getHost(), urlHelper.getPort());
                    socket = new Socket();
                    throwable = null;
                    try {
                        socket.connect(inetSocketAddress, 3000);
                        socket.setSoTimeout(3000);
                        closeable = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        throwable3 = null;
                        try {
                            bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                            throwable2 = null;
                            try {
                                String string3;
                                WebClientUtil.writeRequest(bufferedWriter, urlHelper);
                                logger.debug("[Meta]Get Header...");
                                int n2 = 0;
                                while ((string3 = ((BufferedReader)closeable).readLine()) != null) {
                                    logger.debug("[Meta]Response -> " + string3);
                                    if (string3.equals("")) break;
                                    if (n2 == 0) {
                                        logger.debug("[Meta]Response Check...");
                                        if (!string3.equals("ICY 200 OK") && !string3.equals("HTTP/1.0 200 OK")) {
                                            logger.debug("[Meta]Response Error!");
                                            if (this.listener != null) {
                                                this.listener.notifyMetadata(new MetaEvent(null, urlHelper.toString(), this.channelModel));
                                            }
                                            this.isPlay = false;
                                            break;
                                        }
                                    }
                                    int n3 = 0;
                                    objectArray = string3.split(":");
                                    if (objectArray.length > 1) {
                                        if (objectArray[0].toLowerCase().startsWith("icy-name")) {
                                            string2 = objectArray[1].trim();
                                            ++n3;
                                        }
                                        if (objectArray[0].toLowerCase().startsWith("icy-metaint")) {
                                            String string4 = objectArray[1].trim();
                                            n = Integer.parseInt(string4);
                                            ++n3;
                                        }
                                    }
                                    if (n3 == 2) break;
                                    ++n2;
                                }
                                logger.debug("[Meta]End Header...");
                                if (n == 0) {
                                    logger.debug("[Meta]NotFound icy-metaint !!");
                                    if (this.listener != null) {
                                        this.listener.notifyMetadata(new MetaEvent(null, urlHelper.toString(), this.channelModel));
                                    }
                                    this.isPlay = false;
                                    return;
                                }
                                if (!this.isPlay) {
                                    return;
                                }
                            }
                            catch (Throwable throwable4) {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (bufferedWriter != null) {
                                    if (throwable2 != null) {
                                        try {
                                            bufferedWriter.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                        }
                                    } else {
                                        bufferedWriter.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable3 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (closeable != null) {
                                if (throwable3 != null) {
                                    try {
                                        ((BufferedReader)closeable).close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable3.addSuppressed(throwable7);
                                    }
                                } else {
                                    ((BufferedReader)closeable).close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (socket != null) {
                            if (throwable != null) {
                                try {
                                    socket.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable.addSuppressed(throwable9);
                                }
                            } else {
                                socket.close();
                            }
                        }
                    }
                    socket = new Socket();
                    throwable = null;
                    socket.connect(inetSocketAddress, 3000);
                    socket.setSoTimeout(3000);
                    closeable = socket.getInputStream();
                    throwable3 = null;
                    try {
                        bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                        throwable2 = null;
                        try {
                            WebClientUtil.writeRequest(bufferedWriter, urlHelper);
                            logger.debug("[Meta]Start Stream Data...");
                            byte[] byArray = new byte[1];
                            LinkedList<Integer> linkedList = new LinkedList<Integer>();
                            while (true) {
                                ((InputStream)closeable).read(byArray);
                                linkedList.add(new Integer(byArray[0]));
                                if (linkedList.size() != 4) continue;
                                if ((Integer)linkedList.get(0) == 13 && (Integer)linkedList.get(1) == 10 && (Integer)linkedList.get(2) == 13 && (Integer)linkedList.get(3) == 10) {
                                    logger.debug("End Header...");
                                    break;
                                }
                                linkedList.pollFirst();
                            }
                            while (this.isPlay) {
                                objectArray = new byte[1];
                                for (int i = 0; i < n; i += ((InputStream)closeable).read((byte[])objectArray)) {
                                }
                                ((InputStream)closeable).read((byte[])objectArray);
                                String string5 = objectArray[0];
                                if (string5 <= 0) continue;
                                if (string5 > 256) {
                                    logger.debug("[Meta]Too long MetaDate! Restarting MetaStream...");
                                    break;
                                }
                                byte[] byArray2 = new byte[16 * string5];
                                ((InputStream)closeable).read(byArray2);
                                String string6 = new String(byArray2, "UTF-8");
                                logger.info("[Meta]Meta Data Read..." + string6);
                                if (!string6.startsWith("StreamTitle")) {
                                    logger.debug("[Meta]Broken MetaData! Restarting MetaStream...");
                                    break;
                                }
                                if (SystemUtil.matchTag(string6)) {
                                    logger.debug("[Meta]Finding TAG or Jingle! Restarting MetaStream...");
                                    break;
                                }
                                if (string2 != null) {
                                    statusBox.setStation(string2);
                                }
                                if (string.equals(string6)) continue;
                                string = string6;
                                String[] stringArray = string6.split(";");
                                string6 = stringArray[0].replaceAll("StreamTitle=", "").replaceAll("'", "");
                                statusBox.setSong(string6);
                                logger.debug("[Meta]Get MetaStream Form SongData..." + string6);
                                if (this.listener == null) continue;
                                this.listener.notifyMetadata(new MetaEvent(string6, urlHelper.toString(), this.channelModel));
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable2 = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (bufferedWriter != null) {
                                if (throwable2 != null) {
                                    try {
                                        bufferedWriter.close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable2.addSuppressed(throwable11);
                                    }
                                } else {
                                    bufferedWriter.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable3 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (closeable != null) {
                            if (throwable3 != null) {
                                try {
                                    ((InputStream)closeable).close();
                                }
                                catch (Throwable throwable13) {
                                    throwable3.addSuppressed(throwable13);
                                }
                            } else {
                                ((InputStream)closeable).close();
                            }
                        }
                    }
                    if (socket == null) continue;
                    if (throwable == null) break block116;
                    try {
                        socket.close();
                        continue;
                    }
                    catch (Throwable throwable14) {
                        throwable.addSuppressed(throwable14);
                        continue;
                    }
                }
                socket.close();
            }
            return;
            catch (Throwable throwable15) {
                try {
                    throwable = throwable15;
                    throw throwable15;
                }
                catch (Throwable throwable16) {
                    if (socket == null) throw throwable16;
                    if (throwable != null) {
                        try {
                            socket.close();
                            throw throwable16;
                        }
                        catch (Throwable throwable17) {
                            throwable.addSuppressed(throwable17);
                            throw throwable16;
                        }
                    }
                    socket.close();
                    throw throwable16;
                }
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            logger.debug("[Meta]SocketTimeout...");
            if (this.listener == null) return;
            this.listener.notifyMetadata(new MetaEvent(null, urlHelper.toString(), this.channelModel));
            return;
        }
        catch (Exception exception) {
            logger.error("[Meta] Error!", (Throwable)exception);
            return;
        }
        finally {
            this.isPlay = false;
            System.gc();
            logger.debug("[Meta]Stop Streaming Metadata...");
        }
    }

    public boolean isPlay() {
        return this.isPlay;
    }

    public void stop() {
        this.isPlay = false;
    }
}

