/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int tabs;
    int oldStart;
    int oldEnd;
    boolean doubleClick;
    boolean ignoreModify;
    boolean ignoreVerify;
    boolean ignoreCharacter;
    boolean allowPasswordChar;
    String message;
    int[] segments;
    int clearSegmentsCount = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    public static final int LIMIT = OS.IsWinNT ? Integer.MAX_VALUE : Short.MAX_VALUE;
    public static final String DELIMITER = "\r\n";
    static final int EditProc;
    static final TCHAR EditClass;

    static {
        EditClass = new TCHAR(0, "EDIT", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, EditClass, wNDCLASS);
        EditProc = wNDCLASS.lpfnWndProc;
    }

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        int n5;
        if (this.handle == 0) {
            return 0;
        }
        boolean bl = false;
        switch (n2) {
            case 20: {
                if (this.findImageControl() == null) break;
                return 0;
            }
            case 276: 
            case 277: {
                boolean bl2 = bl = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 0, 0);
                break;
            }
            case 15: {
                n5 = this.findImageControl() != null ? 1 : 0;
                boolean bl3 = false;
                if ((this.style & 4) != 0 && this.message.length() > 0 && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                    boolean bl4 = bl3 = n != OS.GetFocus() && OS.GetWindowTextLength(this.handle) == 0;
                }
                if (n5 == 0 && !bl3) break;
                int n6 = 0;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                n6 = OS.BeginPaint(this.handle, pAINTSTRUCT);
                int n7 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n8 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n7 != 0 && n8 != 0) {
                    RECT rECT;
                    int n9 = n6;
                    int n10 = 0;
                    int n11 = 0;
                    POINT pOINT = null;
                    POINT pOINT2 = null;
                    if (n5 != 0) {
                        n9 = OS.CreateCompatibleDC(n6);
                        pOINT = new POINT();
                        pOINT2 = new POINT();
                        OS.SetWindowOrgEx(n9, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT);
                        OS.SetBrushOrgEx(n9, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT2);
                        n10 = OS.CreateCompatibleBitmap(n6, n7, n8);
                        n11 = OS.SelectObject(n9, n10);
                        rECT = new RECT();
                        OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                        this.drawBackground(n9, rECT);
                    }
                    OS.CallWindowProc(EditProc, n, 15, n9, n4);
                    if (bl3) {
                        boolean bl5;
                        rECT = new RECT();
                        OS.GetClientRect(this.handle, rECT);
                        int n12 = OS.SendMessage(this.handle, 212, 0, 0);
                        rECT.left += OS.LOWORD(n12);
                        rECT.right -= OS.HIWORD(n12);
                        if ((this.style & 0x800) != 0) {
                            ++rECT.left;
                            ++rECT.top;
                            --rECT.right;
                            --rECT.bottom;
                        }
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), this.message, false);
                        int n13 = 8192;
                        boolean bl6 = bl5 = (this.style & 0x4000000) != 0;
                        if (bl5) {
                            n13 |= 0x20000;
                        }
                        int n14 = this.style & 0x1024000;
                        switch (n14) {
                            case 16384: {
                                n13 |= bl5 ? 2 : 0;
                                break;
                            }
                            case 0x1000000: {
                                n13 |= 1;
                            }
                            case 131072: {
                                n13 |= bl5 ? 0 : 2;
                            }
                        }
                        int n15 = OS.SendMessage(n, 49, 0, 0);
                        int n16 = OS.SelectObject(n9, n15);
                        OS.SetTextColor(n9, OS.GetSysColor(OS.COLOR_GRAYTEXT));
                        OS.SetBkMode(n9, 1);
                        OS.DrawText(n9, tCHAR, tCHAR.length(), rECT, n13);
                        OS.SelectObject(n9, n16);
                    }
                    if (n5 != 0) {
                        OS.SetWindowOrgEx(n9, pOINT.x, pOINT.y, null);
                        OS.SetBrushOrgEx(n9, pOINT2.x, pOINT2.y, null);
                        OS.BitBlt(n6, pAINTSTRUCT.left, pAINTSTRUCT.top, n7, n8, n9, 0, 0, 0xCC0020);
                        OS.SelectObject(n9, n11);
                        OS.DeleteObject(n10);
                        OS.DeleteObject(n9);
                    }
                }
                OS.EndPaint(this.handle, pAINTSTRUCT);
                return 0;
            }
        }
        n5 = OS.CallWindowProc(EditProc, n, n2, n3, n4);
        switch (n2) {
            case 276: 
            case 277: {
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return n5;
    }

    void createHandle() {
        super.createHandle();
        OS.SendMessage(this.handle, 197, 0, 0);
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x100;
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        int n = OS.GetWindowTextLength(this.handle);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, n, n, null)) == null) {
            return;
        }
        OS.SendMessage(this.handle, 177, n, n);
        this.clearSegments(true);
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, tCHAR);
        this.ignoreCharacter = false;
        OS.SendMessage(this.handle, 183, 0, 0);
        this.applySegments();
    }

    void applySegments() {
        int n;
        if (--this.clearSegmentsCount != 0) {
            return;
        }
        if (!this.hooks(49) && !this.filters(49)) {
            return;
        }
        int n2 = OS.GetWindowTextLength(this.handle);
        int n3 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n3, n2 + 1);
        if (n2 > 0) {
            OS.GetWindowText(this.handle, tCHAR, n2 + 1);
        }
        String string = tCHAR.toString(0, n2);
        Event event = new Event();
        event.text = string;
        event.segments = this.segments;
        this.sendEvent(49, event);
        this.segments = event.segments;
        if (this.segments == null) {
            return;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return;
        }
        n2 = string == null ? 0 : string.length();
        int n5 = 1;
        while (n5 < n4) {
            if (event.segments[n5] < event.segments[n5 - 1] || event.segments[n5] > n2) {
                this.error(5);
            }
            ++n5;
        }
        n5 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        OS.SendMessage(this.handle, 197, n5 + Math.min(n4, LIMIT - n5), 0);
        char[] cArray = event.segmentsChars;
        char[] cArray2 = new char[(n2 += n4) + 1];
        int n6 = 0;
        int n7 = 0;
        int n8 = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (n6 < n2) {
            if (n7 < n4 && n6 - n7 == this.segments[n7]) {
                n = cArray != null && cArray.length > n7 ? cArray[n7] : n8;
                cArray2[n6++] = n;
                ++n7;
                continue;
            }
            if (string == null) continue;
            cArray2[n6] = string.charAt(n6++ - n7);
        }
        while (n7 < n4) {
            this.segments[n7] = n6 - n7;
            n = cArray != null && cArray.length > n7 ? cArray[n7] : n8;
            cArray2[n6++] = n;
            ++n7;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        boolean bl = this.ignoreCharacter;
        boolean bl2 = this.ignoreModify;
        boolean bl3 = this.ignoreVerify;
        this.ignoreVerify = true;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        cArray2[n2] = '\u0000';
        tCHAR = new TCHAR(n3, cArray2, false);
        OS.SendMessage(this.handle, 177, 0, -1);
        int n9 = OS.SendMessage(this.handle, 198, 0, 0);
        OS.SendMessage(this.handle, 194, n9, tCHAR);
        nArray[0] = this.translateOffset(nArray[0]);
        nArray2[0] = this.translateOffset(nArray2[0]);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl;
        this.ignoreModify = bl2;
        this.ignoreVerify = bl3;
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    void clearSegments(boolean bl) {
        if (this.clearSegmentsCount++ != 0) {
            return;
        }
        if (this.segments == null) {
            return;
        }
        int n = this.segments.length;
        if (n == 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (n2 < LIMIT) {
            OS.SendMessage(this.handle, 197, Math.max(1, n2 - n), 0);
        }
        if (!bl) {
            this.segments = null;
            return;
        }
        boolean bl2 = this.ignoreCharacter;
        boolean bl3 = this.ignoreModify;
        boolean bl4 = this.ignoreVerify;
        this.ignoreVerify = true;
        this.ignoreModify = true;
        this.ignoreCharacter = true;
        int n3 = OS.GetWindowTextLength(this.handle);
        int n4 = this.getCodePage();
        TCHAR tCHAR = new TCHAR(n4, n3 + 1);
        if (n3 > 0) {
            OS.GetWindowText(this.handle, tCHAR, n3 + 1);
        }
        tCHAR = this.deprocessText(tCHAR, 0, -1, true);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        nArray[0] = this.untranslateOffset(nArray[0]);
        nArray2[0] = this.untranslateOffset(nArray2[0]);
        this.segments = null;
        OS.SendMessage(this.handle, 177, 0, -1);
        int n5 = OS.SendMessage(this.handle, 198, 0, 0);
        OS.SendMessage(this.handle, 194, n5, tCHAR);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.wcsToMbcsPos(nArray[0]);
            nArray2[0] = this.wcsToMbcsPos(nArray2[0]);
        }
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = bl2;
        this.ignoreModify = bl3;
        this.ignoreVerify = bl4;
    }

    public void clearSelection() {
        this.checkWidget();
        if (OS.IsWinCE) {
            int[] nArray = new int[1];
            OS.SendMessage(this.handle, 176, null, nArray);
            OS.SendMessage(this.handle, 177, nArray[0], nArray[0]);
        } else {
            OS.SendMessage(this.handle, 177, -1, 0);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            int n5;
            TCHAR tCHAR;
            int n6;
            boolean bl2;
            int n7 = 0;
            int n8 = OS.GetDC(this.handle);
            int n9 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n9 != 0) {
                n7 = OS.SelectObject(n8, n9);
            }
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n8, tEXTMETRIC);
            int n10 = (this.style & 4) != 0 ? 1 : OS.SendMessage(this.handle, 186, 0, 0);
            n3 = n10 * tEXTMETRIC.tmHeight;
            RECT rECT = new RECT();
            int n11 = 11264;
            boolean bl3 = bl2 = (this.style & 2) != 0 && (this.style & 0x40) != 0;
            if (bl2 && n != -1) {
                n11 |= 0x10;
                rECT.right = n;
            }
            if ((n6 = OS.GetWindowTextLength(this.handle)) != 0) {
                tCHAR = new TCHAR(this.getCodePage(), n6 + 1);
                OS.GetWindowText(this.handle, tCHAR, n6 + 1);
                OS.DrawText(n8, tCHAR, n6, rECT, n11);
                n4 = rECT.right - rECT.left;
            }
            if (bl2 && n2 == -1 && (n5 = rECT.bottom - rECT.top) != 0) {
                n3 = n5;
            }
            if ((this.style & 4) != 0 && this.message.length() > 0) {
                OS.SetRect(rECT, 0, 0, 0, 0);
                tCHAR = new TCHAR(this.getCodePage(), this.message, false);
                OS.DrawText(n8, tCHAR, tCHAR.length(), rECT, n11);
                n4 = Math.max(n4, rECT.right - rECT.left);
            }
            if (n9 != 0) {
                OS.SelectObject(n8, n7);
            }
            OS.ReleaseDC(this.handle, n8);
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n4, n3);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = OS.SendMessage(this.handle, 212, 0, 0);
        rectangle.x -= OS.LOWORD(n5);
        rectangle.width += OS.LOWORD(n5) + OS.HIWORD(n5);
        if ((this.style & 0x100) != 0) {
            ++rectangle.width;
        }
        if ((this.style & 0x800) != 0) {
            --rectangle.x;
            --rectangle.y;
            rectangle.width += 2;
            rectangle.height += 2;
        }
        return rectangle;
    }

    public void copy() {
        this.checkWidget();
        OS.SendMessage(this.handle, 769, 0, 0);
    }

    void createWidget() {
        super.createWidget();
        this.message = "";
        this.doubleClick = true;
        this.tabs = 8;
        this.setTabStops(8);
        this.fixAlignment();
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 768, 0, 0);
    }

    int defaultBackground() {
        int n = OS.GetWindowLong(this.handle, -16);
        return OS.GetSysColor((n & 0x800) != 0 ? OS.COLOR_3DFACE : OS.COLOR_WINDOW);
    }

    TCHAR deprocessText(TCHAR tCHAR, int n, int n2, boolean bl) {
        int n3;
        char[] cArray;
        if (tCHAR == null) {
            return null;
        }
        int n4 = tCHAR.length();
        if (n < 0) {
            n = 0;
        }
        if (OS.IsUnicode) {
            cArray = tCHAR.chars;
            if (tCHAR.chars[n4 - 1] == '\u0000') {
                --n4;
            }
        } else {
            cArray = new char[n4];
            n4 = OS.MultiByteToWideChar(this.getCodePage(), 1, tCHAR.bytes, n4, cArray, n4);
        }
        if (n2 == -1) {
            n2 = n4;
        }
        if (this.segments != null && n2 > this.segments[0] && (n3 = this.segments.length) > 0 && n <= this.segments[n3 - 1]) {
            int n5 = 0;
            while (n - n5 > this.segments[n5]) {
                ++n5;
            }
            int n6 = n5;
            int n7 = n;
            while (n7 < n2) {
                if (n6 < n3 && n7 - n6 == this.segments[n6]) {
                    ++n6;
                } else {
                    cArray[n7 - n6 + n5] = cArray[n7];
                }
                ++n7;
            }
            n4 = n2 - n - n6 + n5;
        }
        if (n != 0 || n2 != n4) {
            char[] cArray2 = new char[n4];
            System.arraycopy(cArray, n, cArray2, 0, n4);
            return new TCHAR(this.getCodePage(), cArray2, bl);
        }
        return tCHAR;
    }

    boolean dragDetect(int n, int n2, int n3, boolean bl, boolean[] blArray, boolean[] blArray2) {
        if (bl) {
            int n4;
            int n5;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.SendMessage(this.handle, 176, nArray, nArray2);
            if (nArray[0] != nArray2[0] && nArray[0] <= (n5 = OS.LOWORD(OS.SendMessage(this.handle, 215, 0, n4 = OS.MAKELPARAM(n2, n3)))) && n5 < nArray2[0] && super.dragDetect(n, n2, n3, bl, blArray, blArray2)) {
                if (blArray2 != null) {
                    blArray2[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, n3, bl, blArray, blArray2);
    }

    void fixAlignment() {
        if ((this.style & 0x8000000) != 0) {
            return;
        }
        int n = OS.GetWindowLong(this.handle, -20);
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((this.style & 0x2000000) != 0) {
            n &= 0xFFFFBFFF;
            if ((this.style & 0x20000) != 0) {
                n |= 0x1000;
                n2 |= 2;
            }
            if ((this.style & 0x4000) != 0) {
                n &= 0xFFFFEFFF;
                n2 &= 0xFFFFFFFD;
            }
        } else {
            if ((this.style & 0x20000) != 0) {
                n &= 0xFFFFEFFF;
                n2 &= 0xFFFFFFFD;
            }
            if ((this.style & 0x4000) != 0) {
                n |= 0x1000;
                n2 |= 2;
            }
        }
        if ((this.style & 0x1000000) != 0) {
            n2 |= 1;
        }
        OS.SetWindowLong(this.handle, -20, n);
        OS.SetWindowLong(this.handle, -16, n2);
    }

    public int getBorderWidth() {
        this.checkWidget();
        return super.getBorderWidth();
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 201, -1, 0);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        int n = this.translateOffset(this.getCaretPosition());
        int n2 = OS.SendMessage(this.handle, 214, n, 0);
        if (n2 == -1) {
            n2 = 0;
            if (n >= OS.GetWindowTextLength(this.handle)) {
                int n3 = this.getCodePage();
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                OS.SendMessage(this.handle, 177, n, n);
                this.ignoreModify = true;
                this.ignoreCharacter = true;
                OS.SendMessage(this.handle, 194, 0, new TCHAR(n3, " ", true));
                n2 = OS.SendMessage(this.handle, 214, n, 0);
                OS.SendMessage(this.handle, 177, n, n + 1);
                OS.SendMessage(this.handle, 194, 0, new TCHAR(n3, "", true));
                this.ignoreModify = false;
                this.ignoreCharacter = false;
                OS.SendMessage(this.handle, 177, nArray[0], nArray[0]);
                OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
            }
        }
        return new Point(OS.GET_X_LPARAM(n2), OS.GET_Y_LPARAM(n2));
    }

    public int getCaretPosition() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        int n = nArray[0];
        if (nArray[0] != nArray2[0]) {
            int n2;
            int n3 = OS.SendMessage(this.handle, 201, nArray[0], 0);
            if (n3 == (n2 = OS.SendMessage(this.handle, 201, nArray2[0], 0))) {
                if (!OS.IsWinCE) {
                    POINT pOINT;
                    int n4 = OS.GetWindowThreadProcessId(this.handle, null);
                    GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
                    gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
                    if (OS.GetGUIThreadInfo(n4, gUITHREADINFO) && (gUITHREADINFO.hwndCaret == this.handle || gUITHREADINFO.hwndCaret == 0) && OS.GetCaretPos(pOINT = new POINT())) {
                        int n5 = OS.SendMessage(this.handle, 214, nArray2[0], 0);
                        if (n5 == -1) {
                            int n6 = OS.SendMessage(this.handle, 214, nArray[0], 0);
                            int n7 = OS.GET_X_LPARAM(n6);
                            if (pOINT.x > n7) {
                                n = nArray2[0];
                            }
                        } else {
                            int n8 = OS.GET_X_LPARAM(n5);
                            if (pOINT.x >= n8) {
                                n = nArray2[0];
                            }
                        }
                    }
                }
            } else {
                int n9 = OS.SendMessage(this.handle, 187, -1, 0);
                int n10 = OS.SendMessage(this.handle, 201, n9, 0);
                if (n10 == n2) {
                    n = nArray2[0];
                }
            }
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.mbcsToWcsPos(n);
        }
        return this.untranslateOffset(n);
    }

    public int getCharCount() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.mbcsToWcsPos(n);
        }
        return this.untranslateOffset(n);
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 210, 0, 0);
        if (n != 0 && (n = Display.mbcsToWcs(n, this.getCodePage())) == 0) {
            n = 42;
        }
        return (char)n;
    }

    public boolean getEditable() {
        this.checkWidget();
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 0x800) == 0;
    }

    public int getLineCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 186, 0, 0);
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n2, tEXTMETRIC);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        return tEXTMETRIC.tmHeight;
    }

    public int getOrientation() {
        return super.getOrientation();
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = OS.MAKELPARAM(point.x, point.y);
        int n2 = OS.LOWORD(OS.SendMessage(this.handle, 215, 0, n));
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n2 = this.mbcsToWcsPos(n2);
        }
        return this.untranslateOffset(n2);
    }

    public Point getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            nArray[0] = this.mbcsToWcsPos(nArray[0]);
            nArray2[0] = this.mbcsToWcsPos(nArray2[0]);
        }
        return new Point(this.untranslateOffset(nArray[0]), this.untranslateOffset(nArray2[0]));
    }

    public int getSelectionCount() {
        this.checkWidget();
        Point point = this.getSelection();
        return point.y - point.x;
    }

    public String getSelectionText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (nArray[0] == nArray2[0]) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, nArray[0], nArray2[0], false);
            return tCHAR.toString();
        }
        return tCHAR.toString(nArray[0], nArray2[0] - nArray[0]);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    int getTabWidth(int n) {
        int n2 = 0;
        RECT rECT = new RECT();
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = 3104;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), " ", false);
        OS.DrawText(n3, tCHAR, tCHAR.length(), rECT, n5);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        return (rECT.right - rECT.left) * n;
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
            return tCHAR.toString();
        }
        return tCHAR.toString(0, n);
    }

    public char[] getTextChars() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return new char[0];
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        if (this.segments != null) {
            tCHAR = this.deprocessText(tCHAR, 0, -1, false);
        }
        char[] cArray = new char[n];
        System.arraycopy(tCHAR.chars, 0, cArray, 0, n);
        return cArray;
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || n2 < 0) {
            return "";
        }
        int n3 = OS.GetWindowTextLength(this.handle);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n3 = this.mbcsToWcsPos(n3);
        }
        if (n > (n2 = Math.min(n2, this.untranslateOffset(n3) - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return this.getText().substring(n, n2 + 1);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (this.segments != null && n < LIMIT) {
            n = Math.max(1, n - this.segments.length);
        }
        return n;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return OS.SendMessage(this.handle, 206, 0, 0);
    }

    public int getTopPixel() {
        this.checkWidget();
        int[] nArray = new int[2];
        int n = OS.SendMessage(this.handle, 1245, 0, nArray);
        if (n == 1) {
            return nArray[1];
        }
        return this.getTopIndex() * this.getLineHeight();
    }

    public void insert(String string) {
        Object object;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if (this.hooks(25) || this.filters(25)) {
            object = new int[1];
            int[] nArray = new int[1];
            OS.SendMessage(this.handle, 176, object, nArray);
            string = this.verifyText(string, object[0], nArray[0], null);
            if (string == null) {
                return;
            }
        }
        this.clearSegments(true);
        object = new TCHAR(this.getCodePage(), string, true);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
        this.ignoreCharacter = false;
        this.applySegments();
    }

    int mbcsToWcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = this.getCodePage();
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[128];
        String string = this.getLineDelimiter();
        int n5 = string.length();
        int n6 = OS.SendMessageA(this.handle, 186, 0, 0);
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            int n9 = 0;
            int n10 = OS.SendMessageA(this.handle, 187, n7, 0);
            int n11 = OS.SendMessageA(this.handle, 193, n10, 0);
            if (n11 != 0) {
                if (n11 + n5 > byArray.length) {
                    byArray = new byte[n11 + n5];
                }
                byArray[0] = (byte)(n11 & 0xFF);
                byArray[1] = (byte)(n11 >> 8);
                n11 = OS.SendMessageA(this.handle, 196, n7, byArray);
                n9 = OS.MultiByteToWideChar(n2, 1, byArray, n11, null, 0);
            }
            if (n7 - 1 != n6) {
                n8 = 0;
                while (n8 < n5) {
                    byArray[n11++] = (byte)string.charAt(n8);
                    ++n8;
                }
                n9 += n5;
            }
            if (n4 + n11 >= n) {
                n8 = n - n4;
                n9 = OS.MultiByteToWideChar(n2, 1, byArray, n8, null, 0);
                return n3 + n9;
            }
            n3 += n9;
            n4 += n11;
            ++n7;
        }
        return n3;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 770, 0, 0);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.message = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 177, 0, -1);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        String string;
        Object object;
        if (!super.sendKeyEvent(n, n2, n3, n4, event)) {
            return false;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (this.ignoreVerify) {
            return true;
        }
        if (n != 1) {
            return true;
        }
        if (n2 != 258 && n2 != 256 && n2 != 646) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return true;
        }
        char c = event.character;
        int n5 = event.stateMask;
        switch (n2) {
            case 258: {
                if (c != '\b' && c != '\u007f' && c != '\r' && c != '\t' && c != '\n') break;
            }
            case 256: {
                if ((n5 & 0x70000) == 0) break;
                return false;
            }
        }
        if (OS.GetKeyState(1) < 0 && this.handle == OS.GetCapture()) {
            return true;
        }
        String string2 = "";
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        switch (c) {
            case '\b': {
                if (nArray[0] != nArray2[0]) break;
                if (nArray[0] == 0) {
                    return true;
                }
                int n6 = OS.SendMessage(this.handle, 187, -1, 0);
                if (nArray[0] == n6) {
                    nArray[0] = nArray[0] - DELIMITER.length();
                } else {
                    nArray[0] = nArray[0] - 1;
                    if (!OS.IsUnicode && OS.IsDBLocale) {
                        object = new int[1];
                        int[] nArray3 = new int[1];
                        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
                        OS.SendMessage(this.handle, 176, (int[])object, nArray3);
                        if (nArray[0] != object[0]) {
                            nArray[0] = nArray[0] - 1;
                        }
                    }
                }
                nArray[0] = Math.max(nArray[0], 0);
                break;
            }
            case '\u007f': {
                if (nArray[0] != nArray2[0]) break;
                int n6 = OS.GetWindowTextLength(this.handle);
                if (nArray[0] == n6) {
                    return true;
                }
                int n7 = OS.SendMessage(this.handle, 201, nArray2[0], 0);
                int n8 = OS.SendMessage(this.handle, 187, n7 + 1, 0);
                if (nArray2[0] == n8 - DELIMITER.length()) {
                    nArray2[0] = nArray2[0] + DELIMITER.length();
                } else {
                    nArray2[0] = nArray2[0] + 1;
                    if (!OS.IsUnicode && OS.IsDBLocale) {
                        int[] nArray4 = new int[1];
                        int[] nArray5 = new int[1];
                        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
                        OS.SendMessage(this.handle, 176, nArray4, nArray5);
                        if (nArray2[0] != nArray5[0]) {
                            nArray2[0] = nArray2[0] + 1;
                        }
                    }
                }
                nArray2[0] = Math.min(nArray2[0], n6);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                string2 = DELIMITER;
                break;
            }
            default: {
                if (c != '\t' && c < ' ') {
                    return true;
                }
                string2 = new String(new char[]{c});
            }
        }
        if ((string = this.verifyText(string2, nArray[0], nArray2[0], event)) == null) {
            return false;
        }
        if (string == string2) {
            return true;
        }
        string = Display.withCrLf(string);
        object = new TCHAR(this.getCodePage(), string, true);
        OS.SendMessage(this.handle, 177, nArray[0], nArray2[0]);
        this.ignoreCharacter = true;
        OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
        this.ignoreCharacter = false;
        return false;
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        int n6;
        Object object;
        int n7;
        int n8;
        if ((n5 & 1) == 0 && n3 != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            n8 = OS.SendMessage(this.handle, 212, 0, 0);
            n7 = OS.LOWORD(n8) + OS.HIWORD(n8);
            if (rECT.right - rECT.left <= n7) {
                int[] nArray = new int[1];
                object = new int[1];
                OS.SendMessage(this.handle, 176, nArray, object);
                if (nArray[0] != 0 || object[0] != 0) {
                    this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
                    OS.SendMessage(this.handle, 177, 0, 0);
                    OS.SendMessage(this.handle, 177, nArray[0], object[0]);
                    return;
                }
            }
        }
        super.setBounds(n, n2, n3, n4, n5);
        if ((n5 & 1) == 0 && ((n6 = OS.GetWindowLong(this.handle, -16)) & 4) != 0) {
            n7 = 0;
            int n9 = OS.GetDC(this.handle);
            n8 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n8 != 0) {
                n7 = OS.SelectObject(n9, n8);
            }
            object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n9, (TEXTMETRIC)object);
            if (n8 != 0) {
                OS.SelectObject(n9, n7);
            }
            OS.ReleaseDC(this.handle, n9);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (rECT.bottom - rECT.top < object.tmHeight) {
                int n10 = OS.SendMessage(this.handle, 212, 0, 0);
                rECT.left += OS.LOWORD(n10);
                rECT.right -= OS.HIWORD(n10);
                rECT.top = 0;
                rECT.bottom = object.tmHeight;
                OS.SendMessage(this.handle, 179, 0, rECT);
            }
        }
    }

    void setDefaultFont() {
        super.setDefaultFont();
        this.setMargins();
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (c != '\u0000' && (c = (char)Display.wcsToMbcs(c, this.getCodePage())) == '\u0000') {
            c = (char)42;
        }
        this.allowPasswordChar = true;
        OS.SendMessage(this.handle, 204, (int)c, 0);
        this.allowPasswordChar = false;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style &= 0xFFFFFFF7;
        if (!bl) {
            this.style |= 8;
        }
        OS.SendMessage(this.handle, 207, bl ? 0 : 1, 0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        this.setTabStops(this.tabs);
        this.setMargins();
    }

    void setMargins() {
        if ((this.style & 0x80) != 0 && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.SendMessage(this.handle, 211, 3, 0);
        }
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (!OS.IsWinCE) {
            if (OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                int n = OS.GetWindowLong(this.handle, -16);
                if ((n & 4) == 0) {
                    int n2 = string.length();
                    char[] cArray = new char[n2 + 1];
                    string.getChars(0, n2, cArray, 0);
                    OS.SendMessage(this.handle, 5377, 0, cArray);
                }
            } else {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        n = this.translateOffset(n);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
        }
        OS.SendMessage(this.handle, 177, n, n);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        if (!OS.IsUnicode && OS.IsDBLocale) {
            n = this.wcsToMbcsPos(n);
            n2 = this.wcsToMbcsPos(n2);
        }
        OS.SendMessage(this.handle, 177, n, n2);
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (!this.getDrawing()) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (!bl) {
            this.oldStart = nArray[0];
            this.oldEnd = nArray2[0];
        } else {
            if (this.oldStart == nArray[0] && this.oldEnd == nArray2[0]) {
                return;
            }
            OS.SendMessage(this.handle, 183, 0, 0);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.tabs = n;
        this.setTabStops(this.tabs);
    }

    void setTabStops(int n) {
        int n2 = this.getTabWidth(n) * 4 / OS.LOWORD(OS.GetDialogBaseUnits());
        OS.SendMessage(this.handle, 203, 1, new int[]{n2});
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        string = Display.withCrLf(string);
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n = OS.GetWindowTextLength(this.handle), null)) == null) {
            return;
        }
        this.clearSegments(false);
        n = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
        this.applySegments();
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 4) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextChars(char[] object) {
        int n;
        Object object2;
        int n2;
        this.checkWidget();
        if (object == null) {
            this.error(4);
        }
        object = Display.withCrLf(object);
        if (this.hooks(25) || this.filters(25)) {
            n2 = OS.GetWindowTextLength(this.handle);
            object2 = this.verifyText(new String((char[])object), 0, n2, null);
            if (object2 == null) {
                return;
            }
            object = new char[((String)object2).length()];
            ((String)object2).getChars(0, ((char[])object).length, (char[])object, 0);
        }
        this.clearSegments(false);
        n2 = OS.SendMessage(this.handle, 213, 0, 0) & Integer.MAX_VALUE;
        if (((char[])object).length > n2) {
            object2 = new char[n2];
            n = 0;
            while (n < n2) {
                object2[n] = object[n];
                ++n;
            }
            object = object2;
        }
        object2 = new TCHAR(this.getCodePage(), (char[])object, true);
        OS.SetWindowText(this.handle, (TCHAR)object2);
        this.applySegments();
        n = OS.GetWindowLong(this.handle, -16);
        if ((n & 4) != 0) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.segments != null && n > 0) {
            OS.SendMessage(this.handle, 197, n + Math.min(this.segments.length, LIMIT - n), 0);
        } else {
            OS.SendMessage(this.handle, 197, n, 0);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 186, 0, 0);
        n = Math.min(Math.max(n, 0), n2 - 1);
        int n3 = OS.SendMessage(this.handle, 206, 0, 0);
        OS.SendMessage(this.handle, 182, 0, n - n3);
    }

    public void showSelection() {
        this.checkWidget();
        OS.SendMessage(this.handle, 183, 0, 0);
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = 0;
        int n3 = this.segments.length;
        while (n2 < n3 && n - n2 >= this.segments[n2]) {
            ++n;
            ++n2;
        }
        return n;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = 0;
        int n3 = this.segments.length;
        while (n2 < n3 && n > this.segments[n2]) {
            --n;
            ++n2;
        }
        return n;
    }

    void updateMenuLocation(Event event) {
        Point point = this.display.map((Control)this, null, this.getCaretLocation());
        event.x = point.x;
        event.y = point.y + this.getLineHeight();
    }

    void updateOrientation() {
        int n = OS.GetWindowLong(this.handle, -20);
        n = (this.style & 0x4000000) != 0 ? (n |= 0x6000) : (n &= 0xFFFF9FFF);
        OS.SetWindowLong(this.handle, -20, n);
        this.fixAlignment();
    }

    String verifyText(String string, int n, int n2, Event event) {
        if (this.ignoreVerify) {
            return string;
        }
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        if (!OS.IsUnicode && OS.IsDBLocale) {
            event2.start = this.mbcsToWcsPos(n);
            event2.end = this.mbcsToWcsPos(n2);
        }
        event2.start = this.untranslateOffset(event2.start);
        event2.end = this.untranslateOffset(event2.end);
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }

    int wcsToMbcsPos(int n) {
        if (n <= 0) {
            return 0;
        }
        if (OS.IsUnicode) {
            return n;
        }
        int n2 = this.getCodePage();
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = new byte[128];
        String string = this.getLineDelimiter();
        int n5 = string.length();
        int n6 = OS.SendMessageA(this.handle, 186, 0, 0);
        int n7 = 0;
        while (n7 < n6) {
            int n8;
            int n9 = 0;
            int n10 = OS.SendMessageA(this.handle, 187, n7, 0);
            int n11 = OS.SendMessageA(this.handle, 193, n10, 0);
            if (n11 != 0) {
                if (n11 + n5 > byArray.length) {
                    byArray = new byte[n11 + n5];
                }
                byArray[0] = (byte)(n11 & 0xFF);
                byArray[1] = (byte)(n11 >> 8);
                n11 = OS.SendMessageA(this.handle, 196, n7, byArray);
                n9 = OS.MultiByteToWideChar(n2, 1, byArray, n11, null, 0);
            }
            if (n7 - 1 != n6) {
                n8 = 0;
                while (n8 < n5) {
                    byArray[n11++] = (byte)string.charAt(n8);
                    ++n8;
                }
                n9 += n5;
            }
            if (n3 + n9 >= n) {
                n9 = 0;
                n8 = 0;
                while (n8 < n11) {
                    if (n3 + n9 == n) {
                        return n4 + n8;
                    }
                    if (OS.IsDBCSLeadByte(byArray[n8++])) {
                        ++n8;
                    }
                    ++n9;
                }
                return n4 + n11;
            }
            n3 += n9;
            n4 += n11;
            ++n7;
        }
        return n4;
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x80;
        if ((this.style & 0x400000) != 0) {
            n |= 0x20;
        }
        if ((this.style & 0x1000000) != 0) {
            n |= 1;
        }
        if ((this.style & 0x20000) != 0) {
            n |= 2;
        }
        if ((this.style & 8) != 0) {
            n |= 0x800;
        }
        if ((this.style & 4) != 0) {
            if ((this.style & 8) != 0 && (this.style & 0xB00) == 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                n |= 4;
            }
            return n;
        }
        n |= 0x144;
        if ((this.style & 0x40) != 0) {
            n &= 0xFFEFFF7F;
        }
        return n;
    }

    TCHAR windowClass() {
        return EditClass;
    }

    int windowProc() {
        return EditProc;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        int n5;
        boolean bl = false;
        boolean bl2 = false;
        if (this.hooks(49) || this.filters(49)) {
            switch (n2) {
                case 198: 
                case 199: 
                case 772: {
                    return 0;
                }
                case 256: {
                    bl = n3 == 46;
                    break;
                }
                case 769: {
                    bl = this.segments != null;
                    break;
                }
                case 258: {
                    bl = !this.ignoreCharacter && OS.GetKeyState(17) >= 0 && OS.GetKeyState(18) >= 0;
                    break;
                }
                case 768: 
                case 770: 
                case 771: {
                    bl = true;
                }
            }
        }
        if (bl) {
            if (this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                bl2 = true;
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
            this.clearSegments(true);
        }
        if (n2 == 199 && ((n5 = OS.GetWindowLong(this.handle, -16)) & 4) == 0) {
            LRESULT lRESULT = this.wmClipboard(199, n3, n4);
            if (lRESULT != null) {
                return lRESULT.value;
            }
            return this.callWindowProc(n, 199, n3, n4);
        }
        if (n2 == 204 && !this.allowPasswordChar) {
            return 1;
        }
        if (n2 == Display.SWT_RESTORECARET) {
            this.callWindowProc(n, 8, 0, 0);
            this.callWindowProc(n, 7, 0, 0);
            return 1;
        }
        int n6 = super.windowProc(n, n2, n3, n4);
        if (bl) {
            this.applySegments();
            if (bl2) {
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
            OS.SendMessage(this.handle, 183, 0, 0);
        }
        return n6;
    }

    LRESULT WM_CHAR(int n, int n2) {
        if (this.ignoreCharacter) {
            return null;
        }
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 127: {
                if (OS.GetKeyState(17) >= 0) break;
                return LRESULT.ZERO;
            }
        }
        if ((this.style & 4) != 0) {
            switch (n) {
                case 13: {
                    this.sendSelectionEvent(14);
                }
                case 9: 
                case 27: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_CLEAR(int n, int n2) {
        LRESULT lRESULT = super.WM_CLEAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(771, n, n2);
    }

    LRESULT WM_CUT(int n, int n2) {
        LRESULT lRESULT = super.WM_CUT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(768, n, n2);
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        Control control;
        int n3;
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0 && ((n3 = OS.GetWindowLong(this.handle, -16)) & 4) != 0 && (control = this.findBackgroundControl()) == null && this.background == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.fillThemeBackground(n, control, rECT);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsPPC && (this.style & 2) != 0 && (this.style & 8) == 0 && n2 == 0) {
            return new LRESULT(140);
        }
        if ((this.style & 8) != 0) {
            int n3 = this.callWindowProc(this.handle, 135, n, n2);
            return new LRESULT(n3 &= 0xFFFFFFF9);
        }
        return null;
    }

    LRESULT WM_GETOBJECT(int n, int n2) {
        if ((this.style & 0x80) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(n, n2);
    }

    LRESULT WM_IME_CHAR(int n, int n2) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n, n2)) {
            return LRESULT.ZERO;
        }
        this.ignoreCharacter = true;
        int n3 = this.callWindowProc(this.handle, 646, n, n2);
        MSG mSG = new MSG();
        int n4 = 10420227;
        while (OS.PeekMessage(mSG, this.handle, 258, 258, n4)) {
            OS.TranslateMessage(mSG);
            OS.DispatchMessage(mSG);
        }
        this.ignoreCharacter = false;
        this.sendKeyEvent(2, 646, n, n2);
        display.lastAscii = 0;
        display.lastKey = 0;
        return new LRESULT(n3);
    }

    LRESULT WM_LBUTTONDBLCLK(int n, int n2) {
        int n3;
        int n4;
        LRESULT lRESULT = null;
        this.sendMouseEvent(3, 1, this.handle, 513, n, n2);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, n, n2)) {
            lRESULT = LRESULT.ZERO;
        }
        if (!this.display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (!this.doubleClick) {
            return LRESULT.ZERO;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.SendMessage(this.handle, 176, nArray, nArray2);
        if (nArray[0] == nArray2[0] && (n4 = OS.GetWindowTextLength(this.handle)) == nArray[0] && (n3 = OS.SendMessage(this.handle, 193, n4, 0)) == 0) {
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        if (OS.IsPPC) {
            boolean bl;
            LRESULT lRESULT = null;
            Display display = this.display;
            display.captureChanged = false;
            boolean bl2 = this.sendMouseEvent(3, 1, this.handle, 513, n, n2);
            boolean bl3 = bl = this.menu != null && !this.menu.isDisposed();
            if (bl || this.hooks(35)) {
                int n3 = OS.GET_X_LPARAM(n2);
                int n4 = OS.GET_Y_LPARAM(n2);
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = SHRGINFO.sizeof;
                sHRGINFO.hwndClient = this.handle;
                sHRGINFO.ptDown_x = n3;
                sHRGINFO.ptDown_y = n4;
                sHRGINFO.dwFlags = 1;
                int n5 = OS.SHRecognizeGesture(sHRGINFO);
                if (n5 == 1000) {
                    this.showMenu(n3, n4);
                    return LRESULT.ONE;
                }
            }
            lRESULT = bl2 ? new LRESULT(this.callWindowProc(this.handle, 513, n, n2)) : LRESULT.ZERO;
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return lRESULT;
        }
        return super.WM_LBUTTONDOWN(n, n2);
    }

    LRESULT WM_PASTE(int n, int n2) {
        LRESULT lRESULT = super.WM_PASTE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(770, n, n2);
    }

    LRESULT WM_UNDO(int n, int n2) {
        LRESULT lRESULT = super.WM_UNDO(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return this.wmClipboard(772, n, n2);
    }

    LRESULT wmClipboard(int n, int n2, int n3) {
        Object object;
        if ((this.style & 8) != 0) {
            return null;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return null;
        }
        boolean bl = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        String string = null;
        switch (n) {
            case 768: 
            case 771: {
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                if (nArray[0] == nArray2[0]) break;
                string = "";
                bl = true;
                break;
            }
            case 770: {
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                string = this.getClipboardText();
                break;
            }
            case 199: 
            case 772: {
                if (OS.SendMessage(this.handle, 198, 0, 0) == 0) break;
                this.ignoreCharacter = true;
                this.ignoreModify = true;
                this.callWindowProc(this.handle, n, n2, n3);
                int n4 = OS.GetWindowTextLength(this.handle);
                object = new int[1];
                int[] nArray3 = new int[1];
                OS.SendMessage(this.handle, 176, object, nArray3);
                if (n4 != 0 && object[0] != nArray3[0]) {
                    TCHAR tCHAR = new TCHAR(this.getCodePage(), n4 + 1);
                    OS.GetWindowText(this.handle, tCHAR, n4 + 1);
                    string = tCHAR.toString(object[0], nArray3[0] - object[0]);
                } else {
                    string = "";
                }
                this.callWindowProc(this.handle, n, n2, n3);
                OS.SendMessage(this.handle, 176, nArray, nArray2);
                this.ignoreCharacter = false;
                this.ignoreModify = false;
            }
        }
        if (string != null) {
            String string2 = string;
            if ((string = this.verifyText(string, nArray[0], nArray2[0], null)) == null) {
                return LRESULT.ZERO;
            }
            if (!string.equals(string2)) {
                if (bl) {
                    this.callWindowProc(this.handle, n, n2, n3);
                }
                string = Display.withCrLf(string);
                object = new TCHAR(this.getCodePage(), string, true);
                this.ignoreCharacter = true;
                OS.SendMessage(this.handle, 194, 0, (TCHAR)object);
                this.ignoreCharacter = false;
                return LRESULT.ZERO;
            }
        }
        if (n == 772) {
            this.ignoreCharacter = true;
            this.ignoreVerify = true;
            this.callWindowProc(this.handle, 772, n2, n3);
            this.ignoreCharacter = false;
            this.ignoreVerify = false;
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmColorChild(int n, int n2) {
        Control control;
        int n3;
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0 && ((n3 = OS.GetWindowLong(this.handle, -16)) & 4) != 0 && (control = this.findBackgroundControl()) == null && this.background == -1 && (this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (control = this.findThemeControl()) != null) {
            OS.SetTextColor(n, this.getForegroundPixel());
            OS.SetBkColor(n, this.getBackgroundPixel());
            OS.SetBkMode(n, 1);
            return new LRESULT(OS.GetStockObject(5));
        }
        return super.wmColorChild(n, n2);
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 768: {
                if (this.findImageControl() != null) {
                    OS.InvalidateRect(this.handle, null, true);
                }
                if (this.ignoreModify) break;
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return LRESULT.ZERO;
            }
            case 1792: 
            case 1793: {
                int n4 = OS.GetWindowLong(this.handle, -20);
                if ((n4 & 0x2000) != 0) {
                    this.style &= 0xFDFFFFFF;
                    this.style |= 0x4000000;
                } else {
                    this.style &= 0xFBFFFFFF;
                    this.style |= 0x2000000;
                }
                Event event = new Event();
                event.doit = true;
                this.sendEvent(44, event);
                if (!event.doit) {
                    if (n3 == 1792) {
                        n4 |= 0x6000;
                        this.style &= 0xFDFFFFFF;
                        this.style |= 0x4000000;
                    } else {
                        n4 &= 0xFFFF9FFF;
                        this.style &= 0xFBFFFFFF;
                        this.style |= 0x2000000;
                    }
                    OS.SetWindowLong(this.handle, -20, n4);
                } else {
                    this.clearSegments(true);
                    this.applySegments();
                }
                this.fixAlignment();
            }
        }
        return super.wmCommandChild(n, n2);
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.segments != null) {
            switch (n2) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    int n4 = 0;
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    OS.SendMessage(this.handle, 176, nArray, nArray2);
                    while (true) {
                        n4 = this.callWindowProc(this.handle, 256, n2, n3);
                        OS.SendMessage(this.handle, 176, nArray3, nArray4);
                        if (nArray3[0] != nArray[0] ? this.untranslateOffset(nArray3[0]) != this.untranslateOffset(nArray[0]) : nArray4[0] == nArray2[0] || this.untranslateOffset(nArray4[0]) != this.untranslateOffset(nArray2[0])) break;
                        nArray[0] = nArray3[0];
                        nArray2[0] = nArray4[0];
                    }
                    lRESULT = n4 == 0 ? LRESULT.ZERO : new LRESULT(n4);
                }
            }
        }
        return lRESULT;
    }
}

