/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.io.File;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.CONTROLINFO;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IClassFactory2;
import org.eclipse.swt.internal.ole.win32.IOleControl;
import org.eclipse.swt.internal.ole.win32.IPersistStorage;
import org.eclipse.swt.internal.ole.win32.IProvideClassInfo;
import org.eclipse.swt.internal.ole.win32.IProvideClassInfo2;
import org.eclipse.swt.internal.ole.win32.ITypeInfo;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.LICINFO;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleEventSink;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.OlePropertyChangeSink;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class OleControlSite
extends OleClientSite {
    private COMObject iOleControlSite;
    private COMObject iDispatch;
    private OlePropertyChangeSink olePropertyChangeSink;
    private OleEventSink[] oleEventSink = new OleEventSink[0];
    private GUID[] oleEventSinkGUID = new GUID[0];
    private int[] oleEventSinkIUnknown = new int[0];
    private CONTROLINFO currentControlInfo;
    private int[] sitePropertyIds = new int[0];
    private Variant[] sitePropertyValues = new Variant[0];
    private Font font;
    static int SWT_RESTORECARET;
    static final String SHELL_PROG_ID = "Shell.Explorer";

    public OleControlSite(Composite composite, int n, File file) {
        super(composite, n, file);
        this.setSiteProperty(-709, new Variant(true));
        this.setSiteProperty(-710, new Variant(false));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OleControlSite(Composite composite, int n, String string) {
        super(composite, n);
        try {
            int n2;
            this.appClsid = this.getClassID(string);
            if (this.appClsid == null) {
                OLE.error(1004);
            }
            if ((n2 = this.getLicenseInfo(this.appClsid)) == 0) {
                this.tempStorage = this.createTempStorage();
                int[] nArray = new int[1];
                int n3 = this.isICAClient() ? 0 : this.iOleClientSite.getAddress();
                int n4 = COM.OleCreate(this.appClsid, COM.IIDIUnknown, 1, null, n3, this.tempStorage.getAddress(), nArray);
                if (n4 != 0) {
                    OLE.error(1001, n4);
                }
                this.objIUnknown = new IUnknown(nArray[0]);
            } else {
                int[] nArray = new int[1];
                try {
                    int n5 = COM.CoGetClassObject(this.appClsid, 3, 0, COM.IIDIClassFactory2, nArray);
                    if (n5 != 0) {
                        OLE.error(1005, n5);
                    }
                    IClassFactory2 iClassFactory2 = new IClassFactory2(nArray[0]);
                    nArray = new int[1];
                    n5 = iClassFactory2.CreateInstanceLic(0, 0, COM.IIDIUnknown, n2, nArray);
                    iClassFactory2.Release();
                    if (n5 != 0) {
                        OLE.error(1006, n5);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    COM.SysFreeString(n2);
                    throw throwable;
                }
                {
                    Object var8_15 = null;
                }
                COM.SysFreeString(n2);
                this.objIUnknown = new IUnknown(nArray[0]);
                nArray = new int[1];
                if (this.objIUnknown.QueryInterface(COM.IIDIPersistStorage, nArray) == 0) {
                    IPersistStorage iPersistStorage = new IPersistStorage(nArray[0]);
                    this.tempStorage = this.createTempStorage();
                    iPersistStorage.InitNew(this.tempStorage.getAddress());
                    iPersistStorage.Release();
                }
            }
            this.addObjectReferences();
            this.setSiteProperty(-709, new Variant(true));
            this.setSiteProperty(-710, new Variant(false));
            if (COM.OleRun(this.objIUnknown.getAddress()) != 0) return;
            this.state = 1;
            return;
        }
        catch (SWTError sWTError) {
            this.dispose();
            this.disposeCOMInterfaces();
            throw sWTError;
        }
    }

    public OleControlSite(Composite composite, int n, String string, File file) {
        super(composite, n, string, file);
        this.setSiteProperty(-709, new Variant(true));
        this.setSiteProperty(-710, new Variant(false));
    }

    public void addEventListener(int n, OleListener oleListener) {
        GUID gUID;
        if (oleListener == null) {
            OLE.error(4);
        }
        if ((gUID = OleControlSite.getDefaultEventSinkGUID(this.objIUnknown)) != null) {
            this.addEventListener(this.objIUnknown.getAddress(), gUID, n, oleListener);
        }
    }

    static GUID getDefaultEventSinkGUID(IUnknown iUnknown) {
        Object object;
        IProvideClassInfo iProvideClassInfo;
        int[] nArray = new int[1];
        if (iUnknown.QueryInterface(COM.IIDIProvideClassInfo2, nArray) == 0) {
            iProvideClassInfo = new IProvideClassInfo2(nArray[0]);
            object = new GUID();
            int n = ((IProvideClassInfo2)iProvideClassInfo).GetGUID(1, (GUID)object);
            iProvideClassInfo.Release();
            if (n == 0) {
                return object;
            }
        }
        if (iUnknown.QueryInterface(COM.IIDIProvideClassInfo, nArray) == 0) {
            iProvideClassInfo = new IProvideClassInfo(nArray[0]);
            object = new int[1];
            int[] nArray2 = new int[1];
            int n = iProvideClassInfo.GetClassInfo((int[])object);
            iProvideClassInfo.Release();
            if (n == 0 && object[0] != false) {
                Object object2;
                ITypeInfo iTypeInfo = new ITypeInfo((int)object[0]);
                int[] nArray3 = new int[1];
                n = iTypeInfo.GetTypeAttr(nArray3);
                if (n == 0 && nArray3[0] != 0) {
                    object2 = new TYPEATTR();
                    COM.MoveMemory((TYPEATTR)object2, nArray3[0], TYPEATTR.sizeof);
                    iTypeInfo.ReleaseTypeAttr(nArray3[0]);
                    int n2 = 7;
                    int n3 = 3;
                    int n4 = 0;
                    while (n4 < ((TYPEATTR)object2).cImplTypes) {
                        int[] nArray4;
                        int[] nArray5 = new int[1];
                        if (iTypeInfo.GetImplTypeFlags(n4, nArray5) == 0 && (nArray5[0] & n2) == n3 && iTypeInfo.GetRefTypeOfImplType(n4, nArray4 = new int[1]) == 0) {
                            iTypeInfo.GetRefTypeInfo(nArray4[0], nArray2);
                        }
                        ++n4;
                    }
                }
                iTypeInfo.Release();
                if (nArray2[0] != 0) {
                    object2 = new ITypeInfo(nArray2[0]);
                    nArray3 = new int[1];
                    n = ((ITypeInfo)object2).GetTypeAttr(nArray3);
                    GUID gUID = null;
                    if (n == 0 && nArray3[0] != 0) {
                        gUID = new GUID();
                        COM.MoveMemory(gUID, nArray3[0], GUID.sizeof);
                        ((ITypeInfo)object2).ReleaseTypeAttr(nArray3[0]);
                    }
                    ((IUnknown)object2).Release();
                    return gUID;
                }
            }
        }
        return null;
    }

    public void addEventListener(OleAutomation oleAutomation, int n, OleListener oleListener) {
        int n2;
        IUnknown iUnknown;
        GUID gUID;
        if (oleListener == null || oleAutomation == null) {
            OLE.error(4);
        }
        if ((gUID = OleControlSite.getDefaultEventSinkGUID(iUnknown = new IUnknown(n2 = oleAutomation.getAddress()))) != null) {
            this.addEventListener(n2, gUID, n, oleListener);
        }
    }

    public void addEventListener(OleAutomation oleAutomation, String string, int n, OleListener oleListener) {
        GUID gUID;
        int n2;
        if (oleListener == null || oleAutomation == null || string == null) {
            OLE.error(4);
        }
        if ((n2 = oleAutomation.getAddress()) == 0) {
            return;
        }
        char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
        if (COM.IIDFromString(cArray, gUID = new GUID()) != 0) {
            return;
        }
        this.addEventListener(n2, gUID, n, oleListener);
    }

    void addEventListener(int n, GUID gUID, int n2, OleListener oleListener) {
        if (oleListener == null || n == 0 || gUID == null) {
            OLE.error(4);
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.oleEventSinkGUID.length) {
            if (COM.IsEqualGUID(this.oleEventSinkGUID[n4], gUID) && n == this.oleEventSinkIUnknown[n4]) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 != -1) {
            this.oleEventSink[n3].addListener(n2, oleListener);
        } else {
            n4 = this.oleEventSink.length;
            OleEventSink[] oleEventSinkArray = new OleEventSink[n4 + 1];
            GUID[] gUIDArray = new GUID[n4 + 1];
            int[] nArray = new int[n4 + 1];
            System.arraycopy(this.oleEventSink, 0, oleEventSinkArray, 0, n4);
            System.arraycopy(this.oleEventSinkGUID, 0, gUIDArray, 0, n4);
            System.arraycopy(this.oleEventSinkIUnknown, 0, nArray, 0, n4);
            this.oleEventSink = oleEventSinkArray;
            this.oleEventSinkGUID = gUIDArray;
            this.oleEventSinkIUnknown = nArray;
            this.oleEventSink[n4] = new OleEventSink(this, n, gUID);
            this.oleEventSinkGUID[n4] = gUID;
            this.oleEventSinkIUnknown[n4] = n;
            this.oleEventSink[n4].AddRef();
            this.oleEventSink[n4].connect();
            this.oleEventSink[n4].addListener(n2, oleListener);
        }
    }

    protected void addObjectReferences() {
        super.addObjectReferences();
        this.connectPropertyChangeSink();
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIOleControl, nArray) == 0) {
            IOleControl iOleControl = new IOleControl(nArray[0]);
            this.currentControlInfo = new CONTROLINFO();
            iOleControl.GetControlInfo(this.currentControlInfo);
            iOleControl.Release();
        }
    }

    public void addPropertyListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            SWT.error(4);
        }
        this.olePropertyChangeSink.addListener(n, oleListener);
    }

    private void connectPropertyChangeSink() {
        this.olePropertyChangeSink = new OlePropertyChangeSink(this);
        this.olePropertyChangeSink.AddRef();
        this.olePropertyChangeSink.connect(this.objIUnknown);
    }

    protected void createCOMInterfaces() {
        super.createCOMInterfaces();
        int[] nArray = new int[10];
        nArray[0] = 2;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 3;
        nArray[7] = 2;
        nArray[8] = 1;
        this.iOleControlSite = new COMObject(nArray){

            public int method0(int[] nArray) {
                return OleControlSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleControlSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleControlSite.this.Release();
            }

            public int method3(int[] nArray) {
                return OleControlSite.this.OnControlInfoChanged();
            }

            public int method8(int[] nArray) {
                return OleControlSite.this.OnFocus(nArray[0]);
            }
        };
        int[] nArray2 = new int[7];
        nArray2[0] = 2;
        nArray2[3] = 1;
        nArray2[4] = 3;
        nArray2[5] = 5;
        nArray2[6] = 8;
        this.iDispatch = new COMObject(nArray2){

            public int method0(int[] nArray) {
                return OleControlSite.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleControlSite.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleControlSite.this.Release();
            }

            public int method6(int[] nArray) {
                return OleControlSite.this.Invoke(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], nArray[6], nArray[7]);
            }
        };
    }

    private void disconnectEventSinks() {
        int n = 0;
        while (n < this.oleEventSink.length) {
            OleEventSink oleEventSink = this.oleEventSink[n];
            oleEventSink.disconnect();
            oleEventSink.Release();
            ++n;
        }
        this.oleEventSink = new OleEventSink[0];
        this.oleEventSinkGUID = new GUID[0];
        this.oleEventSinkIUnknown = new int[0];
    }

    private void disconnectPropertyChangeSink() {
        if (this.olePropertyChangeSink != null) {
            this.olePropertyChangeSink.disconnect(this.objIUnknown);
            this.olePropertyChangeSink.Release();
        }
        this.olePropertyChangeSink = null;
    }

    protected void disposeCOMInterfaces() {
        super.disposeCOMInterfaces();
        if (this.iOleControlSite != null) {
            this.iOleControlSite.dispose();
        }
        this.iOleControlSite = null;
        if (this.iDispatch != null) {
            this.iDispatch.dispose();
        }
        this.iDispatch = null;
    }

    public Color getBackground() {
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            Variant variant = oleAutomation.getProperty(-501);
            oleAutomation.dispose();
            if (variant != null) {
                int[] nArray = new int[1];
                if (COM.OleTranslateColor(variant.getInt(), this.getDisplay().hPalette, nArray) == 0) {
                    return Color.win32_new(this.getDisplay(), nArray[0]);
                }
            }
        }
        return super.getBackground();
    }

    public Font getFont() {
        if (this.font != null && !this.font.isDisposed()) {
            return this.font;
        }
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            Variant variant = oleAutomation.getProperty(-512);
            oleAutomation.dispose();
            if (variant != null) {
                OleAutomation oleAutomation2 = variant.getAutomation();
                Variant variant2 = oleAutomation2.getProperty(0);
                Variant variant3 = oleAutomation2.getProperty(2);
                Variant variant4 = oleAutomation2.getProperty(4);
                Variant variant5 = oleAutomation2.getProperty(3);
                oleAutomation2.dispose();
                if (variant2 != null && variant3 != null && variant4 != null && variant5 != null) {
                    int n = 3 * variant5.getInt() + 2 * variant4.getInt();
                    this.font = new Font((Device)this.getShell().getDisplay(), variant2.getString(), variant3.getInt(), n);
                    return this.font;
                }
            }
        }
        return super.getFont();
    }

    public Color getForeground() {
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            Variant variant = oleAutomation.getProperty(-513);
            oleAutomation.dispose();
            if (variant != null) {
                int[] nArray = new int[1];
                if (COM.OleTranslateColor(variant.getInt(), this.getDisplay().hPalette, nArray) == 0) {
                    return Color.win32_new(this.getDisplay(), nArray[0]);
                }
            }
        }
        return super.getForeground();
    }

    protected int getLicenseInfo(GUID gUID) {
        int[] nArray = new int[1];
        if (COM.CoGetClassObject(gUID, 3, 0, COM.IIDIClassFactory, nArray) != 0) {
            return 0;
        }
        int n = 0;
        IUnknown iUnknown = new IUnknown(nArray[0]);
        if (iUnknown.QueryInterface(COM.IIDIClassFactory2, nArray) == 0) {
            IClassFactory2 iClassFactory2 = new IClassFactory2(nArray[0]);
            LICINFO lICINFO = new LICINFO();
            if (iClassFactory2.GetLicInfo(lICINFO) == 0) {
                int[] nArray2 = new int[1];
                if (lICINFO != null && lICINFO.fRuntimeKeyAvail && iClassFactory2.RequestLicKey(0, nArray2) == 0) {
                    n = nArray2[0];
                }
            }
            iClassFactory2.Release();
        }
        iUnknown.Release();
        return n;
    }

    public Variant getSiteProperty(int n) {
        int n2 = 0;
        while (n2 < this.sitePropertyIds.length) {
            if (this.sitePropertyIds[n2] == n) {
                return this.sitePropertyValues[n2];
            }
            ++n2;
        }
        return null;
    }

    protected int GetWindow(int n) {
        if (n == 0) {
            return -2147024809;
        }
        if (this.frame == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return -2147467263;
        }
        COM.MoveMemory(n, new int[]{this.handle}, OS.PTR_SIZEOF);
        return 0;
    }

    private int Invoke(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n6 == 0 || n4 != 2) {
            if (n7 != 0) {
                COM.MoveMemory(n7, new int[1], OS.PTR_SIZEOF);
            }
            if (n8 != 0) {
                COM.MoveMemory(n8, new int[1], 4);
            }
            return -2147352573;
        }
        Variant variant = this.getSiteProperty(n);
        if (variant != null) {
            if (n6 != 0) {
                variant.getData(n6);
            }
            return 0;
        }
        switch (n) {
            case -714: 
            case -712: 
            case -711: {
                if (n6 != 0) {
                    COM.MoveMemory(n6, new int[1], OS.PTR_SIZEOF);
                }
                if (n7 != 0) {
                    COM.MoveMemory(n7, new int[1], OS.PTR_SIZEOF);
                }
                if (n8 != 0) {
                    COM.MoveMemory(n8, new int[1], 4);
                }
                return 1;
            }
            case -5502: 
            case -5501: 
            case -706: 
            case -705: 
            case -704: 
            case -703: 
            case -701: {
                if (n6 != 0) {
                    COM.MoveMemory(n6, new int[1], OS.PTR_SIZEOF);
                }
                if (n7 != 0) {
                    COM.MoveMemory(n7, new int[1], OS.PTR_SIZEOF);
                }
                if (n8 != 0) {
                    COM.MoveMemory(n8, new int[1], 4);
                }
                return -2147467263;
            }
        }
        if (n6 != 0) {
            COM.MoveMemory(n6, new int[1], OS.PTR_SIZEOF);
        }
        if (n7 != 0) {
            COM.MoveMemory(n7, new int[1], OS.PTR_SIZEOF);
        }
        if (n8 != 0) {
            COM.MoveMemory(n8, new int[1], 4);
        }
        return -2147352573;
    }

    private int OnControlInfoChanged() {
        int[] nArray = new int[1];
        if (this.objIUnknown.QueryInterface(COM.IIDIOleControl, nArray) == 0) {
            IOleControl iOleControl = new IOleControl(nArray[0]);
            this.currentControlInfo = new CONTROLINFO();
            iOleControl.GetControlInfo(this.currentControlInfo);
            iOleControl.Release();
        }
        return 0;
    }

    protected int OnUIDeactivate(int n) {
        return super.OnUIDeactivate(n);
    }

    void onFocusIn(Event event) {
        String string = this.getProgramID();
        if (string == null) {
            return;
        }
        if (!string.startsWith(SHELL_PROG_ID)) {
            super.onFocusIn(event);
            return;
        }
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        if (!this.isActivated) {
            this.doVerb(-4);
        }
        if (this.isFocusControl()) {
            return;
        }
        int[] nArray = new int[1];
        this.objIOleInPlaceObject.GetWindow(nArray);
        if (nArray[0] == 0) {
            return;
        }
        OS.SetFocus(nArray[0]);
    }

    void onFocusOut(Event event) {
        if (this.objIOleInPlaceObject == null) {
            return;
        }
        String string = this.getProgramID();
        if (string == null) {
            return;
        }
        if (!string.startsWith(SHELL_PROG_ID)) {
            super.onFocusOut(event);
            return;
        }
        if (this.isFocusControl()) {
            return;
        }
        int n = OS.GetCurrentThreadId();
        GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
        gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
        OS.GetGUIThreadInfo(n, gUITHREADINFO);
        this.objIOleInPlaceObject.UIDeactivate();
        if (gUITHREADINFO.hwndCaret != 0) {
            GUITHREADINFO gUITHREADINFO2 = new GUITHREADINFO();
            gUITHREADINFO2.cbSize = GUITHREADINFO.sizeof;
            OS.GetGUIThreadInfo(n, gUITHREADINFO2);
            if (gUITHREADINFO2.hwndCaret == 0 && gUITHREADINFO.hwndCaret == OS.GetFocus()) {
                if (SWT_RESTORECARET == 0) {
                    SWT_RESTORECARET = OS.RegisterWindowMessage(new TCHAR(0, "SWT_RESTORECARET", true));
                }
                if (OS.SendMessage(gUITHREADINFO.hwndCaret, SWT_RESTORECARET, 0, 0) == 0) {
                    int n2 = gUITHREADINFO.right - gUITHREADINFO.left;
                    int n3 = gUITHREADINFO.bottom - gUITHREADINFO.top;
                    OS.CreateCaret(gUITHREADINFO.hwndCaret, 0, n2, n3);
                    OS.SetCaretPos(gUITHREADINFO.left, gUITHREADINFO.top);
                    OS.ShowCaret(gUITHREADINFO.hwndCaret);
                }
            }
        }
    }

    private int OnFocus(int n) {
        return 0;
    }

    protected int QueryInterface(int n, int n2) {
        int n3 = super.QueryInterface(n, n2);
        if (n3 == 0) {
            return n3;
        }
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIOleControlSite)) {
            COM.MoveMemory(n2, new int[]{this.iOleControlSite.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDispatch)) {
            COM.MoveMemory(n2, new int[]{this.iDispatch.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    protected int Release() {
        int n = super.Release();
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.sitePropertyIds.length) {
                this.sitePropertyValues[n2].dispose();
                ++n2;
            }
            this.sitePropertyIds = new int[0];
            this.sitePropertyValues = new Variant[0];
        }
        return n;
    }

    protected void releaseObjectInterfaces() {
        this.disconnectEventSinks();
        this.disconnectPropertyChangeSink();
        super.releaseObjectInterfaces();
    }

    public void removeEventListener(int n, OleListener oleListener) {
        GUID gUID;
        this.checkWidget();
        if (oleListener == null) {
            SWT.error(4);
        }
        if ((gUID = OleControlSite.getDefaultEventSinkGUID(this.objIUnknown)) != null) {
            this.removeEventListener(this.objIUnknown.getAddress(), gUID, n, oleListener);
        }
    }

    public void removeEventListener(OleAutomation oleAutomation, GUID gUID, int n, OleListener oleListener) {
        this.checkWidget();
        if (oleAutomation == null || oleListener == null || gUID == null) {
            SWT.error(4);
        }
        this.removeEventListener(oleAutomation.getAddress(), gUID, n, oleListener);
    }

    public void removeEventListener(OleAutomation oleAutomation, int n, OleListener oleListener) {
        int n2;
        IUnknown iUnknown;
        GUID gUID;
        this.checkWidget();
        if (oleAutomation == null || oleListener == null) {
            SWT.error(4);
        }
        if ((gUID = OleControlSite.getDefaultEventSinkGUID(iUnknown = new IUnknown(n2 = oleAutomation.getAddress()))) != null) {
            this.removeEventListener(n2, gUID, n, oleListener);
        }
    }

    void removeEventListener(int n, GUID gUID, int n2, OleListener oleListener) {
        if (oleListener == null || gUID == null) {
            SWT.error(4);
        }
        int n3 = 0;
        while (n3 < this.oleEventSink.length) {
            if (COM.IsEqualGUID(this.oleEventSinkGUID[n3], gUID) && n == this.oleEventSinkIUnknown[n3]) {
                this.oleEventSink[n3].removeListener(n2, oleListener);
                if (!this.oleEventSink[n3].hasListeners()) {
                    this.oleEventSink[n3].disconnect();
                    this.oleEventSink[n3].Release();
                    int n4 = this.oleEventSink.length;
                    if (n4 == 1) {
                        this.oleEventSink = new OleEventSink[0];
                        this.oleEventSinkGUID = new GUID[0];
                        this.oleEventSinkIUnknown = new int[0];
                    } else {
                        OleEventSink[] oleEventSinkArray = new OleEventSink[n4 - 1];
                        System.arraycopy(this.oleEventSink, 0, oleEventSinkArray, 0, n3);
                        System.arraycopy(this.oleEventSink, n3 + 1, oleEventSinkArray, n3, n4 - n3 - 1);
                        this.oleEventSink = oleEventSinkArray;
                        GUID[] gUIDArray = new GUID[n4 - 1];
                        System.arraycopy(this.oleEventSinkGUID, 0, gUIDArray, 0, n3);
                        System.arraycopy(this.oleEventSinkGUID, n3 + 1, gUIDArray, n3, n4 - n3 - 1);
                        this.oleEventSinkGUID = gUIDArray;
                        int[] nArray = new int[n4 - 1];
                        System.arraycopy(this.oleEventSinkIUnknown, 0, nArray, 0, n3);
                        System.arraycopy(this.oleEventSinkIUnknown, n3 + 1, nArray, n3, n4 - n3 - 1);
                        this.oleEventSinkIUnknown = nArray;
                    }
                }
                return;
            }
            ++n3;
        }
    }

    public void removePropertyListener(int n, OleListener oleListener) {
        if (oleListener == null) {
            SWT.error(4);
        }
        this.olePropertyChangeSink.removeListener(n, oleListener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            oleAutomation.setProperty(-501, new Variant(color.handle));
            oleAutomation.dispose();
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            Variant variant = oleAutomation.getProperty(-512);
            oleAutomation.dispose();
            if (variant != null) {
                OleAutomation oleAutomation2 = variant.getAutomation();
                FontData[] fontDataArray = font.getFontData();
                oleAutomation2.setProperty(0, new Variant(fontDataArray[0].getName()));
                oleAutomation2.setProperty(2, new Variant(fontDataArray[0].getHeight()));
                oleAutomation2.setProperty(4, new Variant(fontDataArray[0].getStyle() & 2));
                oleAutomation2.setProperty(3, new Variant(fontDataArray[0].getStyle() & 1));
                oleAutomation2.dispose();
            }
        }
        this.font = font;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.objIUnknown != null) {
            OleAutomation oleAutomation = new OleAutomation(this);
            oleAutomation.setProperty(-513, new Variant(color.handle));
            oleAutomation.dispose();
        }
    }

    public void setSiteProperty(int n, Variant variant) {
        int n2 = 0;
        while (n2 < this.sitePropertyIds.length) {
            if (this.sitePropertyIds[n2] == n) {
                if (this.sitePropertyValues[n2] != null) {
                    this.sitePropertyValues[n2].dispose();
                }
                if (variant != null) {
                    this.sitePropertyValues[n2] = variant;
                } else {
                    int n3 = this.sitePropertyIds.length;
                    int[] nArray = new int[n3 - 1];
                    Variant[] variantArray = new Variant[n3 - 1];
                    System.arraycopy(this.sitePropertyIds, 0, nArray, 0, n2);
                    System.arraycopy(this.sitePropertyIds, n2 + 1, nArray, n2, n3 - n2 - 1);
                    System.arraycopy(this.sitePropertyValues, 0, variantArray, 0, n2);
                    System.arraycopy(this.sitePropertyValues, n2 + 1, variantArray, n2, n3 - n2 - 1);
                    this.sitePropertyIds = nArray;
                    this.sitePropertyValues = variantArray;
                }
                return;
            }
            ++n2;
        }
        n2 = this.sitePropertyIds.length;
        int[] nArray = new int[n2 + 1];
        Variant[] variantArray = new Variant[n2 + 1];
        System.arraycopy(this.sitePropertyIds, 0, nArray, 0, n2);
        System.arraycopy(this.sitePropertyValues, 0, variantArray, 0, n2);
        nArray[n2] = n;
        variantArray[n2] = variant;
        this.sitePropertyIds = nArray;
        this.sitePropertyValues = variantArray;
    }
}

