/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionEvent;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextEvent;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkEvent;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTableCellEvent;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextAttributeEvent;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueEvent;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.accessibility.Relation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IAccessible;
import org.eclipse.swt.internal.ole.win32.IEnumVARIANT;
import org.eclipse.swt.internal.ole.win32.IServiceProvider;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class Accessible {
    static final int MAX_RELATION_TYPES = 15;
    static final int TABLE_MODEL_CHANGE_SIZE = 5;
    static final int TEXT_CHANGE_SIZE = 4;
    static final boolean DEBUG = false;
    static final String PROPERTY_USEIA2 = "org.eclipse.swt.accessibility.UseIA2";
    static boolean UseIA2 = true;
    static int UniqueID = -16;
    int refCount = 0;
    int enumIndex = 0;
    COMObject objIAccessible;
    COMObject objIEnumVARIANT;
    COMObject objIServiceProvider;
    COMObject objIAccessible2;
    COMObject objIAccessibleAction;
    COMObject objIAccessibleApplication;
    COMObject objIAccessibleEditableText;
    COMObject objIAccessibleHyperlink;
    COMObject objIAccessibleHypertext;
    COMObject objIAccessibleTable2;
    COMObject objIAccessibleTableCell;
    COMObject objIAccessibleText;
    COMObject objIAccessibleValue;
    IAccessible iaccessible;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Vector accessibleActionListeners = new Vector();
    Vector accessibleEditableTextListeners = new Vector();
    Vector accessibleHyperlinkListeners = new Vector();
    Vector accessibleTableListeners = new Vector();
    Vector accessibleTableCellListeners = new Vector();
    Vector accessibleTextExtendedListeners = new Vector();
    Vector accessibleValueListeners = new Vector();
    Vector accessibleAttributeListeners = new Vector();
    Relation[] relations = new Relation[15];
    Object[] variants;
    Accessible parent;
    Vector children = new Vector();
    Control control;
    int uniqueID = -1;
    int[] tableChange;
    Object[] textDeleted;
    Object[] textInserted;
    ToolItem item;

    static {
        String string = System.getProperty(PROPERTY_USEIA2);
        if (string != null && string.equalsIgnoreCase("false")) {
            UseIA2 = false;
        }
    }

    public Accessible(Accessible accessible) {
        this.parent = Accessible.checkNull(accessible);
        this.control = accessible.control;
        accessible.children.addElement(this);
        this.AddRef();
    }

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
        int[] nArray = new int[1];
        int n = COM.CreateStdAccessibleObject(control.handle, -4, COM.IIDIAccessible, nArray);
        if (nArray[0] == 0) {
            return;
        }
        if (n != 0) {
            OLE.error(1001, n);
        }
        this.iaccessible = new IAccessible(nArray[0]);
        this.createIAccessible();
        this.AddRef();
    }

    Accessible(Accessible accessible, int n) {
        this(accessible);
        this.iaccessible = new IAccessible(n);
    }

    static Accessible checkNull(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        return accessible;
    }

    void createIAccessible() {
        int[] nArray = new int[28];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 5;
        nArray[23] = 3;
        nArray[24] = 3;
        nArray[25] = 1;
        nArray[26] = 2;
        nArray[27] = 2;
        this.objIAccessible = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_accParent(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_accChildCount(nArray[0]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_accChild(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_accName(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_accValue(nArray[0], nArray[1]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_accDescription(nArray[0], nArray[1]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_accRole(nArray[0], nArray[1]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.get_accState(nArray[0], nArray[1]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.get_accHelp(nArray[0], nArray[1]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.get_accHelpTopic(nArray[0], nArray[1], nArray[2]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_accKeyboardShortcut(nArray[0], nArray[1]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.get_accFocus(nArray[0]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.get_accSelection(nArray[0]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.get_accDefaultAction(nArray[0], nArray[1]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.accSelect(nArray[0], nArray[1]);
            }

            public int method22(int[] nArray) {
                return Accessible.this.accLocation(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method23(int[] nArray) {
                return Accessible.this.accNavigate(nArray[0], nArray[1], nArray[2]);
            }

            public int method24(int[] nArray) {
                return Accessible.this.accHitTest(nArray[0], nArray[1], nArray[2]);
            }

            public int method25(int[] nArray) {
                return Accessible.this.accDoDefaultAction(nArray[0]);
            }

            public int method26(int[] nArray) {
                return Accessible.this.put_accName(nArray[0], nArray[1]);
            }

            public int method27(int[] nArray) {
                return Accessible.this.put_accValue(nArray[0], nArray[1]);
            }
        };
        int n = this.objIAccessible.ppVtable;
        int[] nArray2 = new int[1];
        COM.MoveMemory(nArray2, n, OS.PTR_SIZEOF);
        int[] nArray3 = new int[28];
        COM.MoveMemory(nArray3, nArray2[0], OS.PTR_SIZEOF * nArray3.length);
        nArray3[9] = COM.get_accChild_CALLBACK(nArray3[9]);
        nArray3[10] = COM.get_accName_CALLBACK(nArray3[10]);
        nArray3[11] = COM.get_accValue_CALLBACK(nArray3[11]);
        nArray3[12] = COM.get_accDescription_CALLBACK(nArray3[12]);
        nArray3[13] = COM.get_accRole_CALLBACK(nArray3[13]);
        nArray3[14] = COM.get_accState_CALLBACK(nArray3[14]);
        nArray3[15] = COM.get_accHelp_CALLBACK(nArray3[15]);
        nArray3[16] = COM.get_accHelpTopic_CALLBACK(nArray3[16]);
        nArray3[17] = COM.get_accKeyboardShortcut_CALLBACK(nArray3[17]);
        nArray3[20] = COM.get_accDefaultAction_CALLBACK(nArray3[20]);
        nArray3[21] = COM.accSelect_CALLBACK(nArray3[21]);
        nArray3[22] = COM.accLocation_CALLBACK(nArray3[22]);
        nArray3[23] = COM.accNavigate_CALLBACK(nArray3[23]);
        nArray3[25] = COM.accDoDefaultAction_CALLBACK(nArray3[25]);
        nArray3[26] = COM.put_accName_CALLBACK(nArray3[26]);
        nArray3[27] = COM.put_accValue_CALLBACK(nArray3[27]);
        COM.MoveMemory(nArray2[0], nArray3, OS.PTR_SIZEOF * nArray3.length);
    }

    void createIAccessible2() {
        int[] nArray = new int[46];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 5;
        nArray[6] = 8;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 2;
        nArray[21] = 2;
        nArray[22] = 5;
        nArray[23] = 3;
        nArray[24] = 3;
        nArray[25] = 1;
        nArray[26] = 2;
        nArray[27] = 2;
        nArray[28] = 1;
        nArray[29] = 2;
        nArray[30] = 3;
        nArray[31] = 1;
        nArray[32] = 1;
        nArray[33] = 3;
        nArray[34] = 3;
        nArray[35] = 1;
        nArray[36] = 1;
        nArray[37] = 1;
        nArray[38] = 1;
        nArray[39] = 3;
        nArray[40] = 3;
        nArray[41] = 1;
        nArray[42] = 1;
        nArray[43] = 1;
        nArray[44] = 1;
        nArray[45] = 1;
        this.objIAccessible2 = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_accParent(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_accChildCount(nArray[0]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_accChild(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_accName(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_accValue(nArray[0], nArray[1]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_accDescription(nArray[0], nArray[1]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_accRole(nArray[0], nArray[1]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.get_accState(nArray[0], nArray[1]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.get_accHelp(nArray[0], nArray[1]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.get_accHelpTopic(nArray[0], nArray[1], nArray[2]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_accKeyboardShortcut(nArray[0], nArray[1]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.get_accFocus(nArray[0]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.get_accSelection(nArray[0]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.get_accDefaultAction(nArray[0], nArray[1]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.accSelect(nArray[0], nArray[1]);
            }

            public int method22(int[] nArray) {
                return Accessible.this.accLocation(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method23(int[] nArray) {
                return Accessible.this.accNavigate(nArray[0], nArray[1], nArray[2]);
            }

            public int method24(int[] nArray) {
                return Accessible.this.accHitTest(nArray[0], nArray[1], nArray[2]);
            }

            public int method25(int[] nArray) {
                return Accessible.this.accDoDefaultAction(nArray[0]);
            }

            public int method26(int[] nArray) {
                return Accessible.this.put_accName(nArray[0], nArray[1]);
            }

            public int method27(int[] nArray) {
                return Accessible.this.put_accValue(nArray[0], nArray[1]);
            }

            public int method28(int[] nArray) {
                return Accessible.this.get_nRelations(nArray[0]);
            }

            public int method29(int[] nArray) {
                return Accessible.this.get_relation(nArray[0], nArray[1]);
            }

            public int method30(int[] nArray) {
                return Accessible.this.get_relations(nArray[0], nArray[1], nArray[2]);
            }

            public int method31(int[] nArray) {
                return Accessible.this.get_role(nArray[0]);
            }

            public int method32(int[] nArray) {
                return Accessible.this.scrollTo(nArray[0]);
            }

            public int method33(int[] nArray) {
                return Accessible.this.scrollToPoint(nArray[0], nArray[1], nArray[2]);
            }

            public int method34(int[] nArray) {
                return Accessible.this.get_groupPosition(nArray[0], nArray[1], nArray[2]);
            }

            public int method35(int[] nArray) {
                return Accessible.this.get_states(nArray[0]);
            }

            public int method36(int[] nArray) {
                return Accessible.this.get_extendedRole(nArray[0]);
            }

            public int method37(int[] nArray) {
                return Accessible.this.get_localizedExtendedRole(nArray[0]);
            }

            public int method38(int[] nArray) {
                return Accessible.this.get_nExtendedStates(nArray[0]);
            }

            public int method39(int[] nArray) {
                return Accessible.this.get_extendedStates(nArray[0], nArray[1], nArray[2]);
            }

            public int method40(int[] nArray) {
                return Accessible.this.get_localizedExtendedStates(nArray[0], nArray[1], nArray[2]);
            }

            public int method41(int[] nArray) {
                return Accessible.this.get_uniqueID(nArray[0]);
            }

            public int method42(int[] nArray) {
                return Accessible.this.get_windowHandle(nArray[0]);
            }

            public int method43(int[] nArray) {
                return Accessible.this.get_indexInParent(nArray[0]);
            }

            public int method44(int[] nArray) {
                return Accessible.this.get_locale(nArray[0]);
            }

            public int method45(int[] nArray) {
                return Accessible.this.get_attributes(nArray[0]);
            }
        };
        int n = this.objIAccessible2.ppVtable;
        int[] nArray2 = new int[1];
        COM.MoveMemory(nArray2, n, OS.PTR_SIZEOF);
        int[] nArray3 = new int[28];
        COM.MoveMemory(nArray3, nArray2[0], OS.PTR_SIZEOF * nArray3.length);
        nArray3[9] = COM.get_accChild_CALLBACK(nArray3[9]);
        nArray3[10] = COM.get_accName_CALLBACK(nArray3[10]);
        nArray3[11] = COM.get_accValue_CALLBACK(nArray3[11]);
        nArray3[12] = COM.get_accDescription_CALLBACK(nArray3[12]);
        nArray3[13] = COM.get_accRole_CALLBACK(nArray3[13]);
        nArray3[14] = COM.get_accState_CALLBACK(nArray3[14]);
        nArray3[15] = COM.get_accHelp_CALLBACK(nArray3[15]);
        nArray3[16] = COM.get_accHelpTopic_CALLBACK(nArray3[16]);
        nArray3[17] = COM.get_accKeyboardShortcut_CALLBACK(nArray3[17]);
        nArray3[20] = COM.get_accDefaultAction_CALLBACK(nArray3[20]);
        nArray3[21] = COM.accSelect_CALLBACK(nArray3[21]);
        nArray3[22] = COM.accLocation_CALLBACK(nArray3[22]);
        nArray3[23] = COM.accNavigate_CALLBACK(nArray3[23]);
        nArray3[25] = COM.accDoDefaultAction_CALLBACK(nArray3[25]);
        nArray3[26] = COM.put_accName_CALLBACK(nArray3[26]);
        nArray3[27] = COM.put_accValue_CALLBACK(nArray3[27]);
        COM.MoveMemory(nArray2[0], nArray3, OS.PTR_SIZEOF * nArray3.length);
    }

    void createIAccessibleAction() {
        int[] nArray = new int[9];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 2;
        nArray[8] = 2;
        this.objIAccessibleAction = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_nActions(nArray[0]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.doAction(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_description(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_keyBinding(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_name(nArray[0], nArray[1]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_localizedName(nArray[0], nArray[1]);
            }
        };
    }

    void createIAccessibleApplication() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        this.objIAccessibleApplication = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_appName(nArray[0]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.get_appVersion(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_toolkitName(nArray[0]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_toolkitVersion(nArray[0]);
            }
        };
    }

    void createIAccessibleEditableText() {
        int[] nArray = new int[10];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 3;
        this.objIAccessibleEditableText = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.copyText(nArray[0], nArray[1]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.deleteText(nArray[0], nArray[1]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.insertText(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.cutText(nArray[0], nArray[1]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.pasteText(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.replaceText(nArray[0], nArray[1], nArray[2]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.setAttributes(nArray[0], nArray[1], nArray[2]);
            }
        };
    }

    void createIAccessibleHyperlink() {
        int[] nArray = new int[14];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[13] = 1;
        this.objIAccessibleHyperlink = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_nActions(nArray[0]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.doAction(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_description(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_keyBinding(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_name(nArray[0], nArray[1]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_localizedName(nArray[0], nArray[1]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_anchor(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_anchorTarget(nArray[0], nArray[1]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_startIndex(nArray[0]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_endIndex(nArray[0]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_valid(nArray[0]);
            }
        };
    }

    void createIAccessibleHypertext() {
        int[] nArray = new int[25];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 1;
        nArray[6] = 6;
        nArray[7] = 1;
        nArray[8] = 4;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 5;
        nArray[12] = 5;
        nArray[13] = 5;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 3;
        nArray[17] = 1;
        nArray[18] = 3;
        nArray[19] = 5;
        nArray[20] = 1;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 2;
        nArray[24] = 2;
        this.objIAccessibleHypertext = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.addSelection(nArray[0], nArray[1]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.get_attributes(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_caretOffset(nArray[0]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_characterExtents(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_nSelections(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_offsetAtPoint(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_selection(nArray[0], nArray[1], nArray[2]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_text(nArray[0], nArray[1], nArray[2]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_textBeforeOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_textAfterOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_textAtOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.removeSelection(nArray[0]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.setCaretOffset(nArray[0]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.setSelection(nArray[0], nArray[1], nArray[2]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_nCharacters(nArray[0]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.scrollSubstringTo(nArray[0], nArray[1], nArray[2]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.scrollSubstringToPoint(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.get_newText(nArray[0]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.get_oldText(nArray[0]);
            }

            public int method22(int[] nArray) {
                return Accessible.this.get_nHyperlinks(nArray[0]);
            }

            public int method23(int[] nArray) {
                return Accessible.this.get_hyperlink(nArray[0], nArray[1]);
            }

            public int method24(int[] nArray) {
                return Accessible.this.get_hyperlinkIndex(nArray[0], nArray[1]);
            }
        };
    }

    void createIAccessibleTable2() {
        int[] nArray = new int[23];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 1;
        nArray[16] = 2;
        nArray[17] = 2;
        nArray[18] = 1;
        nArray[19] = 1;
        nArray[20] = 1;
        nArray[21] = 1;
        nArray[22] = 1;
        this.objIAccessibleTable2 = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_cellAt(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.get_caption(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_columnDescription(nArray[0], nArray[1]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_nColumns(nArray[0]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_nRows(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_nSelectedCells(nArray[0]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_nSelectedColumns(nArray[0]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_nSelectedRows(nArray[0]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_rowDescription(nArray[0], nArray[1]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_selectedCells(nArray[0], nArray[1]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_selectedColumns(nArray[0], nArray[1]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.get_selectedRows(nArray[0], nArray[1]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.get_summary(nArray[0]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.get_isColumnSelected(nArray[0], nArray[1]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_isRowSelected(nArray[0], nArray[1]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.selectRow(nArray[0]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.selectColumn(nArray[0]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.unselectRow(nArray[0]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.unselectColumn(nArray[0]);
            }

            public int method22(int[] nArray) {
                return Accessible.this.get_modelChange(nArray[0]);
            }
        };
    }

    void createIAccessibleTableCell() {
        int[] nArray = new int[12];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 2;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 5;
        nArray[11] = 1;
        this.objIAccessibleTableCell = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_columnExtent(nArray[0]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.get_columnHeaderCells(nArray[0], nArray[1]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_columnIndex(nArray[0]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_rowExtent(nArray[0]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_rowHeaderCells(nArray[0], nArray[1]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_rowIndex(nArray[0]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_isSelected(nArray[0]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_rowColumnExtents(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_table(nArray[0]);
            }
        };
    }

    void createIAccessibleText() {
        int[] nArray = new int[22];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 4;
        nArray[5] = 1;
        nArray[6] = 6;
        nArray[7] = 1;
        nArray[8] = 4;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 5;
        nArray[12] = 5;
        nArray[13] = 5;
        nArray[14] = 1;
        nArray[15] = 1;
        nArray[16] = 3;
        nArray[17] = 1;
        nArray[18] = 3;
        nArray[19] = 5;
        nArray[20] = 1;
        nArray[21] = 1;
        this.objIAccessibleText = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.addSelection(nArray[0], nArray[1]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.get_attributes(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_caretOffset(nArray[0]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_characterExtents(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
            }

            public int method7(int[] nArray) {
                return Accessible.this.get_nSelections(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Accessible.this.get_offsetAtPoint(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            public int method9(int[] nArray) {
                return Accessible.this.get_selection(nArray[0], nArray[1], nArray[2]);
            }

            public int method10(int[] nArray) {
                return Accessible.this.get_text(nArray[0], nArray[1], nArray[2]);
            }

            public int method11(int[] nArray) {
                return Accessible.this.get_textBeforeOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method12(int[] nArray) {
                return Accessible.this.get_textAfterOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method13(int[] nArray) {
                return Accessible.this.get_textAtOffset(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method14(int[] nArray) {
                return Accessible.this.removeSelection(nArray[0]);
            }

            public int method15(int[] nArray) {
                return Accessible.this.setCaretOffset(nArray[0]);
            }

            public int method16(int[] nArray) {
                return Accessible.this.setSelection(nArray[0], nArray[1], nArray[2]);
            }

            public int method17(int[] nArray) {
                return Accessible.this.get_nCharacters(nArray[0]);
            }

            public int method18(int[] nArray) {
                return Accessible.this.scrollSubstringTo(nArray[0], nArray[1], nArray[2]);
            }

            public int method19(int[] nArray) {
                return Accessible.this.scrollSubstringToPoint(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
            }

            public int method20(int[] nArray) {
                return Accessible.this.get_newText(nArray[0]);
            }

            public int method21(int[] nArray) {
                return Accessible.this.get_oldText(nArray[0]);
            }
        };
    }

    void createIAccessibleValue() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        this.objIAccessibleValue = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.get_currentValue(nArray[0]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.setCurrentValue(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.get_maximumValue(nArray[0]);
            }

            public int method6(int[] nArray) {
                return Accessible.this.get_minimumValue(nArray[0]);
            }
        };
        int n = this.objIAccessibleValue.ppVtable;
        int[] nArray2 = new int[1];
        COM.MoveMemory(nArray2, n, OS.PTR_SIZEOF);
        int[] nArray3 = new int[7];
        COM.MoveMemory(nArray3, nArray2[0], OS.PTR_SIZEOF * nArray3.length);
        nArray3[4] = COM.CALLBACK_setCurrentValue(nArray3[4]);
        COM.MoveMemory(nArray2[0], nArray3, OS.PTR_SIZEOF * nArray3.length);
    }

    void createIEnumVARIANT() {
        int[] nArray = new int[7];
        nArray[0] = 2;
        nArray[3] = 3;
        nArray[4] = 1;
        nArray[6] = 1;
        this.objIEnumVARIANT = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.Next(nArray[0], nArray[1], nArray[2]);
            }

            public int method4(int[] nArray) {
                return Accessible.this.Skip(nArray[0]);
            }

            public int method5(int[] nArray) {
                return Accessible.this.Reset();
            }

            public int method6(int[] nArray) {
                return Accessible.this.Clone(nArray[0]);
            }
        };
    }

    void createIServiceProvider() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 3;
        this.objIServiceProvider = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Accessible.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Accessible.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Accessible.this.Release();
            }

            public int method3(int[] nArray) {
                return Accessible.this.QueryService(nArray[0], nArray[1], nArray[2]);
            }
        };
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.addElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.addElement(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.addElement(accessibleActionListener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        this.accessibleEditableTextListeners.addElement(accessibleEditableTextListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.addElement(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.addElement(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.addElement(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.addElement(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.addElement(accessibleAttributeListener);
    }

    public void addRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (this.relations[n] == null) {
            this.relations[n] = new Relation(this, n);
        }
        this.relations[n].addTarget(accessible);
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.Release();
        this.parent.children.removeElement(this);
        this.parent = null;
    }

    int getAddress() {
        if (this.objIAccessible == null) {
            this.createIAccessible();
        }
        return this.objIAccessible.getAddress();
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.iaccessible != null) {
            this.iaccessible.Release();
        }
        this.iaccessible = null;
        this.Release();
        int n = 0;
        while (n < this.children.size()) {
            Accessible accessible = (Accessible)this.children.elementAt(n);
            accessible.dispose();
            ++n;
        }
    }

    public int internal_WM_GETOBJECT(int n, int n2) {
        if (this.objIAccessible == null) {
            return 0;
        }
        if (n2 == -4) {
            return COM.LresultFromObject(COM.IIDIAccessible, n, this.objIAccessible.getAddress());
        }
        return 0;
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.removeElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.removeElement(accessibleTextListener);
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.removeElement(accessibleActionListener);
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener accessibleEditableTextListener) {
        this.checkWidget();
        if (accessibleEditableTextListener == null) {
            SWT.error(4);
        }
        this.accessibleEditableTextListeners.removeElement(accessibleEditableTextListener);
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.removeElement(accessibleHyperlinkListener);
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.removeElement(accessibleTableListener);
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.removeElement(accessibleTableCellListener);
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.removeElement(accessibleValueListener);
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.removeElement(accessibleAttributeListener);
    }

    public void removeRelation(int n, Accessible accessible) {
        this.checkWidget();
        Relation relation = this.relations[n];
        if (relation != null) {
            relation.removeTarget(accessible);
            if (!relation.hasTargets()) {
                this.relations[n].Release();
                this.relations[n] = null;
            }
        }
    }

    public void sendEvent(int n, Object object) {
        this.checkWidget();
        if (!UseIA2) {
            return;
        }
        switch (n) {
            case 518: {
                if (!(object instanceof int[]) || ((int[])object).length != 5) break;
                this.tableChange = (int[])object;
                COM.NotifyWinEvent(278, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 524: {
                if (!(object instanceof Object[]) || ((Object[])object).length != 4) break;
                Object[] objectArray = (Object[])object;
                int n2 = (Integer)objectArray[0];
                switch (n2) {
                    case 1: {
                        this.textDeleted = (Object[])object;
                        COM.NotifyWinEvent(287, this.control.handle, -4, this.eventChildID());
                        break;
                    }
                    case 0: {
                        this.textInserted = (Object[])object;
                        COM.NotifyWinEvent(286, this.control.handle, -4, this.eventChildID());
                    }
                }
                break;
            }
            case 268: {
                if (!(object instanceof Integer)) break;
                COM.NotifyWinEvent(268, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32782: {
                COM.NotifyWinEvent(32782, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32778: {
                COM.NotifyWinEvent(32778, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32777: {
                COM.NotifyWinEvent(32777, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32788: {
                COM.NotifyWinEvent(32788, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32779: {
                COM.NotifyWinEvent(32779, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32780: {
                COM.NotifyWinEvent(32780, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 32781: {
                COM.NotifyWinEvent(32781, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 261: {
                COM.NotifyWinEvent(261, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 262: {
                COM.NotifyWinEvent(262, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 263: {
                COM.NotifyWinEvent(263, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 273: {
                COM.NotifyWinEvent(273, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 274: {
                COM.NotifyWinEvent(274, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 256: {
                COM.NotifyWinEvent(257, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 269: {
                COM.NotifyWinEvent(269, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 264: {
                COM.NotifyWinEvent(264, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 265: {
                COM.NotifyWinEvent(265, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 266: {
                COM.NotifyWinEvent(266, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 267: {
                COM.NotifyWinEvent(267, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 271: {
                COM.NotifyWinEvent(271, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 512: {
                COM.NotifyWinEvent(272, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 515: {
                COM.NotifyWinEvent(275, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 516: {
                COM.NotifyWinEvent(276, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 517: {
                COM.NotifyWinEvent(277, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 519: {
                COM.NotifyWinEvent(279, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 520: {
                COM.NotifyWinEvent(280, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 521: {
                COM.NotifyWinEvent(281, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 522: {
                COM.NotifyWinEvent(282, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 283: {
                COM.NotifyWinEvent(283, this.control.handle, -4, this.eventChildID());
                break;
            }
            case 285: {
                COM.NotifyWinEvent(285, this.control.handle, -4, this.eventChildID());
            }
        }
    }

    public void sendEvent(int n, Object object, int n2) {
        this.checkWidget();
        if (!UseIA2) {
            return;
        }
        int n3 = n2 == -1 ? this.eventChildID() : this.childIDToOs(n2);
        switch (n) {
            case 32778: {
                COM.NotifyWinEvent(32778, this.control.handle, -4, n3);
                break;
            }
            case 32780: {
                COM.NotifyWinEvent(32780, this.control.handle, -4, n3);
                break;
            }
            case 32782: {
                COM.NotifyWinEvent(32782, this.control.handle, -4, n3);
                break;
            }
            case 32779: {
                COM.NotifyWinEvent(32779, this.control.handle, -4, n3);
                break;
            }
            case 32777: {
                COM.NotifyWinEvent(32777, this.control.handle, -4, n3);
                break;
            }
            case 32788: {
                COM.NotifyWinEvent(32788, this.control.handle, -4, n3);
                break;
            }
            case 32781: {
                COM.NotifyWinEvent(32781, this.control.handle, -4, n3);
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        COM.NotifyWinEvent(32777, this.control.handle, -4, this.eventChildID());
    }

    public void setFocus(int n) {
        this.checkWidget();
        int n2 = n == -1 ? this.eventChildID() : this.childIDToOs(n);
        COM.NotifyWinEvent(32773, this.control.handle, -4, n2);
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        COM.NotifyWinEvent(32779, this.control.handle, -8, this.eventChildID());
        if (!UseIA2) {
            return;
        }
        COM.NotifyWinEvent(283, this.control.handle, -4, this.eventChildID());
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n2;
        accessibleTextEvent.end = n2 + n3;
        accessibleTextEvent.count = 0;
        accessibleTextEvent.type = 5;
        int n4 = 0;
        while (n4 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
            ++n4;
        }
        if (accessibleTextEvent.result != null) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n2 + n3), accessibleTextEvent.result};
            this.sendEvent(524, objectArray);
            return;
        }
        COM.NotifyWinEvent(32782, this.control.handle, -4, this.eventChildID());
    }

    public void textSelectionChanged() {
        this.checkWidget();
        COM.NotifyWinEvent(32782, this.control.handle, -4, this.eventChildID());
    }

    int QueryInterface(int n, int n2) {
        COM.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown)) {
            COM.MoveMemory(n2, new int[]{this.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDispatch) || COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            if (this.objIAccessible == null) {
                this.createIAccessible();
            }
            COM.MoveMemory(n2, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIEnumVARIANT)) {
            if (this.objIEnumVARIANT == null) {
                this.createIEnumVARIANT();
            }
            COM.MoveMemory(n2, new int[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            this.enumIndex = 0;
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIServiceProvider)) {
            if (!UseIA2) {
                return -2147467262;
            }
            if (this.accessibleActionListeners.size() > 0 || this.accessibleAttributeListeners.size() > 0 || this.accessibleHyperlinkListeners.size() > 0 || this.accessibleTableListeners.size() > 0 || this.accessibleTableCellListeners.size() > 0 || this.accessibleTextExtendedListeners.size() > 0 || this.accessibleValueListeners.size() > 0 || this.getRelationCount() > 0 || this.control instanceof Button && (this.control.getStyle() & 0x10) != 0) {
                if (this.objIServiceProvider == null) {
                    this.createIServiceProvider();
                }
                COM.MoveMemory(n2, new int[]{this.objIServiceProvider.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        int n3 = this.queryAccessible2Interfaces(gUID, n2);
        if (n3 != 1) {
            return n3;
        }
        if (this.iaccessible != null) {
            int[] nArray = new int[1];
            n3 = this.iaccessible.QueryInterface(gUID, nArray);
            COM.MoveMemory(n2, nArray, OS.PTR_SIZEOF);
            return n3;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessible != null) {
                this.objIAccessible.dispose();
            }
            this.objIAccessible = null;
            if (this.objIEnumVARIANT != null) {
                this.objIEnumVARIANT.dispose();
            }
            this.objIEnumVARIANT = null;
            if (this.objIServiceProvider != null) {
                this.objIServiceProvider.dispose();
            }
            this.objIServiceProvider = null;
            if (this.objIAccessible2 != null) {
                this.objIAccessible2.dispose();
            }
            this.objIAccessible2 = null;
            if (this.objIAccessibleAction != null) {
                this.objIAccessibleAction.dispose();
            }
            this.objIAccessibleAction = null;
            if (this.objIAccessibleApplication != null) {
                this.objIAccessibleApplication.dispose();
            }
            this.objIAccessibleApplication = null;
            if (this.objIAccessibleEditableText != null) {
                this.objIAccessibleEditableText.dispose();
            }
            this.objIAccessibleEditableText = null;
            if (this.objIAccessibleHyperlink != null) {
                this.objIAccessibleHyperlink.dispose();
            }
            this.objIAccessibleHyperlink = null;
            if (this.objIAccessibleHypertext != null) {
                this.objIAccessibleHypertext.dispose();
            }
            this.objIAccessibleHypertext = null;
            if (this.objIAccessibleTable2 != null) {
                this.objIAccessibleTable2.dispose();
            }
            this.objIAccessibleTable2 = null;
            if (this.objIAccessibleTableCell != null) {
                this.objIAccessibleTableCell.dispose();
            }
            this.objIAccessibleTableCell = null;
            if (this.objIAccessibleText != null) {
                this.objIAccessibleText.dispose();
            }
            this.objIAccessibleText = null;
            if (this.objIAccessibleValue != null) {
                this.objIAccessibleValue.dispose();
            }
            this.objIAccessibleValue = null;
            int n = 0;
            while (n < this.relations.length) {
                if (this.relations[n] != null) {
                    this.relations[n].Release();
                }
                ++n;
            }
        }
        return this.refCount;
    }

    int QueryService(int n, int n2, int n3) {
        int[] nArray;
        int n4;
        int n5;
        COM.MoveMemory(n3, new int[1], OS.PTR_SIZEOF);
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        GUID gUID2 = new GUID();
        COM.MoveMemory(gUID2, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible)) {
            if (COM.IsEqualGUID(gUID2, COM.IIDIUnknown) || COM.IsEqualGUID(gUID2, COM.IIDIDispatch) | COM.IsEqualGUID(gUID2, COM.IIDIAccessible)) {
                if (this.objIAccessible == null) {
                    this.createIAccessible();
                }
                COM.MoveMemory(n3, new int[]{this.objIAccessible.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            n5 = this.queryAccessible2Interfaces(gUID2, n3);
            if (n5 != 1) {
                return n5;
            }
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible2) && (n5 = this.queryAccessible2Interfaces(gUID2, n3)) != 1) {
            return n5;
        }
        if (this.iaccessible != null && (n4 = this.iaccessible.QueryInterface(COM.IIDIServiceProvider, nArray = new int[1])) == 0) {
            IServiceProvider iServiceProvider = new IServiceProvider(nArray[0]);
            int[] nArray2 = new int[1];
            n4 = iServiceProvider.QueryService(gUID, gUID2, nArray2);
            COM.MoveMemory(n3, nArray2, OS.PTR_SIZEOF);
            return n4;
        }
        return -2147467262;
    }

    int queryAccessible2Interfaces(GUID gUID, int n) {
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessible2)) {
            if (this.accessibleActionListeners.size() > 0 || this.accessibleAttributeListeners.size() > 0 || this.accessibleHyperlinkListeners.size() > 0 || this.accessibleTableListeners.size() > 0 || this.accessibleTableCellListeners.size() > 0 || this.accessibleTextExtendedListeners.size() > 0 || this.accessibleValueListeners.size() > 0 || this.getRelationCount() > 0 || this.control instanceof Button && (this.control.getStyle() & 0x10) != 0) {
                if (this.objIAccessible2 == null) {
                    this.createIAccessible2();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessible2.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleAction)) {
            if (this.accessibleActionListeners.size() > 0) {
                if (this.objIAccessibleAction == null) {
                    this.createIAccessibleAction();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleAction.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleApplication)) {
            if (this.objIAccessibleApplication == null) {
                this.createIAccessibleApplication();
            }
            COM.MoveMemory(n, new int[]{this.objIAccessibleApplication.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleComponent)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleEditableText)) {
            if (this.accessibleEditableTextListeners.size() > 0) {
                if (this.objIAccessibleEditableText == null) {
                    this.createIAccessibleEditableText();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleEditableText.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleHyperlink)) {
            if (this.accessibleHyperlinkListeners.size() > 0) {
                if (this.objIAccessibleHyperlink == null) {
                    this.createIAccessibleHyperlink();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleHyperlink.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleHypertext)) {
            if (this.accessibleTextExtendedListeners.size() > 0) {
                if (this.objIAccessibleHypertext == null) {
                    this.createIAccessibleHypertext();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleHypertext.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleImage)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTable)) {
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTable2)) {
            if (this.accessibleTableListeners.size() > 0) {
                if (this.objIAccessibleTable2 == null) {
                    this.createIAccessibleTable2();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleTable2.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleTableCell)) {
            if (this.accessibleTableCellListeners.size() > 0) {
                if (this.objIAccessibleTableCell == null) {
                    this.createIAccessibleTableCell();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleTableCell.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleText)) {
            if (this.accessibleTextExtendedListeners.size() > 0) {
                if (this.objIAccessibleText == null) {
                    this.createIAccessibleText();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleText.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIAccessibleValue)) {
            if (this.accessibleValueListeners.size() > 0) {
                if (this.objIAccessibleValue == null) {
                    this.createIAccessibleValue();
                }
                COM.MoveMemory(n, new int[]{this.objIAccessibleValue.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0;
            }
            return -2147467262;
        }
        return 1;
    }

    int accDoDefaultAction(int n) {
        if (this.accessibleActionListeners.size() > 0) {
            VARIANT vARIANT = this.getVARIANT(n);
            if (vARIANT.vt != 3) {
                return -2147024809;
            }
            if (vARIANT.lVal == 0) {
                return this.doAction(0);
            }
        }
        int n2 = -2147352573;
        if (this.iaccessible != null && (n2 = this.iaccessible.accDoDefaultAction(n)) == -2147024809) {
            n2 = -2147352573;
        }
        return n2;
    }

    int accHitTest(int n, int n2, int n3) {
        int n4 = -2;
        int n5 = 0;
        if (this.iaccessible != null) {
            int n6 = this.iaccessible.accHitTest(n, n2, n3);
            if (n6 == 0) {
                VARIANT vARIANT = this.getVARIANT(n3);
                if (vARIANT.vt == 3) {
                    n4 = vARIANT.lVal;
                } else if (vARIANT.vt == 9) {
                    n5 = vARIANT.lVal;
                }
            }
            if (this.accessibleControlListeners.size() == 0) {
                return n6;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n4 == -2 ? -2 : this.osToChildID(n4);
        accessibleControlEvent.x = n;
        accessibleControlEvent.y = n2;
        int n7 = 0;
        while (n7 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n7);
            accessibleControlListener.getChildAtPoint(accessibleControlEvent);
            ++n7;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(n3, (short)9, accessible.getAddress());
            return 0;
        }
        int n8 = accessibleControlEvent.childID;
        if (n8 == -2) {
            if (n5 != 0) {
                return 0;
            }
            this.setIntVARIANT(n3, (short)0, 0);
            return 1;
        }
        this.setIntVARIANT(n3, (short)3, this.childIDToOs(n8));
        return 0;
    }

    int accLocation(int n, int n2, int n3, int n4, int n5) {
        Object object;
        VARIANT vARIANT = this.getVARIANT(n5);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n6 = 0;
        Object object2 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this.iaccessible != null) {
            int n9 = this.iaccessible.accLocation(n, n2, n3, n4, n5);
            if (n9 == -2147024809) {
                n9 = -2147352573;
            }
            if (this.accessibleControlListeners.size() == 0) {
                return n9;
            }
            if (n9 == 0) {
                int[] nArray = new int[1];
                object = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                COM.MoveMemory(nArray, n, 4);
                COM.MoveMemory((int[])object, n2, 4);
                COM.MoveMemory(nArray2, n3, 4);
                COM.MoveMemory(nArray3, n4, 4);
                n6 = nArray[0];
                object2 = object[0];
                n7 = nArray2[0];
                n8 = nArray3[0];
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        accessibleControlEvent.x = n6;
        accessibleControlEvent.y = object2;
        accessibleControlEvent.width = n7;
        accessibleControlEvent.height = n8;
        int n10 = 0;
        while (n10 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n10);
            object.getLocation(accessibleControlEvent);
            ++n10;
        }
        OS.MoveMemory(n, new int[]{accessibleControlEvent.x}, 4);
        OS.MoveMemory(n2, new int[]{accessibleControlEvent.y}, 4);
        OS.MoveMemory(n3, new int[]{accessibleControlEvent.width}, 4);
        OS.MoveMemory(n4, new int[]{accessibleControlEvent.height}, 4);
        return 0;
    }

    int accNavigate(int n, int n2, int n3) {
        int n4 = -2147352573;
        if (this.iaccessible != null && (n4 = this.iaccessible.accNavigate(n, n2, n3)) == -2147024809) {
            n4 = -2147352573;
        }
        return n4;
    }

    int accSelect(int n, int n2) {
        int n3 = -2147352573;
        if (this.iaccessible != null && (n3 = this.iaccessible.accSelect(n, n2)) == -2147024809) {
            n3 = -2147352573;
        }
        return n3;
    }

    int get_accChild(int n, int n2) {
        Object object;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        if (vARIANT.lVal == 0) {
            this.AddRef();
            COM.MoveMemory(n2, new int[]{this.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        final int n3 = this.osToChildID(vARIANT.lVal);
        int n4 = 1;
        Accessible accessible = null;
        if (this.iaccessible != null) {
            ToolItem toolItem;
            n4 = this.iaccessible.get_accChild(n, n2);
            if (n4 == -2147024809) {
                n4 = 1;
            }
            if (n4 == 0 && this.control instanceof ToolBar && (toolItem = ((ToolBar)(object2 = (ToolBar)this.control)).getItem(n3)) != null && (toolItem.getStyle() & 4) != 0) {
                object = new int[1];
                COM.MoveMemory((int[])object, n2, OS.PTR_SIZEOF);
                boolean bl = false;
                int n5 = 0;
                while (n5 < this.children.size()) {
                    Accessible accessible2 = (Accessible)this.children.elementAt(n5);
                    if (accessible2.item == toolItem) {
                        accessible2.dispose();
                        accessible2.item = null;
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                accessible = new Accessible(this, (int)object[0]);
                accessible.item = toolItem;
                if (!bl) {
                    toolItem.addListener(12, new Listener(){

                        public void handleEvent(Event event) {
                            int n = 0;
                            while (n < Accessible.this.children.size()) {
                                Accessible accessible = (Accessible)Accessible.this.children.elementAt(n);
                                if (accessible.item == toolItem) {
                                    accessible.dispose();
                                }
                                ++n;
                            }
                        }
                    });
                }
                accessible.addAccessibleListener(new AccessibleAdapter(){

                    public void getName(AccessibleEvent accessibleEvent) {
                        if (accessibleEvent.childID == -1) {
                            AccessibleEvent accessibleEvent2 = new AccessibleEvent(Accessible.this);
                            accessibleEvent2.childID = n3;
                            int n = 0;
                            while (n < Accessible.this.accessibleListeners.size()) {
                                AccessibleListener accessibleListener = (AccessibleListener)Accessible.this.accessibleListeners.elementAt(n);
                                accessibleListener.getName(accessibleEvent2);
                                ++n;
                            }
                            accessibleEvent.result = accessibleEvent2.result;
                        }
                    }
                });
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = n3;
        int n6 = 0;
        while (n6 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
            object.getChild((AccessibleControlEvent)object2);
            ++n6;
        }
        Accessible accessible3 = ((AccessibleControlEvent)object2).accessible;
        if (accessible3 == null) {
            accessible3 = accessible;
        }
        if (accessible3 != null) {
            accessible3.AddRef();
            COM.MoveMemory(n2, new int[]{accessible3.getAddress()}, OS.PTR_SIZEOF);
            return 0;
        }
        return n4;
    }

    int get_accChildCount(int n) {
        int n2 = 0;
        if (this.iaccessible != null) {
            int n3 = this.iaccessible.get_accChildCount(n);
            if (n3 == 0) {
                int[] nArray = new int[1];
                COM.MoveMemory(nArray, n, 4);
                n2 = nArray[0];
            }
            if (this.accessibleControlListeners.size() == 0) {
                return n3;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        accessibleControlEvent.detail = n2;
        int n4 = 0;
        while (n4 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
            accessibleControlListener.getChildCount(accessibleControlEvent);
            ++n4;
        }
        COM.MoveMemory(n, new int[]{accessibleControlEvent.detail}, 4);
        return 0;
    }

    int get_accDefaultAction(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n4 = this.iaccessible.get_accDefaultAction(n, n2);
            if (n4 == -2147024809) {
                n4 = 1;
            }
            if (this.accessibleControlListeners.size() == 0) {
                return n4;
            }
            if (n4 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n3 = COM.SysStringByteLen((int)object2[0]);
                if (n3 > 0) {
                    object = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n3);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object2).result = string;
        n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            object.getDefaultAction((AccessibleControlEvent)object2);
            ++n3;
        }
        if ((((AccessibleControlEvent)object2).result == null || ((AccessibleControlEvent)object2).result.length() == 0) && vARIANT.lVal == 0) {
            n4 = this.get_name(0, n2);
        }
        if (((AccessibleControlEvent)object2).result == null) {
            return n4;
        }
        if (((AccessibleControlEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(n2, ((AccessibleControlEvent)object2).result);
        return 0;
    }

    int get_accDescription(int n, int n2) {
        Tree tree;
        int n3;
        Object object;
        int n4;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n5 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n5 = this.iaccessible.get_accDescription(n, n2);
            if (n5 == -2147024809) {
                n5 = 1;
            }
            if (this.accessibleListeners.size() == 0 && !(this.control instanceof Tree)) {
                return n5;
            }
            if (n5 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n4 = COM.SysStringByteLen((int)object2[0]);
                if (n4 > 0) {
                    object = new char[(n4 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n4);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (vARIANT.lVal != 0 && this.control instanceof Tree && (n3 = (tree = (Tree)this.control).getColumnCount()) > 1) {
            int n6 = this.control.handle;
            int n7 = 0;
            n7 = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(n6, 4394, vARIANT.lVal, 0) : vARIANT.lVal;
            Widget widget = tree.getDisplay().findWidget(n6, n7);
            ((AccessibleEvent)object2).result = "";
            if (widget != null && widget instanceof TreeItem) {
                TreeItem treeItem = (TreeItem)widget;
                int n8 = 1;
                while (n8 < n3) {
                    ((AccessibleEvent)object2).result = String.valueOf(((AccessibleEvent)object2).result) + tree.getColumn(n8).getText() + ": " + treeItem.getText(n8);
                    if (n8 + 1 < n3) {
                        ((AccessibleEvent)object2).result = String.valueOf(((AccessibleEvent)object2).result) + ", ";
                    }
                    ++n8;
                }
            }
        }
        n4 = 0;
        while (n4 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n4);
            object.getDescription((AccessibleEvent)object2);
            ++n4;
        }
        if (((AccessibleEvent)object2).result == null) {
            return n5;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(n2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accFocus(int n) {
        int n2 = -2;
        if (this.iaccessible != null) {
            int n3 = this.iaccessible.get_accFocus(n);
            if (n3 == 0) {
                VARIANT vARIANT = this.getVARIANT(n);
                if (vARIANT.vt == 3) {
                    n2 = vARIANT.lVal;
                }
            }
            if (this.accessibleControlListeners.size() == 0) {
                return n3;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2 == -2 ? -2 : this.osToChildID(n2);
        int n4 = 0;
        while (n4 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
            accessibleControlListener.getFocus(accessibleControlEvent);
            ++n4;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(n, (short)9, accessible.getAddress());
            return 0;
        }
        int n5 = accessibleControlEvent.childID;
        if (n5 == -2) {
            this.setIntVARIANT(n, (short)0, 0);
            return 1;
        }
        if (n5 == -1) {
            this.AddRef();
            this.setIntVARIANT(n, (short)3, 0);
            return 0;
        }
        this.setIntVARIANT(n, (short)3, this.childIDToOs(n5));
        return 0;
    }

    int get_accHelp(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n4 = this.iaccessible.get_accHelp(n, n2);
            if (n4 == -2147024809) {
                n4 = 1;
            }
            if (this.accessibleListeners.size() == 0) {
                return n4;
            }
            if (n4 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n3 = COM.SysStringByteLen((int)object2[0]);
                if (n3 > 0) {
                    object = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n3);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        n3 = 0;
        while (n3 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n3);
            object.getHelp((AccessibleEvent)object2);
            ++n3;
        }
        if (((AccessibleEvent)object2).result == null) {
            return n4;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(n2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accHelpTopic(int n, int n2, int n3) {
        int n4 = -2147352573;
        if (this.iaccessible != null && (n4 = this.iaccessible.get_accHelpTopic(n, n2, n3)) == -2147024809) {
            n4 = -2147352573;
        }
        return n4;
    }

    int get_accKeyboardShortcut(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n4 = this.iaccessible.get_accKeyboardShortcut(n, n2);
            if (n4 == -2147024809) {
                n4 = 1;
            }
            if (this.accessibleListeners.size() == 0 && !(this.control instanceof TabFolder)) {
                return n4;
            }
            if (n4 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n3 = COM.SysStringByteLen((int)object2[0]);
                if (n3 > 0) {
                    object = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n3);
                    string = new String((char[])object);
                }
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (vARIANT.lVal == 0 && this.control instanceof TabFolder) {
            ((AccessibleEvent)object2).result = SWT.getMessage("SWT_SwitchPage_Shortcut");
        }
        n3 = 0;
        while (n3 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n3);
            object.getKeyboardShortcut((AccessibleEvent)object2);
            ++n3;
        }
        if (((AccessibleEvent)object2).result == null) {
            return n4;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(n2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accName(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = 1;
        String string = null;
        if (this.iaccessible != null) {
            n4 = this.iaccessible.get_accName(n, n2);
            if (n4 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n3 = COM.SysStringByteLen((int)object2[0]);
                if (n3 > 0) {
                    object = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n3);
                    string = new String((char[])object);
                }
            }
            if (n4 == -2147024809) {
                n4 = 1;
            }
            if (this.accessibleListeners.size() == 0 && !(this.control instanceof Text)) {
                return n4;
            }
        }
        object2 = new AccessibleEvent(this);
        ((AccessibleEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleEvent)object2).result = string;
        if (this.control instanceof Text && (this.control.getStyle() & 0x80) != 0 && string == null) {
            ((AccessibleEvent)object2).result = ((Text)this.control).getMessage();
        }
        n3 = 0;
        while (n3 < this.accessibleListeners.size()) {
            object = (AccessibleListener)this.accessibleListeners.elementAt(n3);
            object.getName((AccessibleEvent)object2);
            ++n3;
        }
        if (((AccessibleEvent)object2).result == null) {
            return n4;
        }
        if (((AccessibleEvent)object2).result.length() == 0) {
            return 1;
        }
        this.setString(n2, ((AccessibleEvent)object2).result);
        return 0;
    }

    int get_accParent(int n) {
        int n2 = -2147352573;
        if (this.iaccessible != null) {
            n2 = this.iaccessible.get_accParent(n);
        }
        if (this.parent != null) {
            this.parent.AddRef();
            COM.MoveMemory(n, new int[]{this.parent.getAddress()}, OS.PTR_SIZEOF);
            n2 = 0;
        }
        return n2;
    }

    int get_accRole(int n, int n2) {
        int n3;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = 10;
        if (this.iaccessible != null && (n3 = this.iaccessible.get_accRole(n, n2)) == 0) {
            VARIANT vARIANT2 = this.getVARIANT(n2);
            if (vARIANT2.vt == 3) {
                n4 = vARIANT2.lVal;
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = this.osToChildID(vARIANT.lVal);
        accessibleControlEvent.detail = this.osToRole(n4);
        if ((this.control instanceof Tree || this.control instanceof Table) && vARIANT.lVal != 0 && (this.control.getStyle() & 0x20) != 0) {
            accessibleControlEvent.detail = 44;
        }
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n5;
        }
        this.setIntVARIANT(n2, (short)3, this.roleToOs(accessibleControlEvent.detail));
        return 0;
    }

    int get_accSelection(int n) {
        int n2 = -2;
        int n3 = 0;
        if (this.iaccessible != null) {
            int n4 = this.iaccessible.get_accSelection(n);
            if (this.accessibleControlListeners.size() == 0) {
                return n4;
            }
            if (n4 == 0) {
                VARIANT vARIANT = this.getVARIANT(n);
                if (vARIANT.vt == 3) {
                    n2 = this.osToChildID(vARIANT.lVal);
                } else if (vARIANT.vt == 9) {
                    n3 = vARIANT.lVal;
                } else if (vARIANT.vt == 13) {
                    n2 = -3;
                }
            }
        }
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n2;
        int n5 = 0;
        while (n5 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n5);
            accessibleControlListener.getSelection(accessibleControlEvent);
            ++n5;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(n, (short)9, accessible.getAddress());
            return 0;
        }
        int n6 = accessibleControlEvent.childID;
        if (n6 == -2) {
            if (n3 != 0) {
                return 0;
            }
            this.setIntVARIANT(n, (short)0, 0);
            return 1;
        }
        if (n6 == -3) {
            return 0;
        }
        if (n6 == -1) {
            this.AddRef();
            this.setPtrVARIANT(n, (short)9, this.getAddress());
            return 0;
        }
        this.setIntVARIANT(n, (short)3, this.childIDToOs(n6));
        return 0;
    }

    int get_accState(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        int n4;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n5 = 0;
        if (this.iaccessible != null && (n4 = this.iaccessible.get_accState(n, n2)) == 0) {
            object2 = this.getVARIANT(n2);
            if (((VARIANT)object2).vt == 3) {
                n5 = ((VARIANT)object2).lVal;
            }
        }
        n4 = 0;
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object2).detail = this.osToState(n5);
        if (vARIANT.lVal != 0) {
            if (this.control instanceof Tree && (this.control.getStyle() & 0x20) != 0) {
                boolean bl;
                n3 = this.control.handle;
                object = new TVITEM();
                ((TVITEM)object).mask = 24;
                ((TVITEM)object).stateMask = 61440;
                ((TVITEM)object).hItem = OS.COMCTL32_MAJOR >= 6 ? OS.SendMessage(n3, 4394, vARIANT.lVal, 0) : vARIANT.lVal;
                int n6 = OS.SendMessage(n3, OS.TVM_GETITEM, 0, (TVITEM)object);
                boolean bl2 = bl = n6 != 0 && (((TVITEM)object).state >> 12 & 1) == 0;
                if (bl) {
                    ((AccessibleControlEvent)object2).detail |= 0x10;
                }
                n4 = ((TVITEM)object).state >> 12 > 2 ? 1 : 0;
            } else if (this.control instanceof Table && (this.control.getStyle() & 0x20) != 0) {
                Table table = (Table)this.control;
                int n7 = ((AccessibleControlEvent)object2).childID;
                if (n7 >= 0 && n7 < table.getItemCount()) {
                    TableItem tableItem = table.getItem(n7);
                    if (tableItem.getChecked()) {
                        ((AccessibleControlEvent)object2).detail |= 0x10;
                    }
                    if (tableItem.getGrayed()) {
                        n4 = 1;
                    }
                }
            }
        }
        n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            object.getState((AccessibleControlEvent)object2);
            ++n3;
        }
        n3 = this.stateToOs(((AccessibleControlEvent)object2).detail);
        if ((n3 & 0x10) != 0 && n4 != 0) {
            n3 &= 0xFFFFFFEF;
            n3 |= 0x20;
        }
        this.setIntVARIANT(n2, (short)3, n3);
        return 0;
    }

    int get_accValue(int n, int n2) {
        Object object;
        int n3;
        Object object2;
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n4 = -2147352573;
        String string = null;
        if (this.iaccessible != null) {
            n4 = this.iaccessible.get_accValue(n, n2);
            if (n4 == 0) {
                object2 = new int[1];
                COM.MoveMemory((int[])object2, n2, OS.PTR_SIZEOF);
                n3 = COM.SysStringByteLen((int)object2[0]);
                if (n3 > 0) {
                    object = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])object, (int)object2[0], n3);
                    string = new String((char[])object);
                }
            }
            if (n4 == -2147024809) {
                n4 = -2147352573;
            }
            if (this.accessibleControlListeners.size() == 0 && !(this.control instanceof Text)) {
                return n4;
            }
        }
        object2 = new AccessibleControlEvent(this);
        ((AccessibleControlEvent)object2).childID = this.osToChildID(vARIANT.lVal);
        ((AccessibleControlEvent)object2).result = string;
        if (this.control instanceof Text && (this.control.getStyle() & 0x80) != 0 && !this.control.isFocusControl()) {
            ((AccessibleControlEvent)object2).result = ((Text)this.control).getMessage();
        }
        n3 = 0;
        while (n3 < this.accessibleControlListeners.size()) {
            object = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n3);
            object.getValue((AccessibleControlEvent)object2);
            ++n3;
        }
        if (((AccessibleControlEvent)object2).result == null) {
            return n4;
        }
        this.setString(n2, ((AccessibleControlEvent)object2).result);
        return 0;
    }

    int put_accName(int n, int n2) {
        return -2147467263;
    }

    int put_accValue(int n, int n2) {
        VARIANT vARIANT = this.getVARIANT(n);
        if (vARIANT.vt != 3) {
            return -2147024809;
        }
        int n3 = -2147352573;
        if (vARIANT.lVal == 0 && this.accessibleEditableTextListeners.size() > 0) {
            AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
            accessibleEditableTextEvent.start = 0;
            accessibleEditableTextEvent.end = this.getCharacterCount();
            if (accessibleEditableTextEvent.end >= 0) {
                int n4 = COM.SysStringByteLen(n2);
                char[] cArray = new char[(n4 + 1) / 2];
                OS.MoveMemory(cArray, n2, n4);
                accessibleEditableTextEvent.string = new String(cArray);
                int n5 = 0;
                while (n5 < this.accessibleEditableTextListeners.size()) {
                    AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n5);
                    accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
                    ++n5;
                }
                if (accessibleEditableTextEvent.result != null && accessibleEditableTextEvent.result.equals("OK")) {
                    n3 = 0;
                }
            }
        }
        if (n3 != 0 && this.iaccessible != null && (n3 = this.iaccessible.put_accValue(n, n2)) == -2147024809) {
            n3 = -2147352573;
        }
        return n3;
    }

    int Next(int n, int n2, int n3) {
        int n4;
        Object[] objectArray;
        if (this.iaccessible != null && this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n5 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n5 != 0) {
                return n5;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            int[] nArray2 = new int[1];
            n5 = iEnumVARIANT.Next(n, n2, nArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(n3, nArray2, 4);
            return n5;
        }
        if (n2 == 0) {
            return -2147024809;
        }
        if (n3 == 0 && n != 1) {
            return -2147024809;
        }
        if (this.enumIndex == 0) {
            objectArray = new AccessibleControlEvent(this);
            objectArray.childID = -1;
            n4 = 0;
            while (n4 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n4);
                accessibleControlListener.getChildren((AccessibleControlEvent)objectArray);
                ++n4;
            }
            this.variants = objectArray.children;
        }
        objectArray = null;
        if (this.variants != null && n >= 1) {
            n4 = this.enumIndex + n - 1;
            if (n4 > this.variants.length - 1) {
                n4 = this.variants.length - 1;
            }
            if (this.enumIndex <= n4) {
                objectArray = new Object[n4 - this.enumIndex + 1];
                int n6 = 0;
                while (n6 < objectArray.length) {
                    Object object = this.variants[this.enumIndex];
                    objectArray[n6] = object instanceof Integer ? new Integer(this.childIDToOs((Integer)object)) : object;
                    ++this.enumIndex;
                    ++n6;
                }
            }
        }
        if (objectArray != null) {
            n4 = 0;
            while (n4 < objectArray.length) {
                AccessibleControlEvent accessibleControlEvent = objectArray[n4];
                if (accessibleControlEvent instanceof Integer) {
                    int n7 = (Integer)((Object)accessibleControlEvent);
                    this.setIntVARIANT(n2 + n4 * VARIANT.sizeof, (short)3, n7);
                } else {
                    Accessible accessible = (Accessible)((Object)accessibleControlEvent);
                    accessible.AddRef();
                    this.setPtrVARIANT(n2 + n4 * VARIANT.sizeof, (short)9, accessible.getAddress());
                }
                ++n4;
            }
            if (n3 != 0) {
                COM.MoveMemory(n3, new int[]{objectArray.length}, 4);
            }
            if (objectArray.length == n) {
                return 0;
            }
        } else if (n3 != 0) {
            COM.MoveMemory(n3, new int[1], 4);
        }
        return 1;
    }

    int Skip(int n) {
        if (this.iaccessible != null && this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n2 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n2 != 0) {
                return n2;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            n2 = iEnumVARIANT.Skip(n);
            iEnumVARIANT.Release();
            return n2;
        }
        if (n < 1) {
            return -2147024809;
        }
        this.enumIndex += n;
        if (this.enumIndex > this.variants.length - 1) {
            this.enumIndex = this.variants.length - 1;
            return 1;
        }
        return 0;
    }

    int Reset() {
        if (this.iaccessible != null && this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n != 0) {
                return n;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            n = iEnumVARIANT.Reset();
            iEnumVARIANT.Release();
            return n;
        }
        this.enumIndex = 0;
        return 0;
    }

    int Clone(int n) {
        if (this.iaccessible != null && this.accessibleControlListeners.size() == 0) {
            int[] nArray = new int[1];
            int n2 = this.iaccessible.QueryInterface(COM.IIDIEnumVARIANT, nArray);
            if (n2 != 0) {
                return n2;
            }
            IEnumVARIANT iEnumVARIANT = new IEnumVARIANT(nArray[0]);
            int[] nArray2 = new int[1];
            n2 = iEnumVARIANT.Clone(nArray2);
            iEnumVARIANT.Release();
            COM.MoveMemory(n, nArray2, OS.PTR_SIZEOF);
            return n2;
        }
        if (n == 0) {
            return -2147024809;
        }
        COM.MoveMemory(n, new int[]{this.objIEnumVARIANT.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int get_nRelations(int n) {
        int n2 = this.getRelationCount();
        COM.MoveMemory(n, new int[]{n2}, 4);
        return 0;
    }

    int get_relation(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        while (n4 < 15) {
            Relation relation = this.relations[n4];
            if (relation != null) {
                ++n3;
            }
            if (n3 == n) {
                relation.AddRef();
                COM.MoveMemory(n2, new int[]{relation.getAddress()}, OS.PTR_SIZEOF);
                return 0;
            }
            ++n4;
        }
        return -2147024809;
    }

    int get_relations(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < 15) {
            if (n4 == n) break;
            Relation relation = this.relations[n5];
            if (relation != null) {
                relation.AddRef();
                COM.MoveMemory(n2 + n4 * OS.PTR_SIZEOF, new int[]{relation.getAddress()}, OS.PTR_SIZEOF);
                ++n4;
            }
            ++n5;
        }
        COM.MoveMemory(n3, new int[]{n4}, 4);
        return 0;
    }

    int get_role(int n) {
        int n2 = this.getRole();
        if (n2 == 0) {
            n2 = this.getDefaultRole();
        }
        COM.MoveMemory(n, new int[]{n2}, 4);
        return 0;
    }

    int scrollTo(int n) {
        if (n < 4 || n > 6) {
            return -2147024809;
        }
        return -2147467263;
    }

    int scrollToPoint(int n, int n2, int n3) {
        if (n != 0) {
            return -2147024809;
        }
        return -2147467263;
    }

    int get_groupPosition(int n, int n2, int n3) {
        int n4 = 0;
        COM.MoveMemory(n, new int[]{n4}, 4);
        int n5 = 0;
        int n6 = 0;
        if (this.control instanceof Button && (this.control.getStyle() & 0x10) != 0) {
            Control[] controlArray = this.control.getParent().getChildren();
            n6 = 1;
            n5 = 1;
            int n7 = 0;
            while (n7 < controlArray.length) {
                Control control = controlArray[n7];
                if (control instanceof Button && (control.getStyle() & 0x10) != 0) {
                    if (control == this.control) {
                        n6 = n5;
                    } else {
                        ++n5;
                    }
                }
                ++n7;
            }
        }
        COM.MoveMemory(n2, new int[]{n5}, 4);
        COM.MoveMemory(n3, new int[]{n6}, 4);
        if (n4 == 0 && n5 == 0 && n6 == 0) {
            return 1;
        }
        return 0;
    }

    int get_states(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getState(accessibleControlEvent);
            ++n2;
        }
        n2 = accessibleControlEvent.detail;
        int n3 = 0;
        if ((n2 & 0x4000000) != 0) {
            n3 |= 1;
        }
        if ((n2 & 0x8000000) != 0) {
            n3 |= 0x2000;
        }
        if ((n2 & 0x10000000) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x2000000) != 0) {
            n3 |= 0x800;
        }
        if ((n2 & 0x20000000) != 0) {
            n3 |= 0x40;
        }
        if ((n2 & 0x40000000) != 0) {
            n3 |= 0x8000;
        }
        if (this.getRole() == 42 && this.accessibleTextExtendedListeners.size() > 0) {
            n3 |= 8;
        }
        COM.MoveMemory(n, new int[]{n3}, 4);
        return 0;
    }

    int get_extendedRole(int n) {
        this.setString(n, null);
        return 1;
    }

    int get_localizedExtendedRole(int n) {
        this.setString(n, null);
        return 1;
    }

    int get_nExtendedStates(int n) {
        COM.MoveMemory(n, new int[1], 4);
        return 0;
    }

    int get_extendedStates(int n, int n2, int n3) {
        this.setString(n2, null);
        COM.MoveMemory(n3, new int[1], 4);
        return 1;
    }

    int get_localizedExtendedStates(int n, int n2, int n3) {
        this.setString(n2, null);
        COM.MoveMemory(n3, new int[1], 4);
        return 1;
    }

    int get_uniqueID(int n) {
        if (this.uniqueID == -1) {
            this.uniqueID = UniqueID--;
        }
        COM.MoveMemory(n, new int[]{this.uniqueID}, 4);
        return 0;
    }

    int get_windowHandle(int n) {
        COM.MoveMemory(n, new int[]{this.control.handle}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_indexInParent(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -5;
        accessibleControlEvent.detail = -1;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getChild(accessibleControlEvent);
            ++n2;
        }
        n2 = accessibleControlEvent.detail;
        COM.MoveMemory(n, new int[]{n2}, 4);
        return n2 == -1 ? 1 : 0;
    }

    int get_locale(int n) {
        Locale locale = Locale.getDefault();
        char[] cArray = (String.valueOf(locale.getLanguage()) + "\u0000").toCharArray();
        int n2 = COM.SysAllocString(cArray);
        COM.MoveMemory(n, new int[]{n2}, OS.PTR_SIZEOF);
        cArray = (String.valueOf(locale.getCountry()) + "\u0000").toCharArray();
        n2 = COM.SysAllocString(cArray);
        COM.MoveMemory(n + OS.PTR_SIZEOF, new int[]{n2}, OS.PTR_SIZEOF);
        cArray = (String.valueOf(locale.getVariant()) + "\u0000").toCharArray();
        n2 = COM.SysAllocString(cArray);
        COM.MoveMemory(n + 2 * OS.PTR_SIZEOF, new int[]{n2}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_attributes(int n) {
        AccessibleAttributeEvent accessibleAttributeEvent = new AccessibleAttributeEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleAttributeListeners.size()) {
            AccessibleAttributeListener accessibleAttributeListener = (AccessibleAttributeListener)this.accessibleAttributeListeners.elementAt(n2);
            accessibleAttributeListener.getAttributes(accessibleAttributeEvent);
            ++n2;
        }
        String string = "";
        string = String.valueOf(string) + "margin-left:" + accessibleAttributeEvent.leftMargin + ";";
        string = String.valueOf(string) + "margin-top:" + accessibleAttributeEvent.topMargin + ";";
        string = String.valueOf(string) + "margin-right:" + accessibleAttributeEvent.rightMargin + ";";
        string = String.valueOf(string) + "margin-bottom:" + accessibleAttributeEvent.bottomMargin + ";";
        if (accessibleAttributeEvent.tabStops != null) {
            int n3 = 0;
            while (n3 < accessibleAttributeEvent.tabStops.length) {
                string = String.valueOf(string) + "tab-stop:position=" + accessibleAttributeEvent.tabStops[n3] + ";";
                ++n3;
            }
        }
        if (accessibleAttributeEvent.justify) {
            string = String.valueOf(string) + "text-align:justify;";
        }
        string = String.valueOf(string) + "text-align:" + (accessibleAttributeEvent.alignment == 16384 ? "left" : (accessibleAttributeEvent.alignment == 131072 ? "right" : "center")) + ";";
        string = String.valueOf(string) + "text-indent:" + accessibleAttributeEvent.indent + ";";
        if (accessibleAttributeEvent.attributes != null) {
            int n4 = 0;
            while (n4 + 1 < accessibleAttributeEvent.attributes.length) {
                string = String.valueOf(string) + accessibleAttributeEvent.attributes[n4] + ":" + accessibleAttributeEvent.attributes[n4 + 1] + ";";
                n4 += 2;
            }
        }
        if (this.getRole() == 42) {
            string = String.valueOf(string) + "text-model:a1;";
        }
        this.setString(n, string);
        if (string.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_nActions(int n) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n2);
            accessibleActionListener.getActionCount(accessibleActionEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleActionEvent.count}, 4);
        return 0;
    }

    int doAction(int n) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        int n2 = 0;
        while (n2 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n2);
            accessibleActionListener.doAction(accessibleActionEvent);
            ++n2;
        }
        if (accessibleActionEvent.result == null || !accessibleActionEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_description(int n, int n2) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        int n3 = 0;
        while (n3 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n3);
            accessibleActionListener.getDescription(accessibleActionEvent);
            ++n3;
        }
        this.setString(n2, accessibleActionEvent.result);
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_keyBinding(int n, int n2, int n3, int n4) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        int n5 = 0;
        while (n5 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n5);
            accessibleActionListener.getKeyBinding(accessibleActionEvent);
            ++n5;
        }
        String string = accessibleActionEvent.result;
        int n6 = 0;
        if (string != null) {
            n6 = string.length();
        }
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            String string2;
            if (n8 == n2) break;
            int n9 = string.indexOf(59, n7);
            if (n9 == -1) {
                n9 = n6;
            }
            if ((string2 = string.substring(n7, n9)).length() > 0) {
                this.setString(n3 + n8 * OS.PTR_SIZEOF, string2);
                ++n8;
            }
            n7 = n9 + 1;
        }
        COM.MoveMemory(n4, new int[]{n8}, 4);
        if (n8 == 0) {
            this.setString(n3, null);
            return 1;
        }
        return 0;
    }

    int get_name(int n, int n2) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        accessibleActionEvent.localized = false;
        int n3 = 0;
        while (n3 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n3);
            accessibleActionListener.getName(accessibleActionEvent);
            ++n3;
        }
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            this.setString(n2, null);
            return 1;
        }
        this.setString(n2, accessibleActionEvent.result);
        return 0;
    }

    int get_localizedName(int n, int n2) {
        AccessibleActionEvent accessibleActionEvent = new AccessibleActionEvent(this);
        accessibleActionEvent.index = n;
        accessibleActionEvent.localized = true;
        int n3 = 0;
        while (n3 < this.accessibleActionListeners.size()) {
            AccessibleActionListener accessibleActionListener = (AccessibleActionListener)this.accessibleActionListeners.elementAt(n3);
            accessibleActionListener.getName(accessibleActionEvent);
            ++n3;
        }
        if (accessibleActionEvent.result == null || accessibleActionEvent.result.length() == 0) {
            this.setString(n2, null);
            return 1;
        }
        this.setString(n2, accessibleActionEvent.result);
        return 0;
    }

    int get_appName(int n) {
        String string = Display.getAppName();
        if (string == null || string.length() == 0) {
            this.setString(n, null);
            return 1;
        }
        this.setString(n, string);
        return 0;
    }

    int get_appVersion(int n) {
        String string = Display.getAppVersion();
        if (string == null || string.length() == 0) {
            this.setString(n, null);
            return 1;
        }
        this.setString(n, string);
        return 0;
    }

    int get_toolkitName(int n) {
        String string = "SWT";
        this.setString(n, string);
        return 0;
    }

    int get_toolkitVersion(int n) {
        String string = "" + SWT.getVersion();
        this.setString(n, string);
        return 0;
    }

    int copyText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        int n3 = 0;
        while (n3 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n3);
            accessibleEditableTextListener.copyText(accessibleEditableTextEvent);
            ++n3;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int deleteText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleEditableTextEvent.string = "";
        int n3 = 0;
        while (n3 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n3);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
            ++n3;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int insertText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.end = accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.string = this.getString(n2);
        int n3 = 0;
        while (n3 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n3);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
            ++n3;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int cutText(int n, int n2) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        int n3 = 0;
        while (n3 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n3);
            accessibleEditableTextListener.cutText(accessibleEditableTextEvent);
            ++n3;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int pasteText(int n) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.end = accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        int n2 = 0;
        while (n2 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n2);
            accessibleEditableTextListener.pasteText(accessibleEditableTextEvent);
            ++n2;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int replaceText(int n, int n2, int n3) {
        AccessibleEditableTextEvent accessibleEditableTextEvent = new AccessibleEditableTextEvent(this);
        accessibleEditableTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleEditableTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleEditableTextEvent.string = this.getString(n3);
        int n4 = 0;
        while (n4 < this.accessibleEditableTextListeners.size()) {
            AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n4);
            accessibleEditableTextListener.replaceText(accessibleEditableTextEvent);
            ++n4;
        }
        if (accessibleEditableTextEvent.result == null || !accessibleEditableTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setAttributes(int n, int n2, int n3) {
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        String string = this.getString(n3);
        if (string != null && string.length() > 0) {
            String[] stringArray;
            accessibleTextAttributeEvent.start = n == -1 ? this.getCharacterCount() : n;
            accessibleTextAttributeEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
            TextStyle textStyle = new TextStyle();
            FontData fontData = null;
            int n4 = 10;
            String[] stringArray2 = new String[]{};
            int n5 = 0;
            int n6 = string.indexOf(59);
            while (n6 != -1 && n6 < string.length()) {
                String string2 = string.substring(n5, n6).trim();
                int n7 = string2.indexOf(58);
                if (n7 != -1 && n7 + 1 < string2.length()) {
                    stringArray = new String[stringArray2.length + 2];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray2.length] = string2.substring(0, n7).trim();
                    stringArray[stringArray2.length + 1] = string2.substring(n7 + 1).trim();
                    stringArray2 = stringArray;
                }
                n5 = n6 + 1;
                n6 = string.indexOf(59, n5);
            }
            int n8 = 0;
            while (n8 + 1 < stringArray2.length) {
                String string3 = stringArray2[n8];
                stringArray = stringArray2[n8 + 1];
                if (string3.equals("text-position")) {
                    if (stringArray.equals("super")) {
                        textStyle.rise = n4 / 2;
                    } else if (stringArray.equals("sub")) {
                        textStyle.rise = -n4 / 2;
                    }
                } else if (string3.equals("text-underline-type")) {
                    textStyle.underline = true;
                    if (stringArray.equals("double")) {
                        textStyle.underlineStyle = 1;
                    } else if (stringArray.equals("single") && textStyle.underlineStyle != 3 && textStyle.underlineStyle != 2) {
                        textStyle.underlineStyle = 0;
                    }
                } else if (string3.equals("text-underline-style") && stringArray.equals("wave")) {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 3;
                } else if (string3.equals("invalid") && stringArray.equals("true")) {
                    textStyle.underline = true;
                    textStyle.underlineStyle = 2;
                } else if (string3.equals("text-line-through-type")) {
                    if (stringArray.equals("single")) {
                        textStyle.strikeout = true;
                    }
                } else if (string3.equals("font-family")) {
                    if (fontData == null) {
                        fontData = new FontData();
                    }
                    fontData.setName((String)stringArray);
                } else if (string3.equals("font-size")) {
                    try {
                        String[] stringArray3 = stringArray.endsWith("pt") ? stringArray.substring(0, stringArray.length() - 2) : stringArray;
                        n4 = Integer.parseInt((String)stringArray3);
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setHeight(n4);
                        if (textStyle.rise > 0) {
                            textStyle.rise = n4 / 2;
                        } else if (textStyle.rise < 0) {
                            textStyle.rise = -n4 / 2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string3.equals("font-style")) {
                    if (stringArray.equals("italic")) {
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setStyle(fontData.getStyle() | 2);
                    }
                } else if (string3.equals("font-weight")) {
                    if (stringArray.equals("bold")) {
                        if (fontData == null) {
                            fontData = new FontData();
                        }
                        fontData.setStyle(fontData.getStyle() | 1);
                    } else {
                        try {
                            int n9 = Integer.parseInt((String)stringArray);
                            if (fontData == null) {
                                fontData = new FontData();
                            }
                            if (n9 > 400) {
                                fontData.setStyle(fontData.getStyle() | 1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else if (string3.equals("color")) {
                    textStyle.foreground = this.colorFromString((String)stringArray);
                } else if (string3.equals("background-color")) {
                    textStyle.background = this.colorFromString((String)stringArray);
                }
                n8 += 2;
            }
            if (stringArray2.length > 0) {
                accessibleTextAttributeEvent.attributes = stringArray2;
                if (fontData != null) {
                    textStyle.font = new Font((Device)this.control.getDisplay(), fontData);
                }
                if (!textStyle.equals(new TextStyle())) {
                    accessibleTextAttributeEvent.textStyle = textStyle;
                }
            }
            n8 = 0;
            while (n8 < this.accessibleEditableTextListeners.size()) {
                AccessibleEditableTextListener accessibleEditableTextListener = (AccessibleEditableTextListener)this.accessibleEditableTextListeners.elementAt(n8);
                accessibleEditableTextListener.setTextAttributes(accessibleTextAttributeEvent);
                ++n8;
            }
            if (textStyle.font != null) {
                textStyle.font.dispose();
            }
            if (textStyle.foreground != null) {
                textStyle.foreground.dispose();
            }
            if (textStyle.background != null) {
                textStyle.background.dispose();
            }
        }
        if (accessibleTextAttributeEvent.result == null || !accessibleTextAttributeEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_anchor(int n, int n2) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        accessibleHyperlinkEvent.index = n;
        int n3 = 0;
        while (n3 < this.accessibleHyperlinkListeners.size()) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = (AccessibleHyperlinkListener)this.accessibleHyperlinkListeners.elementAt(n3);
            accessibleHyperlinkListener.getAnchor(accessibleHyperlinkEvent);
            ++n3;
        }
        Accessible accessible = accessibleHyperlinkEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(n2, (short)9, accessible.getAddress());
            return 0;
        }
        this.setStringVARIANT(n2, accessibleHyperlinkEvent.result);
        if (accessibleHyperlinkEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_anchorTarget(int n, int n2) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        accessibleHyperlinkEvent.index = n;
        int n3 = 0;
        while (n3 < this.accessibleHyperlinkListeners.size()) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = (AccessibleHyperlinkListener)this.accessibleHyperlinkListeners.elementAt(n3);
            accessibleHyperlinkListener.getAnchorTarget(accessibleHyperlinkEvent);
            ++n3;
        }
        Accessible accessible = accessibleHyperlinkEvent.accessible;
        if (accessible != null) {
            accessible.AddRef();
            this.setPtrVARIANT(n2, (short)9, accessible.getAddress());
            return 0;
        }
        this.setStringVARIANT(n2, accessibleHyperlinkEvent.result);
        if (accessibleHyperlinkEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_startIndex(int n) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleHyperlinkListeners.size()) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = (AccessibleHyperlinkListener)this.accessibleHyperlinkListeners.elementAt(n2);
            accessibleHyperlinkListener.getStartIndex(accessibleHyperlinkEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleHyperlinkEvent.index}, 4);
        return 0;
    }

    int get_endIndex(int n) {
        AccessibleHyperlinkEvent accessibleHyperlinkEvent = new AccessibleHyperlinkEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleHyperlinkListeners.size()) {
            AccessibleHyperlinkListener accessibleHyperlinkListener = (AccessibleHyperlinkListener)this.accessibleHyperlinkListeners.elementAt(n2);
            accessibleHyperlinkListener.getEndIndex(accessibleHyperlinkEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleHyperlinkEvent.index}, 4);
        return 0;
    }

    int get_valid(int n) {
        return -2147467263;
    }

    int get_nHyperlinks(int n) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
            accessibleTextExtendedListener.getHyperlinkCount(accessibleTextEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTextEvent.count}, 4);
        return 0;
    }

    int get_hyperlink(int n, int n2) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        int n3 = 0;
        while (n3 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
            accessibleTextExtendedListener.getHyperlink(accessibleTextEvent);
            ++n3;
        }
        Accessible accessible = accessibleTextEvent.accessible;
        if (accessible == null) {
            this.setIntVARIANT(n2, (short)0, 0);
            return -2147024809;
        }
        accessible.AddRef();
        COM.MoveMemory(n2, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_hyperlinkIndex(int n, int n2) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = n;
        accessibleTextEvent.index = -1;
        int n3 = 0;
        while (n3 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
            accessibleTextExtendedListener.getHyperlinkIndex(accessibleTextEvent);
            ++n3;
        }
        COM.MoveMemory(n2, new int[]{accessibleTextEvent.index}, 4);
        if (accessibleTextEvent.index == -1) {
            return 1;
        }
        return 0;
    }

    int get_cellAt(int n, int n2, int n3) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        accessibleTableEvent.column = n2;
        int n4 = 0;
        while (n4 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n4);
            accessibleTableListener.getCell(accessibleTableEvent);
            ++n4;
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            return -2147024809;
        }
        accessible.AddRef();
        COM.MoveMemory(n3, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_caption(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getCaption(accessibleTableEvent);
            ++n2;
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(n, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_columnDescription(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.getColumnDescription(accessibleTableEvent);
            ++n3;
        }
        this.setString(n2, accessibleTableEvent.result);
        if (accessibleTableEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_nColumns(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getColumnCount(accessibleTableEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nRows(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getRowCount(accessibleTableEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedCells(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getSelectedCellCount(accessibleTableEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedColumns(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getSelectedColumnCount(accessibleTableEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_nSelectedRows(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getSelectedRowCount(accessibleTableEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableEvent.count}, 4);
        return 0;
    }

    int get_rowDescription(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.getRowDescription(accessibleTableEvent);
            ++n3;
        }
        this.setString(n2, accessibleTableEvent.result);
        if (accessibleTableEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_selectedCells(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.getSelectedCells(accessibleTableEvent);
            ++n3;
        }
        if (accessibleTableEvent.accessibles == null || accessibleTableEvent.accessibles.length == 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            COM.MoveMemory(n2, new int[1], 4);
            return 1;
        }
        n3 = accessibleTableEvent.accessibles.length;
        int n4 = COM.CoTaskMemAlloc(n3 * OS.PTR_SIZEOF);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            Accessible accessible = accessibleTableEvent.accessibles[n6];
            if (accessible != null) {
                accessible.AddRef();
                COM.MoveMemory(n4 + n6 * OS.PTR_SIZEOF, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
                ++n5;
            }
            ++n6;
        }
        COM.MoveMemory(n, new int[]{n4}, OS.PTR_SIZEOF);
        COM.MoveMemory(n2, new int[]{n5}, 4);
        return 0;
    }

    int get_selectedColumns(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.getSelectedColumns(accessibleTableEvent);
            ++n3;
        }
        int n4 = n3 = accessibleTableEvent.selected == null ? 0 : accessibleTableEvent.selected.length;
        if (n3 == 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            COM.MoveMemory(n2, new int[1], 4);
            return 1;
        }
        int n5 = COM.CoTaskMemAlloc(n3 * 4);
        COM.MoveMemory(n5, accessibleTableEvent.selected, n3 * 4);
        COM.MoveMemory(n, new int[]{n5}, OS.PTR_SIZEOF);
        COM.MoveMemory(n2, new int[]{n3}, 4);
        return 0;
    }

    int get_selectedRows(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.getSelectedRows(accessibleTableEvent);
            ++n3;
        }
        int n4 = n3 = accessibleTableEvent.selected == null ? 0 : accessibleTableEvent.selected.length;
        if (n3 == 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            COM.MoveMemory(n2, new int[1], 4);
            return 1;
        }
        int n5 = COM.CoTaskMemAlloc(n3 * 4);
        COM.MoveMemory(n5, accessibleTableEvent.selected, n3 * 4);
        COM.MoveMemory(n, new int[]{n5}, OS.PTR_SIZEOF);
        COM.MoveMemory(n2, new int[]{n3}, 4);
        return 0;
    }

    int get_summary(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.getSummary(accessibleTableEvent);
            ++n2;
        }
        Accessible accessible = accessibleTableEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(n, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int get_isColumnSelected(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.isColumnSelected(accessibleTableEvent);
            ++n3;
        }
        COM.MoveMemory(n2, new int[]{accessibleTableEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int get_isRowSelected(int n, int n2) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        int n3 = 0;
        while (n3 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n3);
            accessibleTableListener.isRowSelected(accessibleTableEvent);
            ++n3;
        }
        COM.MoveMemory(n2, new int[]{accessibleTableEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int selectRow(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.setSelectedRow(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int selectColumn(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.setSelectedColumn(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int unselectRow(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.row = n;
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.deselectRow(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int unselectColumn(int n) {
        AccessibleTableEvent accessibleTableEvent = new AccessibleTableEvent(this);
        accessibleTableEvent.column = n;
        int n2 = 0;
        while (n2 < this.accessibleTableListeners.size()) {
            AccessibleTableListener accessibleTableListener = (AccessibleTableListener)this.accessibleTableListeners.elementAt(n2);
            accessibleTableListener.deselectColumn(accessibleTableEvent);
            ++n2;
        }
        if (accessibleTableEvent.result == null || !accessibleTableEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_modelChange(int n) {
        if (this.tableChange == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return 1;
        }
        COM.MoveMemory(n, this.tableChange, this.tableChange.length * 4);
        return 0;
    }

    int get_columnExtent(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getColumnSpan(accessibleTableCellEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableCellEvent.count}, 4);
        return 0;
    }

    int get_columnHeaderCells(int n, int n2) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n3 = 0;
        while (n3 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n3);
            accessibleTableCellListener.getColumnHeaders(accessibleTableCellEvent);
            ++n3;
        }
        if (accessibleTableCellEvent.accessibles == null || accessibleTableCellEvent.accessibles.length == 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            COM.MoveMemory(n2, new int[1], 4);
            return 1;
        }
        n3 = accessibleTableCellEvent.accessibles.length;
        int n4 = COM.CoTaskMemAlloc(n3 * OS.PTR_SIZEOF);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            Accessible accessible = accessibleTableCellEvent.accessibles[n6];
            if (accessible != null) {
                accessible.AddRef();
                COM.MoveMemory(n4 + n6 * OS.PTR_SIZEOF, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
                ++n5;
            }
            ++n6;
        }
        COM.MoveMemory(n, new int[]{n4}, OS.PTR_SIZEOF);
        COM.MoveMemory(n2, new int[]{n5}, 4);
        return 0;
    }

    int get_columnIndex(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getColumnIndex(accessibleTableCellEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableCellEvent.index}, 4);
        return 0;
    }

    int get_rowExtent(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getRowSpan(accessibleTableCellEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableCellEvent.count}, 4);
        return 0;
    }

    int get_rowHeaderCells(int n, int n2) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n3 = 0;
        while (n3 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n3);
            accessibleTableCellListener.getRowHeaders(accessibleTableCellEvent);
            ++n3;
        }
        if (accessibleTableCellEvent.accessibles == null || accessibleTableCellEvent.accessibles.length == 0) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            COM.MoveMemory(n2, new int[1], 4);
            return 1;
        }
        n3 = accessibleTableCellEvent.accessibles.length;
        int n4 = COM.CoTaskMemAlloc(n3 * OS.PTR_SIZEOF);
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            Accessible accessible = accessibleTableCellEvent.accessibles[n6];
            if (accessible != null) {
                accessible.AddRef();
                COM.MoveMemory(n4 + n6 * OS.PTR_SIZEOF, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
                ++n5;
            }
            ++n6;
        }
        COM.MoveMemory(n, new int[]{n4}, OS.PTR_SIZEOF);
        COM.MoveMemory(n2, new int[]{n5}, 4);
        return 0;
    }

    int get_rowIndex(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getRowIndex(accessibleTableCellEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableCellEvent.index}, 4);
        return 0;
    }

    int get_isSelected(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.isSelected(accessibleTableCellEvent);
            ++n2;
        }
        COM.MoveMemory(n, new int[]{accessibleTableCellEvent.isSelected ? 1 : 0}, 4);
        return 0;
    }

    int get_rowColumnExtents(int n, int n2, int n3, int n4, int n5) {
        return -2147352573;
    }

    int get_table(int n) {
        AccessibleTableCellEvent accessibleTableCellEvent = new AccessibleTableCellEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleTableCellListeners.size()) {
            AccessibleTableCellListener accessibleTableCellListener = (AccessibleTableCellListener)this.accessibleTableCellListeners.elementAt(n2);
            accessibleTableCellListener.getTable(accessibleTableCellEvent);
            ++n2;
        }
        Accessible accessible = accessibleTableCellEvent.accessible;
        if (accessible == null) {
            COM.MoveMemory(n, new int[1], OS.PTR_SIZEOF);
            return 1;
        }
        accessible.AddRef();
        COM.MoveMemory(n, new int[]{accessible.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    int addSelection(int n, int n2) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        accessibleTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        int n3 = 0;
        while (n3 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n3);
            accessibleTextExtendedListener.addSelection(accessibleTextEvent);
            ++n3;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_attributes(int n, int n2, int n3, int n4) {
        Object object;
        AccessibleTextAttributeEvent accessibleTextAttributeEvent = new AccessibleTextAttributeEvent(this);
        accessibleTextAttributeEvent.offset = n == -1 ? this.getCharacterCount() : n;
        int n5 = 0;
        while (n5 < this.accessibleAttributeListeners.size()) {
            object = (AccessibleAttributeListener)this.accessibleAttributeListeners.elementAt(n5);
            object.getTextAttributes(accessibleTextAttributeEvent);
            ++n5;
        }
        String string = "";
        object = accessibleTextAttributeEvent.textStyle;
        if (object != null) {
            Object object2;
            Font font;
            if (((TextStyle)object).rise != 0) {
                string = String.valueOf(string) + "text-position:";
                string = ((TextStyle)object).rise > 0 ? String.valueOf(string) + "super" : String.valueOf(string) + "sub";
            }
            if (((TextStyle)object).underline) {
                string = String.valueOf(string) + "text-underline-type:";
                switch (((TextStyle)object).underlineStyle) {
                    case 0: {
                        string = String.valueOf(string) + "single;";
                        break;
                    }
                    case 1: {
                        string = String.valueOf(string) + "double;";
                        break;
                    }
                    case 3: {
                        string = String.valueOf(string) + "single;text-underline-style:wave;";
                        break;
                    }
                    case 2: {
                        string = String.valueOf(string) + "single;text-underline-style:wave;invalid:true;";
                        break;
                    }
                    default: {
                        string = String.valueOf(string) + "none;";
                    }
                }
            }
            if (((TextStyle)object).strikeout) {
                string = String.valueOf(string) + "text-line-through-type:single;";
            }
            if ((font = ((TextStyle)object).font) != null && !font.isDisposed()) {
                object2 = font.getFontData()[0];
                string = String.valueOf(string) + "font-family:" + ((FontData)object2).getName() + ";";
                string = String.valueOf(string) + "font-size:" + ((FontData)object2).getHeight() + "pt;";
                string = String.valueOf(string) + "font-style:" + (((FontData)object2).data.lfItalic != 0 ? "italic" : "normal") + ";";
                string = String.valueOf(string) + "font-weight:" + ((FontData)object2).data.lfWeight + ";";
            }
            if ((object2 = ((TextStyle)object).foreground) != null && !((Color)object2).isDisposed()) {
                string = String.valueOf(string) + "color:rgb(" + ((Color)object2).getRed() + "," + ((Color)object2).getGreen() + "," + ((Color)object2).getBlue() + ");";
            }
            if ((object2 = ((TextStyle)object).background) != null && !((Color)object2).isDisposed()) {
                string = String.valueOf(string) + "background-color:rgb(" + ((Color)object2).getRed() + "," + ((Color)object2).getGreen() + "," + ((Color)object2).getBlue() + ");";
            }
        }
        if (accessibleTextAttributeEvent.attributes != null) {
            int n6 = 0;
            while (n6 + 1 < accessibleTextAttributeEvent.attributes.length) {
                string = String.valueOf(string) + accessibleTextAttributeEvent.attributes[n6] + ":" + accessibleTextAttributeEvent.attributes[n6 + 1] + ";";
                n6 += 2;
            }
        }
        COM.MoveMemory(n2, new int[]{accessibleTextAttributeEvent.start}, 4);
        COM.MoveMemory(n3, new int[]{accessibleTextAttributeEvent.end}, 4);
        this.setString(n4, string);
        if (string.length() == 0) {
            return 1;
        }
        return 0;
    }

    int get_caretOffset(int n) {
        int n2 = this.getCaretOffset();
        COM.MoveMemory(n, new int[]{n2}, 4);
        if (n2 == -1) {
            return 1;
        }
        return 0;
    }

    int get_characterExtents(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getCharacterCount();
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? n7 : (n < 0 ? 0 : n);
        accessibleTextEvent.end = n == -1 || n >= n7 ? n7 : n + 1;
        int n8 = 0;
        while (n8 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n8);
            accessibleTextExtendedListener.getTextBounds(accessibleTextEvent);
            ++n8;
        }
        COM.MoveMemory(n3, new int[]{accessibleTextEvent.x}, 4);
        COM.MoveMemory(n4, new int[]{accessibleTextEvent.y}, 4);
        COM.MoveMemory(n5, new int[]{accessibleTextEvent.width}, 4);
        COM.MoveMemory(n6, new int[]{accessibleTextEvent.height}, 4);
        if (accessibleTextEvent.width == 0 && accessibleTextEvent.height == 0) {
            return -2147024809;
        }
        return 0;
    }

    int get_nSelections(int n) {
        AccessibleTextListener accessibleTextListener;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.count = -1;
        int n2 = 0;
        while (n2 < this.accessibleTextExtendedListeners.size()) {
            accessibleTextListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
            accessibleTextListener.getSelectionCount(accessibleTextEvent);
            ++n2;
        }
        if (accessibleTextEvent.count == -1) {
            accessibleTextEvent.childID = -1;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            n2 = 0;
            while (n2 < this.accessibleTextListeners.size()) {
                accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n2);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
                ++n2;
            }
            accessibleTextEvent.count = accessibleTextEvent.offset != -1 && accessibleTextEvent.length > 0 ? 1 : 0;
        }
        COM.MoveMemory(n, new int[]{accessibleTextEvent.count}, 4);
        return 0;
    }

    int get_offsetAtPoint(int n, int n2, int n3, int n4) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.x = n;
        accessibleTextEvent.y = n2;
        accessibleTextEvent.offset = -1;
        int n5 = 0;
        while (n5 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n5);
            accessibleTextExtendedListener.getOffsetAtPoint(accessibleTextEvent);
            ++n5;
        }
        COM.MoveMemory(n4, new int[]{accessibleTextEvent.offset}, 4);
        if (accessibleTextEvent.offset == -1) {
            return 1;
        }
        return 0;
    }

    int get_selection(int n, int n2, int n3) {
        AccessibleTextListener accessibleTextListener;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        accessibleTextEvent.start = -1;
        accessibleTextEvent.end = -1;
        int n4 = 0;
        while (n4 < this.accessibleTextExtendedListeners.size()) {
            accessibleTextListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
            accessibleTextListener.getSelection(accessibleTextEvent);
            ++n4;
        }
        if (accessibleTextEvent.start == -1 && n == 0) {
            accessibleTextEvent.childID = -1;
            accessibleTextEvent.offset = -1;
            accessibleTextEvent.length = 0;
            n4 = 0;
            while (n4 < this.accessibleTextListeners.size()) {
                accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n4);
                accessibleTextListener.getSelectionRange(accessibleTextEvent);
                ++n4;
            }
            accessibleTextEvent.start = accessibleTextEvent.offset;
            accessibleTextEvent.end = accessibleTextEvent.offset + accessibleTextEvent.length;
        }
        COM.MoveMemory(n2, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(n3, new int[]{accessibleTextEvent.end}, 4);
        if (accessibleTextEvent.start == -1) {
            return 1;
        }
        return 0;
    }

    int get_text(int n, int n2, int n3) {
        int n4;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n == -1 ? this.getCharacterCount() : n;
        int n5 = accessibleTextEvent.end = n2 == -1 ? this.getCharacterCount() : n2;
        if (accessibleTextEvent.start > accessibleTextEvent.end) {
            n4 = accessibleTextEvent.start;
            accessibleTextEvent.start = accessibleTextEvent.end;
            accessibleTextEvent.end = n4;
        }
        accessibleTextEvent.count = 0;
        accessibleTextEvent.type = 5;
        n4 = 0;
        while (n4 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
            ++n4;
        }
        if (accessibleTextEvent.result == null) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -1;
            int n6 = 0;
            while (n6 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n6);
                accessibleControlListener.getRole(accessibleControlEvent);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n6;
            }
            if (accessibleControlEvent.detail == 42) {
                accessibleTextEvent.result = accessibleControlEvent.result;
            }
        }
        this.setString(n3, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return -2147024809;
        }
        return 0;
    }

    int get_textBeforeOffset(int n, int n2, int n3, int n4, int n5) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n6 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n6 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = -1;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n7 = accessibleTextEvent.start;
        int n8 = accessibleTextEvent.end;
        int n9 = 0;
        while (n9 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n9);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
            ++n9;
        }
        if (accessibleTextEvent.end < n6) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    n9 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n7;
                    accessibleTextEvent.end = n8;
                    accessibleTextEvent.count = 0;
                    int n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n9;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(n3, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(n4, new int[]{accessibleTextEvent.end}, 4);
        this.setString(n5, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_textAfterOffset(int n, int n2, int n3, int n4, int n5) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n6 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n6 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = 1;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n7 = accessibleTextEvent.start;
        int n8 = accessibleTextEvent.end;
        int n9 = 0;
        while (n9 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n9);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
            ++n9;
        }
        if (accessibleTextEvent.end < n6) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    n9 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n7;
                    accessibleTextEvent.end = n8;
                    accessibleTextEvent.count = 2;
                    int n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n9;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(n3, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(n4, new int[]{accessibleTextEvent.end}, 4);
        this.setString(n5, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int get_textAtOffset(int n, int n2, int n3, int n4, int n5) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        int n6 = this.getCharacterCount();
        accessibleTextEvent.end = accessibleTextEvent.start = n == -1 ? n6 : (n == -2 ? this.getCaretOffset() : n);
        accessibleTextEvent.count = 0;
        switch (n2) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            case 5: {
                accessibleTextEvent.type = 5;
                accessibleTextEvent.start = 0;
                accessibleTextEvent.end = n6;
                accessibleTextEvent.count = 0;
                break;
            }
            default: {
                return -2147024809;
            }
        }
        int n7 = accessibleTextEvent.start;
        int n8 = accessibleTextEvent.end;
        int n9 = 0;
        while (n9 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n9);
            accessibleTextExtendedListener.getText(accessibleTextEvent);
            ++n9;
        }
        if (accessibleTextEvent.end < n6) {
            switch (n2) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    AccessibleTextExtendedListener accessibleTextExtendedListener;
                    n9 = accessibleTextEvent.start;
                    accessibleTextEvent.start = n7;
                    accessibleTextEvent.end = n8;
                    accessibleTextEvent.count = 1;
                    int n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    accessibleTextEvent.end = accessibleTextEvent.start;
                    accessibleTextEvent.start = n9;
                    accessibleTextEvent.type = 5;
                    accessibleTextEvent.count = 0;
                    n10 = 0;
                    while (n10 < this.accessibleTextExtendedListeners.size()) {
                        accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n10);
                        accessibleTextExtendedListener.getText(accessibleTextEvent);
                        ++n10;
                    }
                    break;
                }
            }
        }
        COM.MoveMemory(n3, new int[]{accessibleTextEvent.start}, 4);
        COM.MoveMemory(n4, new int[]{accessibleTextEvent.end}, 4);
        this.setString(n5, accessibleTextEvent.result);
        if (accessibleTextEvent.result == null) {
            return 1;
        }
        return 0;
    }

    int removeSelection(int n) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        int n2 = 0;
        while (n2 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
            accessibleTextExtendedListener.removeSelection(accessibleTextEvent);
            ++n2;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setCaretOffset(int n) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = n == -1 ? this.getCharacterCount() : n;
        int n2 = 0;
        while (n2 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n2);
            accessibleTextExtendedListener.setCaretOffset(accessibleTextEvent);
            ++n2;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int setSelection(int n, int n2, int n3) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.index = n;
        accessibleTextEvent.start = n2 == -1 ? this.getCharacterCount() : n2;
        accessibleTextEvent.end = n3 == -1 ? this.getCharacterCount() : n3;
        int n4 = 0;
        while (n4 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
            accessibleTextExtendedListener.setSelection(accessibleTextEvent);
            ++n4;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_nCharacters(int n) {
        int n2 = this.getCharacterCount();
        COM.MoveMemory(n, new int[]{n2}, 4);
        return 0;
    }

    int scrollSubstringTo(int n, int n2, int n3) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n;
        accessibleTextEvent.end = n2;
        switch (n3) {
            case 0: {
                accessibleTextEvent.type = 0;
                break;
            }
            case 1: {
                accessibleTextEvent.type = 1;
                break;
            }
            case 2: {
                accessibleTextEvent.type = 2;
                break;
            }
            case 3: {
                accessibleTextEvent.type = 3;
                break;
            }
            case 4: {
                accessibleTextEvent.type = 4;
                break;
            }
            case 5: {
                accessibleTextEvent.type = 5;
                break;
            }
            case 6: {
                accessibleTextEvent.type = 6;
            }
        }
        int n4 = 0;
        while (n4 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n4);
            accessibleTextExtendedListener.scrollText(accessibleTextEvent);
            ++n4;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int scrollSubstringToPoint(int n, int n2, int n3, int n4, int n5) {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.start = n;
        accessibleTextEvent.end = n2;
        accessibleTextEvent.type = 7;
        accessibleTextEvent.x = n4;
        accessibleTextEvent.y = n5;
        int n6 = 0;
        while (n6 < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n6);
            accessibleTextExtendedListener.scrollText(accessibleTextEvent);
            ++n6;
        }
        if (accessibleTextEvent.result == null || !accessibleTextEvent.result.equals("OK")) {
            return -2147024809;
        }
        return 0;
    }

    int get_newText(int n) {
        String string = null;
        int n2 = 0;
        int n3 = 0;
        if (this.textInserted != null) {
            string = (String)this.textInserted[3];
            n2 = (Integer)this.textInserted[1];
            n3 = (Integer)this.textInserted[2];
        }
        this.setString(n, string);
        COM.MoveMemory(n + OS.PTR_SIZEOF, new int[]{n2}, 4);
        COM.MoveMemory(n + OS.PTR_SIZEOF + 4, new int[]{n3}, 4);
        if (this.textInserted == null) {
            return 1;
        }
        return 0;
    }

    int get_oldText(int n) {
        String string = null;
        int n2 = 0;
        int n3 = 0;
        if (this.textDeleted != null) {
            string = (String)this.textDeleted[3];
            n2 = (Integer)this.textDeleted[1];
            n3 = (Integer)this.textDeleted[2];
        }
        this.setString(n, string);
        COM.MoveMemory(n + OS.PTR_SIZEOF, new int[]{n2}, 4);
        COM.MoveMemory(n + OS.PTR_SIZEOF + 4, new int[]{n3}, 4);
        if (this.textDeleted == null) {
            return 1;
        }
        return 0;
    }

    int get_currentValue(int n) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleValueListeners.size()) {
            AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
            accessibleValueListener.getCurrentValue(accessibleValueEvent);
            ++n2;
        }
        this.setNumberVARIANT(n, accessibleValueEvent.value);
        return 0;
    }

    int setCurrentValue(int n) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        accessibleValueEvent.value = this.getNumberVARIANT(n);
        int n2 = 0;
        while (n2 < this.accessibleValueListeners.size()) {
            AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
            accessibleValueListener.setCurrentValue(accessibleValueEvent);
            ++n2;
        }
        return 0;
    }

    int get_maximumValue(int n) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleValueListeners.size()) {
            AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
            accessibleValueListener.getMaximumValue(accessibleValueEvent);
            ++n2;
        }
        this.setNumberVARIANT(n, accessibleValueEvent.value);
        return 0;
    }

    int get_minimumValue(int n) {
        AccessibleValueEvent accessibleValueEvent = new AccessibleValueEvent(this);
        int n2 = 0;
        while (n2 < this.accessibleValueListeners.size()) {
            AccessibleValueListener accessibleValueListener = (AccessibleValueListener)this.accessibleValueListeners.elementAt(n2);
            accessibleValueListener.getMinimumValue(accessibleValueEvent);
            ++n2;
        }
        this.setNumberVARIANT(n, accessibleValueEvent.value);
        return 0;
    }

    int eventChildID() {
        if (this.parent == null) {
            return 0;
        }
        if (this.uniqueID == -1) {
            this.uniqueID = UniqueID--;
        }
        return this.uniqueID;
    }

    void checkUniqueID(int n) {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = n;
        int n2 = 0;
        while (n2 < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
            accessibleControlListener.getChild(accessibleControlEvent);
            ++n2;
        }
        Accessible accessible = accessibleControlEvent.accessible;
        if (accessible != null && accessible.uniqueID == -1) {
            accessible.uniqueID = n;
        }
    }

    int childIDToOs(int n) {
        if (n == -1) {
            return 0;
        }
        int n2 = n + 1;
        if (this.control instanceof Tree) {
            n2 = OS.COMCTL32_MAJOR < 6 ? n : OS.SendMessage(this.control.handle, 4395, n, 0);
        }
        this.checkUniqueID(n2);
        return n2;
    }

    int osToChildID(int n) {
        if (n == 0) {
            return -1;
        }
        if (!(this.control instanceof Tree)) {
            return n - 1;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            return n;
        }
        return OS.SendMessage(this.control.handle, 4394, n, 0);
    }

    int stateToOs(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    int osToState(int n) {
        int n2 = 0;
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        if ((n & 0x200000) != 0) {
            n2 |= 0x200000;
        }
        if ((n & 0x1000000) != 0) {
            n2 |= 0x1000000;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x100000;
        }
        if ((n & 8) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x200) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x400) != 0) {
            n2 |= 0x400;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x800) != 0) {
            n2 |= 0x800;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 0x8000;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 0x10000;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n & 0x400000) != 0) {
            n2 |= 0x400000;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        return n2;
    }

    int roleToOs(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 62: {
                return 62;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
            case 8: {
                return 8;
            }
            case 54: {
                return 54;
            }
            case 27: {
                return 27;
            }
            case 15: {
                return 15;
            }
            case 40: {
                return 40;
            }
            case 20: {
                return 20;
            }
            case 28: {
                return 28;
            }
            case 52: {
                return 52;
            }
            case 23: {
                return 23;
            }
            case 61: {
                return 61;
            }
            case 47: {
                return 47;
            }
            case 1025: {
                return 10;
            }
            case 1027: {
                return 12;
            }
            case 1073: {
                return 12;
            }
            case 1029: {
                return 47;
            }
            case 1038: {
                return 10;
            }
            case 1040: {
                return 10;
            }
            case 1043: {
                return 10;
            }
            case 1044: {
                return 10;
            }
            case 1053: {
                return 10;
            }
            case 1054: {
                return 10;
            }
            case 1060: {
                return 10;
            }
        }
        return 10;
    }

    int osToRole(int n) {
        switch (n) {
            case 10: {
                return 10;
            }
            case 9: {
                return 9;
            }
            case 2: {
                return 2;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 21: {
                return 21;
            }
            case 13: {
                return 13;
            }
            case 3: {
                return 3;
            }
            case 18: {
                return 18;
            }
            case 41: {
                return 41;
            }
            case 43: {
                return 43;
            }
            case 44: {
                return 44;
            }
            case 45: {
                return 45;
            }
            case 62: {
                return 62;
            }
            case 46: {
                return 46;
            }
            case 42: {
                return 42;
            }
            case 22: {
                return 22;
            }
            case 33: {
                return 33;
            }
            case 34: {
                return 34;
            }
            case 24: {
                return 24;
            }
            case 29: {
                return 29;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 35: {
                return 35;
            }
            case 36: {
                return 36;
            }
            case 60: {
                return 60;
            }
            case 37: {
                return 37;
            }
            case 48: {
                return 48;
            }
            case 51: {
                return 51;
            }
            case 30: {
                return 30;
            }
            case 8: {
                return 8;
            }
            case 54: {
                return 54;
            }
            case 27: {
                return 27;
            }
            case 15: {
                return 15;
            }
            case 40: {
                return 40;
            }
            case 20: {
                return 20;
            }
            case 28: {
                return 28;
            }
            case 52: {
                return 52;
            }
            case 23: {
                return 23;
            }
            case 61: {
                return 61;
            }
            case 47: {
                return 47;
            }
        }
        return 10;
    }

    Color colorFromString(String string) {
        try {
            int n = string.indexOf(40);
            int n2 = string.indexOf(44);
            int n3 = string.indexOf(44, n2 + 1);
            int n4 = string.indexOf(41);
            int n5 = Integer.parseInt(string.substring(n + 1, n2));
            int n6 = Integer.parseInt(string.substring(n2 + 1, n3));
            int n7 = Integer.parseInt(string.substring(n3 + 1, n4));
            return new Color(this.control.getDisplay(), n5, n6, n7);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    int getCaretOffset() {
        AccessibleTextListener accessibleTextListener;
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.offset = -1;
        int n = 0;
        while (n < this.accessibleTextExtendedListeners.size()) {
            accessibleTextListener = (AccessibleTextListener)this.accessibleTextExtendedListeners.elementAt(n);
            accessibleTextListener.getCaretOffset(accessibleTextEvent);
            ++n;
        }
        if (accessibleTextEvent.offset == -1) {
            n = 0;
            while (n < this.accessibleTextListeners.size()) {
                accessibleTextEvent.childID = -1;
                accessibleTextListener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(n);
                accessibleTextListener.getCaretOffset(accessibleTextEvent);
                ++n;
            }
        }
        return accessibleTextEvent.offset;
    }

    int getCharacterCount() {
        AccessibleTextEvent accessibleTextEvent = new AccessibleTextEvent(this);
        accessibleTextEvent.count = -1;
        int n = 0;
        while (n < this.accessibleTextExtendedListeners.size()) {
            AccessibleTextExtendedListener accessibleTextExtendedListener = (AccessibleTextExtendedListener)this.accessibleTextExtendedListeners.elementAt(n);
            accessibleTextExtendedListener.getCharacterCount(accessibleTextEvent);
            ++n;
        }
        if (accessibleTextEvent.count == -1) {
            AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
            accessibleControlEvent.childID = -1;
            int n2 = 0;
            while (n2 < this.accessibleControlListeners.size()) {
                AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n2);
                accessibleControlListener.getRole(accessibleControlEvent);
                accessibleControlListener.getValue(accessibleControlEvent);
                ++n2;
            }
            accessibleTextEvent.count = accessibleControlEvent.detail == 42 && accessibleControlEvent.result != null ? accessibleControlEvent.result.length() : 0;
        }
        return accessibleTextEvent.count;
    }

    int getRelationCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < 15) {
            if (this.relations[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    int getRole() {
        AccessibleControlEvent accessibleControlEvent = new AccessibleControlEvent(this);
        accessibleControlEvent.childID = -1;
        int n = 0;
        while (n < this.accessibleControlListeners.size()) {
            AccessibleControlListener accessibleControlListener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(n);
            accessibleControlListener.getRole(accessibleControlEvent);
            ++n;
        }
        return accessibleControlEvent.detail;
    }

    int getDefaultRole() {
        int n = 10;
        if (this.iaccessible != null) {
            int n2 = OS.GlobalAlloc(64, VARIANT.sizeof);
            this.setIntVARIANT(n2, (short)3, 0);
            int n3 = OS.GlobalAlloc(64, VARIANT.sizeof);
            int n4 = this.iaccessible.get_accRole(n2, n3);
            if (n4 == 0) {
                VARIANT vARIANT = this.getVARIANT(n3);
                if (vARIANT.vt == 3) {
                    n = vARIANT.lVal;
                }
            }
            OS.GlobalFree(n2);
            OS.GlobalFree(n3);
        }
        return n;
    }

    String getString(int n) {
        int[] nArray = new int[1];
        OS.MoveMemory(nArray, n, OS.PTR_SIZEOF);
        int n2 = COM.SysStringByteLen(nArray[0]);
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[(n2 + 1) / 2];
        OS.MoveMemory(cArray, nArray[0], n2);
        return new String(cArray);
    }

    VARIANT getVARIANT(int n) {
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n, VARIANT.sizeof);
        return vARIANT;
    }

    Number getNumberVARIANT(int n) {
        VARIANT vARIANT = new VARIANT();
        COM.MoveMemory(vARIANT, n, VARIANT.sizeof);
        if (vARIANT.vt == 20) {
            return new Long(vARIANT.lVal);
        }
        return new Integer(vARIANT.lVal);
    }

    void setIntVARIANT(int n, short s, int n2) {
        if (s == 3 || s == 0) {
            COM.MoveMemory(n, new short[]{s}, 2);
            COM.MoveMemory(n + 8, new int[]{n2}, 4);
        }
    }

    void setPtrVARIANT(int n, short s, int n2) {
        if (s == 9 || s == 13) {
            COM.MoveMemory(n, new short[]{s}, 2);
            COM.MoveMemory(n + 8, new int[]{n2}, OS.PTR_SIZEOF);
        }
    }

    void setNumberVARIANT(int n, Number number) {
        if (number == null) {
            COM.MoveMemory(n, new short[1], 2);
            COM.MoveMemory(n + 8, new int[1], 4);
        } else if (number instanceof Double) {
            COM.MoveMemory(n, new short[]{5}, 2);
            COM.MoveMemory(n + 8, new double[]{number.doubleValue()}, 8);
        } else if (number instanceof Float) {
            COM.MoveMemory(n, new short[]{4}, 2);
            COM.MoveMemory(n + 8, new float[]{number.floatValue()}, 4);
        } else if (number instanceof Long) {
            COM.MoveMemory(n, new short[]{20}, 2);
            COM.MoveMemory(n + 8, new long[]{number.longValue()}, 8);
        } else {
            COM.MoveMemory(n, new short[]{3}, 2);
            COM.MoveMemory(n + 8, new int[]{number.intValue()}, 4);
        }
    }

    void setString(int n, String string) {
        int n2 = 0;
        if (string != null) {
            char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
            n2 = COM.SysAllocString(cArray);
        }
        COM.MoveMemory(n, new int[]{n2}, OS.PTR_SIZEOF);
    }

    void setStringVARIANT(int n, String string) {
        int n2 = 0;
        if (string != null) {
            char[] cArray = (String.valueOf(string) + "\u0000").toCharArray();
            n2 = COM.SysAllocString(cArray);
        }
        COM.MoveMemory(n, new short[]{n2 == 0 ? (short)0 : 8}, 2);
        COM.MoveMemory(n + 8, new int[]{n2}, OS.PTR_SIZEOF);
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    static void print(String string) {
    }

    String getRoleString(int n) {
        return "Unknown role (" + n + ")";
    }

    String getStateString(int n) {
        if (n == 0) {
            return " no state bits set";
        }
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    String getIA2StatesString(int n) {
        if (n == 0) {
            return " no state bits set";
        }
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    String getEventString(int n) {
        return "Unknown event (" + n + ")";
    }

    private String hresult(int n) {
        return " HRESULT=" + n;
    }

    boolean interesting(GUID gUID) {
        return false;
    }

    String guidString(GUID gUID) {
        return gUID.toString();
    }

    static GUID IIDFromString(String string) {
        return null;
    }

    public String toString() {
        String string = super.toString();
        return string;
    }
}

