/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.log;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import uk.co.caprica.vlcj.binding.LibC;
import uk.co.caprica.vlcj.binding.LibVlc;
import uk.co.caprica.vlcj.binding.internal.libvlc_instance_t;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_cb;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_level_e;
import uk.co.caprica.vlcj.binding.internal.libvlc_log_t;
import uk.co.caprica.vlcj.log.LogEventListener;
import uk.co.caprica.vlcj.logger.Logger;
import uk.co.caprica.vlcj.version.LibVlcVersion;

public class NativeLog {
    private static final int BUFFER_SIZE = 201;
    private final List<LogEventListener> eventListenerList = new ArrayList<LogEventListener>();
    private final ExecutorService listenersService = Executors.newSingleThreadExecutor();
    private final LibVlc libvlc;
    private final libvlc_instance_t instance;
    private libvlc_log_cb callback;
    private final AtomicBoolean released = new AtomicBoolean();
    private libvlc_log_level_e logLevel = libvlc_log_level_e.NOTICE;

    public NativeLog(LibVlc libvlc, libvlc_instance_t instance) {
        if (!LibVlcVersion.getVersion().atLeast(LibVlcVersion.LIBVLC_210)) {
            throw new RuntimeException("Native log requires libvlc 2.1.0 or later");
        }
        this.libvlc = libvlc;
        this.instance = instance;
        this.createInstance();
    }

    public final void addLogListener(LogEventListener listener) {
        Logger.debug("addLogListener(listener={})", listener);
        this.eventListenerList.add(listener);
    }

    public final void removeLogListener(LogEventListener listener) {
        Logger.debug("removeLogListener(listener={})", listener);
        this.eventListenerList.remove(listener);
    }

    public final void setLevel(libvlc_log_level_e logLevel) {
        this.logLevel = logLevel;
    }

    public final libvlc_log_level_e getLevel() {
        return this.logLevel;
    }

    public final void release() {
        Logger.debug("release()", new Object[0]);
        if (this.released.compareAndSet(false, true)) {
            this.destroyInstance();
        }
    }

    private void createInstance() {
        Logger.debug("createInstance()", new Object[0]);
        this.callback = new NativeLogCallback();
        this.libvlc.libvlc_log_set(this.instance, this.callback, null);
    }

    private void destroyInstance() {
        Logger.debug("destroyInstance()", new Object[0]);
        this.libvlc.libvlc_log_unset(this.instance);
        this.eventListenerList.clear();
        Logger.debug("Shut down listeners...", new Object[0]);
        this.listenersService.shutdown();
        Logger.debug("Listeners shut down.", new Object[0]);
    }

    protected void finalize() throws Throwable {
        Logger.debug("finalize()", new Object[0]);
        Logger.debug("Native log has been garbage collected", new Object[0]);
        super.finalize();
    }

    private String getString(PointerByReference pointer) {
        Pointer value = pointer.getValue();
        return value != null ? value.getString(0L) : null;
    }

    private void raiseLogEvent(libvlc_log_level_e level, String module, String file, Integer line, String name, String header, Integer id, String message) {
        Logger.trace("raiseLogEvent(level={},module={},line={},name={},header={},id={},message={}", new Object[]{level, module, file, line, name, header, id, message});
        this.listenersService.submit(new NotifyEventListenersRunnable(level, module, file, line, name, header, id, message));
    }

    private final class NotifyEventListenersRunnable
    implements Runnable {
        private final libvlc_log_level_e level;
        private final String module;
        private final String file;
        private final Integer line;
        private final String name;
        private final String header;
        private final Integer id;
        private final String message;

        private NotifyEventListenersRunnable(libvlc_log_level_e level, String module, String file, Integer line, String name, String header, Integer id, String message) {
            this.level = level;
            this.module = module;
            this.file = file;
            this.line = line;
            this.name = name;
            this.header = header;
            this.id = id;
            this.message = message;
        }

        @Override
        public void run() {
            Logger.trace("run()", new Object[0]);
            for (int i = NativeLog.this.eventListenerList.size() - 1; i >= 0; --i) {
                LogEventListener listener = (LogEventListener)NativeLog.this.eventListenerList.get(i);
                try {
                    listener.log(this.level, this.module, this.file, this.line, this.name, this.header, this.id, this.message);
                    continue;
                }
                catch (Exception e) {
                    Logger.warn("Event listener {} threw an exception", e, listener);
                }
            }
            Logger.trace("runnable exits", new Object[0]);
        }
    }

    private final class NativeLogCallback
    implements libvlc_log_cb {
        private NativeLogCallback() {
        }

        @Override
        public void log(Pointer data, int level, libvlc_log_t ctx, String format, Pointer args) {
            if (NativeLog.this.logLevel != null && level >= NativeLog.this.logLevel.intValue()) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(201);
                int size = LibC.INSTANCE.vsnprintf(byteBuffer, byteBuffer.capacity(), format, args);
                if (size >= 0) {
                    size = Math.min(size, 201);
                    byte[] bytes = new byte[size];
                    byteBuffer.get(bytes);
                    String message = new String(bytes);
                    if (message.length() > 0) {
                        PointerByReference modulePointer = new PointerByReference();
                        PointerByReference filePointer = new PointerByReference();
                        IntByReference linePointer = new IntByReference();
                        NativeLog.this.libvlc.libvlc_log_get_context(ctx, modulePointer, filePointer, linePointer);
                        PointerByReference namePointer = new PointerByReference();
                        PointerByReference headerPointer = new PointerByReference();
                        IntByReference idPointer = new IntByReference();
                        NativeLog.this.libvlc.libvlc_log_get_object(ctx, namePointer, headerPointer, idPointer);
                        String module = NativeLog.this.getString(modulePointer);
                        String file = NativeLog.this.getString(filePointer);
                        Integer line = linePointer.getValue();
                        String name = NativeLog.this.getString(namePointer);
                        String header = NativeLog.this.getString(headerPointer);
                        Integer id = idPointer.getValue();
                        NativeLog.this.raiseLogEvent(libvlc_log_level_e.level(level), module, file, line, name, header, id, message);
                    }
                } else {
                    Logger.error("Failed to format log message", new Object[0]);
                }
            }
        }
    }
}

